/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

public class PlatformUtilsCore {
    public static final String PLATFORM_PREFIX_KEY = "idea.platform.prefix";
    public static final String IDEA_PREFIX = "idea";
    public static final String COMMUNITY_PREFIX = "Idea";
    public static final String APPCODE_PREFIX = "AppCode";
    public static final String CLION_PREFIX = "CLion";
    public static final String PYCHARM_PREFIX = "Python";
    public static final String PYCHARM_PREFIX2 = "PyCharmCore";
    public static final String RUBY_PREFIX = "Ruby";
    public static final String PHP_PREFIX = "PhpStorm";
    public static final String WEB_PREFIX = "WebStorm";
    public static final String FLEX_PREFIX = "Flex";
    public static final String DBE_PREFIX = "0xDBE";

    public static String getPlatformPrefix() {
        return PlatformUtilsCore.getPlatformPrefix(IDEA_PREFIX);
    }

    public static String getPlatformPrefix(String defaultPrefix) {
        return System.getProperty(PLATFORM_PREFIX_KEY, defaultPrefix);
    }

    public static boolean isIntelliJ() {
        return PlatformUtilsCore.isIdea() || PlatformUtilsCore.isCommunity();
    }

    public static boolean isIdea() {
        return IDEA_PREFIX.equals(PlatformUtilsCore.getPlatformPrefix());
    }

    public static boolean isCommunity() {
        return COMMUNITY_PREFIX.equals(PlatformUtilsCore.getPlatformPrefix());
    }

    public static boolean isRubyMine() {
        return RUBY_PREFIX.equals(PlatformUtilsCore.getPlatformPrefix());
    }

    public static boolean isAppCode() {
        return APPCODE_PREFIX.equals(PlatformUtilsCore.getPlatformPrefix());
    }

    public static boolean isCLion() {
        return CLION_PREFIX.equals(PlatformUtilsCore.getPlatformPrefix());
    }

    public static boolean isPyCharm() {
        return PlatformUtilsCore.isPyCharmPro() || PlatformUtilsCore.isPyCharmCommunity();
    }

    static boolean isPyCharmPro() {
        return PYCHARM_PREFIX.equals(PlatformUtilsCore.getPlatformPrefix());
    }

    static boolean isPyCharmCommunity() {
        return PYCHARM_PREFIX2.equals(PlatformUtilsCore.getPlatformPrefix());
    }

    public static boolean isPhpStorm() {
        return PHP_PREFIX.equals(PlatformUtilsCore.getPlatformPrefix());
    }

    public static boolean isWebStorm() {
        return WEB_PREFIX.equals(PlatformUtilsCore.getPlatformPrefix());
    }

    public static boolean isDatabaseIDE() {
        return DBE_PREFIX.equals(PlatformUtilsCore.getPlatformPrefix());
    }
}

