/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.resources.Density;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.devices.Storage;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.tools.idea.avdmanager.AvdActionPanel;
import com.android.tools.idea.avdmanager.AvdManagerConnection;
import com.android.tools.idea.avdmanager.AvdUiAction;
import com.android.tools.idea.avdmanager.CreateAvdAction;
import com.android.tools.idea.avdmanager.EmptyAvdListPanel;
import com.android.tools.idea.templates.TemplateUtils;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.IconLoader;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.table.TableView;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import icons.AndroidIcons;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AvdDisplayList
extends JPanel
implements ListSelectionListener,
AvdActionPanel.AvdRefreshProvider,
AvdUiAction.AvdInfoProvider {
    private static final Logger LOG = Logger.getInstance(AvdDisplayList.class);
    public static final String NONEMPTY = "nonempty";
    public static final String EMPTY = "empty";
    private final JButton myRefreshButton = new JButton(AllIcons.Actions.Refresh);
    private final JPanel myCenterCardPanel;
    private TableView<AvdInfo> myTable;
    private ListTableModel<AvdInfo> myModel = new ListTableModel(new ColumnInfo[0]);
    private Set<AvdSelectionListener> myListeners = Sets.newHashSet();
    private final MouseAdapter myEditingListener = new MouseAdapter(){

        @Override
        public void mouseMoved(MouseEvent e) {
            AvdDisplayList.this.possiblySwitchEditors(e);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            AvdDisplayList.this.possiblySwitchEditors(e);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            AvdDisplayList.this.possiblySwitchEditors(e);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            AvdDisplayList.this.possiblySwitchEditors(e);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            AvdDisplayList.this.possiblyShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            AvdDisplayList.this.possiblyShowPopup(e);
        }
    };
    private final ColumnInfo[] ourColumnInfos = new ColumnInfo[]{new AvdIconColumnInfo("Type"){

        @Nullable
        public Icon valueOf(AvdInfo avdInfo) {
            return AvdDisplayList.getIcon(avdInfo);
        }
    }, new AvdColumnInfo("Name"){

        @Nullable
        public String valueOf(AvdInfo info) {
            return AvdDisplayList.getPrettyDeviceName(info);
        }
    }, new AvdColumnInfo("Resolution"){

        @Nullable
        public String valueOf(AvdInfo avdInfo) {
            return AvdDisplayList.getResolution(avdInfo);
        }

        @Override
        @Nullable
        public Comparator<AvdInfo> getComparator() {
            return new Comparator<AvdInfo>(){

                @Override
                public int compare(AvdInfo o1, AvdInfo o2) {
                    Dimension d2;
                    Dimension d1 = AvdManagerConnection.getAvdResolution(o1);
                    if (d1 == (d2 = AvdManagerConnection.getAvdResolution(o2))) {
                        return 0;
                    }
                    if (d1 == null) {
                        return -1;
                    }
                    if (d2 == null) {
                        return 1;
                    }
                    return d1.width * d1.height - d2.width * d2.height;
                }
            };
        }
    }, new AvdColumnInfo("API", 50){

        @Nullable
        public String valueOf(AvdInfo avdInfo) {
            IAndroidTarget target = avdInfo.getTarget();
            if (target == null) {
                return "N/A";
            }
            return target.getVersion().getApiString();
        }
    }, new AvdColumnInfo("Target"){

        @Nullable
        public String valueOf(AvdInfo info) {
            IAndroidTarget target = info.getTarget();
            if (target == null) {
                return "N/A";
            }
            return target.getName();
        }
    }, new AvdColumnInfo("CPU/ABI", 60){

        @Nullable
        public String valueOf(AvdInfo avdInfo) {
            return avdInfo.getCpuArch();
        }
    }, new AvdSizeColumnInfo("Size on Disk"), new AvdActionsColumnInfo(this, "Actions", 2)};

    public AvdDisplayList() {
        this.myModel.setColumnInfos(this.ourColumnInfos);
        this.myModel.setSortable(true);
        this.myTable = new TableView();
        this.myTable.setModelAndUpdateColumns(this.myModel);
        this.setLayout(new BorderLayout());
        this.myCenterCardPanel = new JPanel(new CardLayout());
        this.myCenterCardPanel.add((Component)ScrollPaneFactory.createScrollPane(this.myTable), NONEMPTY);
        this.myCenterCardPanel.add((Component)new EmptyAvdListPanel(this), EMPTY);
        this.add((Component)this.myCenterCardPanel, "Center");
        JPanel southPanel = new JPanel(new BorderLayout());
        southPanel.add((Component)this.myRefreshButton, "East");
        this.myRefreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AvdDisplayList.this.refreshAvds();
            }
        });
        CreateAvdAction createAvdAction = new CreateAvdAction(this);
        JButton newButton = new JButton(createAvdAction);
        newButton.setIcon(createAvdAction.getIcon());
        newButton.setText(createAvdAction.getText());
        southPanel.add((Component)newButton, "West");
        this.add((Component)southPanel, "South");
        this.myTable.getSelectionModel().addListSelectionListener(this);
        this.myTable.addMouseListener((MouseListener)this.myEditingListener);
        this.myTable.addMouseMotionListener((MouseMotionListener)this.myEditingListener);
        this.refreshAvds();
    }

    public void addSelectionListener(AvdSelectionListener listener) {
        this.myListeners.add(listener);
    }

    public void removeSelectionListener(AvdSelectionListener listener) {
        this.myListeners.remove(listener);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        AvdInfo selected = (AvdInfo)this.myTable.getSelectedObject();
        for (AvdSelectionListener listener : this.myListeners) {
            listener.onAvdSelected(selected);
        }
    }

    @Override
    @Nullable
    public AvdInfo getAvdInfo() {
        return (AvdInfo)this.myTable.getSelectedObject();
    }

    @Override
    public void refreshAvds() {
        List<AvdInfo> avds = AvdManagerConnection.getAvds(true);
        this.myModel.setItems(avds);
        if (avds.isEmpty()) {
            ((CardLayout)this.myCenterCardPanel.getLayout()).show(this.myCenterCardPanel, EMPTY);
        } else {
            ((CardLayout)this.myCenterCardPanel.getLayout()).show(this.myCenterCardPanel, NONEMPTY);
        }
    }

    private void possiblySwitchEditors(MouseEvent e) {
        Point p = e.getPoint();
        int row = this.myTable.rowAtPoint(p);
        int col = this.myTable.columnAtPoint(p);
        if ((row != this.myTable.getEditingRow() || col != this.myTable.getEditingColumn()) && row != -1 && col != -1 && this.myTable.isCellEditable(row, col)) {
            this.myTable.editCellAt(row, col);
        }
    }

    private void possiblyShowPopup(MouseEvent e) {
        int lastColumn;
        Component maybeActionPanel;
        if (!e.isPopupTrigger()) {
            return;
        }
        Point p = e.getPoint();
        int row = this.myTable.rowAtPoint(p);
        int col = this.myTable.columnAtPoint(p);
        if (row != -1 && col != -1 && (maybeActionPanel = this.myTable.getCellRenderer(row, lastColumn = this.myTable.getColumnCount() - 1).getTableCellRendererComponent((JTable)this.myTable, this.myTable.getValueAt(row, lastColumn), false, true, row, lastColumn)) instanceof AvdActionPanel) {
            ((AvdActionPanel)maybeActionPanel).showPopup((Component)this.myTable, e);
        }
    }

    protected static String getResolution(AvdInfo info) {
        Dimension res = AvdManagerConnection.getAvdResolution(info);
        Density density = AvdManagerConnection.getAvdDensity(info);
        String densityString = density == null ? "Unknown Density" : density.getResourceValue();
        String resolution = res != null ? String.format(Locale.getDefault(), "%1$d \u00d7 %2$d: %3$s", res.width, res.height, densityString) : "Unknown Resolution";
        return resolution;
    }

    private static Icon getIcon(@NotNull AvdInfo info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/android/tools/idea/avdmanager/AvdDisplayList", "getIcon"));
        }
        String id = info.getTag().getId();
        if (id.contains("android-")) {
            String path = String.format("/icons/formfactors/%s_32.png", id.substring("android-".length()));
            return IconLoader.getIcon((String)path, AvdDisplayList.class);
        }
        return AndroidIcons.FormFactors.Mobile_32;
    }

    private static String getPrettyDeviceName(@NotNull AvdInfo info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/android/tools/idea/avdmanager/AvdDisplayList", "getPrettyDeviceName"));
        }
        String name = info.getDeviceName();
        StringBuilder sb = new StringBuilder(name.length());
        int n = name.length();
        boolean upperCaseNext = false;
        for (int i = 0; i < n; ++i) {
            char c = name.charAt(i);
            if (c == '_') {
                upperCaseNext = true;
                c = ' ';
            } else if (upperCaseNext || i == 0) {
                c = Character.toUpperCase(c);
                upperCaseNext = false;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private class AvdSizeColumnInfo
    extends AvdColumnInfo {
        public AvdSizeColumnInfo(String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/avdmanager/AvdDisplayList$AvdSizeColumnInfo", "<init>"));
            }
            super(name);
        }

        @NotNull
        private Storage getSize(AvdInfo avdInfo) {
            long sizeInBytes = 0L;
            if (avdInfo != null) {
                File avdDir = new File(avdInfo.getDataFolderPath());
                for (File file : TemplateUtils.listFiles(avdDir)) {
                    sizeInBytes += file.length();
                }
            }
            Storage storage = new Storage(sizeInBytes);
            if (storage == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdDisplayList$AvdSizeColumnInfo", "getSize"));
            }
            return storage;
        }

        @Nullable
        public String valueOf(AvdInfo avdInfo) {
            Storage size = this.getSize(avdInfo);
            return String.format(Locale.getDefault(), "%1$d MB", size.getSizeAsUnit(Storage.Unit.MiB));
        }

        @Override
        @Nullable
        public Comparator<AvdInfo> getComparator() {
            return new Comparator<AvdInfo>(){

                @Override
                public int compare(AvdInfo o1, AvdInfo o2) {
                    Storage s1 = AvdSizeColumnInfo.this.getSize(o1);
                    Storage s2 = AvdSizeColumnInfo.this.getSize(o2);
                    return Comparing.compare((long)s1.getSize(), (long)s2.getSize());
                }
            };
        }
    }

    private class AvdActionsColumnInfo
    extends ColumnInfo<AvdInfo, AvdInfo> {
        private int myNumVisibleActions;
        private int myWidth;
        private final ActionRenderer ourActionPanelRendererEditor;
        final /* synthetic */ AvdDisplayList this$0;

        public AvdActionsColumnInfo(@NotNull AvdDisplayList avdDisplayList, String name, int numVisibleActions) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/avdmanager/AvdDisplayList$AvdActionsColumnInfo", "<init>"));
            }
            this.this$0 = avdDisplayList;
            super(name);
            this.myNumVisibleActions = -1;
            this.ourActionPanelRendererEditor = new ActionRenderer(){
                Map<Object, Component> myInfoToComponentMap;
                {
                    this.myInfoToComponentMap = Maps.newHashMap();
                }

                private Component getComponent(JTable table, Object value, boolean isSelected, int row) {
                    Component panel;
                    if (this.myInfoToComponentMap.containsKey(value)) {
                        panel = this.myInfoToComponentMap.get(value);
                    } else {
                        panel = new AvdActionPanel((AvdInfo)value, AvdActionsColumnInfo.this.myNumVisibleActions, AvdActionsColumnInfo.this.this$0);
                        this.myInfoToComponentMap.put(value, panel);
                    }
                    if (table.getSelectedRow() == row || isSelected) {
                        panel.setBackground(table.getSelectionBackground());
                        panel.setForeground(table.getSelectionForeground());
                    } else {
                        panel.setBackground(table.getBackground());
                        panel.setForeground(table.getForeground());
                    }
                    return panel;
                }

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    return this.getComponent(table, value, isSelected, row);
                }

                public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                    return this.getComponent(table, value, isSelected, row);
                }

                public Object getCellEditorValue() {
                    return null;
                }
            };
            this.myNumVisibleActions = numVisibleActions;
            this.myWidth = numVisibleActions == -1 ? -1 : 45 * numVisibleActions + 50;
        }

        public AvdActionsColumnInfo(@NotNull AvdDisplayList avdDisplayList, String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/avdmanager/AvdDisplayList$AvdActionsColumnInfo", "<init>"));
            }
            this(avdDisplayList, name, -1);
        }

        @Nullable
        public AvdInfo valueOf(AvdInfo avdInfo) {
            return avdInfo;
        }

        @Nullable
        public Comparator<AvdInfo> getComparator() {
            return new Comparator<AvdInfo>(){

                @Override
                public int compare(AvdInfo o1, AvdInfo o2) {
                    return o1.getStatus().compareTo((Enum)o2.getStatus());
                }
            };
        }

        @Nullable
        public TableCellRenderer getRenderer(AvdInfo o) {
            return this.ourActionPanelRendererEditor;
        }

        @Nullable
        public TableCellEditor getEditor(AvdInfo avdInfo) {
            return this.ourActionPanelRendererEditor;
        }

        public boolean isCellEditable(AvdInfo avdInfo) {
            return true;
        }

        public int getWidth(JTable table) {
            return this.myWidth;
        }
    }

    private static abstract class ActionRenderer
    extends AbstractTableCellEditor
    implements TableCellRenderer {
        private ActionRenderer() {
        }
    }

    public static abstract class AvdColumnInfo
    extends ColumnInfo<AvdInfo, String> {
        private final Border myBorder;
        private final TableCellRenderer myRenderer;
        private final int myWidth;

        public AvdColumnInfo(@NotNull String name, int width) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/avdmanager/AvdDisplayList$AvdColumnInfo", "<init>"));
            }
            super(name);
            this.myBorder = IdeBorderFactory.createEmptyBorder((int)10, (int)10, (int)10, (int)10);
            this.myRenderer = new TableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    JBLabel label = new JBLabel((String)value);
                    label.setBorder(AvdColumnInfo.this.myBorder);
                    if (table.getSelectedRow() == row) {
                        label.setBackground(table.getSelectionBackground());
                        label.setForeground(table.getSelectionForeground());
                        label.setOpaque(true);
                    }
                    return label;
                }
            };
            this.myWidth = width;
        }

        public AvdColumnInfo(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/avdmanager/AvdDisplayList$AvdColumnInfo", "<init>"));
            }
            this(name, -1);
        }

        @Nullable
        public TableCellRenderer getRenderer(AvdInfo o) {
            return this.myRenderer;
        }

        @Nullable
        public Comparator<AvdInfo> getComparator() {
            return new Comparator<AvdInfo>(){

                @Override
                public int compare(AvdInfo o1, AvdInfo o2) {
                    String s1 = (String)AvdColumnInfo.this.valueOf(o1);
                    String s2 = (String)AvdColumnInfo.this.valueOf(o2);
                    return Comparing.compare((Comparable)((Object)s1), (Comparable)((Object)s2));
                }
            };
        }

        public int getWidth(JTable table) {
            return this.myWidth;
        }
    }

    private static abstract class AvdIconColumnInfo
    extends ColumnInfo<AvdInfo, Icon> {
        private final int myWidth;
        private static final TableCellRenderer ourIconRenderer = new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JBLabel label = new JBLabel((Icon)value);
                if (table.getSelectedRow() == row) {
                    label.setBackground(table.getSelectionBackground());
                    label.setForeground(table.getSelectionForeground());
                    label.setOpaque(true);
                }
                return label;
            }
        };

        public AvdIconColumnInfo(@NotNull String name, int width) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/avdmanager/AvdDisplayList$AvdIconColumnInfo", "<init>"));
            }
            super(name);
            this.myWidth = width;
        }

        public AvdIconColumnInfo(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/avdmanager/AvdDisplayList$AvdIconColumnInfo", "<init>"));
            }
            this(name, 50);
        }

        @Nullable
        public TableCellRenderer getRenderer(AvdInfo o) {
            return ourIconRenderer;
        }

        public int getWidth(JTable table) {
            return this.myWidth;
        }
    }

    public static interface AvdSelectionListener {
        public void onAvdSelected(@Nullable AvdInfo var1);
    }
}

