/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.sdklib.SdkVersionInfo;
import com.android.tools.idea.avdmanager.AvdWizardConstants;
import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.intellij.openapi.util.IconLoader;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.UIUtil;
import icons.AndroidIcons;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SystemImagePreview
extends JPanel {
    private static final String NO_SYSTEM_IMAGE_SELECTED = "No System Image Selected";
    private static final int FIGURE_PADDING = 3;
    private AvdWizardConstants.SystemImageDescription myImageDescription;
    private static final int PADDING = 20;

    public void setImage(@Nullable AvdWizardConstants.SystemImageDescription image) {
        this.myImageDescription = image;
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        GraphicsUtil.setupAntialiasing((Graphics)g);
        GraphicsUtil.setupAAPainting((Graphics)g);
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setColor(JBColor.background());
        g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
        g2d.setColor(JBColor.foreground());
        g2d.setFont(AvdWizardConstants.STANDARD_FONT);
        if (this.myImageDescription == null) {
            FontMetrics metrics = g2d.getFontMetrics();
            g2d.drawString(NO_SYSTEM_IMAGE_SELECTED, (this.getWidth() - metrics.stringWidth(NO_SYSTEM_IMAGE_SELECTED)) / 2, (this.getHeight() - metrics.getHeight()) / 2);
            return;
        }
        g2d.setFont(AvdWizardConstants.TITLE_FONT);
        FontMetrics metrics = g.getFontMetrics(AvdWizardConstants.TITLE_FONT);
        String codeName = SystemImagePreview.getCodeName(this.myImageDescription);
        g2d.drawString(codeName, 20, 20 + metrics.getHeight() / 2);
        g2d.drawLine(0, 50, this.getWidth(), 50);
        Icon icon = SystemImagePreview.getIcon(codeName);
        if (icon != null) {
            icon.paintIcon(this, g, 3, 70);
        }
        int stringHeight = g2d.getFontMetrics(AvdWizardConstants.TITLE_FONT).getHeight();
        int figureHeight = g2d.getFontMetrics(AvdWizardConstants.FIGURE_FONT).getHeight();
        int infoSegmentX = 151;
        int infoSegmentY = 95;
        g2d.setFont(AvdWizardConstants.FIGURE_FONT);
        g2d.drawString("API Level", infoSegmentX, infoSegmentY += figureHeight);
        g2d.setFont(AvdWizardConstants.TITLE_FONT);
        g2d.drawString(this.myImageDescription.target.getVersion().getApiString(), infoSegmentX, infoSegmentY += stringHeight);
        infoSegmentY += 20;
        g2d.setFont(AvdWizardConstants.FIGURE_FONT);
        g2d.drawString("Android", infoSegmentX, infoSegmentY += figureHeight);
        g2d.setFont(AvdWizardConstants.TITLE_FONT);
        g2d.drawString(this.myImageDescription.target.getVersionName(), infoSegmentX, infoSegmentY += stringHeight);
        String vendorName = this.myImageDescription.target.getVendor();
        if (metrics.stringWidth(vendorName) > 128) {
            Iterable parts = Splitter.on((CharMatcher)CharMatcher.WHITESPACE).omitEmptyStrings().split((CharSequence)vendorName);
            String currentLine = "";
            for (String part : parts) {
                if (metrics.stringWidth(currentLine) >= 128) {
                    g2d.drawString(currentLine, infoSegmentX, infoSegmentY += stringHeight);
                    currentLine = "";
                }
                currentLine = currentLine + part + " ";
            }
            if (!currentLine.isEmpty()) {
                g2d.drawString(currentLine, infoSegmentX, infoSegmentY += stringHeight);
            }
        } else {
            g2d.drawString(vendorName, infoSegmentX, infoSegmentY += stringHeight);
        }
        infoSegmentY += 20;
        g2d.setFont(AvdWizardConstants.FIGURE_FONT);
        g2d.drawString("System Image", infoSegmentX, infoSegmentY += figureHeight);
        g2d.setFont(AvdWizardConstants.TITLE_FONT);
        g2d.drawString(this.myImageDescription.systemImage.getAbiType(), infoSegmentX, infoSegmentY += stringHeight);
        if (this.myImageDescription.target.getVersion().getApiLevel() < 8) {
            g2d.setFont(AvdWizardConstants.TITLE_FONT);
            g2d.drawString("This API Level is Deprecated", 20, infoSegmentY += stringHeight * 2);
        }
    }

    public static String getCodeName(@NotNull AvdWizardConstants.SystemImageDescription description) {
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "com/android/tools/idea/avdmanager/SystemImagePreview", "getCodeName"));
        }
        return SdkVersionInfo.getCodeName((int)description.target.getVersion().getApiLevel());
    }

    @Nullable
    public static Icon getIcon(@Nullable String codename) {
        if (codename == null) {
            return null;
        }
        try {
            return IconLoader.getIcon((String)String.format("/icons/versions/%1$s.png", codename), AndroidIcons.class);
        }
        catch (RuntimeException e) {
            int size = 128;
            BufferedImage image = UIUtil.createImage((int)size, (int)size, (int)2);
            Graphics g = ((Image)image).getGraphics();
            GraphicsUtil.setupAntialiasing((Graphics)g);
            GraphicsUtil.setupAAPainting((Graphics)g);
            Font f = UIUtil.getLabelFont();
            Font font = new Font(f.getName(), f.getStyle() | 1, 100);
            g.setColor(JBColor.background());
            g.fillRect(0, 0, size, size);
            g.setColor(JBColor.foreground());
            g.setFont(font);
            int height = g.getFontMetrics().getHeight();
            int width = g.getFontMetrics().stringWidth("?");
            g.drawString("?", (size - width) / 2, height + (size - height) / 2);
            return new ImageIcon(image);
        }
    }
}

