/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.navigation;

import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.State;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.editors.navigation.Transform;
import com.android.tools.idea.editors.navigation.Utilities;
import com.intellij.openapi.project.Project;
import java.awt.Dimension;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

class RenderingParameters {
    @NotNull
    final Project myProject;
    @NotNull
    final Configuration myConfiguration;
    @NotNull
    final AndroidFacet myFacet;

    public RenderingParameters(@NotNull Project project, @NotNull Configuration configuration, @NotNull AndroidFacet facet) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/editors/navigation/RenderingParameters", "<init>"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/android/tools/idea/editors/navigation/RenderingParameters", "<init>"));
        }
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/editors/navigation/RenderingParameters", "<init>"));
        }
        this.myProject = project;
        this.myConfiguration = configuration;
        this.myFacet = facet;
    }

    com.android.navigation.Dimension getDeviceScreenSize() {
        return com.android.navigation.Dimension.create(this.getDeviceScreenSize1());
    }

    private Dimension getDeviceScreenSize1() {
        Configuration configuration = this.myConfiguration;
        Device device = configuration.getDevice();
        if (device == null) {
            return Utilities.ZERO_SIZE;
        }
        State deviceState = configuration.getDeviceState();
        if (deviceState == null) {
            deviceState = device.getDefaultState();
        }
        return Utilities.notNull(device.getScreenSize(deviceState.getOrientation()));
    }

    Dimension getDeviceScreenSizeFor(Transform transform) {
        return transform.modelToView(this.getDeviceScreenSize());
    }
}

