/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.navigation.macros;

import com.android.navigation.ActivityState;
import com.android.navigation.MenuState;
import com.android.navigation.NavigationModel;
import com.android.navigation.State;
import com.android.navigation.Transition;
import com.android.tools.idea.editors.navigation.Utilities;
import com.android.tools.idea.editors.navigation.macros.Macros;
import com.android.tools.idea.editors.navigation.macros.MultiMatch;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.codeStyle.CodeStyleManager;

public class CodeGenerator {
    public final Module module;
    public final NavigationModel navigationModel;

    public CodeGenerator(NavigationModel navigationModel, Module module) {
        this.navigationModel = navigationModel;
        this.module = module;
    }

    private ActivityState getAssociatedActivityState(MenuState menuState) {
        for (Transition t : this.navigationModel.getTransitions()) {
            State state;
            if (t.getDestination().getState() != menuState || !((state = t.getSource().getState()) instanceof ActivityState)) continue;
            return (ActivityState)state;
        }
        assert (false);
        return null;
    }

    public void implementTransition(final Transition transition) {
        PsiClass psiClass;
        ActivityState newActivity;
        Project project = this.module.getProject();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
        final PsiElementFactory factory = facade.getElementFactory();
        final CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
        final Macros macros = Macros.getInstance(this.module.getProject());
        State sourceState = transition.getSource().getState();
        State destinationState = transition.getDestination().getState();
        if (sourceState instanceof MenuState && destinationState instanceof ActivityState) {
            MenuState menuState = (MenuState)sourceState;
            newActivity = (ActivityState)destinationState;
            final ActivityState originatingActivity = this.getAssociatedActivityState(menuState);
            final PsiClass psiClass2 = Utilities.getPsiClass(this.module, originatingActivity.getClassName());
            if (psiClass2 != null) {
                new WriteCommandAction<Void>(project, "Add navigation transition", new PsiFile[]{psiClass2.getContainingFile()}){

                    protected void run(Result<Void> result) {
                        PsiMethod signature = factory.createMethodFromText("public boolean onPrepareOptionsMenu(Menu menu){ }", (PsiElement)psiClass2);
                        PsiMethod method = psiClass2.findMethodBySignature(signature, false);
                        if (method == null) {
                            method = factory.createMethodFromText("@Override public boolean onPrepareOptionsMenu(Menu menu){boolean result=super.onPrepareOptionsMenu(menu);return result;}", (PsiElement)psiClass2);
                            psiClass2.add((PsiElement)method);
                            method = psiClass2.findMethodBySignature(signature, false);
                        }
                        String parameterName = method.getParameterList().getParameters()[0].getName();
                        PsiCodeBlock body = method.getBody();
                        PsiStatement[] statements = body.getStatements();
                        PsiStatement lastStatement = statements[statements.length - 1];
                        MultiMatch macro = macros.installMenuItemOnGetMenuItemAndLaunchActivityMacro;
                        MultiMatch.Bindings<String> bindings = new MultiMatch.Bindings<String>();
                        bindings.put("$consume", "true");
                        bindings.put("$menuItem", "$menu", parameterName);
                        bindings.put("$menuItem", "$id", "R.id." + transition.getSource().getViewName());
                        bindings.put("$f", "context", originatingActivity.getClassName() + ".this");
                        bindings.put("$f", "activityClass", newActivity.getClassName() + ".class");
                        String newCode = macro.instantiate(bindings);
                        PsiStatement newStatement = factory.createStatementFromText(newCode + ";", (PsiElement)body);
                        body.addBefore((PsiElement)newStatement, (PsiElement)lastStatement);
                        codeStyleManager.reformat((PsiElement)method);
                    }
                }.execute();
            }
        }
        if (sourceState instanceof ActivityState && destinationState instanceof MenuState) {
            ActivityState activityState = (ActivityState)sourceState;
            final MenuState menuState = (MenuState)destinationState;
            psiClass = Utilities.getPsiClass(this.module, activityState.getClassName());
            if (psiClass != null) {
                new WriteCommandAction<Void>(project, "Add navigation transition", new PsiFile[]{psiClass.getContainingFile()}){

                    protected void run(Result<Void> result) {
                        PsiMethod signature = factory.createMethodFromText("boolean onCreateOptionsMenu(Menu menu){}", (PsiElement)psiClass);
                        PsiMethod method = psiClass.findMethodBySignature(signature, false);
                        if (method == null) {
                            method = factory.createMethodFromText("@Override public boolean onCreateOptionsMenu(Menu menu) { return true;}", (PsiElement)psiClass);
                            psiClass.add((PsiElement)method);
                            method = psiClass.findMethodBySignature(signature, false);
                        }
                        String parameterName = method.getParameterList().getParameters()[0].getName();
                        PsiCodeBlock body = method.getBody();
                        PsiStatement[] statements = body.getStatements();
                        PsiStatement lastStatement = statements[statements.length - 1];
                        String newStatementText = "getMenuInflater().inflate(R.menu.$XmlResourceName, $parameterName);";
                        newStatementText = newStatementText.replace("$XmlResourceName", menuState.getXmlResourceName());
                        newStatementText = newStatementText.replace("$parameterName", parameterName);
                        PsiStatement newStatement = factory.createStatementFromText(newStatementText, (PsiElement)body);
                        body.addBefore((PsiElement)newStatement, (PsiElement)lastStatement);
                        codeStyleManager.reformat((PsiElement)method);
                    }
                }.execute();
            }
        }
        if (sourceState instanceof ActivityState && destinationState instanceof ActivityState) {
            final ActivityState sourceActivityState = (ActivityState)sourceState;
            newActivity = (ActivityState)destinationState;
            psiClass = Utilities.getPsiClass(this.module, sourceActivityState.getClassName());
            if (psiClass != null) {
                new WriteCommandAction<Void>(project, "Add navigation transition", new PsiFile[]{psiClass.getContainingFile()}){

                    protected void run(Result<Void> result) {
                        PsiMethod signature = factory.createMethodFromText("void onCreate(Bundle savedInstanceState){}", (PsiElement)psiClass);
                        PsiMethod method = psiClass.findMethodBySignature(signature, false);
                        if (method == null) {
                            method = factory.createMethodFromText("@Override public void onCreate(Bundle savedInstanceState) {super.onCreate(savedInstanceState);}", (PsiElement)psiClass);
                            psiClass.add((PsiElement)method);
                            method = psiClass.findMethodBySignature(signature, false);
                        }
                        PsiCodeBlock body = method.getBody();
                        PsiStatement[] statements = body.getStatements();
                        PsiStatement lastStatement = statements[statements.length - 1];
                        String newCode = "findViewById($id).setOnClickListener(new View.OnClickListener() {   @Override  public void onClick(View v) {    $context.startActivity(new Intent($context, $activityClass));  }})";
                        newCode = newCode.replaceAll("\\$id", "R.id." + transition.getSource().getViewName());
                        newCode = newCode.replaceAll("\\$context", sourceActivityState.getClassName() + ".this");
                        newCode = newCode.replaceAll("\\$activityClass", newActivity.getClassName() + ".class");
                        PsiStatement newStatement = factory.createStatementFromText(newCode + ";", (PsiElement)body);
                        body.addAfter((PsiElement)newStatement, (PsiElement)lastStatement);
                        codeStyleManager.reformat((PsiElement)method);
                    }
                }.execute();
            }
        }
    }
}

