/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.navigation.macros;

import com.android.tools.idea.editors.navigation.Utilities;
import com.android.tools.idea.editors.navigation.macros.MultiMatch;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiMethod;
import java.io.IOException;
import java.io.InputStream;
import java.util.IdentityHashMap;
import java.util.Map;

public class Macros {
    private static final String DEFINE_ASSIGNMENT = "void macro(String $fragmentName, Void $messageController) {    getFragment($fragmentName, $messageController);}";
    private static final String DEFINE_INNER_CLASS = "void macro(Class $Interface, Void $method, Class $Type, Object $arg, final Statement $f) {    new $Interface() {        public void $method($Type $arg) {            $f.$();        }    };}";
    private static final String INSTALL_CLICK_LISTENER = "void macro(View $view, Statement $f) {    $view.setOnClickListener(new View.OnClickListener() {        @Override        public void onClick(View view) {            $f.$();        }    });}";
    private static final String INSTALL_MENU_ITEM_CLICK = "void macro(MenuItem $menuItem, final Statement $f, final boolean $consume) {    $menuItem.setOnMenuItemClickListener(new MenuItem.OnMenuItemClickListener() {        @Override        public boolean onMenuItemClick(MenuItem menuItem) {            $f.$();            return $consume;        }    });}";
    private static final String INSTALL_ITEM_CLICK_LISTENER = "void macro(ListView $listView, final Statement $f) {    $listView.setOnItemClickListener(new AdapterView.OnItemClickListener() {        @Override        public void onItemClick(AdapterView<?> parent, View view, int position, long id) {            $f.$$();        }    });}";
    private static final String GET_MENU_ITEM = "void macro(Menu $menu, int $id) {    $menu.findItem($id);}";
    private static final String LAUNCH_ACTIVITY = "void macro(Context context, Class activityClass) {    context.startActivity(new Intent(context, activityClass));}";
    private static final String LAUNCH_ACTIVITY_WITH_ARG = "<T extends Serializable> void macro(Context context, Class activityClass, String name, T value) {    context.startActivity(new Intent(context, activityClass).putExtra(name, value));}";
    public final PsiMethod defineAssignment;
    public final MultiMatch createIntent;
    public final MultiMatch installClickAndCallMacro;
    public final MultiMatch installItemClickAndCallMacro;
    public final MultiMatch installMenuItemOnGetMenuItemAndLaunchActivityMacro;
    public final MultiMatch defineInnerClassToLaunchActivityMacro;
    public final MultiMatch findViewById;
    public final MultiMatch findFragmentByTag;
    private static Map<Project, Macros> ourProjectToMacros = new IdentityHashMap<Project, Macros>();
    private final Project myProject;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PsiMethod[] getMethodsByName(String templateName, String methodName, Project project) {
        PsiMethod[] psiMethodArray;
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
        PsiElementFactory factory = facade.getElementFactory();
        ClassLoader classLoader = Macros.class.getClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream("/navigationTemplates/" + templateName + ".java.template");
        try {
            int available = inputStream.available();
            byte[] buffer = new byte[available];
            assert (available == inputStream.read(buffer));
            String text = new String(buffer);
            int start = text.indexOf("{");
            int end = text.lastIndexOf("}");
            String body = text.substring(start + 1, end);
            PsiClass psiClass = factory.createClassFromText(body, null);
            psiMethodArray = psiClass.findMethodsByName(methodName, false);
        }
        catch (Throwable throwable) {
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        inputStream.close();
        return psiMethodArray;
    }

    public static Macros getInstance(Project project) {
        Macros result = ourProjectToMacros.get(project);
        if (result == null) {
            result = new Macros(project);
            ourProjectToMacros.put(project, result);
        }
        return result;
    }

    public MultiMatch createMacro(String methodDefinition) {
        return MultiMatch.create(this.myProject, methodDefinition);
    }

    private PsiMethod getMethodFromText(String definition) {
        return Utilities.createMethodFromText(this.myProject, definition);
    }

    private Macros(Project project) {
        this.myProject = project;
        this.defineAssignment = this.getMethodFromText(DEFINE_ASSIGNMENT);
        PsiMethod defineInnerClassMacro = this.getMethodFromText(DEFINE_INNER_CLASS);
        PsiMethod installClickMacro = this.getMethodFromText(INSTALL_CLICK_LISTENER);
        PsiMethod installMenuItemClickMacro = this.getMethodFromText(INSTALL_MENU_ITEM_CLICK);
        PsiMethod installItemClickMacro = this.getMethodFromText(INSTALL_ITEM_CLICK_LISTENER);
        PsiMethod getMenuItemMacro = this.getMethodFromText(GET_MENU_ITEM);
        PsiMethod launchActivityMacro = this.getMethodFromText(LAUNCH_ACTIVITY);
        PsiMethod launchActivityMacro2 = this.getMethodFromText(LAUNCH_ACTIVITY_WITH_ARG);
        this.createIntent = this.createMacro("void macro(Context context, Class activityClass) { new Intent(context, activityClass); }");
        this.installClickAndCallMacro = new MultiMatch(installClickMacro);
        this.installItemClickAndCallMacro = new MultiMatch(installItemClickMacro);
        this.findViewById = this.createMacro("void findViewById(int $id) { findViewById(R.id.$id);}");
        this.findFragmentByTag = this.createMacro("void findViewById(void $fragmentManager, int $tag) { $fragmentManager.findFragmentByTag($tag);}");
        this.installMenuItemOnGetMenuItemAndLaunchActivityMacro = new MultiMatch(installMenuItemClickMacro);
        this.installMenuItemOnGetMenuItemAndLaunchActivityMacro.addSubMacro("$menuItem", getMenuItemMacro);
        this.installMenuItemOnGetMenuItemAndLaunchActivityMacro.addSubMacro("$f", launchActivityMacro);
        this.defineInnerClassToLaunchActivityMacro = new MultiMatch(defineInnerClassMacro);
        this.defineInnerClassToLaunchActivityMacro.addSubMacro("$f", launchActivityMacro2);
    }
}

