/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.util;

import com.android.SdkConstants;
import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.AndroidArtifactOutput;
import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.AndroidProject;
import com.android.builder.model.Variant;
import com.android.ide.common.repository.GradleCoordinate;
import com.android.sdklib.repository.FullRevision;
import com.android.tools.idea.gradle.IdeaAndroidProject;
import com.android.tools.idea.gradle.facet.AndroidGradleFacet;
import com.android.tools.idea.gradle.facet.AndroidGradleFacetConfiguration;
import com.android.tools.idea.gradle.project.ChooseGradleHomeDialog;
import com.android.tools.idea.gradle.util.AndroidGradleSettings;
import com.android.tools.idea.gradle.util.BuildMode;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.gradle.util.PropertiesUtil;
import com.android.tools.idea.templates.TemplateManager;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableEP;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.KeyValue;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.Processor;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.net.HttpConfigurable;
import icons.AndroidIcons;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.gradle.StartParameter;
import org.gradle.wrapper.PathAssembler;
import org.gradle.wrapper.WrapperConfiguration;
import org.gradle.wrapper.WrapperExecutor;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.GradleInstallationManager;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyLexer;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;

public final class GradleUtil {
    @NonNls
    public static final String BUILD_DIR_DEFAULT_NAME = "build";
    @NonNls
    public static final String GRADLE_WRAPPER_EXECUTABLE_NAME = SystemInfo.isWindows ? "gradlew.bat" : "gradlew";
    @NonNls
    private static final String GRADLE_EXECUTABLE_NAME = SystemInfo.isWindows ? "gradle.bat" : "gradle";
    @NonNls
    public static final String GRADLEW_PROPERTIES_PATH = FileUtil.join((String[])new String[]{SdkConstants.FD_GRADLE_WRAPPER, "gradle-wrapper.properties"});
    private static final Logger LOG = Logger.getInstance(GradleUtil.class);
    private static final Pattern GRADLE_JAR_NAME_PATTERN = Pattern.compile("gradle-(.*)-(.*)\\.jar");
    private static final ProjectSystemId SYSTEM_ID = GradleConstants.SYSTEM_ID;
    public static final CharMatcher ILLEGAL_GRADLE_PATH_CHARS_MATCHER = CharMatcher.anyOf((CharSequence)"\\/");
    public static final Pattern GRADLE_DISTRIBUTION_URL_PATTERN = Pattern.compile(".*-([^-]+)-([^.]+).zip");

    private GradleUtil() {
    }

    @Deprecated
    @NotNull
    public static AndroidArtifactOutput getOutput(@NotNull AndroidArtifact artifact) {
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/android/tools/idea/gradle/util/GradleUtil", "getOutput"));
        }
        Collection outputs = artifact.getOutputs();
        assert (!outputs.isEmpty());
        AndroidArtifactOutput output = (AndroidArtifactOutput)ContainerUtil.getFirstItem((Collection)outputs);
        assert (output != null);
        AndroidArtifactOutput androidArtifactOutput = output;
        if (androidArtifactOutput == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/GradleUtil", "getOutput"));
        }
        return androidArtifactOutput;
    }

    @NotNull
    public static Icon getModuleIcon(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/util/GradleUtil", "getModuleIcon"));
        }
        AndroidProject androidProject = GradleUtil.getAndroidProject(module);
        if (androidProject != null) {
            Icon icon = androidProject.isLibrary() ? AndroidIcons.LibraryModule : AndroidIcons.AppModule;
            if (icon == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/GradleUtil", "getModuleIcon"));
            }
            return icon;
        }
        Icon icon = Projects.isGradleProject(module.getProject()) ? AllIcons.Nodes.PpJdk : AllIcons.Nodes.Module;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/GradleUtil", "getModuleIcon"));
        }
        return icon;
    }

    @Nullable
    public static AndroidProject getAndroidProject(@NotNull Module module) {
        IdeaAndroidProject androidProject;
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/util/GradleUtil", "getAndroidProject"));
        }
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet != null && (androidProject = facet.getIdeaAndroidProject()) != null) {
            return androidProject.getDelegate();
        }
        return null;
    }

    @Nullable
    public static String getGradlePath(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/util/GradleUtil", "getGradlePath"));
        }
        AndroidGradleFacet facet = AndroidGradleFacet.getInstance(module);
        return facet != null ? ((AndroidGradleFacetConfiguration)facet.getConfiguration()).GRADLE_PROJECT_PATH : null;
    }

    @NotNull
    public static List<AndroidLibrary> getDirectLibraryDependencies(@NotNull Variant variant) {
        if (variant == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variant", "com/android/tools/idea/gradle/util/GradleUtil", "getDirectLibraryDependencies"));
        }
        ArrayList libraries = Lists.newArrayList();
        libraries.addAll(variant.getMainArtifact().getDependencies().getLibraries());
        AndroidArtifact testArtifact = IdeaAndroidProject.findInstrumentationTestArtifact(variant);
        if (testArtifact != null) {
            libraries.addAll(testArtifact.getDependencies().getLibraries());
        }
        ArrayList arrayList = libraries;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/GradleUtil", "getDirectLibraryDependencies"));
        }
        return arrayList;
    }

    @Nullable
    public static Module findModuleByGradlePath(@NotNull Project project, @NotNull String gradlePath) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/GradleUtil", "findModuleByGradlePath"));
        }
        if (gradlePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradlePath", "com/android/tools/idea/gradle/util/GradleUtil", "findModuleByGradlePath"));
        }
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        for (Module module : moduleManager.getModules()) {
            AndroidGradleFacet gradleFacet = AndroidGradleFacet.getInstance(module);
            if (gradleFacet == null || !gradlePath.equals(((AndroidGradleFacetConfiguration)gradleFacet.getConfiguration()).GRADLE_PROJECT_PATH)) continue;
            return module;
        }
        return null;
    }

    @NotNull
    public static List<String> getPathSegments(@NotNull String gradlePath) {
        if (gradlePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradlePath", "com/android/tools/idea/gradle/util/GradleUtil", "getPathSegments"));
        }
        ArrayList arrayList = Lists.newArrayList((Iterable)Splitter.on((String)":").omitEmptyStrings().split((CharSequence)gradlePath));
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/GradleUtil", "getPathSegments"));
        }
        return arrayList;
    }

    @Nullable
    public static VirtualFile getGradleBuildFile(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/util/GradleUtil", "getGradleBuildFile"));
        }
        AndroidGradleFacet gradleFacet = AndroidGradleFacet.getInstance(module);
        if (gradleFacet != null && gradleFacet.getGradleProject() != null) {
            return gradleFacet.getGradleProject().getBuildFile();
        }
        File moduleFilePath = new File(module.getModuleFilePath());
        return GradleUtil.getGradleBuildFile(moduleFilePath.getParentFile());
    }

    @Nullable
    public static VirtualFile getGradleBuildFile(@NotNull File rootDir) {
        if (rootDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootDir", "com/android/tools/idea/gradle/util/GradleUtil", "getGradleBuildFile"));
        }
        File gradleBuildFilePath = GradleUtil.getGradleBuildFilePath(rootDir);
        return VfsUtil.findFileByIoFile((File)gradleBuildFilePath, (boolean)true);
    }

    @NotNull
    public static File getGradleBuildFilePath(@NotNull File rootDir) {
        if (rootDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootDir", "com/android/tools/idea/gradle/util/GradleUtil", "getGradleBuildFilePath"));
        }
        File file = new File(rootDir, "build.gradle");
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/GradleUtil", "getGradleBuildFilePath"));
        }
        return file;
    }

    @Nullable
    public static VirtualFile getGradleSettingsFile(@NotNull File rootDir) {
        if (rootDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootDir", "com/android/tools/idea/gradle/util/GradleUtil", "getGradleSettingsFile"));
        }
        File gradleSettingsFilePath = GradleUtil.getGradleSettingsFilePath(rootDir);
        return VfsUtil.findFileByIoFile((File)gradleSettingsFilePath, (boolean)true);
    }

    @NotNull
    public static File getGradleSettingsFilePath(@NotNull File rootDir) {
        if (rootDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootDir", "com/android/tools/idea/gradle/util/GradleUtil", "getGradleSettingsFilePath"));
        }
        File file = new File(rootDir, "settings.gradle");
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/GradleUtil", "getGradleSettingsFilePath"));
        }
        return file;
    }

    @NotNull
    public static File getGradleWrapperPropertiesFilePath(@NotNull File projectRootDir) {
        if (projectRootDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectRootDir", "com/android/tools/idea/gradle/util/GradleUtil", "getGradleWrapperPropertiesFilePath"));
        }
        File file = new File(projectRootDir, GRADLEW_PROPERTIES_PATH);
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/GradleUtil", "getGradleWrapperPropertiesFilePath"));
        }
        return file;
    }

    public static boolean updateGradleDistributionUrl(@NotNull String gradleVersion, @NotNull File propertiesFile) throws IOException {
        if (gradleVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleVersion", "com/android/tools/idea/gradle/util/GradleUtil", "updateGradleDistributionUrl"));
        }
        if (propertiesFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertiesFile", "com/android/tools/idea/gradle/util/GradleUtil", "updateGradleDistributionUrl"));
        }
        Properties properties = PropertiesUtil.getProperties(propertiesFile);
        String gradleDistributionUrl = GradleUtil.getGradleDistributionUrl(gradleVersion, false);
        String property = properties.getProperty("distributionUrl");
        if (property != null && (property.equals(gradleDistributionUrl) || property.equals(GradleUtil.getGradleDistributionUrl(gradleVersion, true)))) {
            return false;
        }
        properties.setProperty("distributionUrl", gradleDistributionUrl);
        PropertiesUtil.savePropertiesToFile(properties, propertiesFile, null);
        return true;
    }

    @Nullable
    public static String getGradleWrapperVersion(@NotNull File propertiesFile) throws IOException {
        Matcher m;
        if (propertiesFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertiesFile", "com/android/tools/idea/gradle/util/GradleUtil", "getGradleWrapperVersion"));
        }
        Properties properties = PropertiesUtil.getProperties(propertiesFile);
        String url = properties.getProperty("distributionUrl");
        if (url != null && (m = GRADLE_DISTRIBUTION_URL_PATTERN.matcher(url)).matches()) {
            return m.group(1);
        }
        return null;
    }

    @NotNull
    private static String getGradleDistributionUrl(@NotNull String gradleVersion, boolean binOnly) {
        if (gradleVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleVersion", "com/android/tools/idea/gradle/util/GradleUtil", "getGradleDistributionUrl"));
        }
        String suffix = binOnly ? "bin" : "all";
        String string = String.format("http://services.gradle.org/distributions/gradle-%1$s-" + suffix + ".zip", gradleVersion);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/GradleUtil", "getGradleDistributionUrl"));
        }
        return string;
    }

    @Nullable
    public static GradleExecutionSettings getGradleExecutionSettings(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/GradleUtil", "getGradleExecutionSettings"));
        }
        GradleProjectSettings projectSettings = GradleUtil.getGradleProjectSettings(project);
        if (projectSettings == null) {
            String format = "Unable to obtain Gradle project settings for project '%1$s', located at '%2$s'";
            String msg = String.format(format, project.getName(), FileUtil.toSystemDependentName((String)project.getBasePath()));
            LOG.info(msg);
            return null;
        }
        try {
            GradleExecutionSettings settings = (GradleExecutionSettings)ExternalSystemApiUtil.getExecutionSettings((Project)project, (String)projectSettings.getExternalProjectPath(), (ProjectSystemId)SYSTEM_ID);
            if (settings != null) {
                settings.setRemoteProcessIdleTtlInMs(-1L);
            }
            return settings;
        }
        catch (IllegalArgumentException e) {
            LOG.info("Failed to obtain Gradle execution settings", (Throwable)e);
            return null;
        }
    }

    @Nullable
    public static File findWrapperPropertiesFile(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/GradleUtil", "findWrapperPropertiesFile"));
        }
        File baseDir = new File(project.getBasePath());
        File wrapperPropertiesFile = GradleUtil.getGradleWrapperPropertiesFilePath(baseDir);
        return wrapperPropertiesFile.isFile() ? wrapperPropertiesFile : null;
    }

    @Nullable
    public static GradleProjectSettings getGradleProjectSettings(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/GradleUtil", "getGradleProjectSettings"));
        }
        GradleSettings settings = (GradleSettings)ExternalSystemApiUtil.getSettings((Project)project, (ProjectSystemId)SYSTEM_ID);
        GradleSettings.MyState state = settings.getState();
        assert (state != null);
        Set allProjectsSettings = state.getLinkedExternalProjectsSettings();
        return GradleUtil.getFirstNotNull(allProjectsSettings);
    }

    @Nullable
    private static GradleProjectSettings getFirstNotNull(@Nullable Set<GradleProjectSettings> allProjectSettings) {
        if (allProjectSettings != null) {
            for (GradleProjectSettings settings : allProjectSettings) {
                if (settings == null) continue;
                return settings;
            }
        }
        return null;
    }

    @NotNull
    public static List<String> getGradleInvocationJvmArgs(@NotNull File projectDir, @Nullable BuildMode buildMode) {
        if (projectDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectDir", "com/android/tools/idea/gradle/util/GradleUtil", "getGradleInvocationJvmArgs"));
        }
        if (ExternalSystemApiUtil.isInProcessMode((ProjectSystemId)SYSTEM_ID)) {
            String arg;
            AndroidSdkData sdkData;
            ArrayList args = Lists.newArrayList();
            if (!AndroidGradleSettings.isAndroidSdkDirInLocalPropertiesFile((File)projectDir) && (sdkData = AndroidSdkUtils.tryToChooseAndroidSdk()) != null) {
                arg = AndroidGradleSettings.createAndroidHomeJvmArg((String)sdkData.getLocation().getPath());
                args.add(arg);
            }
            List proxyProperties = HttpConfigurable.getJvmPropertiesList((boolean)false, null);
            for (KeyValue proxyProperty : proxyProperties) {
                String arg2 = AndroidGradleSettings.createJvmArg((String)((String)proxyProperty.getKey()), (String)((String)proxyProperty.getValue()));
                args.add(arg2);
            }
            arg = GradleUtil.getGradleInvocationJvmArg(buildMode);
            if (arg != null) {
                args.add(arg);
            }
            ArrayList arrayList = args;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/GradleUtil", "getGradleInvocationJvmArgs"));
            }
            return arrayList;
        }
        List<String> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/GradleUtil", "getGradleInvocationJvmArgs"));
        }
        return list;
    }

    @VisibleForTesting
    @Nullable
    static String getGradleInvocationJvmArg(@Nullable BuildMode buildMode) {
        if (BuildMode.ASSEMBLE_TRANSLATE == buildMode) {
            return AndroidGradleSettings.createJvmArg((String)"enableTranslation", (boolean)true);
        }
        return null;
    }

    public static void stopAllGradleDaemons(boolean interactive) throws IOException {
        File gradleHome = GradleUtil.findAnyGradleHome(interactive);
        if (gradleHome == null) {
            throw new FileNotFoundException("Unable to find path to Gradle home directory");
        }
        File gradleExecutable = new File(gradleHome, "bin" + File.separatorChar + GRADLE_EXECUTABLE_NAME);
        if (!gradleExecutable.isFile()) {
            throw new FileNotFoundException("Unable to find Gradle executable: " + gradleExecutable.getPath());
        }
        new ProcessBuilder(gradleExecutable.getPath(), "--stop").start();
    }

    @Nullable
    public static File findAnyGradleHome(boolean interactive) {
        File path;
        String lastUsedGradleHome = org.jetbrains.plugins.gradle.util.GradleUtil.getLastUsedGradleHome();
        if (!lastUsedGradleHome.isEmpty() && GradleUtil.isValidGradleHome(path = new File(lastUsedGradleHome))) {
            return path;
        }
        ProjectManager projectManager = ProjectManager.getInstance();
        for (Project project : projectManager.getOpenProjects()) {
            File gradleHome = GradleUtil.findGradleHome(project);
            if (gradleHome == null) continue;
            return gradleHome;
        }
        if (interactive) {
            ChooseGradleHomeDialog chooseGradleHomeDialog = new ChooseGradleHomeDialog();
            chooseGradleHomeDialog.setTitle("Choose Gradle Installation");
            String description = "A Gradle installation is necessary to stop all daemons.\nPlease select the home directory of a Gradle installation, otherwise the project won't be closed.";
            chooseGradleHomeDialog.setDescription(description);
            if (!chooseGradleHomeDialog.showAndGet()) {
                return null;
            }
            String enteredPath = chooseGradleHomeDialog.getEnteredGradleHomePath();
            File gradleHomePath = new File(enteredPath);
            if (GradleUtil.isValidGradleHome(gradleHomePath)) {
                chooseGradleHomeDialog.storeLastUsedGradleHome();
                return gradleHomePath;
            }
        }
        return null;
    }

    @Nullable
    private static File findGradleHome(@NotNull Project project) {
        WrapperExecutor wrapperExecutor;
        WrapperConfiguration configuration;
        File gradleHome;
        File path;
        String gradleHome2;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/GradleUtil", "findGradleHome"));
        }
        GradleExecutionSettings settings = GradleUtil.getGradleExecutionSettings(project);
        if (settings != null && !Strings.isNullOrEmpty((String)(gradleHome2 = settings.getGradleHome())) && GradleUtil.isValidGradleHome(path = new File(gradleHome2))) {
            return path;
        }
        File wrapperPropertiesFile = GradleUtil.findWrapperPropertiesFile(project);
        if (wrapperPropertiesFile != null && (gradleHome = GradleUtil.getGradleHome(project, configuration = (wrapperExecutor = WrapperExecutor.forWrapperPropertiesFile((File)wrapperPropertiesFile, (Appendable)new StringBuilder())).getConfiguration())) != null) {
            return gradleHome;
        }
        return null;
    }

    @Nullable
    private static File getGradleHome(@NotNull Project project, @NotNull WrapperConfiguration configuration) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/GradleUtil", "getGradleHome"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/android/tools/idea/gradle/util/GradleUtil", "getGradleHome"));
        }
        File systemHomePath = StartParameter.DEFAULT_GRADLE_USER_HOME;
        if ("PROJECT".equals(configuration.getDistributionBase())) {
            systemHomePath = new File(project.getBasePath(), ".gradle");
        }
        if (!systemHomePath.isDirectory()) {
            return null;
        }
        PathAssembler.LocalDistribution localDistribution = new PathAssembler(systemHomePath).getDistribution(configuration);
        File distributionPath = localDistribution.getDistributionDir();
        if (distributionPath != null) {
            File[] children;
            for (File child : children = FileUtil.notNullize((File[])distributionPath.listFiles())) {
                if (!child.isDirectory() || !child.getName().startsWith("gradle-") || !GradleUtil.isValidGradleHome(child)) continue;
                return child;
            }
        }
        return null;
    }

    private static boolean isValidGradleHome(@NotNull File path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/android/tools/idea/gradle/util/GradleUtil", "isValidGradleHome"));
        }
        return path.isDirectory() && ((GradleInstallationManager)ServiceManager.getService(GradleInstallationManager.class)).isGradleSdkHome(path);
    }

    @NotNull
    public static String getDefaultPhysicalPathFromGradlePath(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/gradle/util/GradleUtil", "getDefaultPhysicalPathFromGradlePath"));
        }
        List<String> segments = GradleUtil.getPathSegments(name);
        String string = FileUtil.join((String[])segments.toArray(new String[segments.size()]));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/GradleUtil", "getDefaultPhysicalPathFromGradlePath"));
        }
        return string;
    }

    @NotNull
    public static File getDefaultSubprojectLocation(@NotNull VirtualFile project, @NotNull String gradlePath) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/GradleUtil", "getDefaultSubprojectLocation"));
        }
        if (gradlePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradlePath", "com/android/tools/idea/gradle/util/GradleUtil", "getDefaultSubprojectLocation"));
        }
        assert (gradlePath.length() > 0);
        String relativePath = GradleUtil.getDefaultPhysicalPathFromGradlePath(gradlePath);
        File file = new File(VfsUtilCore.virtualToIoFile((VirtualFile)project), relativePath);
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/GradleUtil", "getDefaultSubprojectLocation"));
        }
        return file;
    }

    @Nullable
    @Contract(value="null -> null;!null -> !null")
    public static String makeAbsolute(String string) {
        if (string == null) {
            return null;
        }
        if (string.trim().length() == 0) {
            return ":";
        }
        if (!string.startsWith(":")) {
            return ":" + string.trim();
        }
        return string.trim();
    }

    public static int isValidGradlePath(@NotNull String gradlePath) {
        if (gradlePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradlePath", "com/android/tools/idea/gradle/util/GradleUtil", "isValidGradlePath"));
        }
        return ILLEGAL_GRADLE_PATH_CHARS_MATCHER.indexIn((CharSequence)gradlePath);
    }

    public static boolean hasModule(@Nullable Project project, @NotNull String gradlePath, boolean checkProjectFolder) {
        if (gradlePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradlePath", "com/android/tools/idea/gradle/util/GradleUtil", "hasModule"));
        }
        if (project == null) {
            return false;
        }
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            if (!gradlePath.equals(GradleUtil.getGradlePath(module))) continue;
            return true;
        }
        if (checkProjectFolder) {
            File location = GradleUtil.getDefaultSubprojectLocation(project.getBaseDir(), gradlePath);
            if (location.isFile()) {
                return true;
            }
            if (location.isDirectory()) {
                File[] children = location.listFiles();
                return children == null || children.length > 0;
            }
            return false;
        }
        return false;
    }

    public static void cleanUpPreferences(@NotNull ExtensionPoint<ConfigurableEP<Configurable>> preferences, @NotNull List<String> bundlesToRemove) {
        ConfigurableEP[] extensions;
        if (preferences == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preferences", "com/android/tools/idea/gradle/util/GradleUtil", "cleanUpPreferences"));
        }
        if (bundlesToRemove == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bundlesToRemove", "com/android/tools/idea/gradle/util/GradleUtil", "cleanUpPreferences"));
        }
        ArrayList nonStudioExtensions = Lists.newArrayList();
        for (ConfigurableEP extension : extensions = (ConfigurableEP[])preferences.getExtensions()) {
            if (!bundlesToRemove.contains(extension.instanceClass)) continue;
            nonStudioExtensions.add(extension);
        }
        for (ConfigurableEP toRemove : nonStudioExtensions) {
            preferences.unregisterExtension((Object)toRemove);
        }
    }

    @Nullable
    public static FullRevision getGradleVersion(@NotNull File gradleHomePath) {
        if (gradleHomePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleHomePath", "com/android/tools/idea/gradle/util/GradleUtil", "getGradleVersion"));
        }
        File libDirPath = new File(gradleHomePath, "lib");
        for (File child : FileUtil.notNullize((File[])libDirPath.listFiles())) {
            FullRevision version = GradleUtil.getGradleVersionFromJar(child);
            if (version == null) continue;
            return version;
        }
        return null;
    }

    @VisibleForTesting
    @Nullable
    static FullRevision getGradleVersionFromJar(@NotNull File libraryJarFile) {
        if (libraryJarFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryJarFile", "com/android/tools/idea/gradle/util/GradleUtil", "getGradleVersionFromJar"));
        }
        String fileName = libraryJarFile.getName();
        Matcher matcher = GRADLE_JAR_NAME_PATTERN.matcher(fileName);
        if (matcher.matches()) {
            String version = matcher.group(2);
            try {
                return FullRevision.parseRevision((String)version);
            }
            catch (NumberFormatException e) {
                LOG.warn(String.format("Unable to parse version '%1$s' (obtained from file '%2$s')", version, fileName));
            }
        }
        return null;
    }

    public static boolean createGradleWrapper(@NotNull File projectDirPath, @Nullable String gradleVersion) throws IOException {
        if (projectDirPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectDirPath", "com/android/tools/idea/gradle/util/GradleUtil", "createGradleWrapper"));
        }
        File projectWrapperDirPath = new File(projectDirPath, SdkConstants.FD_GRADLE_WRAPPER);
        if (!projectWrapperDirPath.isDirectory()) {
            File wrapperSrcDirPath = new File(TemplateManager.getTemplateRootFolder(), SdkConstants.FD_GRADLE_WRAPPER);
            if (!wrapperSrcDirPath.exists()) {
                File root;
                Iterator<File> i$ = TemplateManager.getExtraTemplateRootFolders().iterator();
                while (i$.hasNext() && !(wrapperSrcDirPath = new File(root = i$.next(), SdkConstants.FD_GRADLE_WRAPPER)).exists()) {
                    wrapperSrcDirPath = null;
                }
            }
            if (wrapperSrcDirPath == null) {
                return false;
            }
            FileUtil.copyDirContent((File)wrapperSrcDirPath, (File)projectDirPath);
        }
        File wrapperPropertiesFile = GradleUtil.getGradleWrapperPropertiesFilePath(projectDirPath);
        String version = gradleVersion != null ? gradleVersion : "2.1";
        GradleUtil.updateGradleDistributionUrl(version, wrapperPropertiesFile);
        return true;
    }

    @Nullable
    public static String getSupportedGradleVersion(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/GradleUtil", "getSupportedGradleVersion"));
        }
        FullRevision modelVersion = GradleUtil.getResolvedAndroidGradleModelVersion(project);
        if (modelVersion != null) {
            return GradleUtil.getSupportedGradleVersion(modelVersion);
        }
        return null;
    }

    @Nullable
    public static String getSupportedGradleVersion(@NotNull FullRevision modelVersion) {
        if (modelVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelVersion", "com/android/tools/idea/gradle/util/GradleUtil", "getSupportedGradleVersion"));
        }
        if (modelVersion.getMajor() == 0) {
            return modelVersion.getMinor() >= 13 ? "2.1" : "1.12";
        }
        return null;
    }

    @Nullable
    public static FullRevision getResolvedAndroidGradleModelVersion(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/GradleUtil", "getResolvedAndroidGradleModelVersion"));
        }
        VirtualFile baseDir = project.getBaseDir();
        if (baseDir == null) {
            return null;
        }
        final Ref modelVersionRef = new Ref();
        VfsUtil.processFileRecursivelyWithoutIgnored((VirtualFile)baseDir, (Processor)new Processor<VirtualFile>(){

            public boolean process(VirtualFile virtualFile) {
                if ("build.gradle".equals(virtualFile.getName())) {
                    File fileToCheck = VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile);
                    try {
                        String contents = FileUtil.loadFile((File)fileToCheck);
                        FullRevision version = GradleUtil.getResolvedAndroidGradleModelVersion(contents);
                        if (version != null) {
                            modelVersionRef.set((Object)version);
                            return false;
                        }
                    }
                    catch (IOException e) {
                        LOG.warn("Failed to read contents of " + fileToCheck.getPath());
                    }
                }
                return true;
            }
        });
        return (FullRevision)modelVersionRef.get();
    }

    @VisibleForTesting
    @Nullable
    static FullRevision getResolvedAndroidGradleModelVersion(@NotNull String fileContents) {
        String revision;
        String text;
        IElementType type;
        if (fileContents == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileContents", "com/android/tools/idea/gradle/util/GradleUtil", "getResolvedAndroidGradleModelVersion"));
        }
        GradleCoordinate found = null;
        GroovyLexer lexer = new GroovyLexer();
        lexer.start((CharSequence)fileContents);
        while (!(lexer.getTokenType() == null || (type = lexer.getTokenType()) == GroovyTokenTypes.mSTRING_LITERAL && (text = StringUtil.unquoteString((String)lexer.getTokenText())).startsWith("com.android.tools.build:gradle:") && (found = GradleCoordinate.parseCoordinateString((String)text)) != null)) {
            lexer.advance();
        }
        if (found != null && StringUtil.isNotEmpty((String)(revision = GradleUtil.getAndroidGradleModelVersion(found)))) {
            try {
                return FullRevision.parseRevision((String)revision);
            }
            catch (NumberFormatException ignored) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    private static String getAndroidGradleModelVersion(@NotNull GradleCoordinate coordinate) {
        GradleCoordinate latest;
        if (coordinate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "coordinate", "com/android/tools/idea/gradle/util/GradleUtil", "getAndroidGradleModelVersion"));
        }
        String revision = coordinate.getFullRevision();
        if (StringUtil.isNotEmpty((String)revision)) {
            if (!coordinate.acceptsGreaterRevisions()) {
                return revision;
            }
            int major = coordinate.getMajorVersion();
            int minor = coordinate.getMinorVersion();
            if (coordinate.getMicroVersion() == -1 && major >= 0 && minor > 0) {
                return major + "." + minor + "." + 0;
            }
        }
        return (latest = GradleUtil.findLatestVersionInGradleCache(coordinate, null)) != null ? latest.getFullRevision() : null;
    }

    @Nullable
    public static GradleCoordinate findLatestVersionInGradleCache(@NotNull GradleCoordinate original, @Nullable String filter) {
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "com/android/tools/idea/gradle/util/GradleUtil", "findLatestVersionInGradleCache"));
        }
        ArrayList coordinates = Lists.newArrayList();
        File gradleCache = new File(SystemProperties.getUserHome(), FileUtil.join((String[])new String[]{".gradle", "caches"}));
        if (gradleCache.exists()) {
            String groupId = original.getGroupId();
            String artifactId = original.getArtifactId();
            for (File moduleDir : FileUtil.notNullize((File[])gradleCache.listFiles())) {
                if (!moduleDir.getName().startsWith("modules-") || !moduleDir.isDirectory()) continue;
                for (File metadataDir : FileUtil.notNullize((File[])moduleDir.listFiles())) {
                    File versionDir;
                    if (!metadataDir.getName().startsWith("metadata-") || !metadataDir.isDirectory() || !(versionDir = new File(metadataDir, FileUtil.join((String[])new String[]{"descriptors", groupId, artifactId}))).isDirectory()) continue;
                    for (File version : FileUtil.notNullize((File[])versionDir.listFiles())) {
                        GradleCoordinate found;
                        String name = version.getName();
                        if (filter != null && !name.startsWith(filter) || name.isEmpty() || !Character.isDigit(name.charAt(0)) || (found = GradleCoordinate.parseCoordinateString((String)(groupId + ":" + artifactId + ":" + name))) == null) continue;
                        coordinates.add(found);
                    }
                }
            }
            if (!coordinates.isEmpty()) {
                Collections.sort(coordinates, GradleCoordinate.COMPARE_PLUS_LOWER);
                return (GradleCoordinate)coordinates.get(coordinates.size() - 1);
            }
        }
        return null;
    }
}

