/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.memory;

import com.android.tools.idea.memory.TimelineData;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import gnu.trove.TIntObjectHashMap;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.Timer;
import org.jetbrains.annotations.NotNull;

public class TimelineComponent
extends JComponent
implements ActionListener,
HierarchyListener {
    private static final Color TEXT_COLOR = Gray._128;
    private static final Font TIMELINE_FONT = new Font("Sans", 0, 10);
    private static final int LEFT_MARGIN = 120;
    private static final int RIGHT_MARGIN = 200;
    private static final int TOP_MARGIN = 10;
    private static final int BOTTOM_MARGIN = 30;
    private static final int FPS = 40;
    private static final float X_SCALE = 20.0f;
    private final float myBufferTime;
    @NotNull
    private final TimelineData myData;
    private final float myInitialMax;
    private final float myInitialMarkerSeparation;
    private final Timer myTimer;
    private String[] myStreamNames;
    private Color[] myStreamColors;
    private boolean myFirstFrame;
    private long myLastRenderTime;
    private Path2D.Float[] myPaths;
    private boolean myDrawDebugInfo;
    private float myCurrentMax;
    private float myMarkerSeparation;
    private float myEvenMarkersAlpha;
    private int myBottom;
    private int myRight;
    private float myFrameLength;
    private float myYScale;
    private float myEndTime;
    private float myBeginTime;
    private float myEventProgress;
    private TIntObjectHashMap<Event> myEvents;
    private String myUnits;

    public TimelineComponent(@NotNull TimelineData data, float bufferTime, float initialMax, float initialMarkerSeparation) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/android/tools/idea/memory/TimelineComponent", "<init>"));
        }
        this.myData = data;
        this.myBufferTime = bufferTime;
        this.myInitialMax = initialMax;
        this.myInitialMarkerSeparation = initialMarkerSeparation;
        int streams = this.myData.getStreamCount();
        this.myTimer = new Timer(25, this);
        this.addHierarchyListener(this);
        this.myPaths = new Path2D.Float[streams];
        this.myStreamNames = new String[streams];
        this.myStreamColors = new Color[streams];
        for (int i = 0; i < streams; ++i) {
            this.myPaths[i] = new Path2D.Float();
            this.myStreamNames[i] = "Stream " + i;
            this.myStreamColors[i] = Color.BLACK;
        }
        this.myUnits = "";
        this.myEvents = new TIntObjectHashMap();
        this.setOpaque(true);
        this.reset();
    }

    public void configureStream(int stream, String name, JBColor color) {
        this.myStreamNames[stream] = name;
        this.myStreamColors[stream] = color;
    }

    public void configureEvent(int typeFrom, int typeTo, int stream, Icon icon, Color color, Color progress) {
        this.myEvents.put(typeFrom, (Object)new Event(typeFrom, typeTo, stream, icon, color, progress));
    }

    public void configureUnits(String units) {
        this.myUnits = units;
    }

    private float lerp(float from, float to, float fraction) {
        float q = (float)Math.pow(1.0f - fraction, this.myFrameLength);
        return from * q + to * (1.0f - q);
    }

    public void reset() {
        this.myCurrentMax = this.myInitialMax;
        this.myMarkerSeparation = this.myInitialMarkerSeparation;
        this.myEvenMarkersAlpha = 1.0f;
        this.myFirstFrame = true;
    }

    public boolean isDrawDebugInfo() {
        return this.myDrawDebugInfo;
    }

    public void setDrawDebugInfo(boolean drawDebugInfo) {
        this.myDrawDebugInfo = drawDebugInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setFont(TIMELINE_FONT);
        Dimension dim = this.getSize();
        g2d.setClip(0, 0, dim.width, dim.height);
        g2d.setColor(this.getBackground());
        g2d.fillRect(0, 0, dim.width, dim.height);
        this.myBottom = dim.height - 30;
        this.myRight = dim.width - 200;
        long now = System.nanoTime();
        this.myFrameLength = (float)(now - this.myLastRenderTime) / 1.0E9f;
        this.myLastRenderTime = now;
        TimelineData timelineData = this.myData;
        synchronized (timelineData) {
            this.myEndTime = this.myData.getEndTime() - this.myBufferTime;
            this.myBeginTime = this.myEndTime - (float)(this.myRight - 120) / 20.0f;
            if (this.myData.getMaxTotal() > this.myCurrentMax) {
                this.myCurrentMax = this.lerp(this.myCurrentMax, this.myData.getMaxTotal(), this.myFirstFrame ? 1.0f : 0.95f);
            }
            this.myYScale = (float)(this.myBottom - 10) / this.myCurrentMax;
            g2d.setClip(120, 10, this.myRight - 120, this.myBottom - 10);
            this.drawTimelineData(g2d);
            this.drawEvents(g2d);
            g2d.setClip(0, 0, dim.width, dim.height);
            this.drawLabels(g2d);
            this.drawTimeMarkers(g2d);
            this.drawMarkers(g2d);
            this.drawGuides(g2d);
            if (this.myDrawDebugInfo) {
                this.drawDebugInfo(g2d);
            }
            g2d.dispose();
        }
        this.myFirstFrame = false;
    }

    private void drawDebugInfo(Graphics2D g2d) {
        int size = this.myData.size();
        int drawn = 0;
        g2d.setFont(TIMELINE_FONT.deriveFont(5.0f));
        for (int i = 0; i < size; ++i) {
            TimelineData.Sample sample = this.myData.get(i);
            if (!(sample.time > this.myBeginTime) || !(sample.time < this.myEndTime)) continue;
            float v = 0.0f;
            for (float f : sample.values) {
                int x = (int)this.timeToX(sample.time);
                int y = (int)this.valueToY(v += f);
                Color c = new Color(17 * sample.type % 255, 121 * sample.type % 255, 71 * sample.type % 255);
                g2d.setColor(c);
                g2d.drawLine(x, y - 2, x, y + 2);
                g2d.drawLine(x - 2, y, x + 2, y);
                g2d.setColor(TEXT_COLOR);
                if (sample.id <= 0) continue;
                g2d.drawString(String.format("[%d]", sample.id), x - 3, y - 5);
            }
            ++drawn;
        }
        g2d.setFont(TIMELINE_FONT);
        g2d.drawString(String.format("FPS: %.2f", Float.valueOf(1.0f / this.myFrameLength)), this.myRight + 20, this.myBottom - 40);
        g2d.drawString(String.format("Total samples: %d", size), this.myRight + 20, this.myBottom - 30);
        g2d.drawString(String.format("Drawn samples: %d", drawn), this.myRight + 20, this.myBottom - 20);
        g2d.drawString(String.format("Render time: %.2fms", Float.valueOf((float)(System.nanoTime() - this.myLastRenderTime) / 1000000.0f)), this.myRight + 20, this.myBottom - 10);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.repaint();
    }

    @Override
    public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
        if (this.myTimer.isRunning() && !this.isShowing()) {
            this.myTimer.stop();
        } else if (!this.myTimer.isRunning() && this.isShowing()) {
            this.myTimer.start();
        }
    }

    private void drawTimelineData(Graphics2D g2d) {
        if (this.myData.size() > 1) {
            this.setPaths(0, this.myData.size());
            for (int i = this.myPaths.length - 1; i >= 0; --i) {
                g2d.setColor(this.myStreamColors[i]);
                g2d.fill(this.myPaths[i]);
            }
        }
    }

    private void drawEvents(Graphics2D g2d) {
        int size = this.myData.size();
        AffineTransform tx = g2d.getTransform();
        Stroke stroke = g2d.getStroke();
        Event currentEvent = null;
        int start = 0;
        float startX = 0.0f;
        float startY = 0.0f;
        for (int i = 0; i < size + 1; ++i) {
            Event event;
            TimelineData.Sample sample = i < size ? this.myData.get(i) : null;
            Event event2 = event = sample == null ? null : (Event)this.myEvents.get(sample.type);
            if (sample != null && event == null && (currentEvent == null || currentEvent.typeTo != sample.type)) continue;
            if (currentEvent != null) {
                this.setPaths(start, i < size ? i + 1 : size);
                g2d.setColor(currentEvent.color);
                g2d.fill(this.myPaths[0]);
                AffineTransform dt = new AffineTransform(tx);
                dt.translate(startX, startY);
                g2d.setTransform(dt);
                Icon icon = currentEvent.icon;
                icon.paintIcon(this, g2d, 0, -icon.getIconHeight());
                g2d.setColor(currentEvent.progress);
                g2d.setStroke(new BasicStroke(1.5f, 1, 1));
                g2d.drawLine(0, 0, 0, (int)((float)this.myBottom - startY));
                g2d.drawLine(0, 0, icon.getIconWidth(), 0);
                if (sample == null) {
                    this.drawInProgressMarker(g2d, icon.getIconWidth() + 6, -icon.getIconHeight(), 6);
                }
                g2d.setTransform(tx);
            }
            if (sample == null) continue;
            float x = this.timeToX(sample.time);
            float y = this.valueToY(sample.values[0]);
            currentEvent = event;
            if (currentEvent == null) continue;
            start = i;
            startX = x;
            startY = y;
        }
        g2d.setStroke(stroke);
    }

    private void drawInProgressMarker(Graphics2D g2d, int x, int y, int size) {
        float dir = this.myEventProgress < 0.0f ? -1.0f : 1.0f;
        float startAngle = System.currentTimeMillis() / 8L % 360L;
        float endAngle = 360.0f * this.myEventProgress * dir;
        if (dir < 0.0f) {
            startAngle += endAngle;
            endAngle = 360.0f - endAngle;
        }
        g2d.drawArc(x - size / 2, y - size / 2, size, size, (int)startAngle, (int)endAngle);
        this.myEventProgress = this.myEventProgress * dir > 0.95f ? 0.01f * -dir : this.lerp(this.myEventProgress, dir, 0.9f);
    }

    private float valueToY(float val) {
        return (float)this.myBottom - val * this.myYScale;
    }

    private float timeToX(float time) {
        return 120.0f + (time - this.myBeginTime) * 20.0f;
    }

    private void drawLabels(Graphics2D g2d) {
        if (!this.myData.isEmpty()) {
            TimelineData.Sample value = this.myData.get(this.myData.size() - 1);
            g2d.setFont(TIMELINE_FONT);
            FontMetrics metrics = g2d.getFontMetrics();
            for (int i = 0; i < this.myData.getStreamCount(); ++i) {
                g2d.setColor(this.myStreamColors[i]);
                int y = 25 + (this.myData.getStreamCount() - i - 1) * 20;
                g2d.fillRect(this.myRight + 20, y, 15, 15);
                g2d.setColor(TEXT_COLOR);
                g2d.drawString(String.format("%s [%.2f %s]", this.myStreamNames[i], Float.valueOf(value.values[i]), this.myUnits), (float)(this.myRight + 40), (float)(y + 7) + (float)metrics.getAscent() * 0.5f);
            }
        }
    }

    private void drawTimeMarkers(Graphics2D g2d) {
        g2d.setFont(TIMELINE_FONT);
        g2d.setColor(TEXT_COLOR);
        FontMetrics metrics = g2d.getFontMetrics();
        float offset = (float)metrics.stringWidth("000") * 0.5f;
        Path2D.Float lines = new Path2D.Float();
        int sec = Math.max((int)Math.ceil(this.myBeginTime), 0);
        while ((float)sec < this.myEndTime) {
            boolean big;
            float x = this.timeToX(sec);
            boolean bl = big = sec % 5 == 0;
            if (big) {
                String text = TimelineComponent.formatTime(sec);
                g2d.drawString(text, x - (float)metrics.stringWidth(text) + offset, (float)(this.myBottom + metrics.getAscent() + 5));
            }
            lines.moveTo(x, this.myBottom);
            lines.lineTo(x, this.myBottom + (big ? 5 : 2));
            ++sec;
        }
        g2d.draw(lines);
    }

    static String formatTime(int seconds) {
        int[] factors = new int[]{60, seconds};
        String[] suffix = new String[]{"m", "h"};
        String ret = seconds % 60 + "s";
        int t = seconds / 60;
        for (int i = 0; i < suffix.length && t > 0; t /= factors[i], ++i) {
            ret = t % factors[i] + suffix[i] + " " + ret;
        }
        return ret;
    }

    private void drawMarkers(Graphics2D g2d) {
        if (this.myYScale <= 0.0f) {
            return;
        }
        g2d.setFont(TIMELINE_FONT);
        FontMetrics metrics = g2d.getFontMetrics();
        int ascent = metrics.getAscent();
        float distance = this.myMarkerSeparation * this.myYScale;
        float evenMarkersTarget = 1.0f;
        if (distance < (float)(ascent * 2)) {
            if (this.myEvenMarkersAlpha < 0.1f) {
                this.myMarkerSeparation *= 2.0f;
                this.myEvenMarkersAlpha = 1.0f;
            } else {
                evenMarkersTarget = 0.0f;
            }
        } else if (distance > (float)(ascent * 5) && this.myEvenMarkersAlpha > 0.9f) {
            this.myMarkerSeparation /= 2.0f;
            this.myEvenMarkersAlpha = 0.0f;
        }
        this.myEvenMarkersAlpha = this.lerp(this.myEvenMarkersAlpha, evenMarkersTarget, 0.999f);
        int markers = (int)(this.myCurrentMax / this.myMarkerSeparation);
        float markerPosition = 110.0f;
        for (int i = 0; i < markers + 1; ++i) {
            float markerValue = (float)(i + 1) * this.myMarkerSeparation;
            int y = (int)this.valueToY(markerValue);
            if (this.myCurrentMax - markerValue < this.myMarkerSeparation * 0.5f) {
                markerValue = this.myCurrentMax;
                i = markers;
                y = 10;
            }
            if (i < markers && i % 2 == 0 && this.myEvenMarkersAlpha < 1.0f) {
                g2d.setColor(new Color(TEXT_COLOR.getColorSpace(), TEXT_COLOR.getColorComponents(null), this.myEvenMarkersAlpha));
            } else {
                g2d.setColor(TEXT_COLOR);
            }
            g2d.drawLine(118, y, 120, y);
            String marker = String.format("%.2f %s", Float.valueOf(markerValue), this.myUnits);
            g2d.drawString(marker, markerPosition - (float)metrics.stringWidth(marker), (float)y + (float)ascent * 0.5f);
        }
    }

    private void drawGuides(Graphics2D g2d) {
        g2d.setColor(TEXT_COLOR);
        g2d.drawLine(110, this.myBottom, this.myRight + 10, this.myBottom);
        if (this.myYScale > 0.0f) {
            g2d.drawLine(120, this.myBottom, 120, 10);
            g2d.drawLine(this.myRight, this.myBottom, this.myRight, 10);
        }
    }

    private void setPaths(int from, int to) {
        for (Path2D.Float path : this.myPaths) {
            path.reset();
        }
        if (to - from > 1) {
            while (from < to - 1 && this.myData.get((int)(from + 1)).time < this.myBeginTime) {
                ++from;
            }
            TimelineData.Sample sample = this.myData.get(from);
            Path2D.Float[] arr$ = this.myPaths;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Path2D.Float path = arr$[i$];
                path.moveTo(this.timeToX(sample.time), this.valueToY(0.0f));
            }
            for (int i = from; i < to; ++i) {
                sample = this.myData.get(i);
                float val = 0.0f;
                for (int j = 0; j < sample.values.length; ++j) {
                    this.myPaths[j].lineTo(this.timeToX(sample.time), this.valueToY(val += sample.values[j]));
                }
                if (sample.time > this.myEndTime) break;
            }
            for (Path2D.Float path : this.myPaths) {
                path.lineTo(this.timeToX(sample.time), this.valueToY(0.0f));
            }
        }
    }

    private static class Event {
        public final int typeFrom;
        public final int typeTo;
        public final int stream;
        public final Icon icon;
        public final Color color;
        public final Color progress;

        private Event(int typeFrom, int typeTo, int stream, Icon icon, Color color, Color progress) {
            this.typeFrom = typeFrom;
            this.typeTo = typeTo;
            this.stream = stream;
            this.icon = icon;
            this.color = color;
            this.progress = progress;
        }
    }
}

