/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.psi.PsiFile;
import com.intellij.ui.SimpleTextAttributes;
import org.jetbrains.annotations.Nullable;

public class AndroidBuildScriptNode
extends PsiFileNode {
    @Nullable
    private final String myQualifier;

    public AndroidBuildScriptNode(Project project, PsiFile value, ViewSettings viewSettings, @Nullable String qualifier) {
        super(project, value, viewSettings);
        this.myQualifier = qualifier;
    }

    public void update(PresentationData data) {
        super.update(data);
        PsiFile psiFile = (PsiFile)this.getValue();
        if (psiFile == null || !psiFile.isValid()) {
            return;
        }
        String fileName = psiFile.getName();
        data.addText(fileName, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        data.setPresentableText(fileName);
        if (this.myQualifier != null) {
            data.addText(" (" + this.myQualifier + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
    }

    @Nullable
    public Comparable getSortKey() {
        String priority;
        if (this.myQualifier != null) {
            boolean isModuleName = ModuleManager.getInstance((Project)this.myProject).findModuleByName(this.myQualifier) != null;
            priority = isModuleName ? "1-" : "2-";
            priority = priority + this.myQualifier + "-";
        } else {
            priority = "3-";
        }
        PsiFile f = (PsiFile)this.getValue();
        return f == null ? priority : priority + f.getName();
    }

    public Comparable getTypeSortKey() {
        return this.getSortKey();
    }

    @Nullable
    public String toTestString(@Nullable Queryable.PrintInfo printInfo) {
        String fileName = ((PsiFile)this.getValue()).getName();
        return fileName + (this.myQualifier == null ? "" : " (" + this.myQualifier + ")");
    }
}

