/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk.wizard;

import com.android.sdklib.AndroidVersion;
import com.android.sdklib.SdkManager;
import com.android.sdklib.internal.repository.updater.SdkUpdaterNoWindow;
import com.android.sdklib.repository.descriptors.IPkgDesc;
import com.android.sdklib.repository.descriptors.PkgType;
import com.android.tools.idea.sdk.SdkState;
import com.android.tools.idea.wizard.DynamicWizardStepWithHeaderAndDescription;
import com.android.tools.idea.wizard.WizardConstants;
import com.android.utils.ILogger;
import com.android.utils.IReaderLogger;
import com.google.common.collect.Lists;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextArea;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SmwOldApiDirectInstall
extends DynamicWizardStepWithHeaderAndDescription {
    private Logger LOG;
    private JBLabel myLabelSdkPath;
    private JTextArea myTextArea1;
    private JBLabel myLabelProgress1;
    private JProgressBar myProgressBar;
    private JBLabel myLabelProgress2;
    private JLabel myErrorLabel;
    private JPanel myContentPanel;
    private boolean myInstallFinished;
    private Boolean myBackgroundSuccess;
    private boolean myBeforeInstall;
    private static Pattern sLicenceText = Pattern.compile("^\\s*License id:\\s*([a-z0-9-]+).*\\s*");
    private static Pattern sProgress1Text = Pattern.compile("^\\s+\\((([0-9]+)%,\\s*[^)]*)\\)(.*)\\s*");
    private static Pattern sProgress2Text = Pattern.compile("^\\s+([^(]+)\\s+\\((([0-9]+)%)\\)\\s*");

    public SmwOldApiDirectInstall(@NotNull Disposable disposable) {
        if (disposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposable", "com/android/tools/idea/sdk/wizard/SmwOldApiDirectInstall", "<init>"));
        }
        super("Installing Requested Components", "", null, disposable);
        this.$$$setupUI$$$();
        this.LOG = Logger.getInstance(SmwOldApiDirectInstall.class);
        this.myBackgroundSuccess = null;
        this.myBeforeInstall = true;
        this.setBodyComponent(this.myContentPanel);
    }

    @Override
    public void onEnterStep() {
        super.onEnterStep();
        this.myTextArea1.setText("");
        this.startSdkInstallUsingNonSwtOldApi();
    }

    @Override
    public boolean isStepVisible() {
        return this.myState.listSize(WizardConstants.INSTALL_REQUESTS_KEY) > 0;
    }

    @Override
    public boolean validate() {
        return this.myInstallFinished;
    }

    @Override
    public boolean canGoPrevious() {
        return this.myInstallFinished;
    }

    private void startSdkInstallUsingNonSwtOldApi() {
        SdkState sdkState;
        final AndroidSdkData sdkData = AndroidSdkUtils.tryToChooseAndroidSdk();
        SdkState sdkState2 = sdkState = sdkData == null ? null : SdkState.getInstance(sdkData);
        if (sdkState == null) {
            this.myErrorLabel.setText("Error: can't get SDK instance.");
            return;
        }
        this.myLabelSdkPath.setText(sdkData.getLocation().getPath());
        final CustomLogger logger = new CustomLogger();
        Runnable onSdkAvailable = new Runnable(){

            @Override
            public void run() {
                ArrayList requestedPackages = Lists.newArrayList();
                List requestedChanges = SmwOldApiDirectInstall.this.myState.get(WizardConstants.INSTALL_REQUESTS_KEY);
                if (requestedChanges == null) {
                    SmwOldApiDirectInstall.this.myInstallFinished = true;
                    SmwOldApiDirectInstall.this.invokeUpdate(null);
                    return;
                }
                for (Object object : requestedChanges) {
                    try {
                        IPkgDesc packageDesc = (IPkgDesc)object;
                        if (packageDesc == null) continue;
                        requestedPackages.add(packageDesc.getInstallId());
                    }
                    catch (ClassCastException e) {
                        SmwOldApiDirectInstall.this.LOG.error((Throwable)e);
                    }
                }
                InstallTask task = new InstallTask(sdkData, requestedPackages, (ILogger)logger);
                BackgroundableProcessIndicator indicator = new BackgroundableProcessIndicator((Task.Backgroundable)task);
                logger.setIndicator(indicator);
                ProgressManager.getInstance().runProcessWithProgressAsynchronously((Task.Backgroundable)task, (ProgressIndicator)indicator);
            }
        };
        logger.info("Loading SDK information...\n", new Object[0]);
        if (!sdkState.loadAsync(86400000L, false, onSdkAvailable, null)) {
            onSdkAvailable.run();
        }
    }

    @Override
    @NotNull
    public String getStepName() {
        if ("InstallingSDKComponentsStep" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdk/wizard/SmwOldApiDirectInstall", "getStepName"));
        }
        return "InstallingSDKComponentsStep";
    }

    public JComponent getPreferredFocusedComponent() {
        return null;
    }

    private void checkForUpgrades(@Nullable List completedChanges) {
        if (completedChanges == null) {
            return;
        }
        int highestNewApiLevel = 0;
        for (Object o : completedChanges) {
            AndroidVersion version;
            IPkgDesc pkgDesc;
            if (!(o instanceof IPkgDesc) || !(pkgDesc = (IPkgDesc)o).getType().equals((Object)PkgType.PKG_PLATFORM) || (version = pkgDesc.getAndroidVersion()) == null || version.getApiLevel() <= highestNewApiLevel) continue;
            highestNewApiLevel = version.getApiLevel();
        }
        if (highestNewApiLevel > 0) {
            this.myState.put(WizardConstants.NEWLY_INSTALLED_API_KEY, highestNewApiLevel);
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextArea jTextArea;
        JLabel jLabel;
        JBLabel jBLabel;
        JProgressBar jProgressBar;
        JBLabel jBLabel2;
        JBLabel jBLabel3;
        JPanel jPanel;
        this.myContentPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(6, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLabel jBLabel4 = new JBLabel();
        jBLabel4.setText("SDK Path:");
        jPanel.add((Component)jBLabel4, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myLabelSdkPath = jBLabel3 = new JBLabel();
        jBLabel3.setText("<placeholder path>");
        jPanel.add((Component)jBLabel3, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myLabelProgress1 = jBLabel2 = new JBLabel();
        jBLabel2.setText("");
        jPanel.add((Component)jBLabel2, new GridConstraints(2, 0, 1, 2, 0, 1, 6, 0, null, null, null));
        this.myProgressBar = jProgressBar = new JProgressBar();
        jPanel.add((Component)jProgressBar, new GridConstraints(3, 0, 1, 2, 0, 1, 7, 0, null, null, null));
        this.myLabelProgress2 = jBLabel = new JBLabel();
        jBLabel.setVerticalAlignment(1);
        jBLabel.setBackground(new Color(-3355444));
        jBLabel.setText("");
        jBLabel.setHorizontalTextPosition(10);
        jPanel.add((Component)jBLabel, new GridConstraints(4, 0, 1, 2, 8, 0, 3, 2, null, null, null));
        this.myErrorLabel = jLabel = new JLabel();
        jLabel.setText("");
        jPanel.add((Component)jLabel, new GridConstraints(5, 0, 1, 2, 0, 1, 2, 0, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jBScrollPane.setVerticalScrollBarPolicy(22);
        jPanel.add((Component)jBScrollPane, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 7, null, null, null));
        this.myTextArea1 = jTextArea = new JTextArea();
        jTextArea.setText("");
        jBScrollPane.setViewportView(jTextArea);
    }

    @Override
    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPanel;
    }

    private class CustomLogger
    implements IReaderLogger {
        private BackgroundableProcessIndicator myIndicator;
        private String myCurrLicense;
        private String myLastLine;

        public void setIndicator(BackgroundableProcessIndicator indicator) {
            this.myIndicator = indicator;
        }

        public int readLine(@NotNull byte[] inputBuffer) throws IOException {
            if (inputBuffer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputBuffer", "com/android/tools/idea/sdk/wizard/SmwOldApiDirectInstall$CustomLogger", "readLine"));
            }
            if (this.myLastLine != null && this.myLastLine.contains("Do you accept the license")) {
                inputBuffer[0] = 121;
                inputBuffer[1] = 0;
                return 1;
            }
            inputBuffer[0] = 110;
            inputBuffer[1] = 0;
            return 1;
        }

        public void error(@Nullable Throwable t, @Nullable String msgFormat, Object ... args) {
            if (msgFormat == null && t != null) {
                if (this.myIndicator != null) {
                    this.myIndicator.setText2(t.toString());
                }
                this.outputLine(t.toString());
            } else if (msgFormat != null) {
                if (this.myIndicator != null) {
                    this.myIndicator.setText2(String.format(msgFormat, args));
                }
                this.outputLine(String.format(msgFormat, args));
            }
        }

        public void warning(@NotNull String msgFormat, Object ... args) {
            if (msgFormat == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "msgFormat", "com/android/tools/idea/sdk/wizard/SmwOldApiDirectInstall$CustomLogger", "warning"));
            }
            if (this.myIndicator != null) {
                this.myIndicator.setText2(String.format(msgFormat, args));
            }
            this.outputLine(String.format(msgFormat, args));
        }

        public void info(@NotNull String msgFormat, Object ... args) {
            if (msgFormat == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "msgFormat", "com/android/tools/idea/sdk/wizard/SmwOldApiDirectInstall$CustomLogger", "info"));
            }
            if (this.myIndicator != null) {
                this.myIndicator.setText2(String.format(msgFormat, args));
            }
            this.outputLine(String.format(msgFormat, args));
        }

        public void verbose(@NotNull String msgFormat, Object ... args) {
            if (msgFormat == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "msgFormat", "com/android/tools/idea/sdk/wizard/SmwOldApiDirectInstall$CustomLogger", "verbose"));
            }
            this.outputLine(String.format(msgFormat, args));
        }

        private void outputLine(@NotNull String line) {
            if (line == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/android/tools/idea/sdk/wizard/SmwOldApiDirectInstall$CustomLogger", "outputLine"));
            }
            this.myLastLine = line;
            try {
                Matcher m = sLicenceText.matcher(line);
                if (m.matches()) {
                    this.myCurrLicense = m.group(1);
                    return;
                }
                if (this.myCurrLicense != null) {
                    if (line.contains("Do you accept the license") && line.contains(this.myCurrLicense)) {
                        this.myCurrLicense = null;
                    }
                    return;
                }
                if (line.contains("Fetching http") || line.contains("Fetching URL:") || line.contains("Validate XML") || line.contains("Parse XML") || line.contains("---------")) {
                    return;
                }
                int progInt = -1;
                String progText2 = null;
                String progText1 = null;
                m = sProgress1Text.matcher(line);
                if (m.matches()) {
                    try {
                        progInt = Integer.parseInt(m.group(2));
                    }
                    catch (NumberFormatException ignore) {
                        progInt = 0;
                    }
                    progText1 = m.group(3);
                    progText2 = m.group(1);
                    line = null;
                } else {
                    m = sProgress2Text.matcher(line);
                    if (m.matches()) {
                        try {
                            progInt = Integer.parseInt(m.group(3));
                        }
                        catch (NumberFormatException ignore) {
                            progInt = 0;
                        }
                        progText1 = m.group(1);
                        progText2 = m.group(2);
                        line = null;
                    }
                }
                final int fProgInt = progInt;
                final String fProgText2 = progText2;
                final String fProgText1 = progText1;
                final String fAddLine = line;
                UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (fAddLine != null) {
                            String current = SmwOldApiDirectInstall.this.myTextArea1.getText();
                            if (current == null) {
                                current = "";
                            }
                            SmwOldApiDirectInstall.this.myTextArea1.setText(current + fAddLine);
                            if (fAddLine.contains("Nothing was installed")) {
                                SmwOldApiDirectInstall.this.myBackgroundSuccess = false;
                            } else if (fAddLine.contains("Failed")) {
                                SmwOldApiDirectInstall.this.myBackgroundSuccess = false;
                            } else if (fAddLine.contains("Done") && !fAddLine.contains("othing")) {
                                SmwOldApiDirectInstall.this.myBackgroundSuccess = Boolean.TRUE;
                            }
                        }
                        if (fProgText1 != null) {
                            SmwOldApiDirectInstall.this.myLabelProgress1.setText(fProgText1);
                        }
                        if (fProgText2 != null) {
                            SmwOldApiDirectInstall.this.myLabelProgress2.setText(fProgText2);
                        }
                        if (fProgInt >= 0) {
                            SmwOldApiDirectInstall.this.myProgressBar.setValue(fProgInt);
                        }
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private class InstallTask
    extends Task.Backgroundable {
        @NotNull
        private final AndroidSdkData mySdkData;
        @NotNull
        private final ArrayList<String> myRequestedPackages;
        @NotNull
        private final ILogger myLogger;

        private InstallTask(@NotNull AndroidSdkData sdkData, @NotNull ArrayList<String> requestedPackages, ILogger logger) {
            if (sdkData == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkData", "com/android/tools/idea/sdk/wizard/SmwOldApiDirectInstall$InstallTask", "<init>"));
            }
            if (requestedPackages == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requestedPackages", "com/android/tools/idea/sdk/wizard/SmwOldApiDirectInstall$InstallTask", "<init>"));
            }
            if (logger == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logger", "com/android/tools/idea/sdk/wizard/SmwOldApiDirectInstall$InstallTask", "<init>"));
            }
            super(null, "Installing Android SDK", false, PerformInBackgroundOption.ALWAYS_BACKGROUND);
            this.mySdkData = sdkData;
            this.myRequestedPackages = requestedPackages;
            this.myLogger = logger;
        }

        public void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/android/tools/idea/sdk/wizard/SmwOldApiDirectInstall$InstallTask", "run"));
            }
            SmwOldApiDirectInstall.this.myBeforeInstall = false;
            String osSdkFolder = this.mySdkData.getLocation().getPath();
            SdkManager sdkManager = SdkManager.createManager((String)osSdkFolder, (ILogger)this.myLogger);
            SdkUpdaterNoWindow upd = new SdkUpdaterNoWindow(osSdkFolder, sdkManager, this.myLogger, false, false, null, null);
            upd.updateAll(this.myRequestedPackages, true, false, null);
            while (SmwOldApiDirectInstall.this.myBackgroundSuccess == null) {
                TimeoutUtil.sleep((long)100L);
            }
            UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                @Override
                public void run() {
                    SmwOldApiDirectInstall.this.myProgressBar.setValue(100);
                    SmwOldApiDirectInstall.this.myLabelProgress1.setText("");
                    if (!SmwOldApiDirectInstall.this.myBackgroundSuccess.booleanValue()) {
                        SmwOldApiDirectInstall.this.myLabelProgress2.setText("<html>Install Failed. Please check your network connection and try again. You may continue with creating your project, but it will not compile correctly without the missing components.</html>");
                        SmwOldApiDirectInstall.this.myLabelProgress2.setForeground((Color)JBColor.RED);
                        SmwOldApiDirectInstall.this.myProgressBar.setEnabled(false);
                    } else {
                        SmwOldApiDirectInstall.this.myLabelProgress2.setText("Done");
                        List requestedChanges = SmwOldApiDirectInstall.this.myState.get(WizardConstants.INSTALL_REQUESTS_KEY);
                        SmwOldApiDirectInstall.this.checkForUpgrades(requestedChanges);
                        SmwOldApiDirectInstall.this.myState.remove(WizardConstants.INSTALL_REQUESTS_KEY);
                    }
                    SmwOldApiDirectInstall.this.myInstallFinished = true;
                    SmwOldApiDirectInstall.this.invokeUpdate(null);
                }
            });
        }
    }
}

