/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome;

import com.android.tools.idea.sdk.DefaultSdks;
import com.android.tools.idea.sdk.Jdks;
import com.android.tools.idea.welcome.JdkLocationStep;
import com.android.tools.idea.wizard.DynamicWizardPath;
import com.android.tools.idea.wizard.ScopedStateStore;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.pom.java.LanguageLevel;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public class SetupJdkPath
extends DynamicWizardPath {
    private static ScopedStateStore.Key<String> KEY_JDK_LOCATION = ScopedStateStore.createKey("jdk.location", ScopedStateStore.Scope.PATH, String.class);

    @Override
    public boolean isPathVisible() {
        Sdk defaultJdk = DefaultSdks.getDefaultJdk();
        return defaultJdk == null || !Jdks.isApplicableJdk(defaultJdk, LanguageLevel.JDK_1_7);
    }

    @Override
    protected void init() {
        this.addStep(new JdkLocationStep(KEY_JDK_LOCATION));
    }

    @Override
    @NotNull
    public String getPathName() {
        if ("Setup JDK" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/SetupJdkPath", "getPathName"));
        }
        return "Setup JDK";
    }

    @Override
    public boolean performFinishingActions() {
        String path = this.myState.get(KEY_JDK_LOCATION);
        assert (path != null);
        DefaultSdks.setDefaultJavaHome(new File(path));
        return true;
    }
}

