/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome;

import com.google.common.collect.ImmutableMap;
import com.intellij.ide.BrowserUtil;
import com.intellij.ui.JBColor;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.font.TextAttribute;
import java.text.AttributedCharacterIterator;
import java.util.Map;
import javax.swing.JButton;
import org.jetbrains.annotations.NotNull;

public final class WelcomeUIUtils {
    private WelcomeUIUtils() {
    }

    private static void makeButtonAHyperlink(JButton button) {
        button.setBorderPainted(false);
        button.setBorder(null);
        button.setForeground((Color)JBColor.blue);
        button.setOpaque(false);
        button.setCursor(Cursor.getPredefinedCursor(12));
        button.setFont(button.getFont().deriveFont((Map<? extends AttributedCharacterIterator.Attribute, ?>)ImmutableMap.of((Object)TextAttribute.UNDERLINE, (Object)TextAttribute.UNDERLINE_LOW_ONE_PIXEL)));
    }

    public static void makeButtonAHyperlink(@NotNull JButton button, final @NotNull String url) {
        if (button == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "button", "com/android/tools/idea/welcome/WelcomeUIUtils", "makeButtonAHyperlink"));
        }
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/android/tools/idea/welcome/WelcomeUIUtils", "makeButtonAHyperlink"));
        }
        WelcomeUIUtils.makeButtonAHyperlink(button);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BrowserUtil.browse((String)url);
            }
        });
    }
}

