/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard;

import com.android.tools.idea.templates.Parameter;
import com.android.tools.idea.wizard.StringEvaluator;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.openapi.util.text.StringUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ParameterDefaultValueComputer
implements Function<Parameter, Object> {
    private final Map<Parameter, Object> nonDefaultValues;
    private final Map<String, Object> myImplicitParameters;
    @Nullable
    private final Deduplicator myDeduplicateValueFunction;
    private final StringEvaluator myStringEvaluator = new StringEvaluator();
    private final Map<String, Parameter> myParameterIds;
    private Map<Parameter, Object> myDefaultsMap;
    private Set<Parameter> inComputation = Sets.newHashSet();

    private ParameterDefaultValueComputer(Set<Parameter> parameterSet, Map<Parameter, Object> nonCurrentValues, Map<String, Object> implicitParameters, @Nullable Deduplicator deduplicateValueFunction) {
        this.nonDefaultValues = nonCurrentValues;
        this.myImplicitParameters = implicitParameters;
        this.myDeduplicateValueFunction = deduplicateValueFunction;
        this.myParameterIds = Maps.uniqueIndex(parameterSet, (Function)new Function<Parameter, String>(){

            public String apply(Parameter input) {
                return input.id;
            }
        });
    }

    public static Map<Parameter, Object> newDefaultValuesMap(Iterable<Parameter> parameters, Map<Parameter, Object> values, Map<String, Object> implicitParameters, @Nullable Deduplicator deduplicateValueFunction) {
        ImmutableSet parameterSet = FluentIterable.from(parameters).filter((Predicate)new Predicate<Parameter>(){

            public boolean apply(Parameter input) {
                return input != null && !StringUtil.isEmpty((String)input.name);
            }
        }).toSet();
        ParameterDefaultValueComputer computer = new ParameterDefaultValueComputer((Set<Parameter>)parameterSet, values, implicitParameters, deduplicateValueFunction);
        Map defaultsMap = Maps.asMap((Set)parameterSet, (Function)computer);
        computer.setDefaultsMap(defaultsMap);
        return defaultsMap;
    }

    @Nullable
    private static Object decodeInitialValue(Parameter input, @Nullable String initial) {
        if (initial != null && input.type == Parameter.Type.BOOLEAN) {
            return Boolean.valueOf(initial);
        }
        return initial;
    }

    private synchronized void setDefaultsMap(Map<Parameter, Object> defaultsMap) {
        this.myDefaultsMap = defaultsMap;
    }

    public Object apply(Parameter parameter) {
        String value;
        if (this.nonDefaultValues.containsKey(parameter)) {
            return this.nonDefaultValues.get(parameter);
        }
        String string = value = !StringUtil.isEmpty((String)parameter.suggest) ? this.deriveValue(parameter) : parameter.initial;
        if (this.myDeduplicateValueFunction != null) {
            value = this.myDeduplicateValueFunction.deduplicate(parameter, value);
        }
        return ParameterDefaultValueComputer.decodeInitialValue(parameter, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private synchronized String deriveValue(Parameter parameter) {
        if (StringUtil.isEmpty((String)parameter.suggest)) {
            return null;
        }
        if (this.inComputation.contains(parameter)) {
            return "";
        }
        this.inComputation.add(parameter);
        try {
            Function values = Functions.forMap(this.myDefaultsMap);
            Function name = Functions.forMap(this.myParameterIds);
            Function nameToValue = Functions.compose((Function)values, (Function)name);
            HashMap parameterIdToValue = Maps.newHashMap();
            parameterIdToValue.putAll(this.getExternalValues());
            parameterIdToValue.putAll(Maps.asMap(this.myParameterIds.keySet(), (Function)nameToValue));
            String string = this.myStringEvaluator.evaluate(parameter.suggest, parameterIdToValue);
            return string;
        }
        finally {
            this.inComputation.remove(parameter);
        }
    }

    private Map<String, Object> getExternalValues() {
        return this.myImplicitParameters;
    }

    public static interface Deduplicator {
        @Nullable
        public String deduplicate(@NotNull Parameter var1, @Nullable String var2);
    }
}

