/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.facet;

import com.android.builder.model.AndroidProject;
import com.android.builder.model.BuildTypeContainer;
import com.android.builder.model.ProductFlavorContainer;
import com.android.builder.model.SourceProvider;
import com.android.builder.model.Variant;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.HashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class IdeaSourceProvider {
    public static Function<IdeaSourceProvider, List<VirtualFile>> MANIFEST_PROVIDER = new Function<IdeaSourceProvider, List<VirtualFile>>(){

        public List<VirtualFile> apply(IdeaSourceProvider provider) {
            VirtualFile manifestFile = provider.getManifestFile();
            return manifestFile == null ? Collections.emptyList() : Collections.singletonList(manifestFile);
        }
    };
    public static Function<IdeaSourceProvider, List<VirtualFile>> RES_PROVIDER = new Function<IdeaSourceProvider, List<VirtualFile>>(){

        public List<VirtualFile> apply(IdeaSourceProvider provider) {
            return Lists.newArrayList(provider.getResDirectories());
        }
    };
    public static Function<IdeaSourceProvider, List<VirtualFile>> JAVA_PROVIDER = new Function<IdeaSourceProvider, List<VirtualFile>>(){

        public List<VirtualFile> apply(IdeaSourceProvider provider) {
            return Lists.newArrayList(provider.getJavaDirectories());
        }
    };
    public static Function<IdeaSourceProvider, List<VirtualFile>> RESOURCES_PROVIDER = new Function<IdeaSourceProvider, List<VirtualFile>>(){

        public List<VirtualFile> apply(IdeaSourceProvider provider) {
            return Lists.newArrayList(provider.getResourcesDirectories());
        }
    };
    public static Function<IdeaSourceProvider, List<VirtualFile>> AIDL_PROVIDER = new Function<IdeaSourceProvider, List<VirtualFile>>(){

        public List<VirtualFile> apply(IdeaSourceProvider provider) {
            return Lists.newArrayList(provider.getAidlDirectories());
        }
    };
    public static Function<IdeaSourceProvider, List<VirtualFile>> JNI_PROVIDER = new Function<IdeaSourceProvider, List<VirtualFile>>(){

        public List<VirtualFile> apply(IdeaSourceProvider provider) {
            return Lists.newArrayList(provider.getJniDirectories());
        }
    };
    public static Function<IdeaSourceProvider, List<VirtualFile>> JNI_LIBS_PROVIDER = new Function<IdeaSourceProvider, List<VirtualFile>>(){

        public List<VirtualFile> apply(IdeaSourceProvider provider) {
            return Lists.newArrayList(provider.getJniLibsDirectories());
        }
    };
    public static Function<IdeaSourceProvider, List<VirtualFile>> ASSETS_PROVIDER = new Function<IdeaSourceProvider, List<VirtualFile>>(){

        public List<VirtualFile> apply(IdeaSourceProvider provider) {
            return Lists.newArrayList(provider.getAssetsDirectories());
        }
    };
    public static Function<IdeaSourceProvider, List<VirtualFile>> RS_PROVIDER = new Function<IdeaSourceProvider, List<VirtualFile>>(){

        public List<VirtualFile> apply(IdeaSourceProvider provider) {
            return Lists.newArrayList(provider.getRenderscriptDirectories());
        }
    };

    private IdeaSourceProvider() {
    }

    @NotNull
    public static IdeaSourceProvider create(@NotNull SourceProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "org/jetbrains/android/facet/IdeaSourceProvider", "create"));
        }
        Gradle gradle = new Gradle(provider);
        if (gradle == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/IdeaSourceProvider", "create"));
        }
        return gradle;
    }

    @NotNull
    public static IdeaSourceProvider create(@NotNull AndroidFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/facet/IdeaSourceProvider", "create"));
        }
        Legacy legacy = new Legacy(facet);
        if (legacy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/IdeaSourceProvider", "create"));
        }
        return legacy;
    }

    @NotNull
    public abstract String getName();

    @Nullable
    public abstract VirtualFile getManifestFile();

    @NotNull
    public abstract Set<VirtualFile> getJavaDirectories();

    @NotNull
    public abstract Set<VirtualFile> getResourcesDirectories();

    @NotNull
    public abstract Set<VirtualFile> getAidlDirectories();

    @NotNull
    public abstract Set<VirtualFile> getRenderscriptDirectories();

    @NotNull
    public abstract Set<VirtualFile> getJniDirectories();

    @NotNull
    public abstract Set<VirtualFile> getJniLibsDirectories();

    @NotNull
    public abstract Set<VirtualFile> getResDirectories();

    @NotNull
    public abstract Set<VirtualFile> getAssetsDirectories();

    @NotNull
    public static List<IdeaSourceProvider> getCurrentSourceProviders(@NotNull AndroidFacet facet) {
        IdeaSourceProvider variantProvider;
        IdeaSourceProvider buildTypeSourceProvider;
        IdeaSourceProvider multiProvider;
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/facet/IdeaSourceProvider", "getCurrentSourceProviders"));
        }
        if (!facet.isGradleProject()) {
            List<IdeaSourceProvider> list = Collections.singletonList(facet.getMainIdeaSourceProvider());
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/IdeaSourceProvider", "getCurrentSourceProviders"));
            }
            return list;
        }
        ArrayList providers = Lists.newArrayList();
        providers.add(facet.getMainIdeaSourceProvider());
        List<IdeaSourceProvider> flavorSourceProviders = facet.getIdeaFlavorSourceProviders();
        if (flavorSourceProviders != null) {
            for (IdeaSourceProvider provider : flavorSourceProviders) {
                providers.add(provider);
            }
        }
        if ((multiProvider = facet.getIdeaMultiFlavorSourceProvider()) != null) {
            providers.add(multiProvider);
        }
        if ((buildTypeSourceProvider = facet.getIdeaBuildTypeSourceProvider()) != null) {
            providers.add(buildTypeSourceProvider);
        }
        if ((variantProvider = facet.getIdeaVariantSourceProvider()) != null) {
            providers.add(variantProvider);
        }
        ArrayList arrayList = providers;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/IdeaSourceProvider", "getCurrentSourceProviders"));
        }
        return arrayList;
    }

    @NotNull
    public static List<IdeaSourceProvider> getCurrentTestSourceProviders(@NotNull AndroidFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/facet/IdeaSourceProvider", "getCurrentTestSourceProviders"));
        }
        if (!facet.isGradleProject()) {
            List<IdeaSourceProvider> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/IdeaSourceProvider", "getCurrentTestSourceProviders"));
            }
            return list;
        }
        ArrayList providers = Lists.newArrayList();
        providers.addAll(facet.getMainIdeaTestSourceProviders());
        providers.addAll(facet.getIdeaFlavorTestSourceProviders());
        providers.addAll(facet.getIdeaBuildTypeTestSourceProvider());
        ArrayList arrayList = providers;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/IdeaSourceProvider", "getCurrentTestSourceProviders"));
        }
        return arrayList;
    }

    private Collection<VirtualFile> getAllSourceFolders() {
        ArrayList srcDirectories = Lists.newArrayList();
        srcDirectories.addAll(this.getJavaDirectories());
        srcDirectories.addAll(this.getResDirectories());
        srcDirectories.addAll(this.getAidlDirectories());
        srcDirectories.addAll(this.getRenderscriptDirectories());
        srcDirectories.addAll(this.getAssetsDirectories());
        srcDirectories.addAll(this.getJniDirectories());
        return srcDirectories;
    }

    private static Collection<File> getAllSourceFolders(SourceProvider provider) {
        ArrayList srcDirectories = Lists.newArrayList();
        srcDirectories.addAll(provider.getJavaDirectories());
        srcDirectories.addAll(provider.getResDirectories());
        srcDirectories.addAll(provider.getAidlDirectories());
        srcDirectories.addAll(provider.getRenderscriptDirectories());
        srcDirectories.addAll(provider.getAssetsDirectories());
        srcDirectories.addAll(provider.getJniDirectories());
        return srcDirectories;
    }

    public boolean containsFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/android/facet/IdeaSourceProvider", "containsFile"));
        }
        Collection<VirtualFile> srcDirectories = this.getAllSourceFolders();
        if (file.equals(this.getManifestFile())) {
            return true;
        }
        for (VirtualFile container : srcDirectories) {
            if (!container.exists()) continue;
            if (VfsUtilCore.isAncestor((VirtualFile)container, (VirtualFile)file, (boolean)false)) {
                return true;
            }
            if (!file.equals(container.getParent())) continue;
            return true;
        }
        return false;
    }

    public static boolean isContainedBy(@NotNull SourceProvider provider, @NotNull File targetFolder) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "org/jetbrains/android/facet/IdeaSourceProvider", "isContainedBy"));
        }
        if (targetFolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetFolder", "org/jetbrains/android/facet/IdeaSourceProvider", "isContainedBy"));
        }
        Collection<File> srcDirectories = IdeaSourceProvider.getAllSourceFolders(provider);
        for (File container : srcDirectories) {
            if (FileUtil.isAncestor((File)targetFolder, (File)container, (boolean)false)) {
                return true;
            }
            if (!container.exists() || !VfsUtilCore.isAncestor((File)targetFolder, (File)container, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsFile(@NotNull SourceProvider provider, @NotNull File file) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "org/jetbrains/android/facet/IdeaSourceProvider", "containsFile"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/android/facet/IdeaSourceProvider", "containsFile"));
        }
        Collection<File> srcDirectories = IdeaSourceProvider.getAllSourceFolders(provider);
        if (FileUtil.filesEqual((File)provider.getManifestFile(), (File)file)) {
            return true;
        }
        for (File container : srcDirectories) {
            File parent = container.getParentFile();
            if (parent != null && parent.isDirectory() && FileUtil.filesEqual((File)parent, (File)file)) {
                return true;
            }
            if (!container.exists() || !VfsUtilCore.isAncestor((File)container, (File)file, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    public boolean isContainedBy(@NotNull VirtualFile targetFolder) {
        if (targetFolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetFolder", "org/jetbrains/android/facet/IdeaSourceProvider", "isContainedBy"));
        }
        Collection<VirtualFile> srcDirectories = this.getAllSourceFolders();
        for (VirtualFile container : srcDirectories) {
            if (!container.exists() || !VfsUtilCore.isAncestor((VirtualFile)targetFolder, (VirtualFile)container, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static List<SourceProvider> getAllSourceProviders(@NotNull AndroidFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/facet/IdeaSourceProvider", "getAllSourceProviders"));
        }
        if (!facet.isGradleProject() || facet.getIdeaAndroidProject() == null) {
            List<SourceProvider> list = Collections.singletonList(facet.getMainSourceProvider());
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/IdeaSourceProvider", "getAllSourceProviders"));
            }
            return list;
        }
        AndroidProject androidProject = facet.getIdeaAndroidProject().getDelegate();
        Collection variants = androidProject.getVariants();
        ArrayList providers = Lists.newArrayList();
        providers.add(facet.getMainSourceProvider());
        Collection flavors = androidProject.getProductFlavors();
        for (ProductFlavorContainer pfc : flavors) {
            providers.add(pfc.getSourceProvider());
        }
        for (Variant v : variants) {
            SourceProvider provider = v.getMainArtifact().getMultiFlavorSourceProvider();
            if (provider == null) continue;
            providers.add(provider);
        }
        Collection buildTypes = androidProject.getBuildTypes();
        for (BuildTypeContainer btc : buildTypes) {
            providers.add(btc.getSourceProvider());
        }
        for (Variant v : variants) {
            SourceProvider provider = v.getMainArtifact().getVariantSourceProvider();
            if (provider == null) continue;
            providers.add(provider);
        }
        ArrayList arrayList = providers;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/IdeaSourceProvider", "getAllSourceProviders"));
        }
        return arrayList;
    }

    @NotNull
    public static List<IdeaSourceProvider> getAllIdeaSourceProviders(@NotNull AndroidFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/facet/IdeaSourceProvider", "getAllIdeaSourceProviders"));
        }
        ArrayList ideaSourceProviders = Lists.newArrayList();
        for (SourceProvider sourceProvider : IdeaSourceProvider.getAllSourceProviders(facet)) {
            ideaSourceProviders.add(IdeaSourceProvider.create(sourceProvider));
        }
        ArrayList arrayList = ideaSourceProviders;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/IdeaSourceProvider", "getAllIdeaSourceProviders"));
        }
        return arrayList;
    }

    @NotNull
    public static List<IdeaSourceProvider> getIdeaSourceProvidersForFile(@NotNull AndroidFacet facet, @Nullable VirtualFile targetFolder, @Nullable IdeaSourceProvider defaultIdeaSourceProvider) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/facet/IdeaSourceProvider", "getIdeaSourceProvidersForFile"));
        }
        ArrayList sourceProviderList = Lists.newArrayList();
        if (targetFolder != null) {
            for (IdeaSourceProvider provider : IdeaSourceProvider.getAllIdeaSourceProviders(facet)) {
                if (!provider.containsFile(targetFolder) && !provider.isContainedBy(targetFolder)) continue;
                sourceProviderList.add(provider);
            }
        }
        if (sourceProviderList.isEmpty() && defaultIdeaSourceProvider != null) {
            sourceProviderList.add(defaultIdeaSourceProvider);
        }
        ArrayList arrayList = sourceProviderList;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/IdeaSourceProvider", "getIdeaSourceProvidersForFile"));
        }
        return arrayList;
    }

    @NotNull
    public static List<SourceProvider> getSourceProvidersForFile(@NotNull AndroidFacet facet, @Nullable VirtualFile targetFolder, @Nullable SourceProvider defaultSourceProvider) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/facet/IdeaSourceProvider", "getSourceProvidersForFile"));
        }
        ArrayList sourceProviderList = Lists.newArrayList();
        if (targetFolder != null) {
            File targetIoFolder = VfsUtilCore.virtualToIoFile((VirtualFile)targetFolder);
            for (SourceProvider provider : IdeaSourceProvider.getAllSourceProviders(facet)) {
                if (!IdeaSourceProvider.containsFile(provider, targetIoFolder) && !IdeaSourceProvider.isContainedBy(provider, targetIoFolder)) continue;
                sourceProviderList.add(provider);
            }
        }
        if (sourceProviderList.isEmpty() && defaultSourceProvider != null) {
            sourceProviderList.add(defaultSourceProvider);
        }
        ArrayList arrayList = sourceProviderList;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/IdeaSourceProvider", "getSourceProvidersForFile"));
        }
        return arrayList;
    }

    public static boolean isManifestFile(@NotNull AndroidFacet facet, @Nullable VirtualFile candidate) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/facet/IdeaSourceProvider", "isManifestFile"));
        }
        if (candidate == null) {
            return false;
        }
        if (facet.isGradleProject()) {
            for (IdeaSourceProvider provider : IdeaSourceProvider.getCurrentSourceProviders(facet)) {
                if (!candidate.equals(provider.getManifestFile())) continue;
                return true;
            }
            return false;
        }
        return candidate.equals(facet.getMainIdeaSourceProvider().getManifestFile());
    }

    @NotNull
    public static List<VirtualFile> getManifestFiles(@NotNull AndroidFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/facet/IdeaSourceProvider", "getManifestFiles"));
        }
        VirtualFile main = facet.getMainIdeaSourceProvider().getManifestFile();
        if (!facet.isGradleProject()) {
            List<Object> list = main != null ? Collections.singletonList(main) : Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/IdeaSourceProvider", "getManifestFiles"));
            }
            return list;
        }
        ArrayList files = Lists.newArrayList();
        if (main != null) {
            files.add(main);
        }
        for (IdeaSourceProvider provider : IdeaSourceProvider.getCurrentSourceProviders(facet)) {
            VirtualFile manifest = provider.getManifestFile();
            if (manifest == null) continue;
            files.add(manifest);
        }
        ArrayList arrayList = files;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/IdeaSourceProvider", "getManifestFiles"));
        }
        return arrayList;
    }

    private static class Legacy
    extends IdeaSourceProvider {
        @NotNull
        private final AndroidFacet myFacet;

        private Legacy(@NotNull AndroidFacet facet) {
            if (facet == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/facet/IdeaSourceProvider$Legacy", "<init>"));
            }
            this.myFacet = facet;
        }

        @Override
        @NotNull
        public String getName() {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/IdeaSourceProvider$Legacy", "getName"));
            }
            return "";
        }

        @Override
        @Nullable
        public VirtualFile getManifestFile() {
            return AndroidRootUtil.getFileByRelativeModulePath(this.myFacet.getModule(), this.myFacet.getProperties().MANIFEST_FILE_RELATIVE_PATH, true);
        }

        @Override
        @NotNull
        public Set<VirtualFile> getJavaDirectories() {
            Module module = this.myFacet.getModule();
            HashSet dirs = new HashSet();
            Collections.addAll(dirs, ModuleRootManager.getInstance((Module)module).getContentRoots());
            HashSet hashSet = dirs;
            if (hashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/IdeaSourceProvider$Legacy", "getJavaDirectories"));
            }
            return hashSet;
        }

        @Override
        @NotNull
        public Set<VirtualFile> getResourcesDirectories() {
            Set<VirtualFile> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/IdeaSourceProvider$Legacy", "getResourcesDirectories"));
            }
            return set;
        }

        @Override
        @NotNull
        public Set<VirtualFile> getAidlDirectories() {
            VirtualFile dir = AndroidRootUtil.getAidlGenDir(this.myFacet);
            assert (dir != null);
            Set<VirtualFile> set = Collections.singleton(dir);
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/IdeaSourceProvider$Legacy", "getAidlDirectories"));
            }
            return set;
        }

        @Override
        @NotNull
        public Set<VirtualFile> getRenderscriptDirectories() {
            VirtualFile dir = AndroidRootUtil.getRenderscriptGenDir(this.myFacet);
            assert (dir != null);
            Set<VirtualFile> set = Collections.singleton(dir);
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/IdeaSourceProvider$Legacy", "getRenderscriptDirectories"));
            }
            return set;
        }

        @Override
        @NotNull
        public Set<VirtualFile> getJniDirectories() {
            Set<VirtualFile> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/IdeaSourceProvider$Legacy", "getJniDirectories"));
            }
            return set;
        }

        @Override
        @NotNull
        public Set<VirtualFile> getJniLibsDirectories() {
            Set<VirtualFile> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/IdeaSourceProvider$Legacy", "getJniLibsDirectories"));
            }
            return set;
        }

        @Override
        @NotNull
        public Set<VirtualFile> getResDirectories() {
            String resRelPath = this.myFacet.getProperties().RES_FOLDER_RELATIVE_PATH;
            VirtualFile dir = AndroidRootUtil.getFileByRelativeModulePath(this.myFacet.getModule(), resRelPath, true);
            if (dir != null) {
                Set<VirtualFile> set = Collections.singleton(dir);
                if (set == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/IdeaSourceProvider$Legacy", "getResDirectories"));
                }
                return set;
            }
            Set<VirtualFile> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/IdeaSourceProvider$Legacy", "getResDirectories"));
            }
            return set;
        }

        @Override
        @NotNull
        public Set<VirtualFile> getAssetsDirectories() {
            VirtualFile dir = AndroidRootUtil.getAssetsDir(this.myFacet);
            assert (dir != null);
            Set<VirtualFile> set = Collections.singleton(dir);
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/IdeaSourceProvider$Legacy", "getAssetsDirectories"));
            }
            return set;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Legacy that = (Legacy)o;
            return this.myFacet.equals((Object)that.myFacet);
        }

        public int hashCode() {
            return this.myFacet.hashCode();
        }
    }

    private static class Gradle
    extends IdeaSourceProvider {
        private final SourceProvider myProvider;
        private VirtualFile myManifestFile;
        private File myManifestIoFile;

        private Gradle(@NotNull SourceProvider provider) {
            if (provider == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "org/jetbrains/android/facet/IdeaSourceProvider$Gradle", "<init>"));
            }
            this.myProvider = provider;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myProvider.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/IdeaSourceProvider$Gradle", "getName"));
            }
            return string;
        }

        @Override
        @Nullable
        public VirtualFile getManifestFile() {
            File manifestFile = this.myProvider.getManifestFile();
            if (this.myManifestFile == null || !FileUtil.filesEqual((File)manifestFile, (File)this.myManifestIoFile)) {
                this.myManifestIoFile = manifestFile;
                this.myManifestFile = LocalFileSystem.getInstance().findFileByIoFile(manifestFile);
            }
            return this.myManifestFile;
        }

        private static Set<VirtualFile> convertFileSet(@NotNull Collection<File> fileSet) {
            if (fileSet == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileSet", "org/jetbrains/android/facet/IdeaSourceProvider$Gradle", "convertFileSet"));
            }
            java.util.HashSet result = Sets.newHashSetWithExpectedSize((int)fileSet.size());
            LocalFileSystem fileSystem = LocalFileSystem.getInstance();
            for (File file : fileSet) {
                VirtualFile virtualFile = fileSystem.findFileByIoFile(file);
                if (virtualFile == null) continue;
                result.add(virtualFile);
            }
            return result;
        }

        @Override
        @NotNull
        public Set<VirtualFile> getJavaDirectories() {
            Set<VirtualFile> set = Gradle.convertFileSet(this.myProvider.getJavaDirectories());
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/IdeaSourceProvider$Gradle", "getJavaDirectories"));
            }
            return set;
        }

        @Override
        @NotNull
        public Set<VirtualFile> getResourcesDirectories() {
            Set<VirtualFile> set = Gradle.convertFileSet(this.myProvider.getResourcesDirectories());
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/IdeaSourceProvider$Gradle", "getResourcesDirectories"));
            }
            return set;
        }

        @Override
        @NotNull
        public Set<VirtualFile> getAidlDirectories() {
            Set<VirtualFile> set = Gradle.convertFileSet(this.myProvider.getAidlDirectories());
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/IdeaSourceProvider$Gradle", "getAidlDirectories"));
            }
            return set;
        }

        @Override
        @NotNull
        public Set<VirtualFile> getRenderscriptDirectories() {
            Set<VirtualFile> set = Gradle.convertFileSet(this.myProvider.getRenderscriptDirectories());
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/IdeaSourceProvider$Gradle", "getRenderscriptDirectories"));
            }
            return set;
        }

        @Override
        @NotNull
        public Set<VirtualFile> getJniDirectories() {
            Set<VirtualFile> set = Gradle.convertFileSet(this.myProvider.getJniDirectories());
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/IdeaSourceProvider$Gradle", "getJniDirectories"));
            }
            return set;
        }

        @Override
        @NotNull
        public Set<VirtualFile> getJniLibsDirectories() {
            Set<VirtualFile> set = Gradle.convertFileSet(this.myProvider.getJniLibsDirectories());
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/IdeaSourceProvider$Gradle", "getJniLibsDirectories"));
            }
            return set;
        }

        @Override
        @NotNull
        public Set<VirtualFile> getResDirectories() {
            Set<VirtualFile> set = Gradle.convertFileSet(this.myProvider.getResDirectories());
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/IdeaSourceProvider$Gradle", "getResDirectories"));
            }
            return set;
        }

        @Override
        @NotNull
        public Set<VirtualFile> getAssetsDirectories() {
            Set<VirtualFile> set = Gradle.convertFileSet(this.myProvider.getAssetsDirectories());
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/IdeaSourceProvider$Gradle", "getAssetsDirectories"));
            }
            return set;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Gradle that = (Gradle)o;
            if (!this.myProvider.getName().equals(that.getName())) {
                return false;
            }
            return this.myProvider.getManifestFile().getPath().equals(that.myProvider.getManifestFile().getPath());
        }

        public int hashCode() {
            return this.myProvider.getManifestFile().getPath().hashCode();
        }
    }
}

