/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections.lint;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.sdklib.SdkVersionInfo;
import com.android.tools.lint.checks.ApiDetector;
import com.android.tools.lint.checks.ApiLookup;
import com.android.tools.lint.detector.api.ClassContext;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import lombok.ast.AstVisitor;
import lombok.ast.CompilationUnit;
import lombok.ast.ForwardingAstVisitor;
import lombok.ast.Node;
import org.jetbrains.android.inspections.lint.IntellijLintUtils;
import org.jetbrains.annotations.NonNls;

public class IntellijApiDetector
extends ApiDetector {
    static final Implementation IMPLEMENTATION = new Implementation(IntellijApiDetector.class, EnumSet.of(Scope.RESOURCE_FILE, Scope.MANIFEST, Scope.JAVA_FILE), new EnumSet[]{Scope.MANIFEST_SCOPE, Scope.RESOURCE_FILE_SCOPE, Scope.JAVA_FILE_SCOPE});
    @NonNls
    private static final String TARGET_API_FQCN = "android.annotation.TargetApi";

    @Nullable
    public List<Class<? extends Node>> getApplicableNodeTypes() {
        return Collections.singletonList(CompilationUnit.class);
    }

    @Nullable
    public AstVisitor createJavaVisitor(final @NonNull JavaContext context) {
        return new ForwardingAstVisitor(){

            public boolean visitCompilationUnit(CompilationUnit node) {
                IntellijApiDetector.this.check(context);
                return true;
            }
        };
    }

    private void check(final JavaContext context) {
        if (this.mApiDatabase == null) {
            return;
        }
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                PsiFile psiFile = IntellijLintUtils.getPsiFile((Context)context);
                if (!(psiFile instanceof PsiJavaFile)) {
                    return;
                }
                PsiJavaFile javaFile = (PsiJavaFile)psiFile;
                for (PsiClass clz : javaFile.getClasses()) {
                    ApiCheckVisitor visitor = new ApiCheckVisitor((Context)context, clz, psiFile);
                    javaFile.accept((PsiElementVisitor)visitor);
                }
            }
        });
    }

    private static int getTargetApi(@NonNull PsiElement e, @NonNull PsiElement file) {
        for (PsiElement element = e; element != null && element != file; element = element.getParent()) {
            if (!(element instanceof PsiModifierListOwner)) continue;
            PsiModifierListOwner owner = (PsiModifierListOwner)element;
            PsiModifierList modifierList = owner.getModifierList();
            PsiAnnotation annotation = null;
            if (modifierList != null) {
                annotation = modifierList.findAnnotation(TARGET_API_FQCN);
            }
            if (annotation == null) continue;
            for (PsiNameValuePair pair : annotation.getParameterList().getAttributes()) {
                PsiAnnotationMemberValue v = pair.getValue();
                if (v instanceof PsiLiteral) {
                    PsiLiteral literal = (PsiLiteral)v;
                    Object value = literal.getValue();
                    if (value instanceof Integer) {
                        return (Integer)value;
                    }
                    if (!(value instanceof String)) continue;
                    return IntellijApiDetector.codeNameToApi((String)value);
                }
                if (v instanceof PsiArrayInitializerMemberValue) {
                    PsiArrayInitializerMemberValue mv = (PsiArrayInitializerMemberValue)v;
                    for (PsiAnnotationMemberValue mmv : mv.getInitializers()) {
                        if (!(mmv instanceof PsiLiteral)) continue;
                        PsiLiteral literal = (PsiLiteral)mmv;
                        Object value = literal.getValue();
                        if (value instanceof Integer) {
                            return (Integer)value;
                        }
                        if (!(value instanceof String)) continue;
                        return IntellijApiDetector.codeNameToApi((String)value);
                    }
                    continue;
                }
                if (!(v instanceof PsiExpression)) continue;
                if (v instanceof PsiReferenceExpression) {
                    String fqcn = ((PsiReferenceExpression)v).getQualifiedName();
                    return IntellijApiDetector.codeNameToApi(fqcn);
                }
                return IntellijApiDetector.codeNameToApi(v.getText());
            }
        }
        return -1;
    }

    private static int codeNameToApi(String text) {
        int dotIndex = text.lastIndexOf(46);
        if (dotIndex != -1) {
            text = text.substring(dotIndex + 1);
        }
        return SdkVersionInfo.getApiByBuildCode((String)text, (boolean)true);
    }

    private static boolean isWithinVersionCheckConditional(PsiElement element, int api) {
        PsiElement current;
        PsiElement prev = current = element.getParent();
        while (current != null) {
            if (current instanceof PsiIfStatement) {
                PsiReferenceExpression ref;
                PsiExpression left;
                PsiBinaryExpression binary;
                IElementType tokenType;
                PsiIfStatement ifStatement = (PsiIfStatement)current;
                PsiExpression condition = ifStatement.getCondition();
                if (condition != prev && condition instanceof PsiBinaryExpression && ((tokenType = (binary = (PsiBinaryExpression)condition).getOperationTokenType()) == JavaTokenType.GT || tokenType == JavaTokenType.GE || tokenType == JavaTokenType.LE || tokenType == JavaTokenType.LT || tokenType == JavaTokenType.EQEQ) && (left = binary.getLOperand()) instanceof PsiReferenceExpression && "SDK_INT".equals((ref = (PsiReferenceExpression)left).getReferenceName())) {
                    PsiLiteralExpression lit;
                    Object value;
                    PsiExpression right = binary.getROperand();
                    int level = -1;
                    if (right instanceof PsiReferenceExpression) {
                        PsiReferenceExpression ref2 = (PsiReferenceExpression)right;
                        String codeName = ref2.getReferenceName();
                        level = SdkVersionInfo.getApiByBuildCode((String)codeName, (boolean)true);
                    } else if (right instanceof PsiLiteralExpression && (value = (lit = (PsiLiteralExpression)right).getValue()) instanceof Integer) {
                        level = (Integer)value;
                    }
                    if (level != -1) {
                        boolean fromElse;
                        boolean fromThen = prev == ifStatement.getThenBranch();
                        boolean bl = fromElse = prev == ifStatement.getElseBranch();
                        assert (fromThen == !fromElse);
                        if (tokenType == JavaTokenType.GE) {
                            return level >= api && fromThen;
                        }
                        if (tokenType == JavaTokenType.GT) {
                            return level >= api - 1 && fromThen;
                        }
                        if (tokenType == JavaTokenType.LE) {
                            return level >= api - 1 && fromElse;
                        }
                        if (tokenType == JavaTokenType.LT) {
                            return level >= api && fromElse;
                        }
                        if (tokenType == JavaTokenType.EQEQ) {
                            return level >= api && fromThen;
                        }
                        assert (false) : tokenType;
                    }
                }
            } else if (current instanceof PsiMethod || current instanceof PsiFile) {
                return false;
            }
            prev = current;
            current = current.getParent();
        }
        return false;
    }

    private class ApiCheckVisitor
    extends JavaRecursiveElementVisitor {
        private final Context myContext;
        private boolean mySeenSuppress;
        private boolean mySeenTargetApi;
        private final PsiClass myClass;
        private final PsiFile myFile;
        private final boolean myCheckAccess;
        private boolean myCheckOverride;
        private String myFrameworkParent;

        public ApiCheckVisitor(Context context, PsiClass clz, PsiFile file) {
            this.myContext = context;
            this.myClass = clz;
            this.myFile = file;
            this.myCheckAccess = context.isEnabled(ApiDetector.UNSUPPORTED) || context.isEnabled(ApiDetector.INLINED);
            boolean bl = this.myCheckOverride = context.isEnabled(ApiDetector.OVERRIDE) && context.getMainProject().getBuildSdk() >= 1;
            if (this.myCheckOverride) {
                this.myFrameworkParent = null;
                for (PsiClass superClass = this.myClass.getSuperClass(); superClass != null; superClass = superClass.getSuperClass()) {
                    String fqcn = superClass.getQualifiedName();
                    if (fqcn == null) {
                        this.myCheckOverride = false;
                        continue;
                    }
                    if (!fqcn.startsWith("android.") && !fqcn.startsWith("java.") && !fqcn.startsWith("javax.")) continue;
                    if (fqcn.equals("java.lang.Object")) break;
                    this.myFrameworkParent = ClassContext.getInternalName((String)fqcn);
                    break;
                }
                if (this.myFrameworkParent == null) {
                    this.myCheckOverride = false;
                }
            }
        }

        public void visitAnnotation(PsiAnnotation annotation) {
            super.visitAnnotation(annotation);
            String fqcn = annotation.getQualifiedName();
            if (IntellijApiDetector.TARGET_API_FQCN.equals(fqcn)) {
                this.mySeenTargetApi = true;
            } else if ("android.annotation.SuppressLint".equals(fqcn) || "java.lang.SuppressWarnings".equals(fqcn)) {
                this.mySeenSuppress = true;
            }
        }

        public void visitMethod(PsiMethod method) {
            super.visitMethod(method);
            if (!this.myCheckOverride) {
                return;
            }
            int buildSdk = this.myContext.getMainProject().getBuildSdk();
            String name = method.getName();
            assert (this.myFrameworkParent != null);
            String desc = IntellijLintUtils.getInternalDescription(method, false, false);
            if (desc == null) {
                return;
            }
            int api = IntellijApiDetector.this.mApiDatabase.getCallVersion(this.myFrameworkParent, name, desc);
            if (api > buildSdk && buildSdk != -1) {
                String fqcn;
                if (this.mySeenSuppress && IntellijLintUtils.isSuppressed((PsiElement)method, this.myFile, ApiDetector.OVERRIDE)) {
                    return;
                }
                PsiClass containingClass = method.getContainingClass();
                if (containingClass != null) {
                    String className = containingClass.getName();
                    String fullClassName = containingClass.getQualifiedName();
                    if (fullClassName != null) {
                        className = fullClassName;
                    }
                    fqcn = className + '#' + name;
                } else {
                    fqcn = name;
                }
                String message = String.format("This method is not overriding anything with the current build target, but will in API level %1$d (current target is %2$d): %3$s", api, buildSdk, fqcn);
                PsiIdentifier locationNode = method.getNameIdentifier();
                if (locationNode == null) {
                    locationNode = method;
                }
                Location location = IntellijLintUtils.getLocation(this.myContext.file, (PsiElement)locationNode);
                this.myContext.report(ApiDetector.OVERRIDE, location, message, null);
            }
        }

        public void visitClass(PsiClass aClass) {
            super.visitClass(aClass);
            if (!this.myCheckAccess) {
                return;
            }
            for (PsiClassType type : aClass.getSuperTypes()) {
                Location location;
                int target;
                int minSdk;
                int api;
                String signature = IntellijLintUtils.getInternalName(type);
                if (signature == null || (api = IntellijApiDetector.this.mApiDatabase.getClassVersion(signature)) == -1 || api <= (minSdk = IntellijApiDetector.this.getMinSdk(this.myContext)) || this.mySeenTargetApi && (target = IntellijApiDetector.getTargetApi((PsiElement)aClass, (PsiElement)this.myFile)) != -1 && api <= target || this.mySeenSuppress && IntellijLintUtils.isSuppressed((PsiElement)aClass, this.myFile, ApiDetector.UNSUPPORTED)) continue;
                if (type instanceof PsiClassReferenceType) {
                    PsiJavaCodeReferenceElement reference = ((PsiClassReferenceType)type).getReference();
                    PsiElement element = reference.getElement();
                    if (IntellijApiDetector.isWithinVersionCheckConditional(element, api)) continue;
                    location = IntellijLintUtils.getLocation(this.myContext.file, element);
                } else {
                    location = IntellijLintUtils.getLocation(this.myContext.file, (PsiElement)aClass);
                }
                String fqcn = type.getClassName();
                String message = String.format("Class requires API level %1$d (current min is %2$d): %3$s", api, minSdk, fqcn);
                this.myContext.report(ApiDetector.UNSUPPORTED, location, message, null);
            }
        }

        public void visitReferenceExpression(PsiReferenceExpression expression) {
            super.visitReferenceExpression(expression);
            if (!this.myCheckAccess) {
                return;
            }
            PsiReference reference = expression.getReference();
            if (reference == null) {
                return;
            }
            PsiElement resolved = reference.resolve();
            if (resolved != null && resolved instanceof PsiField) {
                PsiField field = (PsiField)resolved;
                PsiClass containingClass = field.getContainingClass();
                if (containingClass == null) {
                    return;
                }
                String owner = IntellijLintUtils.getInternalName(containingClass);
                if (owner == null) {
                    return;
                }
                String name = field.getName();
                int api = IntellijApiDetector.this.mApiDatabase.getFieldVersion(owner, name);
                if (api == -1) {
                    return;
                }
                int minSdk = IntellijApiDetector.this.getMinSdk(this.myContext);
                if (this.isSuppressed(api, (PsiElement)expression, minSdk)) {
                    return;
                }
                Location location = IntellijLintUtils.getLocation(this.myContext.file, (PsiElement)expression);
                String fqcn = containingClass.getQualifiedName();
                String message = String.format("Field requires API level %1$d (current min is %2$d): %3$s", api, minSdk, fqcn + '#' + name);
                Issue issue = ApiDetector.UNSUPPORTED;
                PsiType type = field.getType();
                if (type == PsiType.INT || type == PsiType.CHAR || type == PsiType.BOOLEAN || type == PsiType.DOUBLE || type == PsiType.FLOAT || type == PsiType.BYTE || type.equalsToText("java.lang.String")) {
                    issue = ApiDetector.INLINED;
                    if (this.isBenignConstantUsage((PsiElement)expression, name, owner)) {
                        return;
                    }
                }
                this.myContext.report(issue, location, message, null);
            }
        }

        public void visitTryStatement(PsiTryStatement statement) {
            super.visitTryStatement(statement);
            PsiResourceList resourceList = statement.getResourceList();
            if (resourceList != null) {
                int api = 19;
                int minSdk = IntellijApiDetector.this.getMinSdk(this.myContext);
                if (this.isSuppressed(api, (PsiElement)statement, minSdk)) {
                    return;
                }
                Location location = IntellijLintUtils.getLocation(this.myContext.file, (PsiElement)resourceList);
                String message = String.format("Try-with-resources requires API level %1$d (current min is %2$d)", api, minSdk);
                this.myContext.report(ApiDetector.UNSUPPORTED, location, message, null);
            }
            for (PsiParameter parameter : statement.getCatchBlockParameters()) {
                int target;
                int minSdk;
                int api;
                String signature;
                PsiClassReferenceType referenceType;
                PsiClass resolved;
                PsiType type;
                PsiTypeElement typeElement = parameter.getTypeElement();
                if (typeElement == null || !((type = typeElement.getType()) instanceof PsiClassReferenceType) || (resolved = (referenceType = (PsiClassReferenceType)type).resolve()) == null || (signature = IntellijLintUtils.getInternalName(resolved)) == null || (api = IntellijApiDetector.this.mApiDatabase.getClassVersion(signature)) == -1 || api <= (minSdk = IntellijApiDetector.this.getMinSdk(this.myContext)) || this.mySeenTargetApi && (target = IntellijApiDetector.getTargetApi((PsiElement)statement, (PsiElement)this.myFile)) != -1 && api <= target || this.mySeenSuppress && IntellijLintUtils.isSuppressed((PsiElement)statement, this.myFile, ApiDetector.UNSUPPORTED)) continue;
                PsiJavaCodeReferenceElement reference = referenceType.getReference();
                Location location = IntellijLintUtils.getLocation(this.myContext.file, reference.getElement());
                String fqcn = referenceType.getClassName();
                String message = String.format("Class requires API level %1$d (current min is %2$d): %3$s", api, minSdk, fqcn);
                this.myContext.report(ApiDetector.UNSUPPORTED, location, message, null);
            }
        }

        private boolean isSuppressed(int api, PsiElement element, int minSdk) {
            int target;
            if (api <= minSdk) {
                return true;
            }
            if (this.mySeenTargetApi && (target = IntellijApiDetector.getTargetApi(element, (PsiElement)this.myFile)) != -1 && api <= target) {
                return true;
            }
            if (this.mySeenSuppress && (IntellijLintUtils.isSuppressed(element, this.myFile, ApiDetector.UNSUPPORTED) || IntellijLintUtils.isSuppressed(element, this.myFile, ApiDetector.INLINED))) {
                return true;
            }
            return IntellijApiDetector.isWithinVersionCheckConditional(element, api);
        }

        public boolean isBenignConstantUsage(@NonNull PsiElement node, @NonNull String name, @NonNull String owner) {
            if (ApiDetector.isBenignConstantUsage(null, (String)name, (String)owner)) {
                return true;
            }
            for (PsiElement curr = node.getParent(); curr != null; curr = curr.getParent()) {
                if (curr instanceof PsiSwitchLabelStatement) {
                    PsiSwitchLabelStatement caseStatement = (PsiSwitchLabelStatement)curr;
                    PsiExpression condition = caseStatement.getCaseValue();
                    return condition != null && PsiTreeUtil.isAncestor((PsiElement)condition, (PsiElement)node, (boolean)false);
                }
                if (curr instanceof PsiIfStatement) {
                    PsiIfStatement ifStatement = (PsiIfStatement)curr;
                    PsiExpression condition = ifStatement.getCondition();
                    return condition != null && PsiTreeUtil.isAncestor((PsiElement)condition, (PsiElement)node, (boolean)false);
                }
                if (!(curr instanceof PsiConditionalExpression)) continue;
                PsiConditionalExpression ifStatement = (PsiConditionalExpression)curr;
                PsiExpression condition = ifStatement.getCondition();
                return PsiTreeUtil.isAncestor((PsiElement)condition, (PsiElement)node, (boolean)false);
            }
            return false;
        }

        public void visitCallExpression(PsiCallExpression expression) {
            super.visitCallExpression(expression);
            if (!this.myCheckAccess) {
                return;
            }
            PsiMethod method = expression.resolveMethod();
            if (method != null) {
                PsiClass containingClass = method.getContainingClass();
                if (containingClass == null) {
                    return;
                }
                String fqcn = containingClass.getQualifiedName();
                String owner = IntellijLintUtils.getInternalName(containingClass);
                if (owner == null) {
                    return;
                }
                String name = IntellijLintUtils.getInternalMethodName(method);
                String desc = IntellijLintUtils.getInternalDescription(method, false, false);
                if (desc == null) {
                    return;
                }
                int api = IntellijApiDetector.this.mApiDatabase.getCallVersion(owner, name, desc);
                if (api == -1) {
                    return;
                }
                int minSdk = IntellijApiDetector.this.getMinSdk(this.myContext);
                if (api <= minSdk) {
                    return;
                }
                if (expression instanceof PsiMethodCallExpression) {
                    String expressionOwner;
                    PsiExpression qualifier = ((PsiMethodCallExpression)expression).getMethodExpression().getQualifierExpression();
                    if (qualifier != null && !(qualifier instanceof PsiThisExpression) && !(qualifier instanceof PsiSuperExpression)) {
                        int specificApi;
                        PsiType type = qualifier.getType();
                        if (type != null && type instanceof PsiClassType && (expressionOwner = IntellijLintUtils.getInternalName((PsiClassType)type)) != null && !expressionOwner.equals(owner) && ((specificApi = IntellijApiDetector.this.mApiDatabase.getCallVersion(expressionOwner, name, desc)) == -1 ? ApiLookup.isRelevantOwner((String)expressionOwner) : specificApi <= minSdk)) {
                            return;
                        }
                    } else {
                        for (PsiClass cls = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiClass.class); cls != null && (expressionOwner = IntellijLintUtils.getInternalName(cls)) != null; cls = cls.getSuperClass()) {
                            int specificApi = IntellijApiDetector.this.mApiDatabase.getCallVersion(expressionOwner, name, desc);
                            if (specificApi == -1) {
                                if (!ApiLookup.isRelevantOwner((String)expressionOwner)) continue;
                                return;
                            }
                            if (specificApi > minSdk) break;
                            return;
                        }
                    }
                }
                if (this.isSuppressed(api, (PsiElement)expression, minSdk)) {
                    return;
                }
                PsiElement locationNode = IntellijLintUtils.getCallName(expression);
                if (locationNode == null) {
                    locationNode = expression;
                }
                Location location = IntellijLintUtils.getLocation(this.myContext.file, locationNode);
                String message = String.format("Call requires API level %1$d (current min is %2$d): %3$s", api, minSdk, fqcn + '#' + method.getName());
                this.myContext.report(ApiDetector.UNSUPPORTED, location, message, null);
            }
        }
    }
}

