/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.uipreview;

import com.android.ide.common.resources.LocaleManager;
import com.android.ide.common.resources.configuration.CountryCodeQualifier;
import com.android.ide.common.resources.configuration.DensityQualifier;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.KeyboardStateQualifier;
import com.android.ide.common.resources.configuration.LanguageQualifier;
import com.android.ide.common.resources.configuration.LayoutDirectionQualifier;
import com.android.ide.common.resources.configuration.NavigationMethodQualifier;
import com.android.ide.common.resources.configuration.NavigationStateQualifier;
import com.android.ide.common.resources.configuration.NetworkCodeQualifier;
import com.android.ide.common.resources.configuration.NightModeQualifier;
import com.android.ide.common.resources.configuration.RegionQualifier;
import com.android.ide.common.resources.configuration.ResourceQualifier;
import com.android.ide.common.resources.configuration.ScreenDimensionQualifier;
import com.android.ide.common.resources.configuration.ScreenHeightQualifier;
import com.android.ide.common.resources.configuration.ScreenOrientationQualifier;
import com.android.ide.common.resources.configuration.ScreenRatioQualifier;
import com.android.ide.common.resources.configuration.ScreenSizeQualifier;
import com.android.ide.common.resources.configuration.ScreenWidthQualifier;
import com.android.ide.common.resources.configuration.SmallestScreenWidthQualifier;
import com.android.ide.common.resources.configuration.TextInputMethodQualifier;
import com.android.ide.common.resources.configuration.TouchScreenQualifier;
import com.android.ide.common.resources.configuration.UiModeQualifier;
import com.android.ide.common.resources.configuration.VersionQualifier;
import com.android.resources.Density;
import com.android.resources.Keyboard;
import com.android.resources.KeyboardState;
import com.android.resources.LayoutDirection;
import com.android.resources.Navigation;
import com.android.resources.NavigationState;
import com.android.resources.NightMode;
import com.android.resources.ResourceEnum;
import com.android.resources.ScreenOrientation;
import com.android.resources.ScreenRatio;
import com.android.resources.ScreenSize;
import com.android.resources.TouchScreen;
import com.android.resources.UiMode;
import com.android.tools.idea.rendering.FlagManager;
import com.google.common.collect.Maps;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.Comparing;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.EnumComboBoxModel;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.SortedListModel;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.speedSearch.ListWithFilter;
import com.intellij.util.containers.HashMap;
import com.intellij.util.ui.AbstractLayoutManager;
import com.intellij.util.ui.UIUtil;
import icons.AndroidIcons;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.android.uipreview.InvalidOptionValueException;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DeviceConfiguratorPanel
extends JPanel {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.uipreview.DeviceConfiguratorPanel");
    private JBList myAvailableQualifiersList;
    private JButton myAddQualifierButton;
    private JButton myRemoveQualifierButton;
    private JPanel myQualifierOptionsPanel;
    private final Map<String, MyQualifierEditor> myEditors = new HashMap();
    private final FolderConfiguration myAvailableQualifiersConfig = new FolderConfiguration();
    private final FolderConfiguration myChosenQualifiersConfig = new FolderConfiguration();
    private FolderConfiguration myActualQualifiersConfig = new FolderConfiguration();
    private JBList myChosenQualifiersList;
    private final DocumentListener myUpdatingDocumentListener = new DocumentAdapter(){

        protected void textChanged(DocumentEvent e) {
            DeviceConfiguratorPanel.this.applyEditors();
        }
    };
    public final ListSelectionListener myUpdatingListListener = new ListSelectionListener(){

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            DeviceConfiguratorPanel.this.applyEditors();
        }
    };
    private static final Map<String, Icon> ourIcons = Maps.newHashMapWithExpectedSize((int)25);

    public DeviceConfiguratorPanel() {
        super(new BorderLayout());
        this.createUIComponents();
        this.createDefaultConfig(this.myAvailableQualifiersConfig);
        this.myChosenQualifiersConfig.reset();
        for (ResourceQualifier qualifier : this.myAvailableQualifiersConfig.getQualifiers()) {
            String name = qualifier.getShortName();
            if (qualifier instanceof CountryCodeQualifier) {
                this.myEditors.put(name, new MyCountryCodeEditor());
                continue;
            }
            if (qualifier instanceof NetworkCodeQualifier) {
                this.myEditors.put(name, new MyNetworkCodeEditor());
                continue;
            }
            if (qualifier instanceof KeyboardStateQualifier) {
                this.myEditors.put(name, new MyKeyboardStateEditor());
                continue;
            }
            if (qualifier instanceof NavigationMethodQualifier) {
                this.myEditors.put(name, new MyNavigationMethodEditor());
                continue;
            }
            if (qualifier instanceof NavigationStateQualifier) {
                this.myEditors.put(name, new MyNavigationStateEditor());
                continue;
            }
            if (qualifier instanceof DensityQualifier) {
                this.myEditors.put(name, new MyDensityEditor());
                continue;
            }
            if (qualifier instanceof ScreenDimensionQualifier) {
                this.myEditors.put(name, new MyScreenDimensionEditor());
                continue;
            }
            if (qualifier instanceof ScreenOrientationQualifier) {
                this.myEditors.put(name, new MyScreenOrientationEditor());
                continue;
            }
            if (qualifier instanceof ScreenRatioQualifier) {
                this.myEditors.put(name, new MyScreenRatioEditor());
                continue;
            }
            if (qualifier instanceof ScreenSizeQualifier) {
                this.myEditors.put(name, new MyScreenSizeEditor());
                continue;
            }
            if (qualifier instanceof TextInputMethodQualifier) {
                this.myEditors.put(name, new MyTextInputMethodEditor());
                continue;
            }
            if (qualifier instanceof TouchScreenQualifier) {
                this.myEditors.put(name, new MyTouchScreenEditor());
                continue;
            }
            if (qualifier instanceof VersionQualifier) {
                this.myEditors.put(name, new MyVersionEditor());
                continue;
            }
            if (qualifier instanceof NightModeQualifier) {
                this.myEditors.put(name, new MyNightModeEditor());
                continue;
            }
            if (qualifier instanceof UiModeQualifier) {
                this.myEditors.put(name, new MyUiModeEditor());
                continue;
            }
            if (qualifier instanceof LanguageQualifier) {
                this.myEditors.put(name, new MyLanguageEditor());
                continue;
            }
            if (qualifier instanceof RegionQualifier) {
                this.myEditors.put(name, new MyRegionEditor());
                continue;
            }
            if (qualifier instanceof SmallestScreenWidthQualifier) {
                this.myEditors.put(name, new MySmallestScreenWidthEditor());
                continue;
            }
            if (qualifier instanceof ScreenWidthQualifier) {
                this.myEditors.put(name, new MyScreenWidthEditor());
                continue;
            }
            if (qualifier instanceof ScreenHeightQualifier) {
                this.myEditors.put(name, new MyScreenHeightEditor());
                continue;
            }
            if (qualifier instanceof LayoutDirectionQualifier) {
                this.myEditors.put(name, new MyLayoutDirectionEditor());
                continue;
            }
            LOG.info("Missing editor for qualifier " + qualifier);
        }
        for (String name : this.myEditors.keySet()) {
            MyQualifierEditor editor = this.myEditors.get(name);
            this.myQualifierOptionsPanel.add((Component)editor.getComponent(), name);
        }
        this.myAvailableQualifiersList.setCellRenderer((ListCellRenderer)new ColoredListCellRenderer(){

            protected void customizeCellRenderer(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                if (value instanceof ResourceQualifier) {
                    ResourceQualifier qualifier = (ResourceQualifier)value;
                    this.append(qualifier.getShortName());
                    this.setIcon(DeviceConfiguratorPanel.getResourceIcon(qualifier));
                }
            }
        });
        this.myChosenQualifiersList.setCellRenderer((ListCellRenderer)new ColoredListCellRenderer(){

            protected void customizeCellRenderer(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                if (value instanceof ResourceQualifier) {
                    ResourceQualifier qualifier = DeviceConfiguratorPanel.this.getActualQualifier((ResourceQualifier)value);
                    String shortDisplayValue = qualifier.getShortDisplayValue();
                    if (shortDisplayValue != null && !shortDisplayValue.isEmpty()) {
                        this.append(shortDisplayValue);
                    } else {
                        this.append(qualifier.getShortName() + " (?)");
                    }
                    this.setIcon(DeviceConfiguratorPanel.getResourceIcon(qualifier));
                }
            }
        });
        this.myAddQualifierButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResourceQualifier selectedQualifier = (ResourceQualifier)DeviceConfiguratorPanel.this.myAvailableQualifiersList.getSelectedValue();
                if (selectedQualifier != null) {
                    int index = DeviceConfiguratorPanel.this.myAvailableQualifiersList.getSelectedIndex();
                    DeviceConfiguratorPanel.this.myAvailableQualifiersConfig.removeQualifier(selectedQualifier);
                    DeviceConfiguratorPanel.this.myChosenQualifiersConfig.addQualifier(selectedQualifier);
                    DeviceConfiguratorPanel.this.updateLists();
                    DeviceConfiguratorPanel.this.applyEditors();
                    if (index >= 0) {
                        DeviceConfiguratorPanel.this.myAvailableQualifiersList.setSelectedIndex(Math.min(index, DeviceConfiguratorPanel.this.myAvailableQualifiersList.getItemsCount() - 1));
                    }
                    DeviceConfiguratorPanel.this.myChosenQualifiersList.setSelectedValue((Object)selectedQualifier, true);
                }
            }
        });
        this.myRemoveQualifierButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResourceQualifier selectedQualifier = (ResourceQualifier)DeviceConfiguratorPanel.this.myChosenQualifiersList.getSelectedValue();
                if (selectedQualifier != null) {
                    int index = DeviceConfiguratorPanel.this.myChosenQualifiersList.getSelectedIndex();
                    DeviceConfiguratorPanel.this.myChosenQualifiersConfig.removeQualifier(selectedQualifier);
                    DeviceConfiguratorPanel.this.myAvailableQualifiersConfig.addQualifier(selectedQualifier);
                    DeviceConfiguratorPanel.this.updateLists();
                    DeviceConfiguratorPanel.this.applyEditors();
                    if (index >= 0) {
                        DeviceConfiguratorPanel.this.myChosenQualifiersList.setSelectedIndex(Math.min(index, DeviceConfiguratorPanel.this.myChosenQualifiersList.getItemsCount() - 1));
                    }
                }
            }
        });
        this.myAvailableQualifiersList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                DeviceConfiguratorPanel.this.updateButtons();
            }
        });
        this.myChosenQualifiersList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                DeviceConfiguratorPanel.this.updateButtons();
                DeviceConfiguratorPanel.this.updateQualifierEditor();
            }
        });
    }

    @Nullable
    private static Icon getResourceIcon(ResourceQualifier qualifier) {
        return ourIcons.get(qualifier.getName());
    }

    public void init(@NotNull FolderConfiguration config) {
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "org/jetbrains/android/uipreview/DeviceConfiguratorPanel", "init"));
        }
        this.myChosenQualifiersConfig.set(config);
        this.myAvailableQualifiersConfig.substract(config);
        for (ResourceQualifier qualifier : config.getQualifiers()) {
            MyQualifierEditor editor = this.myEditors.get(qualifier.getShortName());
            if (editor == null) continue;
            editor.reset(qualifier);
        }
    }

    protected void createDefaultConfig(FolderConfiguration config) {
        config.createDefault();
    }

    public abstract void applyEditors();

    public void updateAll() {
        this.updateLists();
        this.updateButtons();
        this.updateQualifierEditor();
        this.applyEditors();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doApplyEditors() throws InvalidOptionValueException {
        try {
            FolderConfiguration newConfig = new FolderConfiguration();
            for (ResourceQualifier qualifier : this.myChosenQualifiersConfig.getQualifiers()) {
                MyQualifierEditor editor = this.myEditors.get(qualifier.getShortName());
                if (editor == null) continue;
                newConfig.addQualifier(editor.apply());
            }
            this.myActualQualifiersConfig = newConfig;
        }
        finally {
            this.myAvailableQualifiersList.repaint();
            this.myChosenQualifiersList.repaint();
        }
    }

    public DocumentListener getUpdatingDocumentListener() {
        return this.myUpdatingDocumentListener;
    }

    private ResourceQualifier getActualQualifier(ResourceQualifier qualifier) {
        for (ResourceQualifier qualifier1 : this.myActualQualifiersConfig.getQualifiers()) {
            if (!Comparing.equal((String)qualifier1.getShortName(), (String)qualifier.getShortName())) continue;
            return qualifier1;
        }
        return qualifier;
    }

    private void updateQualifierEditor() {
        ResourceQualifier selectedQualifier = (ResourceQualifier)this.myChosenQualifiersList.getSelectedValue();
        if (selectedQualifier != null && this.myEditors.containsKey(selectedQualifier.getShortName())) {
            CardLayout layout = (CardLayout)this.myQualifierOptionsPanel.getLayout();
            layout.show(this.myQualifierOptionsPanel, selectedQualifier.getShortName());
            this.myQualifierOptionsPanel.setVisible(true);
        } else {
            this.myQualifierOptionsPanel.setVisible(false);
        }
    }

    private void updateButtons() {
        this.myAddQualifierButton.setEnabled(this.myAvailableQualifiersList.getSelectedIndex() >= 0);
        this.myRemoveQualifierButton.setEnabled(this.myChosenQualifiersList.getSelectedIndex() >= 0);
    }

    private void updateLists() {
        Object qualifier = this.myAvailableQualifiersList.getSelectedValue();
        Object[] availableQualifiers = this.filterUnsupportedQualifiers(this.myAvailableQualifiersConfig.getQualifiers());
        this.myAvailableQualifiersList.setModel((ListModel)new CollectionListModel(availableQualifiers));
        this.myAvailableQualifiersList.setSelectedValue(qualifier, true);
        if (this.myAvailableQualifiersList.getSelectedValue() == null && this.myAvailableQualifiersList.getItemsCount() > 0) {
            this.myAvailableQualifiersList.setSelectedIndex(0);
        }
        qualifier = this.myChosenQualifiersList.getSelectedValue();
        Object[] chosenQualifiers = this.filterUnsupportedQualifiers(this.myChosenQualifiersConfig.getQualifiers());
        this.myChosenQualifiersList.setModel((ListModel)new CollectionListModel(chosenQualifiers));
        this.myChosenQualifiersList.setSelectedValue(qualifier, true);
        if (this.myChosenQualifiersList.getSelectedValue() == null && this.myChosenQualifiersList.getItemsCount() > 0) {
            this.myChosenQualifiersList.setSelectedIndex(0);
        }
    }

    private ResourceQualifier[] filterUnsupportedQualifiers(ResourceQualifier[] qualifiers) {
        ArrayList<ResourceQualifier> result = new ArrayList<ResourceQualifier>();
        for (ResourceQualifier qualifier : qualifiers) {
            if (!this.myEditors.containsKey(qualifier.getShortName())) continue;
            result.add(qualifier);
        }
        return result.toArray(new ResourceQualifier[result.size()]);
    }

    public FolderConfiguration getConfiguration() {
        return this.myActualQualifiersConfig;
    }

    private void createUIComponents() {
        this.myQualifierOptionsPanel = new JPanel(new CardLayout());
        final JPanel leftPanel = new JPanel(new BorderLayout(5, 5));
        this.myAvailableQualifiersList = new JBList();
        this.myAvailableQualifiersList.setMinimumSize(new Dimension(10, 10));
        JBLabel label = new JBLabel(AndroidBundle.message("android.layout.preview.edit.configuration.available.qualifiers.label", new Object[0]));
        label.setLabelFor((Component)this.myAvailableQualifiersList);
        leftPanel.add((Component)label, "North");
        leftPanel.add((Component)new JBScrollPane((Component)this.myAvailableQualifiersList, 20, 31), "Center");
        final JPanel rightPanel = new JPanel(new BorderLayout(5, 5));
        this.myChosenQualifiersList = new JBList();
        this.myChosenQualifiersList.setMinimumSize(new Dimension(10, 10));
        label = new JBLabel(AndroidBundle.message("android.layout.preview.edit.configuration.choosen.qualifiers.label", new Object[0]));
        label.setLabelFor((Component)this.myChosenQualifiersList);
        rightPanel.add((Component)label, "North");
        rightPanel.add((Component)new JBScrollPane((Component)this.myChosenQualifiersList, 20, 31), "Center");
        final JPanel buttonsPanel = new JPanel((LayoutManager)new VerticalFlowLayout(1, 0, 0, true, false));
        this.myAddQualifierButton = new JButton(">>");
        buttonsPanel.add(this.myAddQualifierButton);
        this.myRemoveQualifierButton = new JButton("<<");
        buttonsPanel.add(this.myRemoveQualifierButton);
        int gap = 5;
        JPanel listsPanel = new JPanel((LayoutManager)new AbstractLayoutManager(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Dimension preferredLayoutSize(Container target) {
                Object object = target.getTreeLock();
                synchronized (object) {
                    Dimension leftPref = leftPanel.getPreferredSize();
                    Dimension rightPref = rightPanel.getPreferredSize();
                    Dimension middlePref = buttonsPanel.getPreferredSize();
                    Insets insets = target.getInsets();
                    int width = leftPref.width + middlePref.width + rightPref.width + insets.left + insets.right + 10;
                    int height = Math.max(leftPref.height, Math.max(rightPref.height, middlePref.height)) + insets.top + insets.bottom;
                    return new Dimension(width, height);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void layoutContainer(Container target) {
                Object object = target.getTreeLock();
                synchronized (object) {
                    Insets insets = target.getInsets();
                    int top = insets.top;
                    int bottom = target.getHeight() - insets.bottom;
                    int left = insets.left;
                    int right = target.getWidth() - insets.right;
                    int middleWidth = buttonsPanel.getPreferredSize().width + 10;
                    int listWidth = (right - left - middleWidth) / 2;
                    int height = bottom - top;
                    leftPanel.setSize(listWidth, height);
                    rightPanel.setSize(listWidth, height);
                    buttonsPanel.setSize(middleWidth, height);
                    leftPanel.setBounds(left, top, listWidth, height);
                    rightPanel.setBounds(right - listWidth, top, listWidth, height);
                    buttonsPanel.setBounds(left + listWidth + 5, top, middleWidth - 10, height);
                }
            }
        });
        listsPanel.add(leftPanel);
        listsPanel.add(buttonsPanel);
        listsPanel.add(rightPanel);
        this.add((Component)listsPanel, "Center");
        this.add((Component)this.myQualifierOptionsPanel, "East");
    }

    public JBList getAvailableQualifiersList() {
        return this.myAvailableQualifiersList;
    }

    private static Font adFont() {
        Font font = UIUtil.getLabelFont();
        return font.deriveFont((float)(font.getSize() - 2));
    }

    static {
        ourIcons.put("UI Mode", AndroidIcons.Configs.Dock);
        ourIcons.put("Night Mode", AndroidIcons.Configs.Night);
        ourIcons.put("Screen Dimension", AndroidIcons.Configs.Dimension);
        ourIcons.put("Density", AndroidIcons.Configs.Dpi);
        ourIcons.put("Screen Height", AndroidIcons.Configs.Height);
        ourIcons.put("Keyboard State", AndroidIcons.Configs.Keyboard);
        ourIcons.put("Language", AndroidIcons.Configs.Language);
        ourIcons.put("Mobile Country Code", AndroidIcons.Configs.Mcc);
        ourIcons.put("Mobile Network Code", AndroidIcons.Configs.Mnc);
        ourIcons.put("Navigation State", AndroidIcons.Configs.Navpad);
        ourIcons.put("Navigation Method", AndroidIcons.Configs.NavpadMethod);
        ourIcons.put("Screen Orientation", AndroidIcons.Configs.Orientation);
        ourIcons.put("Screen Ratio", AndroidIcons.Configs.Ratio);
        ourIcons.put("Region", AndroidIcons.Configs.Region);
        ourIcons.put("Screen Size", AndroidIcons.Configs.Size);
        ourIcons.put("Smallest Screen Width", AndroidIcons.Configs.SmallestWidth);
        ourIcons.put("Screen Width", AndroidIcons.Configs.Width);
        ourIcons.put("Text Input Method", AndroidIcons.Configs.TextInput);
        ourIcons.put("Touch Screen", AndroidIcons.Configs.Touch);
        ourIcons.put("Layout Direction", AndroidIcons.Configs.LayoutDirection);
        ourIcons.put("Platform Version", AndroidIcons.Targets);
    }

    private class MyScreenHeightEditor
    extends MySizeEditorBase<ScreenHeightQualifier> {
        private MyScreenHeightEditor() {
            super("Screen height:");
        }

        @Override
        protected int getValue(@NotNull ScreenHeightQualifier qualifier) {
            if (qualifier == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifier", "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyScreenHeightEditor", "getValue"));
            }
            return qualifier.getValue();
        }

        @Override
        @NotNull
        protected ScreenHeightQualifier createQualifier(int value) {
            ScreenHeightQualifier screenHeightQualifier = new ScreenHeightQualifier(value);
            if (screenHeightQualifier == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyScreenHeightEditor", "createQualifier"));
            }
            return screenHeightQualifier;
        }

        @Override
        protected String getErrorMessage() {
            return "Incorrect screen height";
        }
    }

    private class MyScreenWidthEditor
    extends MySizeEditorBase<ScreenWidthQualifier> {
        private MyScreenWidthEditor() {
            super("Screen width:");
        }

        @Override
        protected int getValue(@NotNull ScreenWidthQualifier qualifier) {
            if (qualifier == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifier", "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyScreenWidthEditor", "getValue"));
            }
            return qualifier.getValue();
        }

        @Override
        @NotNull
        protected ScreenWidthQualifier createQualifier(int value) {
            ScreenWidthQualifier screenWidthQualifier = new ScreenWidthQualifier(value);
            if (screenWidthQualifier == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyScreenWidthEditor", "createQualifier"));
            }
            return screenWidthQualifier;
        }

        @Override
        protected String getErrorMessage() {
            return "Incorrect screen width";
        }
    }

    private class MySmallestScreenWidthEditor
    extends MySizeEditorBase<SmallestScreenWidthQualifier> {
        private MySmallestScreenWidthEditor() {
            super("Smallest screen width:");
        }

        @Override
        protected int getValue(@NotNull SmallestScreenWidthQualifier qualifier) {
            if (qualifier == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifier", "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MySmallestScreenWidthEditor", "getValue"));
            }
            return qualifier.getValue();
        }

        @Override
        @NotNull
        protected SmallestScreenWidthQualifier createQualifier(int value) {
            SmallestScreenWidthQualifier smallestScreenWidthQualifier = new SmallestScreenWidthQualifier(value);
            if (smallestScreenWidthQualifier == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MySmallestScreenWidthEditor", "createQualifier"));
            }
            return smallestScreenWidthQualifier;
        }

        @Override
        protected String getErrorMessage() {
            return "Incorrect smallest screen width";
        }
    }

    private abstract class MySizeEditorBase<T extends ResourceQualifier>
    extends MyQualifierEditor<T> {
        private final JTextField myTextField;
        private String myLabelText;

        protected MySizeEditorBase(String labelText) {
            this.myTextField = new JTextField(3);
            this.myLabelText = labelText;
        }

        @Override
        JComponent getComponent() {
            JPanel panel = new JPanel((LayoutManager)new VerticalFlowLayout());
            JBLabel label = new JBLabel(this.myLabelText);
            panel.add((Component)label);
            label.setLabelFor((Component)this.myTextField);
            this.myTextField.getDocument().addDocumentListener(DeviceConfiguratorPanel.this.myUpdatingDocumentListener);
            panel.add(this.myTextField);
            return panel;
        }

        @Override
        void reset(@NotNull T qualifier) {
            if (qualifier == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifier", "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MySizeEditorBase", "reset"));
            }
            this.myTextField.setText(Integer.toString(this.getValue(qualifier)));
        }

        protected abstract int getValue(@NotNull T var1);

        @NotNull
        protected abstract T createQualifier(int var1);

        protected abstract String getErrorMessage();

        @Override
        @NotNull
        T apply() throws InvalidOptionValueException {
            T t;
            try {
                int value = Integer.parseInt(this.myTextField.getText().trim());
                if (value < 0) {
                    throw new InvalidOptionValueException(this.getErrorMessage());
                }
                t = this.createQualifier(value);
            }
            catch (NumberFormatException e) {
                throw new InvalidOptionValueException(this.getErrorMessage());
            }
            if (t == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MySizeEditorBase", "apply"));
            }
            return t;
        }
    }

    private class MyRegionEditor
    extends MyQualifierEditor<RegionQualifier> {
        private final JBList myList;

        private MyRegionEditor() {
            this.myList = new JBList();
        }

        @Override
        JComponent getComponent() {
            BorderLayout layout = new BorderLayout(5, 5);
            JPanel panel = new JPanel(layout);
            panel.setBorder(new EmptyBorder(0, 20, 0, 0));
            JBLabel header = new JBLabel("Region:");
            header.setLabelFor((Component)this.myList);
            panel.add((Component)header, "North");
            SortedListModel model = new SortedListModel(String.CASE_INSENSITIVE_ORDER);
            model.addAll((Collection)LocaleManager.getRegionCodes());
            this.myList.setModel((ListModel)model);
            this.myList.setSelectionMode(0);
            this.myList.setCellRenderer(FlagManager.get().getRegionCodeCellRenderer());
            JBScrollPane scroll = new JBScrollPane((Component)this.myList);
            JComponent list = ListWithFilter.wrap((JList)this.myList, (JScrollPane)scroll, FlagManager.getRegionNameMapper());
            panel.add((Component)list, "Center");
            JBLabel tipLabel = new JBLabel("Tip: Type in list to filter");
            tipLabel.setHorizontalAlignment(4);
            tipLabel.setFont(DeviceConfiguratorPanel.adFont());
            panel.add((Component)tipLabel, "South");
            this.myList.addListSelectionListener(DeviceConfiguratorPanel.this.myUpdatingListListener);
            return panel;
        }

        @Override
        void reset(@NotNull RegionQualifier qualifier) {
            if (qualifier == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifier", "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyRegionEditor", "reset"));
            }
            if (qualifier.isValid() && !qualifier.hasFakeValue()) {
                String value = qualifier.getValue();
                ListModel model = this.myList.getModel();
                int n = model.getSize();
                for (int i = 0; i < n; ++i) {
                    if (!value.equals(model.getElementAt(i))) continue;
                    this.myList.setSelectedIndex(i);
                    break;
                }
            } else {
                this.myList.setSelectedIndex(-1);
            }
        }

        @Override
        @NotNull
        RegionQualifier apply() throws InvalidOptionValueException {
            Object selectedValue = this.myList.getSelectedValue();
            if (selectedValue == null) {
                throw new InvalidOptionValueException("Select a region");
            }
            RegionQualifier regionQualifier = new RegionQualifier((String)selectedValue);
            if (regionQualifier == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyRegionEditor", "apply"));
            }
            return regionQualifier;
        }
    }

    private class MyLanguageEditor
    extends MyQualifierEditor<LanguageQualifier> {
        private final JBList myList;

        private MyLanguageEditor() {
            this.myList = new JBList();
        }

        @Override
        JComponent getComponent() {
            BorderLayout layout = new BorderLayout(5, 5);
            JPanel panel = new JPanel(layout);
            panel.setBorder(new EmptyBorder(0, 20, 0, 0));
            JBLabel header = new JBLabel("Language:");
            header.setLabelFor((Component)this.myList);
            panel.add((Component)header, "North");
            SortedListModel model = new SortedListModel(String.CASE_INSENSITIVE_ORDER);
            model.addAll((Collection)LocaleManager.getLanguageCodes());
            this.myList.setModel((ListModel)model);
            this.myList.setSelectionMode(0);
            this.myList.setCellRenderer(FlagManager.get().getLanguageCodeCellRenderer());
            JBScrollPane scroll = new JBScrollPane((Component)this.myList);
            JComponent list = ListWithFilter.wrap((JList)this.myList, (JScrollPane)scroll, FlagManager.getLanguageNameMapper());
            panel.add((Component)list, "Center");
            JBLabel tipLabel = new JBLabel("Tip: Type in list to filter");
            tipLabel.setHorizontalAlignment(4);
            tipLabel.setFont(DeviceConfiguratorPanel.adFont());
            panel.add((Component)tipLabel, "South");
            this.myList.addListSelectionListener(DeviceConfiguratorPanel.this.myUpdatingListListener);
            return panel;
        }

        @Override
        void reset(@NotNull LanguageQualifier qualifier) {
            if (qualifier == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifier", "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyLanguageEditor", "reset"));
            }
            if (qualifier.isValid() && !qualifier.hasFakeValue()) {
                String value = qualifier.getValue();
                ListModel model = this.myList.getModel();
                int n = model.getSize();
                for (int i = 0; i < n; ++i) {
                    if (!value.equals(model.getElementAt(i))) continue;
                    this.myList.setSelectedIndex(i);
                    break;
                }
            } else {
                this.myList.setSelectedIndex(-1);
            }
        }

        @Override
        @NotNull
        LanguageQualifier apply() throws InvalidOptionValueException {
            Object selectedValue = this.myList.getSelectedValue();
            if (selectedValue == null) {
                throw new InvalidOptionValueException("Select a language");
            }
            LanguageQualifier languageQualifier = new LanguageQualifier((String)selectedValue);
            if (languageQualifier == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyLanguageEditor", "apply"));
            }
            return languageQualifier;
        }
    }

    private class MyUiModeEditor
    extends MyEnumBasedEditor<UiModeQualifier, UiMode> {
        private MyUiModeEditor() {
            super(UiMode.class);
        }

        @Override
        @NotNull
        protected String getCaption() {
            if ("UI mode:" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyUiModeEditor", "getCaption"));
            }
            return "UI mode:";
        }

        @Override
        protected UiMode getValue(@NotNull UiModeQualifier qualifier) {
            if (qualifier == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifier", "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyUiModeEditor", "getValue"));
            }
            return qualifier.getValue();
        }

        @Override
        @NotNull
        protected UiModeQualifier getQualifier(@NotNull UiMode value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyUiModeEditor", "getQualifier"));
            }
            UiModeQualifier uiModeQualifier = new UiModeQualifier(value);
            if (uiModeQualifier == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyUiModeEditor", "getQualifier"));
            }
            return uiModeQualifier;
        }

        @Override
        @NotNull
        protected String getErrorMessage() {
            if ("Specify UI mode" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyUiModeEditor", "getErrorMessage"));
            }
            return "Specify UI mode";
        }
    }

    private class MyNightModeEditor
    extends MyEnumBasedEditor<NightModeQualifier, NightMode> {
        protected MyNightModeEditor() {
            super(NightMode.class);
        }

        @Override
        @NotNull
        protected String getCaption() {
            if ("Night mode:" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyNightModeEditor", "getCaption"));
            }
            return "Night mode:";
        }

        @Override
        protected NightMode getValue(@NotNull NightModeQualifier qualifier) {
            if (qualifier == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifier", "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyNightModeEditor", "getValue"));
            }
            return qualifier.getValue();
        }

        @Override
        @NotNull
        protected NightModeQualifier getQualifier(@NotNull NightMode value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyNightModeEditor", "getQualifier"));
            }
            NightModeQualifier nightModeQualifier = new NightModeQualifier(value);
            if (nightModeQualifier == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyNightModeEditor", "getQualifier"));
            }
            return nightModeQualifier;
        }

        @Override
        @NotNull
        protected String getErrorMessage() {
            if ("Specify night mode" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyNightModeEditor", "getErrorMessage"));
            }
            return "Specify night mode";
        }
    }

    private class MyVersionEditor
    extends MyQualifierEditor<VersionQualifier> {
        private final JTextField myTextField;

        private MyVersionEditor() {
            this.myTextField = new JTextField(3);
        }

        @Override
        JComponent getComponent() {
            JPanel panel = new JPanel((LayoutManager)new VerticalFlowLayout());
            JBLabel label = new JBLabel("Platform API level:");
            panel.add((Component)label);
            label.setLabelFor((Component)this.myTextField);
            this.myTextField.getDocument().addDocumentListener(DeviceConfiguratorPanel.this.myUpdatingDocumentListener);
            panel.add(this.myTextField);
            return panel;
        }

        @Override
        void reset(@NotNull VersionQualifier qualifier) {
            if (qualifier == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifier", "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyVersionEditor", "reset"));
            }
            this.myTextField.setText(Integer.toString(qualifier.getVersion()));
        }

        @Override
        @NotNull
        VersionQualifier apply() throws InvalidOptionValueException {
            VersionQualifier versionQualifier;
            block3: {
                try {
                    int apiLevel = Integer.parseInt(this.myTextField.getText().trim());
                    if (apiLevel < 0) {
                        throw new InvalidOptionValueException("Incorrect API level");
                    }
                    versionQualifier = new VersionQualifier(apiLevel);
                    if (versionQualifier != null) break block3;
                }
                catch (NumberFormatException e) {
                    throw new InvalidOptionValueException("Incorrect API level");
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyVersionEditor", "apply"));
            }
            return versionQualifier;
        }
    }

    private class MyScreenDimensionEditor
    extends MyQualifierEditor<ScreenDimensionQualifier> {
        private final JTextField mySizeField1;
        private final JTextField mySizeField2;

        private MyScreenDimensionEditor() {
            this.mySizeField1 = new JTextField();
            this.mySizeField2 = new JTextField();
        }

        @Override
        JComponent getComponent() {
            JPanel panel = new JPanel((LayoutManager)new VerticalFlowLayout());
            JBLabel label = new JBLabel("Screen dimension in dp:");
            label.setLabelFor((Component)this.mySizeField1);
            panel.add((Component)label);
            panel.add(this.mySizeField1);
            panel.add(this.mySizeField2);
            this.mySizeField1.getDocument().addDocumentListener(DeviceConfiguratorPanel.this.myUpdatingDocumentListener);
            this.mySizeField2.getDocument().addDocumentListener(DeviceConfiguratorPanel.this.myUpdatingDocumentListener);
            return panel;
        }

        @Override
        void reset(@NotNull ScreenDimensionQualifier qualifier) {
            int value2;
            if (qualifier == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifier", "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyScreenDimensionEditor", "reset"));
            }
            int value1 = qualifier.getValue1();
            if (value1 >= 0) {
                this.mySizeField1.setText(Integer.toString(value1));
            }
            if ((value2 = qualifier.getValue2()) >= 0) {
                this.mySizeField2.setText(Integer.toString(value2));
            }
        }

        @Override
        @NotNull
        ScreenDimensionQualifier apply() throws InvalidOptionValueException {
            ScreenDimensionQualifier screenDimensionQualifier;
            block3: {
                try {
                    int size1 = Integer.parseInt(this.mySizeField1.getText());
                    int size2 = Integer.parseInt(this.mySizeField2.getText());
                    if (size1 <= 0 || size2 <= 0) {
                        throw new InvalidOptionValueException("Incorrect screen dimension");
                    }
                    screenDimensionQualifier = new ScreenDimensionQualifier(size1, size2);
                    if (screenDimensionQualifier != null) break block3;
                }
                catch (NumberFormatException e) {
                    LOG.debug((Throwable)e);
                    throw new InvalidOptionValueException("Incorrect screen dimension");
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyScreenDimensionEditor", "apply"));
            }
            return screenDimensionQualifier;
        }
    }

    private class MyLayoutDirectionEditor
    extends MyEnumBasedEditor<LayoutDirectionQualifier, LayoutDirection> {
        private MyLayoutDirectionEditor() {
            super(LayoutDirection.class);
        }

        @Override
        @NotNull
        protected String getCaption() {
            if ("Layout direction:" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyLayoutDirectionEditor", "getCaption"));
            }
            return "Layout direction:";
        }

        @Override
        @NotNull
        protected LayoutDirection getValue(@NotNull LayoutDirectionQualifier qualifier) {
            if (qualifier == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifier", "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyLayoutDirectionEditor", "getValue"));
            }
            LayoutDirection layoutDirection = qualifier.getValue();
            if (layoutDirection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyLayoutDirectionEditor", "getValue"));
            }
            return layoutDirection;
        }

        @Override
        @NotNull
        protected LayoutDirectionQualifier getQualifier(@NotNull LayoutDirection value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyLayoutDirectionEditor", "getQualifier"));
            }
            LayoutDirectionQualifier layoutDirectionQualifier = new LayoutDirectionQualifier(value);
            if (layoutDirectionQualifier == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyLayoutDirectionEditor", "getQualifier"));
            }
            return layoutDirectionQualifier;
        }

        @Override
        @NotNull
        protected String getErrorMessage() {
            if ("Specify layout direction" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyLayoutDirectionEditor", "getErrorMessage"));
            }
            return "Specify layout direction";
        }
    }

    private class MyNavigationMethodEditor
    extends MyEnumBasedEditor<NavigationMethodQualifier, Navigation> {
        private MyNavigationMethodEditor() {
            super(Navigation.class);
        }

        @Override
        @NotNull
        protected String getCaption() {
            if ("Navigation method:" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyNavigationMethodEditor", "getCaption"));
            }
            return "Navigation method:";
        }

        @Override
        @NotNull
        protected Navigation getValue(@NotNull NavigationMethodQualifier qualifier) {
            if (qualifier == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifier", "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyNavigationMethodEditor", "getValue"));
            }
            Navigation navigation = qualifier.getValue();
            if (navigation == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyNavigationMethodEditor", "getValue"));
            }
            return navigation;
        }

        @Override
        @NotNull
        protected NavigationMethodQualifier getQualifier(@NotNull Navigation value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyNavigationMethodEditor", "getQualifier"));
            }
            NavigationMethodQualifier navigationMethodQualifier = new NavigationMethodQualifier(value);
            if (navigationMethodQualifier == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyNavigationMethodEditor", "getQualifier"));
            }
            return navigationMethodQualifier;
        }

        @Override
        @NotNull
        protected String getErrorMessage() {
            if ("Specify navigation method" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyNavigationMethodEditor", "getErrorMessage"));
            }
            return "Specify navigation method";
        }
    }

    private class MyNavigationStateEditor
    extends MyEnumBasedEditor<NavigationStateQualifier, NavigationState> {
        private MyNavigationStateEditor() {
            super(NavigationState.class);
        }

        @Override
        @NotNull
        protected String getCaption() {
            if ("Navigation state:" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyNavigationStateEditor", "getCaption"));
            }
            return "Navigation state:";
        }

        @Override
        @NotNull
        protected NavigationState getValue(@NotNull NavigationStateQualifier qualifier) {
            if (qualifier == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifier", "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyNavigationStateEditor", "getValue"));
            }
            NavigationState navigationState = qualifier.getValue();
            if (navigationState == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyNavigationStateEditor", "getValue"));
            }
            return navigationState;
        }

        @Override
        @NotNull
        protected NavigationStateQualifier getQualifier(@NotNull NavigationState value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyNavigationStateEditor", "getQualifier"));
            }
            NavigationStateQualifier navigationStateQualifier = new NavigationStateQualifier(value);
            if (navigationStateQualifier == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyNavigationStateEditor", "getQualifier"));
            }
            return navigationStateQualifier;
        }

        @Override
        @NotNull
        protected String getErrorMessage() {
            if ("Specify navigation state" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyNavigationStateEditor", "getErrorMessage"));
            }
            return "Specify navigation state";
        }
    }

    private class MyTextInputMethodEditor
    extends MyEnumBasedEditor<TextInputMethodQualifier, Keyboard> {
        private MyTextInputMethodEditor() {
            super(Keyboard.class);
        }

        @Override
        @NotNull
        protected String getCaption() {
            if ("Text input method:" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyTextInputMethodEditor", "getCaption"));
            }
            return "Text input method:";
        }

        @Override
        @NotNull
        protected Keyboard getValue(@NotNull TextInputMethodQualifier qualifier) {
            if (qualifier == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifier", "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyTextInputMethodEditor", "getValue"));
            }
            Keyboard keyboard = qualifier.getValue();
            if (keyboard == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyTextInputMethodEditor", "getValue"));
            }
            return keyboard;
        }

        @Override
        @NotNull
        protected TextInputMethodQualifier getQualifier(@NotNull Keyboard value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyTextInputMethodEditor", "getQualifier"));
            }
            TextInputMethodQualifier textInputMethodQualifier = new TextInputMethodQualifier(value);
            if (textInputMethodQualifier == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyTextInputMethodEditor", "getQualifier"));
            }
            return textInputMethodQualifier;
        }

        @Override
        @NotNull
        protected String getErrorMessage() {
            if ("Specify text input method" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyTextInputMethodEditor", "getErrorMessage"));
            }
            return "Specify text input method";
        }
    }

    private class MyKeyboardStateEditor
    extends MyEnumBasedEditor<KeyboardStateQualifier, KeyboardState> {
        private MyKeyboardStateEditor() {
            super(KeyboardState.class);
        }

        @Override
        @NotNull
        protected String getCaption() {
            if ("Keyboard state:" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyKeyboardStateEditor", "getCaption"));
            }
            return "Keyboard state:";
        }

        @Override
        @NotNull
        protected KeyboardState getValue(@NotNull KeyboardStateQualifier qualifier) {
            if (qualifier == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifier", "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyKeyboardStateEditor", "getValue"));
            }
            KeyboardState keyboardState = qualifier.getValue();
            if (keyboardState == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyKeyboardStateEditor", "getValue"));
            }
            return keyboardState;
        }

        @Override
        @NotNull
        protected KeyboardStateQualifier getQualifier(@NotNull KeyboardState value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyKeyboardStateEditor", "getQualifier"));
            }
            KeyboardStateQualifier keyboardStateQualifier = new KeyboardStateQualifier(value);
            if (keyboardStateQualifier == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyKeyboardStateEditor", "getQualifier"));
            }
            return keyboardStateQualifier;
        }

        @Override
        @NotNull
        protected String getErrorMessage() {
            if ("Specify keyboard state" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyKeyboardStateEditor", "getErrorMessage"));
            }
            return "Specify keyboard state";
        }
    }

    private class MyTouchScreenEditor
    extends MyEnumBasedEditor<TouchScreenQualifier, TouchScreen> {
        private MyTouchScreenEditor() {
            super(TouchScreen.class);
        }

        @Override
        @NotNull
        protected String getCaption() {
            if ("Touch screen:" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyTouchScreenEditor", "getCaption"));
            }
            return "Touch screen:";
        }

        @Override
        @NotNull
        protected TouchScreen getValue(@NotNull TouchScreenQualifier qualifier) {
            if (qualifier == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifier", "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyTouchScreenEditor", "getValue"));
            }
            TouchScreen touchScreen = qualifier.getValue();
            if (touchScreen == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyTouchScreenEditor", "getValue"));
            }
            return touchScreen;
        }

        @Override
        @NotNull
        protected TouchScreenQualifier getQualifier(@NotNull TouchScreen value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyTouchScreenEditor", "getQualifier"));
            }
            TouchScreenQualifier touchScreenQualifier = new TouchScreenQualifier(value);
            if (touchScreenQualifier == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyTouchScreenEditor", "getQualifier"));
            }
            return touchScreenQualifier;
        }

        @Override
        @NotNull
        protected String getErrorMessage() {
            if ("Specify touch screen" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyTouchScreenEditor", "getErrorMessage"));
            }
            return "Specify touch screen";
        }
    }

    private class MyDensityEditor
    extends MyEnumBasedEditor<DensityQualifier, Density> {
        private MyDensityEditor() {
            super(Density.class);
        }

        @Override
        @NotNull
        protected String getCaption() {
            if ("Density:" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyDensityEditor", "getCaption"));
            }
            return "Density:";
        }

        @Override
        @NotNull
        protected Density getValue(@NotNull DensityQualifier qualifier) {
            if (qualifier == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifier", "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyDensityEditor", "getValue"));
            }
            Density density = qualifier.getValue();
            if (density == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyDensityEditor", "getValue"));
            }
            return density;
        }

        @Override
        @NotNull
        protected DensityQualifier getQualifier(@NotNull Density value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyDensityEditor", "getQualifier"));
            }
            DensityQualifier densityQualifier = new DensityQualifier(value);
            if (densityQualifier == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyDensityEditor", "getQualifier"));
            }
            return densityQualifier;
        }

        @Override
        @NotNull
        protected String getErrorMessage() {
            if ("Specify density" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyDensityEditor", "getErrorMessage"));
            }
            return "Specify density";
        }
    }

    private class MyScreenRatioEditor
    extends MyEnumBasedEditor<ScreenRatioQualifier, ScreenRatio> {
        private MyScreenRatioEditor() {
            super(ScreenRatio.class);
        }

        @Override
        @NotNull
        protected String getCaption() {
            if ("Screen ratio:" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyScreenRatioEditor", "getCaption"));
            }
            return "Screen ratio:";
        }

        @Override
        @NotNull
        protected ScreenRatio getValue(@NotNull ScreenRatioQualifier qualifier) {
            if (qualifier == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifier", "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyScreenRatioEditor", "getValue"));
            }
            ScreenRatio screenRatio = qualifier.getValue();
            if (screenRatio == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyScreenRatioEditor", "getValue"));
            }
            return screenRatio;
        }

        @Override
        @NotNull
        protected ScreenRatioQualifier getQualifier(@NotNull ScreenRatio value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyScreenRatioEditor", "getQualifier"));
            }
            ScreenRatioQualifier screenRatioQualifier = new ScreenRatioQualifier(value);
            if (screenRatioQualifier == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyScreenRatioEditor", "getQualifier"));
            }
            return screenRatioQualifier;
        }

        @Override
        @NotNull
        protected String getErrorMessage() {
            if ("Specify screen ratio" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyScreenRatioEditor", "getErrorMessage"));
            }
            return "Specify screen ratio";
        }
    }

    private class MyScreenOrientationEditor
    extends MyEnumBasedEditor<ScreenOrientationQualifier, ScreenOrientation> {
        private MyScreenOrientationEditor() {
            super(ScreenOrientation.class);
        }

        @Override
        @NotNull
        protected String getCaption() {
            if ("Screen orientation:" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyScreenOrientationEditor", "getCaption"));
            }
            return "Screen orientation:";
        }

        @Override
        @NotNull
        protected ScreenOrientation getValue(@NotNull ScreenOrientationQualifier qualifier) {
            if (qualifier == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifier", "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyScreenOrientationEditor", "getValue"));
            }
            ScreenOrientation screenOrientation = qualifier.getValue();
            if (screenOrientation == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyScreenOrientationEditor", "getValue"));
            }
            return screenOrientation;
        }

        @Override
        @NotNull
        protected ScreenOrientationQualifier getQualifier(@NotNull ScreenOrientation value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyScreenOrientationEditor", "getQualifier"));
            }
            ScreenOrientationQualifier screenOrientationQualifier = new ScreenOrientationQualifier(value);
            if (screenOrientationQualifier == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyScreenOrientationEditor", "getQualifier"));
            }
            return screenOrientationQualifier;
        }

        @Override
        @NotNull
        protected String getErrorMessage() {
            if ("Specify screen orientation" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyScreenOrientationEditor", "getErrorMessage"));
            }
            return "Specify screen orientation";
        }
    }

    private class MyScreenSizeEditor
    extends MyEnumBasedEditor<ScreenSizeQualifier, ScreenSize> {
        private MyScreenSizeEditor() {
            super(ScreenSize.class);
        }

        @Override
        @NotNull
        protected String getCaption() {
            if ("Screen size:" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyScreenSizeEditor", "getCaption"));
            }
            return "Screen size:";
        }

        @Override
        @NotNull
        protected ScreenSize getValue(@NotNull ScreenSizeQualifier qualifier) {
            if (qualifier == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifier", "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyScreenSizeEditor", "getValue"));
            }
            ScreenSize screenSize = qualifier.getValue();
            if (screenSize == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyScreenSizeEditor", "getValue"));
            }
            return screenSize;
        }

        @Override
        @NotNull
        protected ScreenSizeQualifier getQualifier(@NotNull ScreenSize value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyScreenSizeEditor", "getQualifier"));
            }
            ScreenSizeQualifier screenSizeQualifier = new ScreenSizeQualifier(value);
            if (screenSizeQualifier == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyScreenSizeEditor", "getQualifier"));
            }
            return screenSizeQualifier;
        }

        @Override
        @NotNull
        protected String getErrorMessage() {
            if ("Specify screen size" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyScreenSizeEditor", "getErrorMessage"));
            }
            return "Specify screen size";
        }
    }

    private abstract class MyEnumBasedEditor<T extends ResourceQualifier, U extends Enum<U>>
    extends MyQualifierEditor<T> {
        private final JComboBox myComboBox;
        private final Class<U> myEnumClass;

        protected MyEnumBasedEditor(Class<U> enumClass) {
            if (enumClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumClass", "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyEnumBasedEditor", "<init>"));
            }
            this.myComboBox = new JComboBox();
            this.myEnumClass = enumClass;
        }

        @Override
        JComponent getComponent() {
            this.myComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DeviceConfiguratorPanel.this.applyEditors();
                }
            });
            this.myComboBox.setRenderer(new ListCellRendererWrapper(){

                public void customize(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                    if (value instanceof ResourceEnum) {
                        this.setText(((ResourceEnum)value).getShortDisplayValue());
                    }
                }
            });
            JPanel panel = new JPanel((LayoutManager)new VerticalFlowLayout());
            JBLabel label = new JBLabel(this.getCaption());
            label.setLabelFor((Component)this.myComboBox);
            this.myComboBox.setModel(new EnumComboBoxModel(this.myEnumClass));
            panel.add((Component)label);
            panel.add(this.myComboBox);
            return panel;
        }

        @NotNull
        protected abstract String getCaption();

        @Override
        void reset(@NotNull T qualifier) {
            if (qualifier == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifier", "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyEnumBasedEditor", "reset"));
            }
            U value = this.getValue(qualifier);
            if (value != null) {
                this.myComboBox.setSelectedItem(value);
            } else if (this.myComboBox.getItemCount() > 0) {
                this.myComboBox.setSelectedIndex(0);
            }
        }

        protected abstract U getValue(@NotNull T var1);

        @NotNull
        protected abstract T getQualifier(@NotNull U var1);

        @NotNull
        protected abstract String getErrorMessage();

        @Override
        @NotNull
        T apply() throws InvalidOptionValueException {
            Enum selectedItem = (Enum)this.myComboBox.getSelectedItem();
            if (selectedItem == null) {
                throw new InvalidOptionValueException(this.getErrorMessage());
            }
            T t = this.getQualifier(selectedItem);
            if (t == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyEnumBasedEditor", "apply"));
            }
            return t;
        }
    }

    private class MyNetworkCodeEditor
    extends MyQualifierEditor<NetworkCodeQualifier> {
        private final JTextField myTextField;

        private MyNetworkCodeEditor() {
            this.myTextField = new JTextField(3);
        }

        @Override
        JComponent getComponent() {
            JPanel panel = new JPanel((LayoutManager)new VerticalFlowLayout());
            JBLabel label = new JBLabel("<html><body>Mobile network code<br>(1-3 digits):</body></html>");
            panel.add((Component)label);
            label.setLabelFor((Component)this.myTextField);
            this.myTextField.getDocument().addDocumentListener(DeviceConfiguratorPanel.this.myUpdatingDocumentListener);
            panel.add(this.myTextField);
            return panel;
        }

        @Override
        void reset(@NotNull NetworkCodeQualifier qualifier) {
            if (qualifier == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifier", "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyNetworkCodeEditor", "reset"));
            }
            this.myTextField.setText(Integer.toString(qualifier.getCode()));
        }

        @Override
        @NotNull
        NetworkCodeQualifier apply() throws InvalidOptionValueException {
            NetworkCodeQualifier networkCodeQualifier;
            block3: {
                try {
                    int code = Integer.parseInt(this.myTextField.getText());
                    if (code <= 0 || code >= 1000) {
                        throw new InvalidOptionValueException("Incorrect network code");
                    }
                    networkCodeQualifier = new NetworkCodeQualifier(code);
                    if (networkCodeQualifier != null) break block3;
                }
                catch (NumberFormatException e) {
                    throw new InvalidOptionValueException("Network code must be a number");
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyNetworkCodeEditor", "apply"));
            }
            return networkCodeQualifier;
        }
    }

    private class MyCountryCodeEditor
    extends MyQualifierEditor<CountryCodeQualifier> {
        private final JTextField myTextField;

        private MyCountryCodeEditor() {
            this.myTextField = new JTextField(3);
        }

        @Override
        JComponent getComponent() {
            JPanel panel = new JPanel((LayoutManager)new VerticalFlowLayout());
            JBLabel label = new JBLabel("<html><body>Mobile country code<br>(3 digits):</body></html>");
            label.setLabelFor((Component)this.myTextField);
            this.myTextField.setColumns(3);
            this.myTextField.getDocument().addDocumentListener(DeviceConfiguratorPanel.this.myUpdatingDocumentListener);
            panel.add((Component)label);
            panel.add(this.myTextField);
            return panel;
        }

        @Override
        void reset(@NotNull CountryCodeQualifier qualifier) {
            if (qualifier == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifier", "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyCountryCodeEditor", "reset"));
            }
            this.myTextField.setText(Integer.toString(qualifier.getCode()));
        }

        @Override
        @NotNull
        CountryCodeQualifier apply() throws InvalidOptionValueException {
            CountryCodeQualifier countryCodeQualifier;
            block4: {
                if (this.myTextField.getText().length() != 3) {
                    throw new InvalidOptionValueException("Country code must contain 3 digits");
                }
                try {
                    int code = Integer.parseInt(this.myTextField.getText());
                    if (code < 100 || code > 999) {
                        throw new InvalidOptionValueException("Incorrect country code");
                    }
                    countryCodeQualifier = new CountryCodeQualifier(code);
                    if (countryCodeQualifier != null) break block4;
                }
                catch (NumberFormatException e) {
                    throw new InvalidOptionValueException("Country code must be a number");
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyCountryCodeEditor", "apply"));
            }
            return countryCodeQualifier;
        }
    }

    private static abstract class MyQualifierEditor<T extends ResourceQualifier> {
        private MyQualifierEditor() {
        }

        abstract JComponent getComponent();

        abstract void reset(@NotNull T var1);

        @NotNull
        abstract T apply() throws InvalidOptionValueException;
    }
}

