/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit;

import com.intellij.execution.CantRunException;
import com.intellij.execution.ConfigurationUtil;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.junit.JUnitConfiguration;
import com.intellij.execution.junit.JUnitProcessHandler;
import com.intellij.execution.junit.RefactoringListeners;
import com.intellij.execution.junit.TestClassFilter;
import com.intellij.execution.junit.TestObject;
import com.intellij.execution.junit2.ui.model.JUnitRunningModel;
import com.intellij.execution.junit2.ui.properties.JUnitConsoleProperties;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.testframework.SourceScope;
import com.intellij.execution.testframework.TestSearchScope;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PackageScope;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.util.Function;
import gnu.trove.THashSet;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestPackage
extends TestObject {
    protected BackgroundableProcessIndicator mySearchForTestsIndicator;
    protected ServerSocket myServerSocket;
    private boolean myFoundTests = true;

    public TestPackage(JUnitConfiguration configuration, ExecutionEnvironment environment) {
        super(configuration, environment);
    }

    @Override
    public SourceScope getSourceScope() {
        JUnitConfiguration.Data data = this.myConfiguration.getPersistentData();
        return data.getScope().getSourceScope((ModuleBasedConfiguration)this.myConfiguration);
    }

    @Override
    protected JUnitProcessHandler createHandler(Executor executor) throws ExecutionException {
        final JUnitProcessHandler handler = super.createHandler(executor);
        final SearchForTestsTask[] tasks = new SearchForTestsTask[1];
        handler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void startNotified(ProcessEvent event) {
                super.startNotified(event);
                tasks[0] = (SearchForTestsTask)TestPackage.this.findTests();
            }

            public void processTerminated(ProcessEvent event) {
                handler.removeProcessListener((ProcessListener)this);
                if (TestPackage.this.mySearchForTestsIndicator != null && !TestPackage.this.mySearchForTestsIndicator.isCanceled() && tasks[0] != null) {
                    tasks[0].finish();
                }
            }
        });
        return handler;
    }

    public Task findTests() {
        TestClassFilter filter;
        final JUnitConfiguration.Data data = this.myConfiguration.getPersistentData();
        try {
            filter = this.getClassFilter(data);
        }
        catch (CantRunException ignored) {
            return null;
        }
        return this.findTestsWithProgress(new FindCallback(){

            @Override
            public void found(@NotNull Collection<PsiClass> classes, boolean isJunit4) {
                if (classes == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classes", "com/intellij/execution/junit/TestPackage$2", "found"));
                }
                try {
                    TestPackage.this.addClassesListToJavaParameters(classes, new Function<PsiElement, String>(){

                        @Nullable
                        public String fun(PsiElement element) {
                            if (element instanceof PsiClass) {
                                return JavaExecutionUtil.getRuntimeQualifiedName((PsiClass)((PsiClass)element));
                            }
                            if (element instanceof PsiMethod) {
                                PsiMethod method = (PsiMethod)element;
                                return JavaExecutionUtil.getRuntimeQualifiedName((PsiClass)method.getContainingClass()) + "," + method.getName();
                            }
                            return null;
                        }
                    }, TestPackage.this.getPackageName(data), false, isJunit4);
                }
                catch (CantRunException cantRunException) {
                    // empty catch block
                }
            }
        }, filter);
    }

    protected String getPackageName(JUnitConfiguration.Data data) throws CantRunException {
        return this.getPackage(data).getQualifiedName();
    }

    @Override
    protected void initialize() throws ExecutionException {
        super.initialize();
        JUnitConfiguration.Data data = this.myConfiguration.getPersistentData();
        this.getClassFilter(data);
        this.configureClasspath();
        try {
            this.createTempFiles();
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        try {
            this.myServerSocket = new ServerSocket(0, 0, InetAddress.getByName("127.0.0.1"));
            this.myJavaParameters.getProgramParametersList().add("-socket" + this.myServerSocket.getLocalPort());
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    protected void configureClasspath() throws ExecutionException {
        final ExecutionException[] exception = new ExecutionException[1];
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                try {
                    TestPackage.this.myConfiguration.configureClasspath(TestPackage.this.myJavaParameters);
                }
                catch (CantRunException e) {
                    exception[0] = e;
                }
            }
        });
        if (exception[0] != null) {
            throw exception[0];
        }
    }

    protected TestClassFilter getClassFilter(JUnitConfiguration.Data data) throws CantRunException {
        Module module = ((JavaRunConfigurationModule)this.myConfiguration.getConfigurationModule()).getModule();
        if (this.myConfiguration.getPersistentData().getScope() == TestSearchScope.WHOLE_PROJECT) {
            module = null;
        }
        TestClassFilter classFilter = TestClassFilter.create(this.getSourceScope(), module);
        return classFilter.intersectionWith(this.filterScope(data));
    }

    protected GlobalSearchScope filterScope(JUnitConfiguration.Data data) throws CantRunException {
        PsiPackage aPackage = this.getPackage(data);
        return PackageScope.packageScope((PsiPackage)aPackage, (boolean)true);
    }

    protected PsiPackage getPackage(JUnitConfiguration.Data data) throws CantRunException {
        Project project = this.myConfiguration.getProject();
        String packageName = data.getPackageName();
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        PsiPackage aPackage = JavaPsiFacade.getInstance((Project)psiManager.getProject()).findPackage(packageName);
        if (aPackage == null) {
            throw CantRunException.packageNotFound((String)packageName);
        }
        return aPackage;
    }

    @Override
    public String suggestActionName() {
        JUnitConfiguration.Data data = this.myConfiguration.getPersistentData();
        if (data.getPackageName().trim().length() > 0) {
            return ExecutionBundle.message((String)"test.in.scope.presentable.text", (Object[])new Object[]{data.getPackageName()});
        }
        return ExecutionBundle.message((String)"all.tests.scope.presentable.text", (Object[])new Object[0]);
    }

    @Override
    public RefactoringElementListener getListener(PsiElement element, JUnitConfiguration configuration) {
        if (!(element instanceof PsiPackage)) {
            return null;
        }
        return RefactoringListeners.getListener((PsiPackage)((PsiPackage)element), configuration.myPackage);
    }

    @Override
    public boolean isConfiguredByElement(JUnitConfiguration configuration, PsiClass testClass, PsiMethod testMethod, PsiPackage testPackage, PsiDirectory testDir) {
        return testPackage != null && Comparing.equal((String)testPackage.getQualifiedName(), (String)configuration.getPersistentData().getPackageName());
    }

    @Override
    public void checkConfiguration() throws RuntimeConfigurationException {
        super.checkConfiguration();
        String packageName = this.myConfiguration.getPersistentData().getPackageName();
        PsiPackage aPackage = JavaPsiFacade.getInstance((Project)this.myConfiguration.getProject()).findPackage(packageName);
        if (aPackage == null) {
            throw new RuntimeConfigurationWarning(ExecutionBundle.message((String)"package.does.not.exist.error.message", (Object[])new Object[]{packageName}));
        }
        if (this.getSourceScope() == null) {
            ((JavaRunConfigurationModule)this.myConfiguration.getConfigurationModule()).checkForWarning();
        }
    }

    private MySearchForTestsTask findTestsWithProgress(FindCallback callback, TestClassFilter classFilter) {
        if (TestPackage.isSyncSearch()) {
            THashSet classes = new THashSet();
            boolean isJUnit4 = ConfigurationUtil.findAllTestClasses(classFilter, (Set<PsiClass>)classes);
            callback.found((Collection<PsiClass>)classes, isJUnit4);
            return null;
        }
        THashSet classes = new THashSet();
        boolean[] isJunit4 = new boolean[1];
        MySearchForTestsTask task = new MySearchForTestsTask(classFilter, isJunit4, (THashSet<PsiClass>)classes, callback);
        this.mySearchForTestsIndicator = new BackgroundableProcessIndicator((Task.Backgroundable)task);
        ProgressManager.getInstance().runProcessWithProgressAsynchronously((Task.Backgroundable)task, (ProgressIndicator)this.mySearchForTestsIndicator);
        return task;
    }

    private static boolean isSyncSearch() {
        return ApplicationManager.getApplication().isUnitTestMode();
    }

    @Override
    protected void notifyByBalloon(JUnitRunningModel model, boolean started, JUnitConsoleProperties consoleProperties) {
        if (this.myFoundTests) {
            super.notifyByBalloon(model, started, consoleProperties);
        } else {
            PsiDirectory[] directories;
            String packageName = this.myConfiguration.getPackage();
            if (packageName == null) {
                return;
            }
            Project project = this.myConfiguration.getProject();
            PsiPackage aPackage = JavaPsiFacade.getInstance((Project)project).findPackage(packageName);
            if (aPackage == null) {
                return;
            }
            Module module = ((JavaRunConfigurationModule)this.myConfiguration.getConfigurationModule()).getModule();
            if (module == null) {
                return;
            }
            HashSet<Module> modulesWithPackage = new HashSet<Module>();
            for (PsiDirectory directory : directories = aPackage.getDirectories()) {
                Module currentModule = ModuleUtilCore.findModuleForFile((VirtualFile)directory.getVirtualFile(), (Project)project);
                if (module == currentModule || currentModule == null) continue;
                modulesWithPackage.add(currentModule);
            }
            if (!modulesWithPackage.isEmpty()) {
                String testRunDebugId = consoleProperties.isDebug() ? ToolWindowId.DEBUG : ToolWindowId.RUN;
                ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)project);
                Function<Module, String> moduleNameRef = new Function<Module, String>(){

                    public String fun(Module module) {
                        String moduleName = module.getName();
                        return "<a href=\"" + moduleName + "\">" + moduleName + "</a>";
                    }
                };
                String message = "Tests were not found in module \"" + module.getName() + "\".\n" + "Use ";
                message = modulesWithPackage.size() == 1 ? message + "module \"" + (String)moduleNameRef.fun(modulesWithPackage.iterator().next()) + "\" " : message + "one of\n" + StringUtil.join(modulesWithPackage, (Function)moduleNameRef, (String)"\n") + "\n";
                message = message + "instead";
                toolWindowManager.notifyByBalloon(testRunDebugId, MessageType.WARNING, message, null, (HyperlinkListener)((Object)new ResetConfigurationModuleAdapter(project, consoleProperties, toolWindowManager, testRunDebugId)));
            }
        }
    }

    private class ResetConfigurationModuleAdapter
    extends HyperlinkAdapter {
        private final Project myProject;
        private final JUnitConsoleProperties myConsoleProperties;
        private final ToolWindowManager myToolWindowManager;
        private final String myTestRunDebugId;

        public ResetConfigurationModuleAdapter(Project project, JUnitConsoleProperties consoleProperties, ToolWindowManager toolWindowManager, String testRunDebugId) {
            this.myProject = project;
            this.myConsoleProperties = consoleProperties;
            this.myToolWindowManager = toolWindowManager;
            this.myTestRunDebugId = testRunDebugId;
        }

        protected void hyperlinkActivated(HyperlinkEvent e) {
            Module moduleByName = ModuleManager.getInstance((Project)this.myProject).findModuleByName(e.getDescription());
            if (moduleByName != null) {
                ((JavaRunConfigurationModule)TestPackage.this.myConfiguration.getConfigurationModule()).setModule(moduleByName);
                try {
                    Executor executor = this.myConsoleProperties.isDebug() ? DefaultDebugExecutor.getDebugExecutorInstance() : DefaultRunExecutor.getRunExecutorInstance();
                    ExecutionEnvironmentBuilder.create((Project)this.myProject, (Executor)executor, (RunProfile)TestPackage.this.myConfiguration).contentToReuse(null).buildAndExecute();
                    Balloon balloon = this.myToolWindowManager.getToolWindowBalloon(this.myTestRunDebugId);
                    if (balloon != null) {
                        balloon.hide();
                    }
                }
                catch (ExecutionException e1) {
                    TestObject.LOG.error((Throwable)e1);
                }
            }
        }
    }

    private class MySearchForTestsTask
    extends SearchForTestsTask {
        private final TestClassFilter myClassFilter;
        private final boolean[] myJunit4;
        private final THashSet<PsiClass> myClasses;
        private final FindCallback myCallback;

        public MySearchForTestsTask(TestClassFilter classFilter, boolean[] junit4, THashSet<PsiClass> classes, FindCallback callback) {
            super(classFilter.getProject(), ExecutionBundle.message((String)"seaching.test.progress.title", (Object[])new Object[0]), true);
            this.myClassFilter = classFilter;
            this.myJunit4 = junit4;
            this.myClasses = classes;
            this.myCallback = callback;
        }

        public void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/execution/junit/TestPackage$MySearchForTestsTask", "run"));
            }
            try {
                this.mySocket = TestPackage.this.myServerSocket.accept();
                DumbService.getInstance((Project)this.myProject).repeatUntilPassesInSmartMode(new Runnable(){

                    @Override
                    public void run() {
                        MySearchForTestsTask.this.myClasses.clear();
                        ((MySearchForTestsTask)MySearchForTestsTask.this).myJunit4[0] = ConfigurationUtil.findAllTestClasses(MySearchForTestsTask.this.myClassFilter, (Set<PsiClass>)MySearchForTestsTask.this.myClasses);
                    }
                });
                TestPackage.this.myFoundTests = !this.myClasses.isEmpty();
            }
            catch (IOException e) {
                TestObject.LOG.info((Throwable)e);
            }
            catch (Throwable e) {
                TestObject.LOG.error(e);
            }
        }

        public void onSuccess() {
            this.myCallback.found((Collection<PsiClass>)this.myClasses, this.myJunit4[0]);
            this.finish();
        }
    }

    protected abstract class SearchForTestsTask
    extends Task.Backgroundable {
        protected Socket mySocket;

        public SearchForTestsTask(@NotNull Project project, String title, boolean canBeCancelled) {
            if (title == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/execution/junit/TestPackage$SearchForTestsTask", "<init>"));
            }
            super(project, title, canBeCancelled);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finish() {
            FilterOutputStream os = null;
            try {
                if (this.mySocket == null || this.mySocket.isClosed()) {
                    return;
                }
                os = new DataOutputStream(this.mySocket.getOutputStream());
                ((DataOutputStream)os).writeBoolean(true);
            }
            catch (Throwable e) {
                TestObject.LOG.info(e);
            }
            finally {
                try {
                    if (os != null) {
                        os.close();
                    }
                }
                catch (Throwable e) {
                    TestObject.LOG.info(e);
                }
                try {
                    if (!TestPackage.this.myServerSocket.isClosed()) {
                        TestPackage.this.myServerSocket.close();
                    }
                }
                catch (Throwable e) {
                    TestObject.LOG.info(e);
                }
            }
        }

        public void onCancel() {
            this.finish();
        }
    }

    public static interface FindCallback {
        public void found(@NotNull Collection<PsiClass> var1, boolean var2);
    }
}

