/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.log;

import com.intellij.ui.JBColor;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.RefGroup;
import com.intellij.vcs.log.VcsLogRefManager;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.VcsRefType;
import com.intellij.vcs.log.impl.SingletonRefGroup;
import java.awt.Color;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class HgRefManager
implements VcsLogRefManager {
    private static final Color TIP_COLOR = new JBColor(new Color(15855518), new Color(113, 111, 64));
    private static final Color HEAD_COLOR = new JBColor(new Color(15798185), new Color(15798185).darker());
    private static final Color BRANCH_COLOR = new JBColor(new Color(7728839), new Color(879951));
    private static final Color CLOSED_BRANCH_COLOR = new JBColor(new Color(15630218), new Color(15630218).darker());
    private static final Color BOOKMARK_COLOR = new JBColor(new Color(0xBCBCFC), new Color(0xBCBCFC).darker().darker());
    private static final Color TAG_COLOR = JBColor.WHITE;
    private static final Color LOCAL_TAG_COLOR = JBColor.CYAN;
    public static final VcsRefType TIP = new SimpleRefType(true, TIP_COLOR);
    public static final VcsRefType HEAD = new SimpleRefType(true, HEAD_COLOR);
    public static final VcsRefType BRANCH = new SimpleRefType(true, BRANCH_COLOR);
    public static final VcsRefType CLOSED_BRANCH = new SimpleRefType(false, CLOSED_BRANCH_COLOR);
    public static final VcsRefType BOOKMARK = new SimpleRefType(true, BOOKMARK_COLOR);
    public static final VcsRefType TAG = new SimpleRefType(false, TAG_COLOR);
    public static final VcsRefType LOCAL_TAG = new SimpleRefType(false, LOCAL_TAG_COLOR);
    private static final List<VcsRefType> REF_TYPE_PRIORITIES = Arrays.asList(TIP, HEAD, BRANCH, BOOKMARK, TAG);
    public static final Comparator<VcsRefType> REF_TYPE_COMPARATOR = new Comparator<VcsRefType>(){

        @Override
        public int compare(VcsRefType type1, VcsRefType type2) {
            int p1 = REF_TYPE_PRIORITIES.indexOf(type1);
            int p2 = REF_TYPE_PRIORITIES.indexOf(type2);
            return p1 - p2;
        }
    };
    private static final String DEFAULT = "default";
    private final Comparator<VcsRef> REF_COMPARATOR = new Comparator<VcsRef>(){

        @Override
        public int compare(VcsRef ref1, VcsRef ref2) {
            VcsRefType type2;
            VcsRefType type1 = ref1.getType();
            int typeComparison = REF_TYPE_COMPARATOR.compare(type1, type2 = ref2.getType());
            if (typeComparison != 0) {
                return typeComparison;
            }
            VcsRefType type = type1;
            if (type == BRANCH) {
                if (ref1.getName().equals(HgRefManager.DEFAULT)) {
                    return -1;
                }
                if (ref2.getName().equals(HgRefManager.DEFAULT)) {
                    return 1;
                }
                return ref1.getName().compareTo(ref2.getName());
            }
            return ref1.getName().compareTo(ref2.getName());
        }
    };

    @NotNull
    public Comparator<VcsRef> getComparator() {
        Comparator<VcsRef> comparator = this.REF_COMPARATOR;
        if (comparator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/log/HgRefManager", "getComparator"));
        }
        return comparator;
    }

    @NotNull
    public List<RefGroup> group(Collection<VcsRef> refs) {
        List list = ContainerUtil.map(this.sort(refs), (Function)new Function<VcsRef, RefGroup>(){

            public RefGroup fun(VcsRef ref) {
                return new SingletonRefGroup(ref);
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/log/HgRefManager", "group"));
        }
        return list;
    }

    @NotNull
    private Collection<VcsRef> sort(@NotNull Collection<VcsRef> refs) {
        if (refs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refs", "org/zmlx/hg4idea/log/HgRefManager", "sort"));
        }
        List list = ContainerUtil.sorted(refs, this.getComparator());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/log/HgRefManager", "sort"));
        }
        return list;
    }

    private static class SimpleRefType
    implements VcsRefType {
        private final boolean myIsBranch;
        @NotNull
        private final Color myColor;

        public SimpleRefType(boolean isBranch, @NotNull Color color) {
            if (color == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "org/zmlx/hg4idea/log/HgRefManager$SimpleRefType", "<init>"));
            }
            this.myIsBranch = isBranch;
            this.myColor = color;
        }

        public boolean isBranch() {
            return this.myIsBranch;
        }

        @NotNull
        public Color getBackgroundColor() {
            Color color = this.myColor;
            if (color == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/log/HgRefManager$SimpleRefType", "getBackgroundColor"));
            }
            return color;
        }
    }
}

