/*
 * Decompiled with CFR 0.152.
 */
package com.android.manifmerger;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.utils.PositionXmlParser;
import com.google.common.base.Preconditions;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

final class PositionImpl
implements PositionXmlParser.Position {
    private static final String POSITION_ELEMENT = "position";
    private static final String LINE_ATTRIBUTE = "line";
    private static final String COLUMN_ATTRIBUTE = "col";
    private static final String OFFSET_ATTRIBUTE = "offset";
    static final PositionXmlParser.Position UNKNOWN = new PositionImpl(0, 0, 0);
    private final int mLine;
    private final int mColumn;
    private final int mOffset;

    private PositionImpl(int line, int column, int offset) {
        this.mLine = line;
        this.mColumn = column;
        this.mOffset = offset;
    }

    public static PositionXmlParser.Position fromXml(Element xml) {
        Preconditions.checkArgument((boolean)xml.getNodeName().equals(POSITION_ELEMENT));
        return new PositionImpl(Integer.parseInt(xml.getAttribute(LINE_ATTRIBUTE)), Integer.parseInt(xml.getAttribute(COLUMN_ATTRIBUTE)), Integer.parseInt(xml.getAttribute(OFFSET_ATTRIBUTE)));
    }

    public static Element toXml(PositionXmlParser.Position position, Document document) {
        Element xml = document.createElement(POSITION_ELEMENT);
        xml.setAttribute(LINE_ATTRIBUTE, String.valueOf(position.getLine()));
        xml.setAttribute(COLUMN_ATTRIBUTE, String.valueOf(position.getColumn()));
        xml.setAttribute(OFFSET_ATTRIBUTE, String.valueOf(position.getOffset()));
        return xml;
    }

    @Nullable
    public PositionXmlParser.Position getEnd() {
        return null;
    }

    public void setEnd(@NonNull PositionXmlParser.Position end) {
    }

    public int getLine() {
        return this.mLine;
    }

    public int getOffset() {
        return this.mOffset;
    }

    public int getColumn() {
        return this.mColumn;
    }
}

