/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.repository.remote;

import com.android.annotations.NonNull;
import com.android.sdklib.internal.repository.AddonsListFetcher;
import com.android.sdklib.internal.repository.DownloadCache;
import com.android.sdklib.internal.repository.NullTaskMonitor;
import com.android.sdklib.internal.repository.packages.Package;
import com.android.sdklib.internal.repository.sources.SdkAddonSource;
import com.android.sdklib.internal.repository.sources.SdkRepoSource;
import com.android.sdklib.internal.repository.sources.SdkSource;
import com.android.sdklib.internal.repository.sources.SdkSourceCategory;
import com.android.sdklib.internal.repository.sources.SdkSources;
import com.android.sdklib.internal.repository.sources.SdkSysImgSource;
import com.android.sdklib.internal.repository.updater.SettingsController;
import com.android.sdklib.repository.SdkAddonsListConstants;
import com.android.sdklib.repository.descriptors.IPkgDesc;
import com.android.sdklib.repository.descriptors.PkgType;
import com.android.sdklib.repository.remote.RemotePkgInfo;
import com.android.utils.ILogger;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;

public class RemoteSdk {
    public static final long DEFAULT_EXPIRATION_PERIOD_MS = 86400000L;
    private final SettingsController mSettingsController;
    private final SdkSources mSdkSources = new SdkSources();
    private long mSdkSourceTS;
    private DownloadCache mDownloadCache;

    public RemoteSdk(SettingsController settingsController) {
        this.mSettingsController = settingsController;
        settingsController.registerOnChangedListener(new SettingsController.OnChangedListener(){

            @Override
            public void onSettingsChanged(@NonNull SettingsController controller, @NonNull SettingsController.Settings oldSettings) {
                RemoteSdk.this.mDownloadCache = null;
            }
        });
    }

    @NonNull
    public Multimap<PkgType, RemotePkgInfo> fetch(@NonNull SdkSources sources, @NonNull ILogger logger) {
        HashMultimap remotes = HashMultimap.create();
        boolean forceHttp = this.mSettingsController.getSettings().getForceHttp();
        for (SdkSource source : sources.getAllSources()) {
            source.load(this.getDownloadCache(), new NullTaskMonitor(logger), forceHttp);
            Package[] pkgs = source.getPackages();
            if (pkgs == null || pkgs.length == 0) continue;
            for (Package p : pkgs) {
                IPkgDesc d = p.getPkgDesc();
                RemotePkgInfo r = new RemotePkgInfo(d, source);
                remotes.put((Object)d.getType(), (Object)r);
            }
        }
        return remotes;
    }

    @NonNull
    public SdkSources fetchSources(long expirationDelayMs, @NonNull ILogger logger) {
        boolean expired;
        long now = System.currentTimeMillis();
        boolean bl = expired = now - this.mSdkSourceTS > expirationDelayMs;
        if (expired || !this.mSdkSources.hasSources(SdkSourceCategory.ANDROID_REPO)) {
            String baseUrl = System.getenv("SDK_TEST_BASE_URL");
            if (baseUrl == null || baseUrl.length() <= 0 || !baseUrl.endsWith("/")) {
                baseUrl = "https://dl-ssl.google.com/android/repository/";
            }
            this.mSdkSources.removeAll(SdkSourceCategory.ANDROID_REPO);
            this.mSdkSources.add(SdkSourceCategory.ANDROID_REPO, new SdkRepoSource(baseUrl, SdkSourceCategory.ANDROID_REPO.getUiName()));
        }
        if (expired || !this.mSdkSources.hasSources(SdkSourceCategory.USER_ADDONS)) {
            this.mSdkSources.loadUserAddons(logger);
        }
        if (expired || !this.mSdkSources.hasSources(SdkSourceCategory.ADDONS_3RD_PARTY)) {
            NullTaskMonitor tempMonitor = new NullTaskMonitor(logger);
            String url = SdkAddonsListConstants.URL_ADDON_LIST;
            String baseUrl = System.getenv("SDK_TEST_BASE_URL");
            if (baseUrl != null) {
                if (baseUrl.length() > 0 && baseUrl.endsWith("/")) {
                    if (url.startsWith("https://dl-ssl.google.com/android/repository/")) {
                        url = baseUrl + url.substring("https://dl-ssl.google.com/android/repository/".length());
                    }
                } else {
                    tempMonitor.logError("Ignoring invalid SDK_TEST_BASE_URL: %1$s", baseUrl);
                }
            }
            if (this.mSettingsController.getSettings().getForceHttp()) {
                url = url.replaceAll("https://", "http://");
            }
            boolean fetch3rdParties = System.getenv("SDK_SKIP_3RD_PARTIES") == null;
            AddonsListFetcher fetcher = new AddonsListFetcher();
            AddonsListFetcher.Site[] sites = fetcher.fetch(url, this.getDownloadCache(), tempMonitor);
            if (sites != null) {
                this.mSdkSources.removeAll(SdkSourceCategory.ADDONS_3RD_PARTY);
                if (fetch3rdParties) {
                    block4: for (AddonsListFetcher.Site s : sites) {
                        switch (s.getType()) {
                            case ADDON_SITE: {
                                this.mSdkSources.add(SdkSourceCategory.ADDONS_3RD_PARTY, new SdkAddonSource(s.getUrl(), s.getUiName()));
                                continue block4;
                            }
                            case SYS_IMG_SITE: {
                                this.mSdkSources.add(SdkSourceCategory.ADDONS_3RD_PARTY, new SdkSysImgSource(s.getUrl(), s.getUiName()));
                            }
                        }
                    }
                }
                this.mSdkSources.notifyChangeListeners();
            }
        }
        this.mSdkSourceTS = now;
        return this.mSdkSources;
    }

    protected DownloadCache getDownloadCache() {
        if (this.mDownloadCache == null) {
            this.mDownloadCache = new DownloadCache(this.mSettingsController.getSettings().getUseDownloadCache() ? DownloadCache.Strategy.FRESH_CACHE : DownloadCache.Strategy.DIRECT);
        }
        return this.mDownloadCache;
    }
}

