/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.config;

import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.options.BaseConfigurable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.actions.IconWithTextAction;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.tasks.TaskManager;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.TaskRepositorySubtype;
import com.intellij.tasks.TaskRepositoryType;
import com.intellij.tasks.config.RecentTaskRepositories;
import com.intellij.tasks.config.TaskRepositoryEditor;
import com.intellij.tasks.impl.TaskManagerImpl;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.Nullable;

public class TaskRepositoriesConfigurable
extends BaseConfigurable
implements Configurable.NoScroll {
    private static final String EMPTY_PANEL = "empty.panel";
    private JPanel myPanel;
    private JPanel myServersPanel;
    private final JBList myRepositoriesList;
    private JPanel myToolbarPanel;
    private JPanel myRepositoryEditor;
    private JBLabel myServersLabel;
    private Splitter mySplitter;
    private JPanel myEmptyPanel;
    private final List<TaskRepository> myRepositories;
    private final List<TaskRepositoryEditor> myEditors;
    private final Project myProject;
    private final Consumer<TaskRepository> myChangeListener;
    private final FactoryMap<TaskRepository, String> myRepoNames;
    private final TaskManagerImpl myManager;

    public TaskRepositoriesConfigurable(Project project) {
        this.$$$setupUI$$$();
        this.myRepositories = new ArrayList<TaskRepository>();
        this.myEditors = new ArrayList<TaskRepositoryEditor>();
        this.myRepoNames = new ConcurrentFactoryMap<TaskRepository, String>(){
            private int count;

            protected String create(TaskRepository repository) {
                return Integer.toString(this.count++);
            }
        };
        this.myProject = project;
        this.myManager = (TaskManagerImpl)TaskManager.getManager((Project)project);
        this.myRepositoriesList = new JBList();
        this.myRepositoriesList.getEmptyText().setText("No servers");
        this.myServersLabel.setLabelFor((Component)this.myRepositoriesList);
        TaskRepositoryType[] groups = TaskRepositoryType.getRepositoryTypes();
        final ArrayList<2> createActions = new ArrayList<2>();
        for (final TaskRepositoryType repositoryType : groups) {
            for (final TaskRepositorySubtype subtype : repositoryType.getAvailableSubtypes()) {
                String description = "New " + subtype.getName() + " server";
                createActions.add(new IconWithTextAction(subtype.getName(), description, subtype.getIcon()){

                    public void actionPerformed(AnActionEvent e) {
                        TaskRepository repository = repositoryType.createRepository(subtype);
                        TaskRepositoriesConfigurable.this.addRepository(repository);
                    }
                });
            }
        }
        ToolbarDecorator toolbarDecorator = ToolbarDecorator.createDecorator((JList)this.myRepositoriesList).disableUpDownActions();
        toolbarDecorator.setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton anActionButton) {
                DefaultActionGroup group = new DefaultActionGroup();
                for (AnAction aMyAdditional : createActions) {
                    group.add(aMyAdditional);
                }
                Set<TaskRepository> repositories = RecentTaskRepositories.getInstance().getRepositories();
                repositories.removeAll(TaskRepositoriesConfigurable.this.myRepositories);
                if (!repositories.isEmpty()) {
                    group.add((AnAction)Separator.getInstance());
                    for (final TaskRepository repository : repositories) {
                        group.add((AnAction)new IconWithTextAction(repository.getUrl(), repository.getUrl(), repository.getIcon()){

                            public void actionPerformed(AnActionEvent e) {
                                TaskRepositoriesConfigurable.this.addRepository(repository);
                            }
                        });
                    }
                }
                JBPopupFactory.getInstance().createActionGroupPopup("Add server", (ActionGroup)group, DataManager.getInstance().getDataContext((Component)anActionButton.getContextComponent()), JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, false).show(anActionButton.getPreferredPopupPoint());
            }
        });
        toolbarDecorator.setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton anActionButton) {
                TaskRepository repository = TaskRepositoriesConfigurable.this.getSelectedRepository();
                if (repository != null) {
                    CollectionListModel model = (CollectionListModel)TaskRepositoriesConfigurable.this.myRepositoriesList.getModel();
                    model.remove((Object)repository);
                    TaskRepositoriesConfigurable.this.myRepositories.remove(repository);
                    if (model.getSize() > 0) {
                        TaskRepositoriesConfigurable.this.myRepositoriesList.setSelectedValue(model.getElementAt(0), true);
                    } else {
                        TaskRepositoriesConfigurable.this.myRepositoryEditor.removeAll();
                        TaskRepositoriesConfigurable.this.myRepositoryEditor.repaint();
                    }
                }
            }
        });
        this.myServersPanel.add((Component)toolbarDecorator.createPanel(), "Center");
        this.myRepositoriesList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                TaskRepository repository = TaskRepositoriesConfigurable.this.getSelectedRepository();
                if (repository != null) {
                    String name = (String)TaskRepositoriesConfigurable.this.myRepoNames.get((Object)repository);
                    assert (name != null);
                    ((CardLayout)TaskRepositoriesConfigurable.this.myRepositoryEditor.getLayout()).show(TaskRepositoriesConfigurable.this.myRepositoryEditor, name);
                    TaskRepositoriesConfigurable.this.mySplitter.doLayout();
                    TaskRepositoriesConfigurable.this.mySplitter.repaint();
                }
            }
        });
        this.myRepositoriesList.setCellRenderer((ListCellRenderer)new ColoredListCellRenderer(){

            protected void customizeCellRenderer(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                TaskRepository repository = (TaskRepository)value;
                this.setIcon(repository.getIcon());
                this.append(repository.getPresentableName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            }
        });
        this.myChangeListener = new Consumer<TaskRepository>(){

            public void consume(TaskRepository repository) {
                ((CollectionListModel)TaskRepositoriesConfigurable.this.myRepositoriesList.getModel()).contentsChanged((Object)repository);
            }
        };
    }

    private void addRepository(TaskRepository repository) {
        this.myRepositories.add(repository);
        ((CollectionListModel)this.myRepositoriesList.getModel()).add((Object)repository);
        this.addRepositoryEditor(repository, true);
        this.myRepositoriesList.setSelectedIndex(this.myRepositoriesList.getModel().getSize() - 1);
    }

    private void addRepositoryEditor(TaskRepository repository, boolean requestFocus) {
        TaskRepositoryEditor editor = repository.getRepositoryType().createEditor(repository, this.myProject, this.myChangeListener);
        this.myEditors.add(editor);
        JComponent component = editor.createComponent();
        String name = (String)this.myRepoNames.get((Object)repository);
        this.myRepositoryEditor.add((Component)component, name);
        this.myRepositoryEditor.doLayout();
        JComponent preferred = editor.getPreferredFocusedComponent();
        if (preferred == null || requestFocus) {
            // empty if block
        }
    }

    @Nullable
    private TaskRepository getSelectedRepository() {
        return (TaskRepository)this.myRepositoriesList.getSelectedValue();
    }

    @Nls
    public String getDisplayName() {
        return "Servers";
    }

    public String getHelpTopic() {
        return "reference.settings.project.tasks.servers";
    }

    public JComponent createComponent() {
        return this.myPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myRepositoriesList;
    }

    public boolean isModified() {
        return !((Object)this.myRepositories).equals(this.getReps());
    }

    public void apply() throws ConfigurationException {
        List newRepositories = ContainerUtil.map(this.myRepositories, (Function)new Function<TaskRepository, TaskRepository>(){

            public TaskRepository fun(TaskRepository taskRepository) {
                return taskRepository.clone();
            }
        });
        this.myManager.setRepositories(newRepositories);
        this.myManager.updateIssues(null);
        RecentTaskRepositories.getInstance().addRepositories(this.myRepositories);
    }

    public void reset() {
        this.myRepoNames.clear();
        this.myRepositoryEditor.removeAll();
        this.myRepositoryEditor.add((Component)this.myEmptyPanel, EMPTY_PANEL);
        this.myRepositories.clear();
        CollectionListModel listModel = new CollectionListModel(new ArrayList());
        for (TaskRepository repository : this.myManager.getAllRepositories()) {
            TaskRepository clone = repository.clone();
            assert (clone.equals((Object)repository)) : repository.getClass().getName();
            this.myRepositories.add(clone);
            listModel.add((Object)clone);
        }
        this.myRepositoriesList.setModel((ListModel)listModel);
        for (TaskRepository clone : this.myRepositories) {
            this.addRepositoryEditor(clone, false);
        }
        if (!this.myRepositories.isEmpty()) {
            this.myRepositoriesList.setSelectedValue((Object)this.myRepositories.get(0), true);
        }
    }

    private List<TaskRepository> getReps() {
        return Arrays.asList(this.myManager.getAllRepositories());
    }

    public void disposeUIResources() {
        for (TaskRepositoryEditor editor : this.myEditors) {
            Disposer.dispose((Disposable)editor);
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        Splitter splitter;
        JPanel jPanel;
        JPanel jPanel2;
        JPanel jPanel3;
        JBLabel jBLabel;
        JPanel jPanel4;
        this.myPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myServersLabel = jBLabel = new JBLabel();
        jBLabel.setText("Configured servers:");
        jBLabel.setDisplayedMnemonic('C');
        jBLabel.setDisplayedMnemonicIndex(0);
        jPanel4.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myServersPanel = jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 1, 1, 3, 3, null, new Dimension(0, 50), null));
        this.myRepositoryEditor = jPanel2 = new JPanel();
        jPanel2.setLayout(new CardLayout(0, 0));
        jPanel4.add((Component)jPanel2, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 7, null, null, null));
        this.myEmptyPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, "Card1");
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(100, 220, 100, 220), null, 0, 0, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setHorizontalAlignment(0);
        jBLabel2.setText("No server selected");
        jPanel.add((Component)jBLabel2, "Center");
        this.mySplitter = splitter = new Splitter();
        splitter.setOrientation(true);
        jPanel4.add((Component)splitter, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        splitter.setFirstComponent((JComponent)jPanel3);
        splitter.setSecondComponent((JComponent)jPanel2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

