/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage.view;

import com.intellij.coverage.CoverageSuite;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.JavaCoverageAnnotator;
import com.intellij.coverage.JavaCoverageSuite;
import com.intellij.coverage.PackageAnnotator;
import com.intellij.coverage.view.CoverageListNode;
import com.intellij.coverage.view.CoverageListRootNode;
import com.intellij.coverage.view.CoverageViewExtension;
import com.intellij.coverage.view.CoverageViewManager;
import com.intellij.coverage.view.ElementColumnInfo;
import com.intellij.coverage.view.PercentageCoverageColumnInfo;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ui.ColumnInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class JavaCoverageViewExtension
extends CoverageViewExtension {
    private final JavaCoverageAnnotator myAnnotator;

    public JavaCoverageViewExtension(JavaCoverageAnnotator annotator, Project project, CoverageSuitesBundle suitesBundle, CoverageViewManager.StateBean stateBean) {
        super(project, suitesBundle, stateBean);
        this.myAnnotator = annotator;
    }

    @Override
    public String getSummaryForNode(AbstractTreeNode node) {
        String coverageInformationString = this.myAnnotator.getPackageCoverageInformationString((PsiPackage)node.getValue(), null, this.myCoverageDataManager, this.myStateBean.myFlattenPackages);
        return "Coverage Summary for Package '" + node.toString() + "': " + JavaCoverageViewExtension.getNotCoveredMessage(coverageInformationString);
    }

    @Override
    public String getSummaryForRootNode(AbstractTreeNode childNode) {
        Object value = childNode.getValue();
        String coverageInformationString = this.myAnnotator.getPackageCoverageInformationString((PsiPackage)value, null, this.myCoverageDataManager);
        if (coverageInformationString == null) {
            if (!this.myCoverageViewManager.isReady()) {
                return "Loading...";
            }
            PackageAnnotator.PackageCoverageInfo info = new PackageAnnotator.PackageCoverageInfo();
            Collection children = childNode.getChildren();
            for (Object child : children) {
                Object childValue = ((CoverageListNode)((Object)child)).getValue();
                if (childValue instanceof PsiPackage) {
                    PackageAnnotator.PackageCoverageInfo coverageInfo = this.myAnnotator.getPackageCoverageInfo((PsiPackage)childValue, this.myStateBean.myFlattenPackages);
                    if (coverageInfo == null) continue;
                    info = JavaCoverageAnnotator.merge(info, coverageInfo);
                    continue;
                }
                PackageAnnotator.ClassCoverageInfo classCoverageInfo = this.getClassCoverageInfo((PsiClass)childValue);
                if (classCoverageInfo == null) continue;
                info.coveredClassCount = info.coveredClassCount + (classCoverageInfo.coveredMethodCount > 0 ? 1 : 0);
                ++info.totalClassCount;
                info.coveredMethodCount += classCoverageInfo.coveredMethodCount;
                info.totalMethodCount += classCoverageInfo.totalMethodCount;
                info.coveredLineCount += classCoverageInfo.partiallyCoveredLineCount + classCoverageInfo.fullyCoveredLineCount;
                info.totalLineCount += classCoverageInfo.totalLineCount;
            }
            coverageInformationString = JavaCoverageAnnotator.getCoverageInformationString(info, false);
        }
        return "Coverage Summary for 'all classes in scope': " + JavaCoverageViewExtension.getNotCoveredMessage(coverageInformationString);
    }

    private static String getNotCoveredMessage(String coverageInformationString) {
        if (coverageInformationString == null) {
            coverageInformationString = "not covered";
        }
        return coverageInformationString;
    }

    @Override
    public String getPercentage(int columnIndex, AbstractTreeNode node) {
        Object value = node.getValue();
        if (value instanceof PsiClass) {
            if (((PsiClass)value).isInterface()) {
                return null;
            }
            String qualifiedName = ((PsiClass)value).getQualifiedName();
            if (columnIndex == 1) {
                return this.myAnnotator.getClassCoveredPercentage(qualifiedName);
            }
            if (columnIndex == 2) {
                return this.myAnnotator.getClassMethodPercentage(qualifiedName);
            }
            return this.myAnnotator.getClassLinePercentage(qualifiedName);
        }
        if (value instanceof PsiPackage) {
            boolean flatten = this.myStateBean.myFlattenPackages;
            if (columnIndex == 1) {
                return this.myAnnotator.getPackageClassPercentage((PsiPackage)value, flatten);
            }
            if (columnIndex == 2) {
                return this.myAnnotator.getPackageMethodPercentage((PsiPackage)value, flatten);
            }
            return this.myAnnotator.getPackageLinePercentage((PsiPackage)value, flatten);
        }
        return null;
    }

    @Override
    public PsiElement getElementToSelect(Object object) {
        PsiFile containingFile;
        PsiElement psiElement = super.getElementToSelect(object);
        if (psiElement != null && (containingFile = psiElement.getContainingFile()) instanceof PsiClassOwner) {
            PsiClass[] classes = ((PsiClassOwner)containingFile).getClasses();
            if (classes.length == 1) {
                return classes[0];
            }
            for (PsiClass aClass : classes) {
                if (!PsiTreeUtil.isAncestor((PsiElement)aClass, (PsiElement)psiElement, (boolean)false)) continue;
                return aClass;
            }
        }
        return psiElement;
    }

    @Override
    public VirtualFile getVirtualFile(Object object) {
        if (object instanceof PsiPackage) {
            PsiDirectory[] directories = ((PsiPackage)object).getDirectories();
            return directories.length > 0 ? directories[0].getVirtualFile() : null;
        }
        return super.getVirtualFile(object);
    }

    @Override
    @Nullable
    public PsiElement getParentElement(PsiElement element) {
        if (element instanceof PsiClass) {
            PsiDirectory containingDirectory = element.getContainingFile().getContainingDirectory();
            return containingDirectory != null ? JavaDirectoryService.getInstance().getPackage(containingDirectory) : null;
        }
        return ((PsiPackage)element).getParentPackage();
    }

    @Override
    public AbstractTreeNode createRootNode() {
        return new CoverageListRootNode(this.myProject, (PsiNamedElement)JavaPsiFacade.getInstance((Project)this.myProject).findPackage(""), this.mySuitesBundle, this.myStateBean);
    }

    @Override
    public List<AbstractTreeNode> createTopLevelNodes() {
        ArrayList<AbstractTreeNode> topLevelNodes = new ArrayList<AbstractTreeNode>();
        LinkedHashSet<PsiPackage> packages = new LinkedHashSet<PsiPackage>();
        LinkedHashSet<PsiClass> classes = new LinkedHashSet<PsiClass>();
        for (CoverageSuite suite : this.mySuitesBundle.getSuites()) {
            packages.addAll(((JavaCoverageSuite)suite).getCurrentSuitePackages(this.myProject));
            classes.addAll(((JavaCoverageSuite)suite).getCurrentSuiteClasses(this.myProject));
        }
        HashSet<PsiPackage> packs = new HashSet<PsiPackage>();
        block1: for (PsiPackage aPackage : packages) {
            String qualifiedName = aPackage.getQualifiedName();
            for (PsiPackage psiPackage : packages) {
                if (!psiPackage.getQualifiedName().startsWith(qualifiedName + ".")) continue;
                packs.add(psiPackage);
                continue block1;
            }
        }
        packages.removeAll(packs);
        for (PsiPackage aPackage : packages) {
            GlobalSearchScope searchScope;
            if (aPackage.getDirectories(searchScope = this.mySuitesBundle.getSearchScope(this.myProject)).length == 0) continue;
            if (aPackage.getClasses(searchScope).length != 0) {
                CoverageListNode node = new CoverageListNode(this.myProject, (PsiNamedElement)aPackage, this.mySuitesBundle, this.myStateBean);
                topLevelNodes.add(node);
            }
            JavaCoverageViewExtension.collectSubPackages(topLevelNodes, aPackage, this.mySuitesBundle, this.myStateBean);
        }
        for (PsiClass aClass : classes) {
            if (this.getClassCoverageInfo(aClass) == null) continue;
            topLevelNodes.add(new CoverageListNode(this.myProject, (PsiNamedElement)aClass, this.mySuitesBundle, this.myStateBean));
        }
        return topLevelNodes;
    }

    private static void collectSubPackages(List<AbstractTreeNode> children, final PsiPackage rootPackage, final CoverageSuitesBundle data, CoverageViewManager.StateBean stateBean) {
        PsiPackage[] subPackages;
        final GlobalSearchScope searchScope = data.getSearchScope(rootPackage.getProject());
        for (final PsiPackage aPackage : subPackages = (PsiPackage[])ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiPackage[]>(){

            public PsiPackage[] compute() {
                return rootPackage.getSubPackages(searchScope);
            }
        })) {
            PsiDirectory[] directories = (PsiDirectory[])ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiDirectory[]>(){

                public PsiDirectory[] compute() {
                    return aPackage.getDirectories(searchScope);
                }
            });
            if (directories.length == 0 && !((Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

                public Boolean compute() {
                    return JavaPsiFacade.getInstance((Project)aPackage.getProject()).isPartOfPackagePrefix(aPackage.getQualifiedName());
                }
            })).booleanValue()) continue;
            if (((Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

                public Boolean compute() {
                    return JavaCoverageViewExtension.isInCoverageScope((PsiElement)aPackage, data);
                }
            })).booleanValue()) {
                CoverageListNode node = new CoverageListNode(rootPackage.getProject(), (PsiNamedElement)aPackage, data, stateBean);
                children.add(node);
            } else if (!stateBean.myFlattenPackages) {
                JavaCoverageViewExtension.collectSubPackages(children, aPackage, data, stateBean);
            }
            if (!stateBean.myFlattenPackages) continue;
            JavaCoverageViewExtension.collectSubPackages(children, aPackage, data, stateBean);
        }
    }

    @Override
    public List<AbstractTreeNode> getChildrenNodes(final AbstractTreeNode node) {
        ArrayList<AbstractTreeNode> children = new ArrayList<AbstractTreeNode>();
        if (node instanceof CoverageListNode) {
            final Object val = node.getValue();
            if (val instanceof PsiClass) {
                return Collections.emptyList();
            }
            if (val instanceof PsiPackage) {
                if (!this.myStateBean.myFlattenPackages) {
                    JavaCoverageViewExtension.collectSubPackages(children, (PsiPackage)val, this.mySuitesBundle, this.myStateBean);
                }
                if (((Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

                    public Boolean compute() {
                        return JavaCoverageViewExtension.isInCoverageScope((PsiElement)((PsiPackage)val), JavaCoverageViewExtension.this.mySuitesBundle);
                    }
                })).booleanValue()) {
                    PsiClass[] classes;
                    for (PsiClass aClass : classes = (PsiClass[])ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiClass[]>(){

                        public PsiClass[] compute() {
                            return ((PsiPackage)val).getClasses(JavaCoverageViewExtension.this.mySuitesBundle.getSearchScope(node.getProject()));
                        }
                    })) {
                        if (!(node instanceof CoverageListRootNode) && this.getClassCoverageInfo(aClass) == null) continue;
                        children.add(new CoverageListNode(this.myProject, (PsiNamedElement)aClass, this.mySuitesBundle, this.myStateBean));
                    }
                }
            }
            if (node instanceof CoverageListRootNode) {
                for (CoverageSuite suite : this.mySuitesBundle.getSuites()) {
                    List<PsiClass> classes = ((JavaCoverageSuite)suite).getCurrentSuiteClasses(this.myProject);
                    for (PsiClass aClass : classes) {
                        children.add(new CoverageListNode(this.myProject, (PsiNamedElement)aClass, this.mySuitesBundle, this.myStateBean));
                    }
                }
            }
            for (AbstractTreeNode childNode : children) {
                childNode.setParent(node);
            }
        }
        return children;
    }

    @Nullable
    private PackageAnnotator.ClassCoverageInfo getClassCoverageInfo(final PsiClass aClass) {
        return this.myAnnotator.getClassCoverageInfo((String)ApplicationManager.getApplication().runReadAction((Computable)new NullableComputable<String>(){

            public String compute() {
                return aClass.getQualifiedName();
            }
        }));
    }

    @Override
    public ColumnInfo[] createColumnInfos() {
        return new ColumnInfo[]{new ElementColumnInfo(), new PercentageCoverageColumnInfo(1, "Class, %", this.mySuitesBundle, this.myStateBean), new PercentageCoverageColumnInfo(2, "Method, %", this.mySuitesBundle, this.myStateBean), new PercentageCoverageColumnInfo(3, "Line, %", this.mySuitesBundle, this.myStateBean)};
    }

    private static boolean isInCoverageScope(PsiElement element, CoverageSuitesBundle suitesBundle) {
        if (element instanceof PsiPackage) {
            PsiPackage psiPackage = (PsiPackage)element;
            String qualifiedName = psiPackage.getQualifiedName();
            for (CoverageSuite suite : suitesBundle.getSuites()) {
                if (!((JavaCoverageSuite)suite).isPackageFiltered(qualifiedName)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean canSelectInCoverageView(Object object) {
        PsiFile psiFile;
        PsiFile psiFile2 = psiFile = object instanceof VirtualFile ? PsiManager.getInstance((Project)this.myProject).findFile((VirtualFile)object) : null;
        if (psiFile instanceof PsiClassOwner) {
            String packageName = ((PsiClassOwner)psiFile).getPackageName();
            return JavaCoverageViewExtension.isInCoverageScope((PsiElement)JavaPsiFacade.getInstance((Project)this.myProject).findPackage(packageName), this.mySuitesBundle);
        }
        if (object instanceof PsiPackage) {
            return JavaCoverageViewExtension.isInCoverageScope((PsiElement)object, this.mySuitesBundle);
        }
        return false;
    }

    @Override
    public boolean supportFlattenPackages() {
        return true;
    }
}

