/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.build;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.build.SplitOutput;
import com.android.resources.Density;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;

public class SplitOutputMatcher {
    @Nullable
    public static SplitOutput computeBestOutput(@NonNull List<? extends SplitOutput> outputs, @Nullable Set<String> variantAbiFilters, int deviceDensity, @NonNull List<String> deviceAbis) {
        Density densityEnum = Density.getEnum((int)deviceDensity);
        String densityValue = densityEnum == null ? null : densityEnum.getResourceValue();
        ArrayList matches = Lists.newArrayListWithExpectedSize((int)outputs.size());
        for (SplitOutput splitOutput : outputs) {
            String densityFilter = splitOutput.getDensityFilter();
            String abiFilter = splitOutput.getAbiFilter();
            if (densityFilter != null && !densityFilter.equals(densityValue) || abiFilter != null && !deviceAbis.contains(abiFilter)) continue;
            matches.add(splitOutput);
        }
        if (matches.isEmpty()) {
            return null;
        }
        SplitOutput match = Collections.max(matches, new Comparator<SplitOutput>(){

            @Override
            public int compare(SplitOutput splitOutput, SplitOutput splitOutput2) {
                return splitOutput.getVersionCode() - splitOutput2.getVersionCode();
            }
        });
        if (match.getDensityFilter() == null && variantAbiFilters != null) {
            boolean bl;
            boolean bl2 = false;
            for (String abi : deviceAbis) {
                if (!variantAbiFilters.contains(abi)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                return null;
            }
        }
        return match;
    }
}

