/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.DaemonBundle;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.Divider;
import com.intellij.codeInsight.daemon.impl.FileStatusMap;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoFilter;
import com.intellij.codeInsight.daemon.impl.HighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.HighlightRangeExtension;
import com.intellij.codeInsight.daemon.impl.HighlightVisitor;
import com.intellij.codeInsight.daemon.impl.ProgressableTextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.analysis.CustomHighlightInfoHolder;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightingLevelManager;
import com.intellij.codeInsight.problems.ProblemImpl;
import com.intellij.concurrency.JobScheduler;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.problems.Problem;
import com.intellij.problems.WolfTheProblemSolver;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.PsiTodoSearchHelper;
import com.intellij.psi.search.TodoItem;
import com.intellij.util.NotNullProducer;
import com.intellij.util.SmartList;
import com.intellij.util.containers.Stack;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GeneralHighlightingPass
extends ProgressableTextEditorHighlightingPass
implements DumbAware {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.GeneralHighlightingPass");
    static final String PRESENTABLE_NAME = DaemonBundle.message((String)"pass.syntax", (Object[])new Object[0]);
    private static final Key<Boolean> HAS_ERROR_ELEMENT = Key.create((String)"HAS_ERROR_ELEMENT");
    protected static final Condition<PsiFile> FILE_FILTER = new Condition<PsiFile>(){

        public boolean value(PsiFile file) {
            return HighlightingLevelManager.getInstance(file.getProject()).shouldHighlight((PsiElement)file);
        }
    };
    private static final Random RESTART_DAEMON_RANDOM = new Random();
    protected final int myStartOffset;
    protected final int myEndOffset;
    protected final boolean myUpdateAll;
    protected final ProperTextRange myPriorityRange;
    protected final Editor myEditor;
    protected final List<HighlightInfo> myHighlights;
    protected volatile boolean myHasErrorElement;
    private volatile boolean myErrorFound;
    private static final Comparator<HighlightVisitor> VISITOR_ORDER_COMPARATOR = new Comparator<HighlightVisitor>(){

        @Override
        public int compare(HighlightVisitor o1, HighlightVisitor o2) {
            return o1.order() - o2.order();
        }
    };
    protected final EditorColorsScheme myGlobalScheme;
    private volatile NotNullProducer<HighlightVisitor[]> myHighlightVisitorProducer;
    private static final Key<AtomicInteger> HIGHLIGHT_VISITOR_INSTANCE_COUNT = new Key("HIGHLIGHT_VISITOR_INSTANCE_COUNT");

    public GeneralHighlightingPass(@NotNull Project project, @NotNull PsiFile file, @NotNull Document document, int startOffset, int endOffset, boolean updateAll, @NotNull ProperTextRange priorityRange, @Nullable Editor editor, @NotNull HighlightInfoProcessor highlightInfoProcessor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "<init>"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "<init>"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "<init>"));
        }
        if (priorityRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "priorityRange", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "<init>"));
        }
        if (highlightInfoProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlightInfoProcessor", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "<init>"));
        }
        super(project, document, PRESENTABLE_NAME, file, editor, TextRange.create((int)startOffset, (int)endOffset), true, highlightInfoProcessor);
        this.myHighlights = new ArrayList<HighlightInfo>();
        this.myHighlightVisitorProducer = new NotNullProducer<HighlightVisitor[]>(){

            @NotNull
            public HighlightVisitor[] produce() {
                HighlightVisitor[] highlightVisitorArray = GeneralHighlightingPass.this.cloneHighlightVisitors();
                if (highlightVisitorArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass$3", "produce"));
                }
                return highlightVisitorArray;
            }
        };
        this.myStartOffset = startOffset;
        this.myEndOffset = endOffset;
        this.myUpdateAll = updateAll;
        this.myPriorityRange = priorityRange;
        this.myEditor = editor;
        LOG.assertTrue(file.isValid());
        boolean wholeFileHighlighting = this.isWholeFileHighlighting();
        this.myHasErrorElement = !wholeFileHighlighting && Boolean.TRUE.equals(this.myFile.getUserData(HAS_ERROR_ELEMENT));
        DaemonCodeAnalyzerEx daemonCodeAnalyzer = DaemonCodeAnalyzerEx.getInstanceEx(this.myProject);
        FileStatusMap fileStatusMap = daemonCodeAnalyzer.getFileStatusMap();
        this.myErrorFound = !wholeFileHighlighting && fileStatusMap.wasErrorFound(this.myDocument);
        this.setProgressLimit(document.getTextLength() / 2);
        this.myGlobalScheme = this.myEditor != null ? this.myEditor.getColorsScheme() : EditorColorsManager.getInstance().getGlobalScheme();
    }

    @NotNull
    private HighlightVisitor[] cloneHighlightVisitors() {
        int oldCount = this.incVisitorUsageCount(1);
        HighlightVisitor[] highlightVisitors = (HighlightVisitor[])Extensions.getExtensions(HighlightVisitor.EP_HIGHLIGHT_VISITOR, (AreaInstance)this.myProject);
        if (oldCount != 0) {
            HighlightVisitor[] clones = new HighlightVisitor[highlightVisitors.length];
            for (int i = 0; i < highlightVisitors.length; ++i) {
                HighlightVisitor highlightVisitor = highlightVisitors[i];
                HighlightVisitor cloned = highlightVisitor.clone();
                assert (cloned.getClass() == highlightVisitor.getClass()) : highlightVisitor.getClass() + ".clone() must return a copy of " + highlightVisitor.getClass() + "; but got: " + cloned + " of " + cloned.getClass();
                clones[i] = cloned;
            }
            highlightVisitors = clones;
        }
        if (highlightVisitors == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "cloneHighlightVisitors"));
        }
        return highlightVisitors;
    }

    @NotNull
    private HighlightVisitor[] filterVisitors(@NotNull HighlightVisitor[] highlightVisitors, @NotNull PsiFile psiFile) {
        if (highlightVisitors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlightVisitors", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "filterVisitors"));
        }
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "filterVisitors"));
        }
        ArrayList<HighlightVisitor> visitors = new ArrayList<HighlightVisitor>(highlightVisitors.length);
        List<HighlightVisitor> list = Arrays.asList(highlightVisitors);
        for (HighlightVisitor visitor : DumbService.getInstance((Project)this.myProject).filterByDumbAwareness(list)) {
            if (!visitor.suitableForFile(psiFile)) continue;
            visitors.add(visitor);
        }
        if (visitors.isEmpty()) {
            LOG.error("No visitors registered. list=" + list + "; all visitors are:" + Arrays.asList(Extensions.getExtensions(HighlightVisitor.EP_HIGHLIGHT_VISITOR, (AreaInstance)this.myProject)));
        }
        HighlightVisitor[] visitorArray = visitors.toArray(new HighlightVisitor[visitors.size()]);
        Arrays.sort(visitorArray, VISITOR_ORDER_COMPARATOR);
        if (visitorArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "filterVisitors"));
        }
        return visitorArray;
    }

    public void setHighlightVisitorProducer(@NotNull NotNullProducer<HighlightVisitor[]> highlightVisitorProducer) {
        if (highlightVisitorProducer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlightVisitorProducer", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "setHighlightVisitorProducer"));
        }
        this.myHighlightVisitorProducer = highlightVisitorProducer;
    }

    @NotNull
    protected HighlightVisitor[] getHighlightVisitors(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "getHighlightVisitors"));
        }
        HighlightVisitor[] highlightVisitorArray = this.filterVisitors((HighlightVisitor[])this.myHighlightVisitorProducer.produce(), psiFile);
        if (highlightVisitorArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "getHighlightVisitors"));
        }
        return highlightVisitorArray;
    }

    public int incVisitorUsageCount(int delta) {
        AtomicInteger count = (AtomicInteger)this.myProject.getUserData(HIGHLIGHT_VISITOR_INSTANCE_COUNT);
        if (count == null) {
            count = (AtomicInteger)((UserDataHolderEx)this.myProject).putUserDataIfAbsent(HIGHLIGHT_VISITOR_INSTANCE_COUNT, (Object)new AtomicInteger(0));
        }
        int old = count.getAndAdd(delta);
        assert (old + delta >= 0) : old + ";" + delta;
        return old;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void collectInformationWithProgress(@NotNull ProgressIndicator progress) {
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "collectInformationWithProgress"));
        }
        ArrayList<HighlightInfo> outsideResult = new ArrayList<HighlightInfo>(100);
        final ArrayList<HighlightInfo> insideResult = new ArrayList<HighlightInfo>(100);
        DaemonCodeAnalyzerEx daemonCodeAnalyzer = DaemonCodeAnalyzerEx.getInstanceEx(this.myProject);
        HighlightVisitor[] filteredVisitors = this.getHighlightVisitors(this.myFile);
        final ArrayList<PsiElement> insideElements = new ArrayList<PsiElement>();
        ArrayList<PsiElement> outsideElements = new ArrayList<PsiElement>();
        try {
            ArrayList<ProperTextRange> insideRanges = new ArrayList<ProperTextRange>();
            ArrayList<ProperTextRange> outsideRanges = new ArrayList<ProperTextRange>();
            Divider.divideInsideAndOutside(this.myFile, this.myStartOffset, this.myEndOffset, (TextRange)this.myPriorityRange, insideElements, insideRanges, outsideElements, outsideRanges, false, FILE_FILTER);
            if (!insideElements.isEmpty() && insideElements.get(insideElements.size() - 1) instanceof PsiFile) {
                PsiElement file = (PsiElement)insideElements.remove(insideElements.size() - 1);
                outsideElements.add(file);
                ProperTextRange range = (ProperTextRange)insideRanges.remove(insideRanges.size() - 1);
                outsideRanges.add(range);
            }
            this.setProgressLimit(insideElements.size() + outsideElements.size());
            boolean forceHighlightParents = this.forceHighlightParents();
            if (!this.isDumbMode()) {
                GeneralHighlightingPass.highlightTodos(this.myFile, this.myDocument.getCharsSequence(), this.myStartOffset, this.myEndOffset, progress, this.myPriorityRange, insideResult, outsideResult);
            }
            Runnable after1 = new Runnable(){

                @Override
                public void run() {
                    ProperTextRange priorityIntersection = GeneralHighlightingPass.this.myPriorityRange.intersection(GeneralHighlightingPass.this.myRestrictRange);
                    if (!(insideElements.isEmpty() && insideResult.isEmpty() || priorityIntersection == null)) {
                        GeneralHighlightingPass.this.myHighlightInfoProcessor.highlightsInsideVisiblePartAreProduced(GeneralHighlightingPass.this.myHighlightingSession, insideResult, (TextRange)GeneralHighlightingPass.this.myPriorityRange, GeneralHighlightingPass.this.myRestrictRange);
                    }
                }
            };
            this.collectHighlights(insideElements, insideRanges, after1, outsideElements, outsideRanges, progress, filteredVisitors, insideResult, outsideResult, forceHighlightParents);
            this.myHighlightInfoProcessor.highlightsOutsideVisiblePartAreProduced(this.myHighlightingSession, outsideResult, (TextRange)this.myPriorityRange, this.myRestrictRange);
            if (this.myUpdateAll) {
                daemonCodeAnalyzer.getFileStatusMap().setErrorFoundFlag(this.myDocument, this.myErrorFound);
            }
        }
        finally {
            this.incVisitorUsageCount(-1);
        }
        this.myHighlights.addAll(insideResult);
        this.myHighlights.addAll(outsideResult);
    }

    protected boolean isFailFastOnAcquireReadAction() {
        return true;
    }

    private boolean isWholeFileHighlighting() {
        return this.myUpdateAll && this.myStartOffset == 0 && this.myEndOffset == this.myDocument.getTextLength();
    }

    @Override
    protected void applyInformationWithProgress() {
        this.myFile.putUserData(HAS_ERROR_ELEMENT, (Object)this.myHasErrorElement);
        if (this.myUpdateAll) {
            this.reportErrorsToWolf();
        }
    }

    @Override
    @NotNull
    public List<HighlightInfo> getInfos() {
        ArrayList<HighlightInfo> arrayList = new ArrayList<HighlightInfo>(this.myHighlights);
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "getInfos"));
        }
        return arrayList;
    }

    private void collectHighlights(final @NotNull List<PsiElement> elements1, final @NotNull List<ProperTextRange> ranges1, @NotNull Runnable after1, final @NotNull List<PsiElement> elements2, @NotNull List<ProperTextRange> ranges2, final @NotNull ProgressIndicator progress, @NotNull HighlightVisitor[] visitors, @NotNull List<HighlightInfo> insideResult, @NotNull List<HighlightInfo> outsideResult, boolean forceHighlightParents) {
        if (elements1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements1", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "collectHighlights"));
        }
        if (ranges1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ranges1", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "collectHighlights"));
        }
        if (after1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "after1", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "collectHighlights"));
        }
        if (elements2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements2", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "collectHighlights"));
        }
        if (ranges2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ranges2", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "collectHighlights"));
        }
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "collectHighlights"));
        }
        if (visitors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitors", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "collectHighlights"));
        }
        if (insideResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "insideResult", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "collectHighlights"));
        }
        if (outsideResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outsideResult", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "collectHighlights"));
        }
        THashSet skipParentsSet = new THashSet();
        HighlightInfoHolder holder = this.createInfoHolder(this.myFile);
        final int chunkSize = Math.max(1, (elements1.size() + elements2.size()) / 100);
        Runnable action = new Runnable((Set)skipParentsSet, holder, visitors, insideResult, outsideResult, forceHighlightParents, after1, ranges2){
            final /* synthetic */ Set val$skipParentsSet;
            final /* synthetic */ HighlightInfoHolder val$holder;
            final /* synthetic */ HighlightVisitor[] val$visitors;
            final /* synthetic */ List val$insideResult;
            final /* synthetic */ List val$outsideResult;
            final /* synthetic */ boolean val$forceHighlightParents;
            final /* synthetic */ Runnable val$after1;
            final /* synthetic */ List val$ranges2;
            {
                this.val$skipParentsSet = set;
                this.val$holder = highlightInfoHolder;
                this.val$visitors = highlightVisitorArray;
                this.val$insideResult = list4;
                this.val$outsideResult = list5;
                this.val$forceHighlightParents = bl;
                this.val$after1 = runnable;
                this.val$ranges2 = list6;
            }

            @Override
            public void run() {
                Stack nested = new Stack();
                boolean failed = false;
                List ranges = ranges1;
                for (List elements : new List[]{elements1, elements2}) {
                    nested.clear();
                    int nextLimit = chunkSize;
                    for (int i = 0; i < elements.size(); ++i) {
                        PsiElement element = (PsiElement)elements.get(i);
                        progress.checkCanceled();
                        PsiElement parent = element.getParent();
                        if (element != GeneralHighlightingPass.this.myFile && !this.val$skipParentsSet.isEmpty() && element.getFirstChild() != null && this.val$skipParentsSet.contains(element)) {
                            this.val$skipParentsSet.add(parent);
                            continue;
                        }
                        boolean isErrorElement = element instanceof PsiErrorElement;
                        if (isErrorElement) {
                            GeneralHighlightingPass.this.myHasErrorElement = true;
                        }
                        this.val$holder.clear();
                        for (HighlightVisitor visitor : this.val$visitors) {
                            try {
                                visitor.visit(element);
                            }
                            catch (ProcessCanceledException e) {
                                throw e;
                            }
                            catch (IndexNotReadyException e) {
                                throw e;
                            }
                            catch (Exception e) {
                                if (!failed) {
                                    LOG.error((Throwable)e);
                                }
                                failed = true;
                            }
                        }
                        if (i == nextLimit) {
                            GeneralHighlightingPass.this.advanceProgress(chunkSize);
                            nextLimit = i + chunkSize;
                        }
                        TextRange elementRange = (TextRange)ranges.get(i);
                        List<HighlightInfo> infosForThisRange = this.val$holder.size() == 0 ? null : new ArrayList<HighlightInfo>(this.val$holder.size());
                        for (int j = 0; j < this.val$holder.size(); ++j) {
                            boolean isError;
                            List result;
                            HighlightInfo info = this.val$holder.get(j);
                            assert (info != null);
                            if (!GeneralHighlightingPass.this.myRestrictRange.containsRange(info.getStartOffset(), info.getEndOffset())) continue;
                            List list = result = GeneralHighlightingPass.this.myPriorityRange.containsRange(info.getStartOffset(), info.getEndOffset()) && !(element instanceof PsiFile) ? this.val$insideResult : this.val$outsideResult;
                            if (!result.add(info)) continue;
                            boolean bl = isError = info.getSeverity() == HighlightSeverity.ERROR;
                            if (isError) {
                                if (!this.val$forceHighlightParents) {
                                    this.val$skipParentsSet.add(parent);
                                }
                                GeneralHighlightingPass.this.myErrorFound = true;
                            }
                            info.setBijective(elementRange.equalsToRange(info.startOffset, info.endOffset) || isErrorElement);
                            GeneralHighlightingPass.this.myHighlightInfoProcessor.infoIsAvailable(GeneralHighlightingPass.this.myHighlightingSession, info);
                            infosForThisRange.add(info);
                        }
                        while (!nested.isEmpty() && elementRange.contains((TextRange)((Pair)nested.peek()).first)) {
                            Pair old = (Pair)nested.pop();
                            if (!elementRange.equals(old.first)) continue;
                            if (infosForThisRange == null) {
                                infosForThisRange = (List)old.second;
                                continue;
                            }
                            if (old.second == null) continue;
                            infosForThisRange.addAll((Collection)old.second);
                        }
                        nested.push((Object)Pair.create((Object)elementRange, infosForThisRange));
                        if (parent != null && Comparing.equal((Object)elementRange, (Object)parent.getTextRange())) continue;
                        GeneralHighlightingPass.this.myHighlightInfoProcessor.allHighlightsForRangeAreProduced(GeneralHighlightingPass.this.myHighlightingSession, elementRange, infosForThisRange);
                    }
                    GeneralHighlightingPass.this.advanceProgress(elements.size() - (nextLimit - chunkSize));
                    if (elements != elements1) continue;
                    this.val$after1.run();
                    ranges = this.val$ranges2;
                }
            }
        };
        this.analyzeByVisitors(progress, visitors, holder, 0, action);
    }

    private void analyzeByVisitors(final @NotNull ProgressIndicator progress, final @NotNull HighlightVisitor[] visitors, final @NotNull HighlightInfoHolder holder, final int i, final @NotNull Runnable action) {
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "analyzeByVisitors"));
        }
        if (visitors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitors", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "analyzeByVisitors"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "analyzeByVisitors"));
        }
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "analyzeByVisitors"));
        }
        if (i == visitors.length) {
            action.run();
        } else if (!visitors[i].analyze(this.myFile, this.myUpdateAll, holder, new Runnable(){

            @Override
            public void run() {
                GeneralHighlightingPass.this.analyzeByVisitors(progress, visitors, holder, i + 1, action);
            }
        })) {
            GeneralHighlightingPass.cancelAndRestartDaemonLater(progress, this.myProject, this);
        }
    }

    static void cancelAndRestartDaemonLater(@NotNull ProgressIndicator progress, final @NotNull Project project, @NotNull TextEditorHighlightingPass passCalledFrom) throws ProcessCanceledException {
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "cancelAndRestartDaemonLater"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "cancelAndRestartDaemonLater"));
        }
        if (passCalledFrom == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "passCalledFrom", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "cancelAndRestartDaemonLater"));
        }
        progress.cancel();
        JobScheduler.getScheduler().schedule(new Runnable(){

            @Override
            public void run() {
                Application application = ApplicationManager.getApplication();
                if (!(project.isDisposed() || application.isDisposed() || application.isUnitTestMode())) {
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            DaemonCodeAnalyzer.getInstance((Project)project).restart();
                        }
                    }, project.getDisposed());
                }
            }
        }, (long)RESTART_DAEMON_RANDOM.nextInt(100), TimeUnit.MILLISECONDS);
        throw new ProcessCanceledException();
    }

    private boolean forceHighlightParents() {
        boolean forceHighlightParents = false;
        for (HighlightRangeExtension extension : (HighlightRangeExtension[])Extensions.getExtensions(HighlightRangeExtension.EP_NAME)) {
            if (!extension.isForceHighlightParents(this.myFile)) continue;
            forceHighlightParents = true;
            break;
        }
        return forceHighlightParents;
    }

    protected HighlightInfoHolder createInfoHolder(PsiFile file) {
        HighlightInfoFilter[] filters = (HighlightInfoFilter[])HighlightInfoFilter.EXTENSION_POINT_NAME.getExtensions();
        return new CustomHighlightInfoHolder(file, this.getColorsScheme(), filters);
    }

    protected static void highlightTodos(@NotNull PsiFile file, @NotNull CharSequence text, int startOffset, int endOffset, @NotNull ProgressIndicator progress, @NotNull ProperTextRange priorityRange, @NotNull Collection<HighlightInfo> insideResult, @NotNull Collection<HighlightInfo> outsideResult) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "highlightTodos"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "highlightTodos"));
        }
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "highlightTodos"));
        }
        if (priorityRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "priorityRange", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "highlightTodos"));
        }
        if (insideResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "insideResult", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "highlightTodos"));
        }
        if (outsideResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outsideResult", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "highlightTodos"));
        }
        PsiTodoSearchHelper helper = PsiTodoSearchHelper.SERVICE.getInstance((Project)file.getProject());
        if (helper == null) {
            return;
        }
        TodoItem[] todoItems = helper.findTodoItems(file, startOffset, endOffset);
        if (todoItems.length == 0) {
            return;
        }
        for (TodoItem todoItem : todoItems) {
            progress.checkCanceled();
            TextRange range = todoItem.getTextRange();
            String description = ((Object)text.subSequence(range.getStartOffset(), range.getEndOffset())).toString();
            TextAttributes attributes = todoItem.getPattern().getAttributes().getTextAttributes();
            HighlightInfo.Builder builder = HighlightInfo.newHighlightInfo(HighlightInfoType.TODO).range(range);
            builder.textAttributes(attributes);
            builder.descriptionAndTooltip(description);
            HighlightInfo info = builder.createUnconditionally();
            (priorityRange.containsRange(info.getStartOffset(), info.getEndOffset()) ? insideResult : outsideResult).add(info);
        }
    }

    private void reportErrorsToWolf() {
        if (!this.myFile.getViewProvider().isPhysical()) {
            return;
        }
        Project project = this.myFile.getProject();
        if (!PsiManager.getInstance((Project)project).isInProject((PsiElement)this.myFile)) {
            return;
        }
        VirtualFile file = this.myFile.getVirtualFile();
        if (file == null) {
            return;
        }
        List<Problem> problems = GeneralHighlightingPass.convertToProblems(this.getInfos(), file, this.myHasErrorElement);
        WolfTheProblemSolver wolf = WolfTheProblemSolver.getInstance((Project)project);
        boolean hasErrors = DaemonCodeAnalyzerEx.hasErrors(project, this.getDocument());
        if (!hasErrors || this.isWholeFileHighlighting()) {
            wolf.reportProblems(file, problems);
        } else {
            wolf.weHaveGotProblems(file, problems);
        }
    }

    @Override
    public double getProgress() {
        return this.myUpdateAll ? super.getProgress() : -1.0;
    }

    private static List<Problem> convertToProblems(@NotNull Collection<HighlightInfo> infos, @NotNull VirtualFile file, boolean hasErrorElement) {
        if (infos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "infos", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "convertToProblems"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "convertToProblems"));
        }
        SmartList problems = new SmartList();
        for (HighlightInfo info : infos) {
            if (info.getSeverity() != HighlightSeverity.ERROR) continue;
            ProblemImpl problem = new ProblemImpl(file, info, hasErrorElement);
            problems.add(problem);
        }
        return problems;
    }

    @Override
    public String toString() {
        return super.toString() + " updateAll=" + this.myUpdateAll + " range=(" + this.myStartOffset + "," + this.myEndOffset + ")";
    }
}

