/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.actions.BaseCodeInsightAction;
import com.intellij.codeInsight.editorActions.emacs.EmacsProcessingHandler;
import com.intellij.codeInsight.editorActions.emacs.LanguageEmacsExtension;
import com.intellij.lang.LanguageFormatting;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class EmacsStyleIndentAction
extends BaseCodeInsightAction
implements DumbAware {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.generation.actions.EmacsStyleIndentAction");

    @NotNull
    protected CodeInsightActionHandler getHandler() {
        Handler handler = new Handler();
        if (handler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/editorActions/EmacsStyleIndentAction", "getHandler"));
        }
        return handler;
    }

    protected boolean isValidForFile(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/editorActions/EmacsStyleIndentAction", "isValidForFile"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/editorActions/EmacsStyleIndentAction", "isValidForFile"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/editorActions/EmacsStyleIndentAction", "isValidForFile"));
        }
        PsiElement context = file.findElementAt(editor.getCaretModel().getOffset());
        return context != null && LanguageFormatting.INSTANCE.forContext(context) != null;
    }

    private static class Handler
    implements CodeInsightActionHandler {
        private Handler() {
        }

        public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
            EmacsProcessingHandler.Result result;
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/editorActions/EmacsStyleIndentAction$Handler", "invoke"));
            }
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/editorActions/EmacsStyleIndentAction$Handler", "invoke"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/editorActions/EmacsStyleIndentAction$Handler", "invoke"));
            }
            if (!CodeInsightUtilBase.prepareEditorForWrite(editor)) {
                return;
            }
            PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
            if (!FileDocumentManager.getInstance().requestWriting(editor.getDocument(), project)) {
                return;
            }
            EmacsProcessingHandler emacsProcessingHandler = (EmacsProcessingHandler)LanguageEmacsExtension.INSTANCE.forLanguage(file.getLanguage());
            if (emacsProcessingHandler != null && (result = emacsProcessingHandler.changeIndent(project, editor, file)) == EmacsProcessingHandler.Result.STOP) {
                return;
            }
            Document document = editor.getDocument();
            int startOffset = editor.getCaretModel().getOffset();
            int line = editor.offsetToLogicalPosition((int)startOffset).line;
            int col = editor.getCaretModel().getLogicalPosition().column;
            int lineStart = document.getLineStartOffset(line);
            int initLineEnd = document.getLineEndOffset(line);
            try {
                CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
                int newPos = codeStyleManager.adjustLineIndent(file, lineStart);
                int newCol = newPos - lineStart;
                int lineInc = document.getLineEndOffset(line) - initLineEnd;
                if (newCol >= col + lineInc && newCol >= 0) {
                    LogicalPosition pos = new LogicalPosition(line, newCol);
                    editor.getCaretModel().moveToLogicalPosition(pos);
                    editor.getSelectionModel().removeSelection();
                    editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
                }
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }

        public boolean startInWriteAction() {
            return true;
        }
    }
}

