/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.BackspaceHandlerDelegate;
import com.intellij.codeStyle.CodeStyleFacade;
import com.intellij.formatting.FormatterEx;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelBuilder;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageFormatting;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;

public class IndentingBackspaceHandler
extends BackspaceHandlerDelegate {
    private static final Logger LOG = Logger.getInstance(IndentingBackspaceHandler.class);
    private boolean isApplicable;
    private boolean caretWasAtLineStart;
    private String precalculatedSpacing;

    public void beforeCharDeleted(char c, PsiFile file, Editor editor) {
        int prevLineEnd;
        if (CodeInsightSettings.getInstance().SMART_BACKSPACE != 1 || !StringUtil.isWhiteSpace((char)c)) {
            this.isApplicable = false;
            return;
        }
        LanguageCodeStyleSettingsProvider codeStyleSettingsProvider = LanguageCodeStyleSettingsProvider.forLanguage((Language)file.getLanguage());
        if (codeStyleSettingsProvider != null && codeStyleSettingsProvider.isIndentBasedLanguageSemantics()) {
            this.isApplicable = false;
            return;
        }
        Document document = editor.getDocument();
        CharSequence charSequence = document.getCharsSequence();
        CaretModel caretModel = editor.getCaretModel();
        int caretOffset = caretModel.getOffset();
        LogicalPosition pos = caretModel.getLogicalPosition();
        this.isApplicable = true;
        this.caretWasAtLineStart = pos.column == 0;
        this.precalculatedSpacing = null;
        if (this.caretWasAtLineStart && pos.line > 0 && caretOffset < charSequence.length() && !StringUtil.isWhiteSpace((char)charSequence.charAt(caretOffset)) && (prevLineEnd = document.getLineEndOffset(pos.line - 1)) > 0 && !StringUtil.isWhiteSpace((char)charSequence.charAt(prevLineEnd - 1))) {
            PsiDocumentManager.getInstance((Project)file.getProject()).commitDocument(document);
            this.precalculatedSpacing = IndentingBackspaceHandler.getSpacing(file, caretOffset);
        }
    }

    public boolean charDeleted(char c, PsiFile file, Editor editor) {
        if (!this.isApplicable) {
            return false;
        }
        Project project = file.getProject();
        Document document = editor.getDocument();
        CaretModel caretModel = editor.getCaretModel();
        int caretOffset = caretModel.getOffset();
        int offset = CharArrayUtil.shiftForward((CharSequence)document.getCharsSequence(), (int)caretOffset, (String)" \t");
        int beforeWhitespaceOffset = CharArrayUtil.shiftBackward((CharSequence)document.getCharsSequence(), (int)(offset - 1), (String)" \t") + 1;
        LogicalPosition logicalPosition = caretOffset < offset ? editor.offsetToLogicalPosition(offset) : caretModel.getLogicalPosition();
        int lineStartOffset = document.getLineStartOffset(logicalPosition.line);
        if (lineStartOffset < beforeWhitespaceOffset) {
            if (this.caretWasAtLineStart && beforeWhitespaceOffset <= offset) {
                String spacing;
                if (this.precalculatedSpacing == null) {
                    PsiDocumentManager.getInstance((Project)project).commitDocument(document);
                    spacing = IndentingBackspaceHandler.getSpacing(file, offset);
                } else {
                    spacing = this.precalculatedSpacing;
                }
                if (beforeWhitespaceOffset < offset || !spacing.isEmpty()) {
                    document.replaceString(beforeWhitespaceOffset, offset, (CharSequence)spacing);
                    caretModel.moveToOffset(beforeWhitespaceOffset + spacing.length());
                    return true;
                }
            }
            return false;
        }
        PsiDocumentManager.getInstance((Project)project).commitDocument(document);
        CodeStyleFacade codeStyleFacade = CodeStyleFacade.getInstance((Project)project);
        String indent = codeStyleFacade.getLineIndent(document, offset);
        if (indent == null) {
            return false;
        }
        int tabSize = IndentingBackspaceHandler.getTabSize(codeStyleFacade, document);
        int targetColumn = IndentingBackspaceHandler.getWidth(indent, tabSize);
        if (logicalPosition.column == targetColumn) {
            if (caretOffset < offset) {
                caretModel.moveToLogicalPosition(logicalPosition);
                return true;
            }
            return false;
        }
        if (this.caretWasAtLineStart || logicalPosition.column > targetColumn) {
            document.replaceString(lineStartOffset, offset, (CharSequence)indent);
            caretModel.moveToLogicalPosition(new LogicalPosition(logicalPosition.line, targetColumn));
            return true;
        }
        if (logicalPosition.line == 0) {
            return false;
        }
        int prevLineStartOffset = document.getLineStartOffset(logicalPosition.line - 1);
        int prevLineEndOffset = document.getLineEndOffset(logicalPosition.line - 1);
        int targetOffset = CharArrayUtil.shiftBackward((CharSequence)document.getCharsSequence(), (int)(prevLineEndOffset - 1), (String)" \t") + 1;
        if (prevLineStartOffset < targetOffset) {
            String spacing = IndentingBackspaceHandler.getSpacing(file, offset);
            document.replaceString(targetOffset, offset, (CharSequence)spacing);
            caretModel.moveToOffset(targetOffset + spacing.length());
        } else {
            document.replaceString(prevLineStartOffset, offset, (CharSequence)indent);
            caretModel.moveToLogicalPosition(new LogicalPosition(logicalPosition.line - 1, targetColumn));
        }
        return true;
    }

    private static int getTabSize(@NotNull CodeStyleFacade codeStyleFacade, @NotNull Document document) {
        if (codeStyleFacade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codeStyleFacade", "com/intellij/codeInsight/editorActions/IndentingBackspaceHandler", "getTabSize"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/editorActions/IndentingBackspaceHandler", "getTabSize"));
        }
        VirtualFile file = FileDocumentManager.getInstance().getFile(document);
        FileType fileType = file == null ? null : file.getFileType();
        return codeStyleFacade.getTabSize(fileType);
    }

    private static int getWidth(@NotNull String indent, int tabSize) {
        if (indent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indent", "com/intellij/codeInsight/editorActions/IndentingBackspaceHandler", "getWidth"));
        }
        int width = 0;
        block4: for (int i = 0; i < indent.length(); ++i) {
            char c = indent.charAt(i);
            switch (c) {
                case '\t': {
                    width = tabSize * (width / tabSize + 1);
                    continue block4;
                }
                default: {
                    LOG.error("Unexpected whitespace character: " + c);
                }
                case ' ': {
                    ++width;
                }
            }
        }
        return width;
    }

    private static String getSpacing(PsiFile file, int offset) {
        FormattingModelBuilder builder = LanguageFormatting.INSTANCE.forContext((PsiElement)file);
        if (builder == null) {
            return "";
        }
        CodeStyleSettings settings = CodeStyleSettingsManager.getSettings((Project)file.getProject());
        FormattingModel model = builder.createModel((PsiElement)file, settings);
        int spacing = FormatterEx.getInstance().getSpacingForBlockAtOffset(model, offset);
        return StringUtil.repeatSymbol((char)' ', (int)spacing);
    }
}

