/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.highlighting.HighlightHandlerBase;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandler;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Consumer;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class HighlightUsagesHandlerBase<T extends PsiElement> {
    protected final Editor myEditor;
    protected final PsiFile myFile;
    protected List<TextRange> myReadUsages = new ArrayList<TextRange>();
    protected List<TextRange> myWriteUsages = new ArrayList<TextRange>();
    protected String myStatusText;
    protected String myHintText;

    protected HighlightUsagesHandlerBase(Editor editor, PsiFile file) {
        this.myEditor = editor;
        this.myFile = file;
    }

    public void highlightUsages() {
        List<T> targets = this.getTargets();
        if (targets == null) {
            return;
        }
        this.selectTargets(targets, new Consumer<List<T>>(){

            public void consume(List<T> targets) {
                HighlightUsagesHandlerBase.this.computeUsages(targets);
                HighlightUsagesHandlerBase.this.performHighlighting();
            }
        });
    }

    protected void performHighlighting() {
        boolean clearHighlights = HighlightUsagesHandler.isClearHighlights(this.myEditor);
        EditorColorsManager manager = EditorColorsManager.getInstance();
        TextAttributes attributes = manager.getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
        TextAttributes writeAttributes = manager.getGlobalScheme().getAttributes(EditorColors.WRITE_SEARCH_RESULT_ATTRIBUTES);
        HighlightUsagesHandler.highlightRanges(HighlightManager.getInstance((Project)this.myEditor.getProject()), this.myEditor, attributes, clearHighlights, this.myReadUsages);
        HighlightUsagesHandler.highlightRanges(HighlightManager.getInstance((Project)this.myEditor.getProject()), this.myEditor, writeAttributes, clearHighlights, this.myWriteUsages);
        if (!clearHighlights) {
            WindowManager.getInstance().getStatusBar(this.myEditor.getProject()).setInfo(this.myStatusText);
            HighlightHandlerBase.setupFindModel(this.myEditor.getProject());
        }
        if (this.myHintText != null) {
            HintManager.getInstance().showInformationHint(this.myEditor, this.myHintText);
        }
    }

    protected void buildStatusText(@Nullable String elementName, int refCount) {
        if (refCount > 0) {
            this.myStatusText = CodeInsightBundle.message((String)(elementName != null ? "status.bar.highlighted.usages.message" : "status.bar.highlighted.usages.no.target.message"), (Object[])new Object[]{refCount, elementName, HighlightUsagesHandler.getShortcutText()});
        } else {
            this.myHintText = CodeInsightBundle.message((String)(elementName != null ? "status.bar.highlighted.usages.not.found.message" : "status.bar.highlighted.usages.not.found.no.target.message"), (Object[])new Object[]{elementName});
        }
    }

    public abstract List<T> getTargets();

    protected abstract void selectTargets(List<T> var1, Consumer<List<T>> var2);

    public abstract void computeUsages(List<T> var1);

    protected void addOccurrence(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/highlighting/HighlightUsagesHandlerBase", "addOccurrence"));
        }
        TextRange range = element.getTextRange();
        range = InjectedLanguageManager.getInstance((Project)element.getProject()).injectedToHost(element, range);
        this.myReadUsages.add(range);
    }

    public List<TextRange> getReadUsages() {
        return this.myReadUsages;
    }

    public List<TextRange> getWriteUsages() {
        return this.myWriteUsages;
    }
}

