/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.emmet.completion;

import com.intellij.application.options.emmet.EmmetCompositeConfigurable;
import com.intellij.application.options.emmet.EmmetOptions;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupActionProvider;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementAction;
import com.intellij.codeInsight.template.emmet.ZenCodingTemplate;
import com.intellij.codeInsight.template.impl.CustomLiveTemplateLookupElement;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.util.Consumer;
import com.intellij.util.PlatformIcons;

public class EmmetLookupActionProvider
implements LookupActionProvider {
    @Override
    public void fillActions(LookupElement element, final Lookup lookup, Consumer<LookupElementAction> consumer) {
        if (element instanceof CustomLiveTemplateLookupElement && ((CustomLiveTemplateLookupElement)element).getCustomLiveTemplate() instanceof ZenCodingTemplate) {
            consumer.consume((Object)new LookupElementAction(PlatformIcons.EDIT, "Edit Emmet settings"){

                @Override
                public LookupElementAction.Result performLookupAction() {
                    final Project project = lookup.getEditor().getProject();
                    assert (project != null);
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (project.isDisposed()) {
                                return;
                            }
                            EmmetCompositeConfigurable configurable = new EmmetCompositeConfigurable();
                            ShowSettingsUtil.getInstance().editConfigurable(project, (Configurable)configurable);
                        }
                    });
                    return LookupElementAction.Result.HIDE_LOOKUP;
                }
            });
            consumer.consume((Object)new LookupElementAction(AllIcons.Actions.Delete, String.format("Disable Emmet", new Object[0])){

                @Override
                public LookupElementAction.Result performLookupAction() {
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            EmmetOptions.getInstance().setEmmetEnabled(false);
                        }
                    });
                    return LookupElementAction.Result.HIDE_LOOKUP;
                }
            });
        }
    }
}

