/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.impl.TemplateColors;
import com.intellij.codeInsight.template.impl.TemplateContext;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateTextLexer;
import com.intellij.codeInsight.template.impl.TemplateTokenType;
import com.intellij.ide.DataManager;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.MergingLexerAdapter;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.LayerDescriptor;
import com.intellij.openapi.editor.ex.util.LayeredLexerEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.PlainSyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TemplateEditorUtil {
    private TemplateEditorUtil() {
    }

    public static Editor createEditor(boolean isReadOnly, CharSequence text) {
        return TemplateEditorUtil.createEditor(isReadOnly, text, null);
    }

    public static Editor createEditor(boolean isReadOnly, CharSequence text, @Nullable TemplateContext context) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext());
        return TemplateEditorUtil.createEditor(isReadOnly, TemplateEditorUtil.createDocument(text, context, project), project);
    }

    private static Document createDocument(CharSequence text, @Nullable TemplateContext context, Project project) {
        if (context != null) {
            for (TemplateContextType type : TemplateManagerImpl.getAllContextTypes()) {
                if (!context.isExplicitlyEnabled(type)) continue;
                return type.createDocument(text, project);
            }
        }
        return EditorFactory.getInstance().createDocument(text);
    }

    private static Editor createEditor(boolean isReadOnly, Document document, Project project) {
        EditorFactory editorFactory = EditorFactory.getInstance();
        Editor editor = isReadOnly ? editorFactory.createViewer(document, project) : editorFactory.createEditor(document, project);
        editor.getContentComponent().setFocusable(!isReadOnly);
        EditorSettings editorSettings = editor.getSettings();
        editorSettings.setVirtualSpace(false);
        editorSettings.setLineMarkerAreaShown(false);
        editorSettings.setIndentGuidesShown(false);
        editorSettings.setLineNumbersShown(false);
        editorSettings.setFoldingOutlineShown(false);
        EditorColorsScheme scheme = editor.getColorsScheme();
        scheme.setColor(EditorColors.CARET_ROW_COLOR, null);
        VirtualFile file = FileDocumentManager.getInstance().getFile(document);
        if (file != null) {
            EditorHighlighter highlighter = EditorHighlighterFactory.getInstance().createEditorHighlighter(file, scheme, project);
            ((EditorEx)editor).setHighlighter(highlighter);
        }
        return editor;
    }

    public static void setHighlighter(Editor editor, @Nullable TemplateContext templateContext) {
        SyntaxHighlighter highlighter = null;
        if (templateContext != null) {
            TemplateContextType type;
            TemplateContextType[] arr$ = TemplateManagerImpl.getAllContextTypes();
            int len$ = arr$.length;
            for (int i$ = 0; !(i$ >= len$ || templateContext.isEnabled(type = arr$[i$]) && (highlighter = type.createHighlighter()) != null); ++i$) {
            }
        }
        TemplateEditorUtil.setHighlighter((EditorEx)editor, highlighter);
    }

    public static void setHighlighter(@NotNull Editor editor, @Nullable TemplateContextType templateContextType) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/template/impl/TemplateEditorUtil", "setHighlighter"));
        }
        TemplateEditorUtil.setHighlighter((EditorEx)editor, templateContextType != null ? templateContextType.createHighlighter() : null);
    }

    private static void setHighlighter(EditorEx editor, @Nullable SyntaxHighlighter highlighter) {
        EditorColorsScheme editorColorsScheme = EditorColorsManager.getInstance().getGlobalScheme();
        LayeredLexerEditorHighlighter layeredHighlighter = new LayeredLexerEditorHighlighter((SyntaxHighlighter)new TemplateHighlighter(), editorColorsScheme);
        layeredHighlighter.registerLayer(TemplateTokenType.TEXT, new LayerDescriptor((SyntaxHighlighter)ObjectUtils.notNull((Object)highlighter, (Object)new PlainSyntaxHighlighter()), ""));
        editor.setHighlighter(layeredHighlighter);
    }

    private static class TemplateHighlighter
    extends SyntaxHighlighterBase {
        private final Lexer myLexer = new MergingLexerAdapter((Lexer)new TemplateTextLexer(), TokenSet.create((IElementType[])new IElementType[]{TemplateTokenType.TEXT}));

        @NotNull
        public Lexer getHighlightingLexer() {
            Lexer lexer = this.myLexer;
            if (lexer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/impl/TemplateEditorUtil$TemplateHighlighter", "getHighlightingLexer"));
            }
            return lexer;
        }

        @NotNull
        public TextAttributesKey[] getTokenHighlights(IElementType tokenType) {
            TextAttributesKey[] textAttributesKeyArray = tokenType == TemplateTokenType.VARIABLE ? TemplateHighlighter.pack((TextAttributesKey)TemplateColors.TEMPLATE_VARIABLE_ATTRIBUTES) : EMPTY;
            if (textAttributesKeyArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/impl/TemplateEditorUtil$TemplateHighlighter", "getTokenHighlights"));
            }
            return textAttributesKeyArray;
        }
    }
}

