/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInspection.bytecodeAnalysis.BytecodeAnalysisConverter;
import com.intellij.codeInspection.bytecodeAnalysis.Bytes;
import com.intellij.codeInspection.bytecodeAnalysis.CombinedAnalysis;
import com.intellij.codeInspection.bytecodeAnalysis.Direction;
import com.intellij.codeInspection.bytecodeAnalysis.DirectionResultPair;
import com.intellij.codeInspection.bytecodeAnalysis.Equation;
import com.intellij.codeInspection.bytecodeAnalysis.Final;
import com.intellij.codeInspection.bytecodeAnalysis.HEquations;
import com.intellij.codeInspection.bytecodeAnalysis.InOutAnalysis;
import com.intellij.codeInspection.bytecodeAnalysis.Key;
import com.intellij.codeInspection.bytecodeAnalysis.Method;
import com.intellij.codeInspection.bytecodeAnalysis.NonNullInAnalysis;
import com.intellij.codeInspection.bytecodeAnalysis.NullableInAnalysis;
import com.intellij.codeInspection.bytecodeAnalysis.NullableMethodAnalysis;
import com.intellij.codeInspection.bytecodeAnalysis.ProjectBytecodeAnalysis;
import com.intellij.codeInspection.bytecodeAnalysis.Value;
import com.intellij.codeInspection.bytecodeAnalysis.asm.ASMUtils;
import com.intellij.codeInspection.bytecodeAnalysis.asm.ControlFlowGraph;
import com.intellij.codeInspection.bytecodeAnalysis.asm.DFSTree;
import com.intellij.codeInspection.bytecodeAnalysis.asm.LeakingParameters;
import com.intellij.codeInspection.bytecodeAnalysis.asm.OriginsAnalysis;
import com.intellij.codeInspection.bytecodeAnalysis.asm.RichControlFlow;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Pair;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileContent;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.AnalyzerException;

public class ClassDataIndexer
implements DataIndexer<Bytes, HEquations, FileContent> {
    private static final int STABLE_FLAGS = 26;
    public static final Final<Key, Value> FINAL_TOP = new Final(Value.Top);
    public static final Final<Key, Value> FINAL_BOT = new Final(Value.Bot);
    public static final Final<Key, Value> FINAL_NOT_NULL = new Final(Value.NotNull);
    public static final Final<Key, Value> FINAL_NULL = new Final(Value.Null);
    private static final List<Equation<Key, Value>> EMPTY_EQUATIONS = Collections.EMPTY_LIST;

    @NotNull
    public Map<Bytes, HEquations> map(@NotNull FileContent inputData) {
        if (inputData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputData", "com/intellij/codeInspection/bytecodeAnalysis/ClassDataIndexer", "map"));
        }
        HashMap<Bytes, HEquations> map = new HashMap<Bytes, HEquations>();
        try {
            MessageDigest md = BytecodeAnalysisConverter.getMessageDigest();
            Map<Key, List<Equation<Key, Value>>> rawEquations = ClassDataIndexer.processClass(new ClassReader(inputData.getContent()), inputData.getFile().getPresentableUrl());
            for (Map.Entry<Key, List<Equation<Key, Value>>> entry : rawEquations.entrySet()) {
                Key primaryKey = entry.getKey();
                Key serKey = new Key(primaryKey.method, primaryKey.direction, true);
                List<Equation<Key, Value>> equations = entry.getValue();
                ArrayList<DirectionResultPair> result = new ArrayList<DirectionResultPair>(equations.size());
                for (Equation<Key, Value> equation : equations) {
                    result.add(BytecodeAnalysisConverter.convert(equation, md));
                }
                map.put(new Bytes(BytecodeAnalysisConverter.asmKey((Key)serKey, (MessageDigest)md).key), new HEquations(result, primaryKey.stable));
            }
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            ProjectBytecodeAnalysis.LOG.debug("Unexpected Error during indexing of bytecode", e);
        }
        HashMap<Bytes, HEquations> hashMap = map;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/bytecodeAnalysis/ClassDataIndexer", "map"));
        }
        return hashMap;
    }

    public static Map<Key, List<Equation<Key, Value>>> processClass(ClassReader classReader, final String presentableUrl) {
        final HashMap<Key, List<Equation<Key, Value>>> equations = new HashMap<Key, List<Equation<Key, Value>>>();
        classReader.accept(new ClassVisitor(327680){
            private String className;
            private boolean stableClass;

            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                this.className = name;
                this.stableClass = (access & 0x10) != 0;
                super.visit(version, access, name, signature, superName, interfaces);
            }

            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                final MethodNode node = new MethodNode(327680, access, name, desc, signature, exceptions);
                return new MethodVisitor(327680, (MethodVisitor)node){
                    private boolean jsr;

                    public void visitJumpInsn(int opcode, Label label) {
                        if (opcode == 168) {
                            this.jsr = true;
                        }
                        super.visitJumpInsn(opcode, label);
                    }

                    public void visitEnd() {
                        super.visitEnd();
                        Pair methodEquations = this.processMethod(node, this.jsr);
                        equations.put(methodEquations.first, methodEquations.second);
                    }
                };
            }

            private Pair<Key, List<Equation<Key, Value>>> processMethod(MethodNode methodNode, boolean jsr) {
                ProgressManager.checkCanceled();
                Type[] argumentTypes = Type.getArgumentTypes((String)methodNode.desc);
                Type resultType = Type.getReturnType((String)methodNode.desc);
                boolean isReferenceResult = ASMUtils.isReferenceType(resultType);
                boolean isBooleanResult = ASMUtils.isBooleanType(resultType);
                boolean isInterestingResult = isReferenceResult || isBooleanResult;
                Method method = new Method(this.className, methodNode.name, methodNode.desc);
                boolean stable = this.stableClass || (methodNode.access & 0x1A) != 0 || "<init>".equals(methodNode.name);
                Key primaryKey = new Key(method, Direction.Out, stable);
                if (argumentTypes.length == 0 && !isInterestingResult) {
                    return Pair.create((Object)primaryKey, (Object)EMPTY_EQUATIONS);
                }
                try {
                    ControlFlowGraph graph = ControlFlowGraph.build(this.className, methodNode, jsr);
                    if (graph.transitions.length > 0) {
                        boolean branching;
                        DFSTree dfs = DFSTree.build(graph.transitions, graph.edgeCount);
                        boolean bl = branching = !dfs.back.isEmpty();
                        if (!branching) {
                            for (int[] transition : graph.transitions) {
                                if (transition == null || transition.length <= 1) continue;
                                branching = true;
                                break;
                            }
                        }
                        if (branching) {
                            RichControlFlow richControlFlow = new RichControlFlow(graph, dfs);
                            if (richControlFlow.reducible()) {
                                return Pair.create((Object)primaryKey, this.processBranchingMethod(method, methodNode, richControlFlow, argumentTypes, isReferenceResult, isInterestingResult, stable, jsr));
                            }
                            ProjectBytecodeAnalysis.LOG.debug(method + ": CFG is not reducible");
                        } else {
                            return Pair.create((Object)primaryKey, this.processNonBranchingMethod(method, argumentTypes, graph, isReferenceResult, isBooleanResult, stable));
                        }
                    }
                    return Pair.create((Object)primaryKey, this.topEquations(method, argumentTypes, isReferenceResult, isInterestingResult, stable));
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Throwable e) {
                    ProjectBytecodeAnalysis.LOG.debug("Unexpected Error during processing of " + method + " in " + presentableUrl, e);
                    return Pair.create((Object)primaryKey, this.topEquations(method, argumentTypes, isReferenceResult, isInterestingResult, stable));
                }
            }

            private List<Equation<Key, Value>> processBranchingMethod(Method method, MethodNode methodNode, RichControlFlow richControlFlow, Type[] argumentTypes, boolean isReferenceResult, boolean isInterestingResult, boolean stable, boolean jsr) throws AnalyzerException {
                Equation<Key, Value> outEquation;
                ArrayList<Equation<Key, Value>> result = new ArrayList<Equation<Key, Value>>(argumentTypes.length * 4 + 2);
                boolean maybeLeakingParameter = isInterestingResult;
                for (Type argType : argumentTypes) {
                    if (!ASMUtils.isReferenceType(argType)) continue;
                    maybeLeakingParameter = true;
                    break;
                }
                LeakingParameters leakingParametersAndFrames = maybeLeakingParameter ? this.leakingParametersAndFrames(method, methodNode, argumentTypes, jsr) : null;
                boolean[] leakingParameters = leakingParametersAndFrames != null ? leakingParametersAndFrames.parameters : null;
                boolean[] leakingNullableParameters = leakingParametersAndFrames != null ? leakingParametersAndFrames.nullableParameters : null;
                boolean[] origins = isInterestingResult ? OriginsAnalysis.resultOrigins(leakingParametersAndFrames.frames, methodNode.instructions, richControlFlow.controlFlow) : null;
                Equation<Key, Value> equation = outEquation = isInterestingResult ? new InOutAnalysis(richControlFlow, Direction.Out, origins, stable).analyze() : null;
                if (isReferenceResult) {
                    result.add(outEquation);
                    result.add(new Equation<Key, Value>(new Key(method, Direction.NullableOut, stable), NullableMethodAnalysis.analyze(methodNode, origins, jsr)));
                }
                for (int i = 0; i < argumentTypes.length; ++i) {
                    boolean notNullParam = false;
                    if (!ASMUtils.isReferenceType(argumentTypes[i])) continue;
                    boolean possibleNPE = false;
                    if (leakingParameters[i]) {
                        NonNullInAnalysis notNullInAnalysis = new NonNullInAnalysis(richControlFlow, new Direction.In(i, 0), stable);
                        Equation<Key, Value> notNullParamEquation = notNullInAnalysis.analyze();
                        possibleNPE = notNullInAnalysis.possibleNPE;
                        notNullParam = notNullParamEquation.rhs.equals(FINAL_NOT_NULL);
                        result.add(notNullParamEquation);
                    } else {
                        result.add(new Equation<Key, Value>(new Key(method, new Direction.In(i, 0), stable), FINAL_TOP));
                    }
                    if (leakingNullableParameters[i]) {
                        if (notNullParam || possibleNPE) {
                            result.add(new Equation<Key, Value>(new Key(method, new Direction.In(i, 1), stable), FINAL_TOP));
                        } else {
                            result.add(new NullableInAnalysis(richControlFlow, new Direction.In(i, 1), stable).analyze());
                        }
                    } else {
                        result.add(new Equation<Key, Value>(new Key(method, new Direction.In(i, 1), stable), FINAL_NULL));
                    }
                    if (!isInterestingResult) continue;
                    if (leakingParameters[i]) {
                        if (notNullParam) {
                            result.add(new Equation<Key, Value>(new Key(method, new Direction.InOut(i, Value.Null), stable), FINAL_BOT));
                        } else {
                            result.add(new InOutAnalysis(richControlFlow, new Direction.InOut(i, Value.Null), origins, stable).analyze());
                        }
                        result.add(new InOutAnalysis(richControlFlow, new Direction.InOut(i, Value.NotNull), origins, stable).analyze());
                        continue;
                    }
                    result.add(new Equation(new Key(method, new Direction.InOut(i, Value.Null), stable), outEquation.rhs));
                    result.add(new Equation(new Key(method, new Direction.InOut(i, Value.NotNull), stable), outEquation.rhs));
                }
                return result;
            }

            private List<Equation<Key, Value>> processNonBranchingMethod(Method method, Type[] argumentTypes, ControlFlowGraph graph, boolean isReferenceResult, boolean isBooleanResult, boolean stable) throws AnalyzerException {
                ArrayList<Equation<Key, Value>> result = new ArrayList<Equation<Key, Value>>(argumentTypes.length * 4 + 2);
                CombinedAnalysis analyzer = new CombinedAnalysis(method, graph);
                analyzer.analyze();
                if (isReferenceResult) {
                    result.add(analyzer.outContractEquation(stable));
                    result.add(analyzer.nullableResultEquation(stable));
                }
                for (int i = 0; i < argumentTypes.length; ++i) {
                    Type argType = argumentTypes[i];
                    if (!ASMUtils.isReferenceType(argType)) continue;
                    result.add(analyzer.notNullParamEquation(i, stable));
                    result.add(analyzer.nullableParamEquation(i, stable));
                    if (!isReferenceResult && !isBooleanResult) continue;
                    result.add(analyzer.contractEquation(i, Value.Null, stable));
                    result.add(analyzer.contractEquation(i, Value.NotNull, stable));
                }
                return result;
            }

            private List<Equation<Key, Value>> topEquations(Method method, Type[] argumentTypes, boolean isReferenceResult, boolean isInterestingResult, boolean stable) {
                ArrayList<Equation<Key, Value>> result = new ArrayList<Equation<Key, Value>>(argumentTypes.length * 4 + 2);
                if (isReferenceResult) {
                    result.add(new Equation<Key, Value>(new Key(method, Direction.Out, stable), FINAL_TOP));
                    result.add(new Equation<Key, Value>(new Key(method, Direction.NullableOut, stable), FINAL_BOT));
                }
                for (int i = 0; i < argumentTypes.length; ++i) {
                    if (!ASMUtils.isReferenceType(argumentTypes[i])) continue;
                    result.add(new Equation<Key, Value>(new Key(method, new Direction.In(i, 0), stable), FINAL_TOP));
                    result.add(new Equation<Key, Value>(new Key(method, new Direction.In(i, 1), stable), FINAL_TOP));
                    if (!isInterestingResult) continue;
                    result.add(new Equation<Key, Value>(new Key(method, new Direction.InOut(i, Value.Null), stable), FINAL_TOP));
                    result.add(new Equation<Key, Value>(new Key(method, new Direction.InOut(i, Value.NotNull), stable), FINAL_TOP));
                }
                return result;
            }

            @NotNull
            private LeakingParameters leakingParametersAndFrames(Method method, MethodNode methodNode, Type[] argumentTypes, boolean jsr) throws AnalyzerException {
                LeakingParameters leakingParameters = argumentTypes.length < 32 ? LeakingParameters.buildFast(method.internalClassName, methodNode, jsr) : LeakingParameters.build(method.internalClassName, methodNode, jsr);
                if (leakingParameters == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/bytecodeAnalysis/ClassDataIndexer$1", "leakingParametersAndFrames"));
                }
                return leakingParameters;
            }
        }, 6);
        return equations;
    }
}

