/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl;

import com.intellij.compiler.ProblemsView;
import com.intellij.compiler.impl.ProblemsViewPanel;
import com.intellij.icons.AllIcons;
import com.intellij.ide.errorTreeView.ErrorTreeElement;
import com.intellij.ide.errorTreeView.ErrorViewStructure;
import com.intellij.ide.errorTreeView.GroupingElement;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.pom.Navigatable;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import com.intellij.util.ui.UIUtil;
import java.util.UUID;
import java.util.concurrent.Executor;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.PooledThreadExecutor;

public class ProblemsViewImpl
extends ProblemsView {
    private static final String PROBLEMS_TOOLWINDOW_ID = "Problems";
    private final ProblemsViewPanel myPanel;
    private final SequentialTaskExecutor myViewUpdater = new SequentialTaskExecutor((Executor)PooledThreadExecutor.INSTANCE);
    private final Icon myActiveIcon = AllIcons.Toolwindows.Problems;
    private final Icon myPassiveIcon = IconLoader.getDisabledIcon((Icon)this.myActiveIcon);

    public ProblemsViewImpl(final Project project, final ToolWindowManager wm) {
        super(project);
        this.myPanel = new ProblemsViewPanel(project);
        Disposer.register((Disposable)project, (Disposable)new Disposable(){

            public void dispose() {
                Disposer.dispose((Disposable)ProblemsViewImpl.this.myPanel);
            }
        });
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                if (project.isDisposed()) {
                    return;
                }
                final ToolWindow tw = wm.registerToolWindow(ProblemsViewImpl.PROBLEMS_TOOLWINDOW_ID, false, ToolWindowAnchor.BOTTOM, (Disposable)project, true);
                ProblemsViewImpl.this.updateIcon(false);
                Content content = ContentFactory.SERVICE.getInstance().createContent((JComponent)ProblemsViewImpl.this.myPanel, "", false);
                tw.getContentManager().addContent(content);
                Disposer.register((Disposable)project, (Disposable)new Disposable(){

                    public void dispose() {
                        tw.getContentManager().removeAllContents(true);
                    }
                });
            }
        });
    }

    @Override
    public void clearOldMessages(final @Nullable CompileScope scope, final @NotNull UUID currentSessionId) {
        if (currentSessionId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentSessionId", "com/intellij/compiler/impl/ProblemsViewImpl", "clearOldMessages"));
        }
        this.myViewUpdater.execute(new Runnable(){

            @Override
            public void run() {
                ProblemsViewImpl.this.updateIcon(!ProblemsViewImpl.this.cleanupChildrenRecursively(ProblemsViewImpl.this.myPanel.getErrorViewStructure().getRootElement(), scope, currentSessionId));
                ProblemsViewImpl.this.myPanel.reload();
            }
        });
    }

    private boolean cleanupChildrenRecursively(@NotNull Object fromElement, @Nullable CompileScope scope, @NotNull UUID currentSessionId) {
        if (fromElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromElement", "com/intellij/compiler/impl/ProblemsViewImpl", "cleanupChildrenRecursively"));
        }
        if (currentSessionId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentSessionId", "com/intellij/compiler/impl/ProblemsViewImpl", "cleanupChildrenRecursively"));
        }
        ErrorViewStructure structure = this.myPanel.getErrorViewStructure();
        ErrorTreeElement[] elements = structure.getChildElements(fromElement);
        if (elements.length == 0) {
            return true;
        }
        boolean result = false;
        for (ErrorTreeElement element : elements) {
            if (element instanceof GroupingElement) {
                VirtualFile file;
                if (scope != null && (file = ((GroupingElement)element).getFile()) != null && !scope.belongs(file.getUrl())) continue;
                if (!currentSessionId.equals(element.getData())) {
                    structure.removeElement(element);
                    result = true;
                    continue;
                }
                result |= this.cleanupChildrenRecursively(element, scope, currentSessionId);
                continue;
            }
            if (currentSessionId.equals(element.getData())) continue;
            structure.removeElement(element);
            result = true;
        }
        return result;
    }

    @Override
    public void addMessage(final int type, final @NotNull String[] text, final @Nullable String groupName, final @Nullable Navigatable navigatable, final @Nullable String exportTextPrefix, final @Nullable String rendererTextPrefix, final @Nullable UUID sessionId) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/compiler/impl/ProblemsViewImpl", "addMessage"));
        }
        this.myViewUpdater.execute(new Runnable(){

            @Override
            public void run() {
                ErrorViewStructure structure = ProblemsViewImpl.this.myPanel.getErrorViewStructure();
                GroupingElement group = structure.lookupGroupingElement(groupName);
                if (group != null && !sessionId.equals(group.getData())) {
                    structure.removeElement(group);
                }
                if (navigatable != null) {
                    ProblemsViewImpl.this.myPanel.addMessage(type, text, groupName, navigatable, exportTextPrefix, rendererTextPrefix, (Object)sessionId);
                } else {
                    ProblemsViewImpl.this.myPanel.addMessage(type, text, null, -1, -1, sessionId);
                }
                ProblemsViewImpl.this.updateIcon(true);
            }
        });
    }

    private void updateIcon(final boolean active) {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                ToolWindow tw = ToolWindowManager.getInstance((Project)ProblemsViewImpl.this.myProject).getToolWindow(ProblemsViewImpl.PROBLEMS_TOOLWINDOW_ID);
                if (tw != null) {
                    tw.setIcon(active ? ProblemsViewImpl.this.myActiveIcon : ProblemsViewImpl.this.myPassiveIcon);
                }
            }
        }, this.myProject.getDisposed());
    }

    @Override
    public void setProgress(String text, float fraction) {
        this.myPanel.setProgress(text, fraction);
    }

    @Override
    public void setProgress(String text) {
        this.myPanel.setProgressText(text);
    }

    @Override
    public void clearProgress() {
        this.myPanel.clearProgressData();
    }
}

