/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.server;

import com.google.protobuf.MessageLite;
import com.intellij.ProjectTopics;
import com.intellij.compiler.CompilerWorkspaceConfiguration;
import com.intellij.compiler.impl.javaCompiler.javac.JavacConfiguration;
import com.intellij.compiler.server.AutoMakeMessageHandler;
import com.intellij.compiler.server.BuildManagerListener;
import com.intellij.compiler.server.BuildMessageDispatcher;
import com.intellij.compiler.server.BuildProcessParametersProvider;
import com.intellij.compiler.server.BuilderMessageHandler;
import com.intellij.compiler.server.DefaultMessageHandler;
import com.intellij.compiler.server.MessageHandlerWrapper;
import com.intellij.compiler.server.impl.BuildProcessClasspathManager;
import com.intellij.execution.ExecutionAdapter;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.ide.DataManager;
import com.intellij.ide.PowerSaveMode;
import com.intellij.ide.file.BatchFileChangeListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.compiler.CompilationStatusListener;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompilerTopics;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.FileDocumentManagerImpl;
import com.intellij.openapi.fileTypes.impl.FileTypeManagerImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCoreUtil;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerAdapter;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.impl.JavaAwareProjectJdkTableImpl;
import com.intellij.openapi.roots.ModuleRootAdapter;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.impl.FileNameCache;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import com.intellij.util.containers.IntArrayList;
import com.intellij.util.io.storage.HeavyProcessLatch;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.net.NetUtils;
import gnu.trove.THashSet;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.handler.codec.protobuf.ProtobufDecoder;
import io.netty.handler.codec.protobuf.ProtobufEncoder;
import io.netty.handler.codec.protobuf.ProtobufVarint32FrameDecoder;
import io.netty.handler.codec.protobuf.ProtobufVarint32LengthFieldPrepender;
import java.awt.Component;
import java.awt.Container;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.tools.JavaCompiler;
import javax.tools.ToolProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.PooledThreadExecutor;
import org.jetbrains.io.ChannelRegistrar;
import org.jetbrains.io.NettyUtil;
import org.jetbrains.jps.api.CmdlineProtoUtil;
import org.jetbrains.jps.api.CmdlineRemoteProto;
import org.jetbrains.jps.api.RequestFuture;
import org.jetbrains.jps.cmdline.BuildMain;
import org.jetbrains.jps.cmdline.ClasspathBootstrap;
import org.jetbrains.jps.cmdline.Launcher;
import org.jetbrains.jps.incremental.Utils;

public class BuildManager
implements ApplicationComponent {
    public static final Key<Boolean> ALLOW_AUTOMAKE = Key.create((String)"_allow_automake_when_process_is_active_");
    private static final Key<String> FORCE_MODEL_LOADING_PARAMETER = Key.create((String)"_force_model_loading");
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.compiler.server.BuildManager");
    private static final String COMPILER_PROCESS_JDK_PROPERTY = "compiler.process.jdk";
    public static final String SYSTEM_ROOT = "compile-server";
    public static final String TEMP_DIR_NAME = "_temp_";
    private final boolean IS_UNIT_TEST_MODE;
    private static final String IWS_EXTENSION = ".iws";
    private static final String IPR_EXTENSION = ".ipr";
    private static final String IDEA_PROJECT_DIR_PATTERN = "/.idea/";
    private static final Function<String, Boolean> PATH_FILTER = SystemInfo.isFileSystemCaseSensitive ? new Function<String, Boolean>(){

        public Boolean fun(String s) {
            return !s.contains(BuildManager.IDEA_PROJECT_DIR_PATTERN) && !s.endsWith(BuildManager.IWS_EXTENSION) && !s.endsWith(BuildManager.IPR_EXTENSION);
        }
    } : new Function<String, Boolean>(){

        public Boolean fun(String s) {
            return !StringUtil.endsWithIgnoreCase((String)s, (String)BuildManager.IWS_EXTENSION) && !StringUtil.endsWithIgnoreCase((String)s, (String)BuildManager.IPR_EXTENSION) && !StringUtil.containsIgnoreCase((String)s, (String)BuildManager.IDEA_PROJECT_DIR_PATTERN);
        }
    };
    private final File mySystemDirectory;
    private final ProjectManager myProjectManager;
    private final Map<RequestFuture, Project> myAutomakeFutures = Collections.synchronizedMap(new HashMap());
    private final Map<String, RequestFuture> myBuildsInProgress = Collections.synchronizedMap(new HashMap());
    private final BuildProcessClasspathManager myClasspathManager = new BuildProcessClasspathManager();
    private final SequentialTaskExecutor myRequestsProcessor = new SequentialTaskExecutor((Executor)PooledThreadExecutor.INSTANCE);
    private final Map<String, ProjectData> myProjectDataMap = Collections.synchronizedMap(new HashMap());
    private final BuildManagerPeriodicTask myAutoMakeTask = new BuildManagerPeriodicTask(){

        @Override
        protected int getDelay() {
            return Registry.intValue((String)"compiler.automake.trigger.delay");
        }

        @Override
        protected void runTask() {
            BuildManager.this.runAutoMake();
        }
    };
    private final BuildManagerPeriodicTask myDocumentSaveTask = new BuildManagerPeriodicTask(){
        private final Semaphore mySemaphore = new Semaphore();
        private final Runnable mySaveDocsRunnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    ((FileDocumentManagerImpl)FileDocumentManager.getInstance()).saveAllDocuments(false);
                }
                finally {
                    mySemaphore.up();
                }
            }
        };

        @Override
        protected int getDelay() {
            return Registry.intValue((String)"compiler.document.save.trigger.delay");
        }

        @Override
        public void runTask() {
            if (this.shouldSaveDocuments()) {
                this.mySemaphore.down();
                ApplicationManager.getApplication().invokeLater(this.mySaveDocsRunnable, ModalityState.NON_MODAL);
                this.mySemaphore.waitFor();
            }
        }

        private boolean shouldSaveDocuments() {
            Project contextProject = BuildManager.this.getCurrentContextProject();
            return contextProject != null && BuildManager.canStartAutoMake(contextProject);
        }
    };
    private final ChannelRegistrar myChannelRegistrar = new ChannelRegistrar();
    private final BuildMessageDispatcher myMessageDispatcher = new BuildMessageDispatcher();
    private volatile int myListenPort = -1;
    @Nullable
    private final Charset mySystemCharset;

    public BuildManager(ProjectManager projectManager) {
        Application application = ApplicationManager.getApplication();
        this.IS_UNIT_TEST_MODE = application.isUnitTestMode();
        this.myProjectManager = projectManager;
        this.mySystemCharset = CharsetToolkit.getDefaultSystemCharset();
        String systemPath = PathManager.getSystemPath();
        File system = new File(systemPath);
        try {
            system = system.getCanonicalFile();
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
        this.mySystemDirectory = system;
        projectManager.addProjectManagerListener((ProjectManagerListener)new ProjectWatcher());
        MessageBusConnection conn = application.getMessageBus().connect();
        conn.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener.Adapter(){

            public void after(@NotNull List<? extends VFileEvent> events) {
                if (events == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/compiler/server/BuildManager$5", "after"));
                }
                if (this.shouldTriggerMake(events)) {
                    BuildManager.this.scheduleAutoMake();
                }
            }

            private boolean shouldTriggerMake(List<? extends VFileEvent> events) {
                if (PowerSaveMode.isEnabled()) {
                    return false;
                }
                Project project = null;
                ProjectFileIndex fileIndex = null;
                for (VFileEvent vFileEvent : events) {
                    VirtualFile eventFile = vFileEvent.getFile();
                    if (eventFile == null) continue;
                    if (!eventFile.isValid()) {
                        return true;
                    }
                    if (ProjectCoreUtil.isProjectOrWorkspaceFile((VirtualFile)eventFile)) continue;
                    if (project == null) {
                        project = BuildManager.this.getCurrentContextProject();
                        if (project == null) {
                            return false;
                        }
                        fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
                    }
                    if (!fileIndex.isInContent(eventFile)) continue;
                    return true;
                }
                return false;
            }
        });
        conn.subscribe(BatchFileChangeListener.TOPIC, (Object)new BatchFileChangeListener.Adapter(){

            @Override
            public void batchChangeStarted(Project project) {
                BuildManager.this.cancelAutoMakeTasks(project);
            }
        });
        EditorFactory.getInstance().getEventMulticaster().addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void documentChanged(DocumentEvent e) {
                BuildManager.this.scheduleProjectSave();
            }
        });
        ShutDownTracker.getInstance().registerShutdownTask(new Runnable(){

            @Override
            public void run() {
                BuildManager.this.stopListening();
            }
        });
    }

    private List<Project> getOpenProjects() {
        Project[] projects = this.myProjectManager.getOpenProjects();
        if (projects.length == 0) {
            return Collections.emptyList();
        }
        SmartList projectList = new SmartList();
        for (Project project : projects) {
            if (!BuildManager.isValidProject(project)) continue;
            projectList.add(project);
        }
        return projectList;
    }

    private static boolean isValidProject(@Nullable Project project) {
        return project != null && !project.isDisposed() && !project.isDefault() && project.isInitialized();
    }

    public static BuildManager getInstance() {
        return (BuildManager)ApplicationManager.getApplication().getComponent(BuildManager.class);
    }

    public void notifyFilesChanged(Collection<File> paths) {
        this.doNotify(paths, false);
    }

    public void notifyFilesDeleted(Collection<File> paths) {
        this.doNotify(paths, true);
    }

    public void runCommand(Runnable command) {
        this.myRequestsProcessor.submit(command);
    }

    private void doNotify(final Collection<File> paths, final boolean notifyDeletion) {
        this.runCommand(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ArrayList<String> filtered = new ArrayList<String>(paths.size());
                for (File file : paths) {
                    String path = FileUtil.toSystemIndependentName((String)file.getPath());
                    if (!((Boolean)PATH_FILTER.fun((Object)path)).booleanValue()) continue;
                    filtered.add(path);
                }
                if (filtered.isEmpty()) {
                    return;
                }
                Map map = BuildManager.this.myProjectDataMap;
                synchronized (map) {
                    if (BuildManager.this.IS_UNIT_TEST_MODE) {
                        if (notifyDeletion) {
                            LOG.info("Registering deleted paths: " + filtered);
                        } else {
                            LOG.info("Registering changed paths: " + filtered);
                        }
                    }
                    for (Map.Entry entry : BuildManager.this.myProjectDataMap.entrySet()) {
                        RequestFuture future;
                        ProjectData data = (ProjectData)entry.getValue();
                        if (notifyDeletion) {
                            data.addDeleted(filtered);
                        } else {
                            data.addChanged(filtered);
                        }
                        if ((future = (RequestFuture)BuildManager.this.myBuildsInProgress.get(entry.getKey())) == null || future.isCancelled() || future.isDone()) continue;
                        UUID sessionId = future.getRequestID();
                        Channel channel = BuildManager.this.myMessageDispatcher.getConnectedChannel(sessionId);
                        if (channel == null) continue;
                        CmdlineRemoteProto.Message.ControllerMessage message = CmdlineRemoteProto.Message.ControllerMessage.newBuilder().setType(CmdlineRemoteProto.Message.ControllerMessage.Type.FS_EVENT).setFsEvent(data.createNextEvent()).build();
                        channel.writeAndFlush((Object)CmdlineProtoUtil.toMessage((UUID)sessionId, (CmdlineRemoteProto.Message.ControllerMessage)message));
                    }
                }
            }
        });
    }

    public static void forceModelLoading(CompileContext context) {
        context.getCompileScope().putUserData(FORCE_MODEL_LOADING_PARAMETER, (Object)Boolean.TRUE.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearState(Project project) {
        String projectPath = BuildManager.getProjectPath(project);
        Map<String, ProjectData> map = this.myProjectDataMap;
        synchronized (map) {
            ProjectData data = this.myProjectDataMap.get(projectPath);
            if (data != null) {
                data.dropChanges();
            }
        }
        this.scheduleAutoMake();
    }

    public boolean isProjectWatched(Project project) {
        return this.myProjectDataMap.containsKey(BuildManager.getProjectPath(project));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public List<String> getFilesChangedSinceLastCompilation(Project project) {
        String projectPath = BuildManager.getProjectPath(project);
        Map<String, ProjectData> map = this.myProjectDataMap;
        synchronized (map) {
            ProjectData data = this.myProjectDataMap.get(projectPath);
            if (data != null && !data.myNeedRescan) {
                return BuildManager.convertToStringPaths(data.myChanged);
            }
            return null;
        }
    }

    private static List<String> convertToStringPaths(Collection<InternedPath> interned) {
        ArrayList<String> list = new ArrayList<String>(interned.size());
        for (InternedPath path : interned) {
            list.add(path.getValue());
        }
        return list;
    }

    @Nullable
    private static String getProjectPath(Project project) {
        String url = project.getPresentableUrl();
        if (url == null) {
            return null;
        }
        return VirtualFileManager.extractPath((String)url);
    }

    public void scheduleAutoMake() {
        if (!this.IS_UNIT_TEST_MODE && !PowerSaveMode.isEnabled()) {
            this.myAutoMakeTask.schedule();
        }
    }

    private void scheduleProjectSave() {
        if (!this.IS_UNIT_TEST_MODE && !PowerSaveMode.isEnabled()) {
            this.myDocumentSaveTask.schedule();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runAutoMake() {
        Project project = this.getCurrentContextProject();
        if (project == null || !BuildManager.canStartAutoMake(project)) {
            return;
        }
        List scopes = CmdlineProtoUtil.createAllModulesScopes((boolean)false);
        AutoMakeMessageHandler handler = new AutoMakeMessageHandler(project);
        RequestFuture future = this.scheduleBuild(project, false, true, false, scopes, Collections.<String>emptyList(), Collections.<String, String>emptyMap(), handler);
        if (future != null) {
            this.myAutomakeFutures.put(future, project);
            try {
                future.waitFor();
            }
            finally {
                this.myAutomakeFutures.remove(future);
            }
        }
    }

    private static boolean canStartAutoMake(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/compiler/server/BuildManager", "canStartAutoMake"));
        }
        if (project.isDisposed()) {
            return false;
        }
        CompilerWorkspaceConfiguration config = CompilerWorkspaceConfiguration.getInstance((Project)project);
        if (!config.MAKE_PROJECT_ON_SAVE) {
            return false;
        }
        return config.allowAutoMakeWhileRunningApplication() || !BuildManager.hasRunningProcess(project);
    }

    @Nullable
    private Project getCurrentContextProject() {
        return this.getContextProject(null);
    }

    @Nullable
    private Project getContextProject(@Nullable Window window) {
        Container _parent;
        List<Project> openProjects = this.getOpenProjects();
        if (openProjects.isEmpty()) {
            return null;
        }
        if (openProjects.size() == 1) {
            return openProjects.get(0);
        }
        if (window == null && (window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow()) == null) {
            return null;
        }
        Container comp = window;
        while ((_parent = comp.getParent()) != null) {
            comp = _parent;
        }
        Project project = null;
        if (comp instanceof IdeFrame) {
            project = ((IdeFrame)comp).getProject();
        }
        if (project == null) {
            project = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)comp));
        }
        return BuildManager.isValidProject(project) ? project : null;
    }

    private static boolean hasRunningProcess(Project project) {
        for (ProcessHandler handler : ExecutionManager.getInstance((Project)project).getRunningProcesses()) {
            if (handler.isProcessTerminated() || ((Boolean)ALLOW_AUTOMAKE.get((UserDataHolder)handler, (Object)Boolean.FALSE)).booleanValue()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<RequestFuture> cancelAutoMakeTasks(Project project) {
        SmartList futures = new SmartList();
        Map<RequestFuture, Project> map = this.myAutomakeFutures;
        synchronized (map) {
            for (Map.Entry<RequestFuture, Project> entry : this.myAutomakeFutures.entrySet()) {
                if (!entry.getValue().equals(project)) continue;
                RequestFuture future = entry.getKey();
                future.cancel(false);
                futures.add(future);
            }
        }
        return futures;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public RequestFuture scheduleBuild(final Project project, final boolean isRebuild, final boolean isMake, final boolean onlyCheckUpToDate, final List<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope> scopes, final Collection<String> paths, final Map<String, String> userData, DefaultMessageHandler messageHandler) {
        final String projectPath = BuildManager.getProjectPath(project);
        final UUID sessionId = UUID.randomUUID();
        final boolean isAutomake = messageHandler instanceof AutoMakeMessageHandler;
        final MessageHandlerWrapper handler = new MessageHandlerWrapper(messageHandler){

            @Override
            public void buildStarted(UUID sessionId) {
                super.buildStarted(sessionId);
                try {
                    ((BuildManagerListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(BuildManagerListener.TOPIC)).buildStarted(project, sessionId, isAutomake);
                }
                catch (Throwable e) {
                    LOG.error(e);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sessionTerminated(UUID sessionId) {
                try {
                    super.sessionTerminated(sessionId);
                }
                finally {
                    try {
                        ((BuildManagerListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(BuildManagerListener.TOPIC)).buildFinished(project, sessionId, isAutomake);
                    }
                    catch (Throwable e) {
                        LOG.error(e);
                    }
                }
            }
        };
        if (this.myListenPort < 0) {
            try {
                BuildManager buildManager = this;
                synchronized (buildManager) {
                    if (this.myListenPort < 0) {
                        this.myListenPort = this.startListening();
                    }
                }
            }
            catch (Exception e) {
                handler.handleFailure(sessionId, CmdlineProtoUtil.createFailure((String)e.getMessage(), null));
                handler.sessionTerminated(sessionId);
                return null;
            }
        }
        try {
            final RequestFuture future = new RequestFuture((Object)handler, sessionId, (RequestFuture.CancelAction)new RequestFuture.CancelAction<BuilderMessageHandler>(){

                public void cancel(RequestFuture<BuilderMessageHandler> future) throws Exception {
                    BuildManager.this.myMessageDispatcher.cancelSession(future.getRequestID());
                }
            });
            this.runCommand(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    block9: {
                        SequentialTaskExecutor projectTaskQueue;
                        CmdlineRemoteProto.Message.ControllerMessage.FSEvent currentFSChanges;
                        if (future.isCancelled() || project.isDisposed()) {
                            handler.sessionTerminated(sessionId);
                            future.setDone();
                            return;
                        }
                        CmdlineRemoteProto.Message.ControllerMessage.GlobalSettings globals = CmdlineRemoteProto.Message.ControllerMessage.GlobalSettings.newBuilder().setGlobalOptionsPath(PathManager.getOptionsPath()).build();
                        Map map = BuildManager.this.myProjectDataMap;
                        synchronized (map) {
                            ProjectData data = (ProjectData)BuildManager.this.myProjectDataMap.get(projectPath);
                            if (data == null) {
                                data = new ProjectData(new SequentialTaskExecutor((Executor)PooledThreadExecutor.INSTANCE));
                                BuildManager.this.myProjectDataMap.put(projectPath, data);
                            }
                            if (isRebuild || isAutomake && Registry.is((String)"compiler.automake.force.fs.rescan")) {
                                data.dropChanges();
                            }
                            if (BuildManager.this.IS_UNIT_TEST_MODE) {
                                LOG.info("Scheduling build for " + projectPath + "; CHANGED: " + new HashSet(BuildManager.convertToStringPaths(data.myChanged)) + "; DELETED: " + new HashSet(BuildManager.convertToStringPaths(data.myDeleted)));
                            }
                            currentFSChanges = data.getAndResetRescanFlag() ? null : data.createNextEvent();
                            projectTaskQueue = data.taskQueue;
                        }
                        CmdlineRemoteProto.Message.ControllerMessage params = isRebuild ? CmdlineProtoUtil.createBuildRequest((String)projectPath, (List)scopes, Collections.emptyList(), (Map)userData, (CmdlineRemoteProto.Message.ControllerMessage.GlobalSettings)globals, null) : (onlyCheckUpToDate ? CmdlineProtoUtil.createUpToDateCheckRequest((String)projectPath, (List)scopes, (Collection)paths, (Map)userData, (CmdlineRemoteProto.Message.ControllerMessage.GlobalSettings)globals, (CmdlineRemoteProto.Message.ControllerMessage.FSEvent)currentFSChanges) : CmdlineProtoUtil.createBuildRequest((String)projectPath, (List)scopes, isMake ? Collections.emptyList() : paths, (Map)userData, (CmdlineRemoteProto.Message.ControllerMessage.GlobalSettings)globals, (CmdlineRemoteProto.Message.ControllerMessage.FSEvent)currentFSChanges));
                        BuildManager.this.myMessageDispatcher.registerBuildMessageHandler(sessionId, new MessageHandlerWrapper(handler){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void sessionTerminated(UUID sessionId) {
                                try {
                                    super.sessionTerminated(sessionId);
                                }
                                finally {
                                    future.setDone();
                                }
                            }
                        }, params);
                        try {
                            projectTaskQueue.submit(new Runnable(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                public void run() {
                                    Throwable execFailure = null;
                                    try {
                                        if (project.isDisposed()) {
                                            return;
                                        }
                                        BuildManager.this.myBuildsInProgress.put(projectPath, future);
                                        OSProcessHandler processHandler = BuildManager.this.launchBuildProcess(project, BuildManager.this.myListenPort, sessionId);
                                        final StringBuilder stdErrOutput = new StringBuilder();
                                        processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                                            public void onTextAvailable(ProcessEvent event, Key outputType) {
                                                String text = event.getText();
                                                if (!StringUtil.isEmptyOrSpaces((String)text)) {
                                                    LOG.info("BUILDER_PROCESS [" + outputType.toString() + "]: " + text.trim());
                                                    if (stdErrOutput.length() < 1024 && ProcessOutputTypes.STDERR.equals((Object)outputType)) {
                                                        stdErrOutput.append(text);
                                                    }
                                                }
                                            }
                                        });
                                        processHandler.startNotify();
                                        boolean terminated = processHandler.waitFor();
                                        if (terminated) {
                                            int exitValue = processHandler.getProcess().exitValue();
                                            if (exitValue != 0) {
                                                StringBuilder msg = new StringBuilder();
                                                msg.append("Abnormal build process termination: ");
                                                if (stdErrOutput.length() > 0) {
                                                    msg.append("\n").append((CharSequence)stdErrOutput);
                                                } else {
                                                    msg.append("unknown error");
                                                }
                                                handler.handleFailure(sessionId, CmdlineProtoUtil.createFailure((String)msg.toString(), null));
                                            }
                                        } else {
                                            handler.handleFailure(sessionId, CmdlineProtoUtil.createFailure((String)"Disconnected from build process", null));
                                        }
                                    }
                                    catch (Throwable e) {
                                        execFailure = e;
                                    }
                                    finally {
                                        BuilderMessageHandler unregistered;
                                        BuildManager.this.myBuildsInProgress.remove(projectPath);
                                        if (BuildManager.this.myMessageDispatcher.getAssociatedChannel(sessionId) == null && (unregistered = BuildManager.this.myMessageDispatcher.unregisterBuildMessageHandler(sessionId)) != null) {
                                            if (execFailure != null) {
                                                unregistered.handleFailure(sessionId, CmdlineProtoUtil.createFailure((String)execFailure.getMessage(), (Throwable)execFailure));
                                            }
                                            unregistered.sessionTerminated(sessionId);
                                        }
                                    }
                                }
                            });
                        }
                        catch (Throwable e) {
                            BuilderMessageHandler unregistered = BuildManager.this.myMessageDispatcher.unregisterBuildMessageHandler(sessionId);
                            if (unregistered == null) break block9;
                            unregistered.handleFailure(sessionId, CmdlineProtoUtil.createFailure((String)e.getMessage(), (Throwable)e));
                            unregistered.sessionTerminated(sessionId);
                        }
                    }
                }
            });
            return future;
        }
        catch (Throwable e) {
            handler.handleFailure(sessionId, CmdlineProtoUtil.createFailure((String)e.getMessage(), (Throwable)e));
            handler.sessionTerminated(sessionId);
            return null;
        }
    }

    public void initComponent() {
    }

    public void disposeComponent() {
        this.stopListening();
    }

    @NotNull
    public String getComponentName() {
        if ("com.intellij.compiler.server.BuildManager" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/server/BuildManager", "getComponentName"));
        }
        return "com.intellij.compiler.server.BuildManager";
    }

    private OSProcessHandler launchBuildProcess(Project project, int port, UUID sessionId) throws ExecutionException {
        int debugPort;
        String vmExecutablePath;
        String compilerPath;
        JavaSdkVersion sdkVersion = null;
        String forcedCompiledJdkHome = Registry.stringValue((String)COMPILER_PROCESS_JDK_PROPERTY);
        if (StringUtil.isEmptyOrSpaces((String)forcedCompiledJdkHome)) {
            Sdk projectJdk = null;
            int sdkMinorVersion = 0;
            HashSet<Sdk> candidates = new HashSet<Sdk>();
            Sdk defaultSdk = ProjectRootManager.getInstance((Project)project).getProjectSdk();
            if (defaultSdk != null && defaultSdk.getSdkType() instanceof JavaSdkType) {
                candidates.add(defaultSdk);
            }
            for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
                Sdk sdk = ModuleRootManager.getInstance((Module)module).getSdk();
                if (sdk == null || !(sdk.getSdkType() instanceof JavaSdkType)) continue;
                candidates.add(sdk);
            }
            JavaSdk javaSdkType = JavaSdk.getInstance();
            for (Sdk candidate : candidates) {
                JavaSdkVersion candidateVersion;
                String vs = candidate.getVersionString();
                if (vs == null || (candidateVersion = javaSdkType.getVersion(vs)) == null) continue;
                int candidateMinorVersion = BuildManager.getMinorVersion(vs);
                if (projectJdk == null) {
                    sdkVersion = candidateVersion;
                    sdkMinorVersion = candidateMinorVersion;
                    projectJdk = candidate;
                    continue;
                }
                int result = candidateVersion.compareTo((Enum)sdkVersion);
                if (result <= 0 && (result != 0 || candidateMinorVersion <= sdkMinorVersion)) continue;
                sdkVersion = candidateVersion;
                sdkMinorVersion = candidateMinorVersion;
                projectJdk = candidate;
            }
            Sdk internalJdk = JavaAwareProjectJdkTableImpl.getInstanceEx().getInternalJdk();
            if (projectJdk == null || sdkVersion == null || !sdkVersion.isAtLeast(JavaSdkVersion.JDK_1_6)) {
                projectJdk = internalJdk;
            }
            JavaSdkType projectJdkType = (JavaSdkType)projectJdk.getSdkType();
            if (projectJdk.equals(internalJdk)) {
                JavaCompiler systemCompiler = ToolProvider.getSystemJavaCompiler();
                if (systemCompiler == null) {
                    throw new ExecutionException("No system java compiler is provided by the JRE. Make sure tools.jar is present in IntelliJ IDEA classpath.");
                }
                compilerPath = ClasspathBootstrap.getResourcePath(systemCompiler.getClass());
            } else {
                compilerPath = projectJdkType.getToolsPath(projectJdk);
                if (compilerPath == null) {
                    throw new ExecutionException("Cannot determine path to 'tools.jar' library for " + projectJdk.getName() + " (" + projectJdk.getHomePath() + ")");
                }
            }
            vmExecutablePath = projectJdkType.getVMExecutablePath(projectJdk);
        } else {
            compilerPath = new File(forcedCompiledJdkHome, "lib/tools.jar").getAbsolutePath();
            vmExecutablePath = new File(forcedCompiledJdkHome, "bin/java").getAbsolutePath();
        }
        CompilerWorkspaceConfiguration config = CompilerWorkspaceConfiguration.getInstance((Project)project);
        GeneralCommandLine cmdLine = new GeneralCommandLine();
        cmdLine.setExePath(vmExecutablePath);
        int heapSize = config.getProcessHeapSize(JavacConfiguration.getOptions((Project)project, JavacConfiguration.class).MAXIMUM_HEAP_SIZE);
        cmdLine.addParameter("-Xmx" + heapSize + "m");
        if (SystemInfo.isMac && sdkVersion != null && JavaSdkVersion.JDK_1_6.equals(sdkVersion) && Registry.is((String)"compiler.process.32bit.vm.on.mac")) {
            cmdLine.addParameter("-d32");
        }
        cmdLine.addParameter("-Djava.awt.headless=true");
        cmdLine.addParameter("-Djava.endorsed.dirs=\"\"");
        if (this.IS_UNIT_TEST_MODE) {
            cmdLine.addParameter("-Dtest.mode=true");
        }
        cmdLine.addParameter("-Djdt.compiler.useSingleThread=true");
        String shouldGenerateIndex = System.getProperty("generate.classpath.index");
        if (shouldGenerateIndex != null) {
            cmdLine.addParameter("-Dgenerate.classpath.index=" + shouldGenerateIndex);
        }
        cmdLine.addParameter("-Dcompile.parallel=" + Boolean.toString(config.PARALLEL_COMPILATION));
        cmdLine.addParameter("-Drebuild.on.dependency.change=" + Boolean.toString(config.REBUILD_ON_DEPENDENCY_CHANGE));
        if (Boolean.TRUE.equals(Boolean.valueOf(System.getProperty("java.net.preferIPv4Stack", "false")))) {
            cmdLine.addParameter("-Djava.net.preferIPv4Stack=true");
        }
        boolean isProfilingMode = false;
        String additionalOptions = config.COMPILER_PROCESS_ADDITIONAL_VM_OPTIONS;
        if (!StringUtil.isEmpty((String)additionalOptions)) {
            StringTokenizer tokenizer = new StringTokenizer(additionalOptions, " ", false);
            while (tokenizer.hasMoreTokens()) {
                String option = tokenizer.nextToken();
                if ("-Dprofiling.mode=true".equals(option)) {
                    isProfilingMode = true;
                }
                cmdLine.addParameter(option);
            }
        }
        if (isProfilingMode) {
            cmdLine.addParameter("-agentlib:yjpagent=disablej2ee,disablealloc,delay=10000,sessionname=ExternalBuild");
        }
        if ((debugPort = Registry.intValue((String)"compiler.process.debug.port")) > 0) {
            cmdLine.addParameter("-XX:+HeapDumpOnOutOfMemoryError");
            cmdLine.addParameter("-agentlib:jdwp=transport=dt_socket,server=y,suspend=y,address=" + debugPort);
        }
        if (!Registry.is((String)"compiler.process.use.memory.temp.cache")) {
            cmdLine.addParameter("-Duse.memory.temp.cache=false");
        }
        if (this.mySystemCharset != null) {
            cmdLine.setCharset(this.mySystemCharset);
            cmdLine.addParameter("-Dfile.encoding=" + this.mySystemCharset.name());
        }
        cmdLine.addParameter("-Djps.file.types.component.name=" + FileTypeManagerImpl.getFileTypeComponentName());
        for (String name : new String[]{"user.language", "user.country", "user.region", "idea.paths.selector"}) {
            String value = System.getProperty(name);
            if (value == null) continue;
            cmdLine.addParameter("-D" + name + "=" + value);
        }
        cmdLine.addParameter("-Didea.home.path=" + PathManager.getHomePath());
        cmdLine.addParameter("-Didea.config.path=" + PathManager.getConfigPath());
        cmdLine.addParameter("-Didea.plugins.path=" + PathManager.getPluginsPath());
        cmdLine.addParameter("-Djps.log.dir=" + FileUtil.toSystemIndependentName((String)this.getBuildLogDirectory().getAbsolutePath()));
        File workDirectory = this.getBuildSystemDirectory();
        workDirectory.mkdirs();
        cmdLine.addParameter("-Djava.io.tmpdir=" + FileUtil.toSystemIndependentName((String)workDirectory.getPath()) + "/" + TEMP_DIR_NAME);
        for (BuildProcessParametersProvider provider : (BuildProcessParametersProvider[])project.getExtensions(BuildProcessParametersProvider.EP_NAME)) {
            List<String> args = provider.getVMArguments();
            cmdLine.addParameters(args);
        }
        Class<Launcher> launcherClass = Launcher.class;
        ArrayList<String> launcherCp = new ArrayList<String>();
        launcherCp.add(ClasspathBootstrap.getResourcePath(launcherClass));
        launcherCp.add(compilerPath);
        ClasspathBootstrap.appendJavaCompilerClasspath(launcherCp);
        launcherCp.addAll(BuildProcessClasspathManager.getLauncherClasspath(project));
        cmdLine.addParameter("-classpath");
        cmdLine.addParameter(BuildManager.classpathToString(launcherCp));
        cmdLine.addParameter(launcherClass.getName());
        List cp = ClasspathBootstrap.getBuildProcessApplicationClasspath((boolean)true);
        cp.addAll(this.myClasspathManager.getBuildProcessPluginsClasspath(project));
        if (isProfilingMode) {
            cp.add(new File(workDirectory, "yjp-controller-api-redist.jar").getPath());
        }
        cmdLine.addParameter(BuildManager.classpathToString(cp));
        cmdLine.addParameter(BuildMain.class.getName());
        cmdLine.addParameter("127.0.0.1");
        cmdLine.addParameter(Integer.toString(port));
        cmdLine.addParameter(sessionId.toString());
        cmdLine.addParameter(FileUtil.toSystemIndependentName((String)workDirectory.getPath()));
        cmdLine.setWorkDirectory(workDirectory);
        Process process = cmdLine.createProcess();
        return new OSProcessHandler(process, null, this.mySystemCharset){

            protected boolean shouldDestroyProcessRecursively() {
                return true;
            }
        };
    }

    public File getBuildSystemDirectory() {
        return new File(this.mySystemDirectory, SYSTEM_ROOT);
    }

    public File getBuildLogDirectory() {
        return new File(PathManager.getLogPath(), "build-log");
    }

    @Nullable
    public File getProjectSystemDirectory(Project project) {
        String projectPath = BuildManager.getProjectPath(project);
        return projectPath != null ? Utils.getDataStorageRoot((File)this.getBuildSystemDirectory(), (String)projectPath) : null;
    }

    private static int getMinorVersion(String vs) {
        int dashIndex = vs.lastIndexOf(95);
        if (dashIndex >= 0) {
            char ch;
            StringBuilder builder = new StringBuilder();
            for (int idx = dashIndex + 1; idx < vs.length() && Character.isDigit(ch = vs.charAt(idx)); ++idx) {
                builder.append(ch);
            }
            if (builder.length() > 0) {
                try {
                    return Integer.parseInt(builder.toString());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return 0;
    }

    public void stopListening() {
        this.myChannelRegistrar.close();
    }

    private int startListening() throws Exception {
        ServerBootstrap bootstrap = NettyUtil.nioServerBootstrap((EventLoopGroup)new NioEventLoopGroup(1, (Executor)PooledThreadExecutor.INSTANCE));
        bootstrap.childHandler((ChannelHandler)new ChannelInitializer(){

            protected void initChannel(Channel channel) throws Exception {
                channel.pipeline().addLast(new ChannelHandler[]{BuildManager.this.myChannelRegistrar, new ProtobufVarint32FrameDecoder(), new ProtobufDecoder((MessageLite)CmdlineRemoteProto.Message.getDefaultInstance()), new ProtobufVarint32LengthFieldPrepender(), new ProtobufEncoder(), BuildManager.this.myMessageDispatcher});
            }
        });
        Channel serverChannel = bootstrap.bind(NetUtils.getLoopbackAddress(), 0).syncUninterruptibly().channel();
        this.myChannelRegistrar.add(serverChannel);
        return ((InetSocketAddress)serverChannel.localAddress()).getPort();
    }

    private static String classpathToString(List<String> cp) {
        StringBuilder builder = new StringBuilder();
        for (String file : cp) {
            if (builder.length() > 0) {
                builder.append(File.pathSeparator);
            }
            builder.append(FileUtil.toCanonicalPath((String)file));
        }
        return builder.toString();
    }

    private static class XInternedPath
    extends InternedPath {
        private XInternedPath(String path) {
            super(path);
        }

        @Override
        public String getValue() {
            if (this.myPath.length > 0) {
                StringBuilder buf = new StringBuilder();
                for (int element : this.myPath) {
                    buf.append("/").append(FileNameCache.getVFileName(element));
                }
                return buf.toString();
            }
            return "/";
        }
    }

    private static class WinInternedPath
    extends InternedPath {
        private WinInternedPath(String path) {
            super(path);
        }

        @Override
        public String getValue() {
            if (this.myPath.length == 1) {
                String name = ((Object)FileNameCache.getVFileName(this.myPath[0])).toString();
                return name.length() == 2 && name.endsWith(":") ? name + "/" : name;
            }
            StringBuilder buf = new StringBuilder();
            for (int element : this.myPath) {
                if (buf.length() > 0) {
                    buf.append("/");
                }
                buf.append(FileNameCache.getVFileName(element));
            }
            return buf.toString();
        }
    }

    private static abstract class InternedPath {
        protected final int[] myPath;

        protected InternedPath(String path) {
            IntArrayList list = new IntArrayList();
            StringTokenizer tokenizer = new StringTokenizer(path, "/", false);
            while (tokenizer.hasMoreTokens()) {
                String element = tokenizer.nextToken();
                list.add(FileNameCache.storeName(element));
            }
            this.myPath = list.toArray();
        }

        public abstract String getValue();

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            InternedPath path = (InternedPath)o;
            return Arrays.equals(this.myPath, path.myPath);
        }

        public int hashCode() {
            return Arrays.hashCode(this.myPath);
        }

        public static InternedPath create(String path) {
            return path.startsWith("/") ? new XInternedPath(path) : new WinInternedPath(path);
        }
    }

    private static class ProjectData {
        final SequentialTaskExecutor taskQueue;
        private final Set<InternedPath> myChanged = new THashSet();
        private final Set<InternedPath> myDeleted = new THashSet();
        private long myNextEventOrdinal = 0L;
        private boolean myNeedRescan = true;

        private ProjectData(SequentialTaskExecutor taskQueue) {
            this.taskQueue = taskQueue;
        }

        public void addChanged(Collection<String> paths) {
            if (!this.myNeedRescan) {
                for (String path : paths) {
                    InternedPath _path = InternedPath.create(path);
                    this.myDeleted.remove(_path);
                    this.myChanged.add(_path);
                }
            }
        }

        public void addDeleted(Collection<String> paths) {
            if (!this.myNeedRescan) {
                for (String path : paths) {
                    InternedPath _path = InternedPath.create(path);
                    this.myChanged.remove(_path);
                    this.myDeleted.add(_path);
                }
            }
        }

        public CmdlineRemoteProto.Message.ControllerMessage.FSEvent createNextEvent() {
            CmdlineRemoteProto.Message.ControllerMessage.FSEvent.Builder builder = CmdlineRemoteProto.Message.ControllerMessage.FSEvent.newBuilder();
            builder.setOrdinal(++this.myNextEventOrdinal);
            for (InternedPath path : this.myChanged) {
                builder.addChangedPaths(path.getValue());
            }
            this.myChanged.clear();
            for (InternedPath path : this.myDeleted) {
                builder.addDeletedPaths(path.getValue());
            }
            this.myDeleted.clear();
            return builder.build();
        }

        public boolean getAndResetRescanFlag() {
            boolean rescan = this.myNeedRescan;
            this.myNeedRescan = false;
            return rescan;
        }

        public void dropChanges() {
            this.myNeedRescan = true;
            this.myNextEventOrdinal = 0L;
            this.myChanged.clear();
            this.myDeleted.clear();
        }
    }

    private class ProjectWatcher
    extends ProjectManagerAdapter {
        private final Map<Project, MessageBusConnection> myConnections = new HashMap<Project, MessageBusConnection>();

        private ProjectWatcher() {
        }

        public void projectOpened(final Project project) {
            MessageBusConnection conn = project.getMessageBus().connect();
            this.myConnections.put(project, conn);
            conn.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootAdapter(){

                public void rootsChanged(ModuleRootEvent event) {
                    Object source = event.getSource();
                    if (source instanceof Project) {
                        BuildManager.this.clearState((Project)source);
                    }
                }
            });
            conn.subscribe(ExecutionManager.EXECUTION_TOPIC, (Object)new ExecutionAdapter(){

                public void processTerminated(@NotNull RunProfile runProfile, @NotNull ProcessHandler handler) {
                    if (runProfile == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runProfile", "com/intellij/compiler/server/BuildManager$ProjectWatcher$2", "processTerminated"));
                    }
                    if (handler == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/compiler/server/BuildManager$ProjectWatcher$2", "processTerminated"));
                    }
                    BuildManager.this.scheduleAutoMake();
                }
            });
            conn.subscribe(CompilerTopics.COMPILATION_STATUS, (Object)new CompilationStatusListener(){
                private final Set<String> myRootsToRefresh = new THashSet(FileUtil.PATH_HASHING_STRATEGY);

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void compilationFinished(boolean aborted, int errors, int warnings, CompileContext compileContext) {
                    String[] roots;
                    Set<String> set = this.myRootsToRefresh;
                    synchronized (set) {
                        roots = ArrayUtil.toStringArray(this.myRootsToRefresh);
                        this.myRootsToRefresh.clear();
                    }
                    ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                        @Override
                        public void run() {
                            if (project.isDisposed()) {
                                return;
                            }
                            ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
                            LocalFileSystem lfs = LocalFileSystem.getInstance();
                            HashSet<VirtualFile> filesToRefresh = new HashSet<VirtualFile>();
                            for (String root : roots) {
                                VirtualFile rootFile = lfs.refreshAndFindFileByPath(root);
                                if (rootFile == null || !fileIndex.isInSourceContent(rootFile)) continue;
                                filesToRefresh.add(rootFile);
                            }
                            if (!filesToRefresh.isEmpty()) {
                                lfs.refreshFiles(filesToRefresh, true, true, null);
                            }
                        }
                    });
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void fileGenerated(String outputRoot, String relativePath) {
                    Set<String> set = this.myRootsToRefresh;
                    synchronized (set) {
                        this.myRootsToRefresh.add(outputRoot);
                    }
                }
            });
            final String projectPath = BuildManager.getProjectPath(project);
            Disposer.register((Disposable)project, (Disposable)new Disposable(){

                public void dispose() {
                    BuildManager.this.myProjectDataMap.remove(projectPath);
                }
            });
            StartupManager.getInstance((Project)project).registerPostStartupActivity(new Runnable(){

                @Override
                public void run() {
                    BuildManager.this.scheduleAutoMake();
                }
            });
        }

        public boolean canCloseProject(Project project) {
            BuildManager.this.cancelAutoMakeTasks(project);
            return super.canCloseProject(project);
        }

        public void projectClosing(Project project) {
            for (RequestFuture future : BuildManager.this.cancelAutoMakeTasks(project)) {
                future.waitFor(500L, TimeUnit.MILLISECONDS);
            }
        }

        public void projectClosed(Project project) {
            BuildManager.this.myProjectDataMap.remove(BuildManager.getProjectPath(project));
            MessageBusConnection conn = this.myConnections.remove(project);
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    private static abstract class BuildManagerPeriodicTask
    implements Runnable {
        private final Alarm myAlarm = new Alarm(Alarm.ThreadToUse.SHARED_THREAD);
        private final AtomicBoolean myInProgress = new AtomicBoolean(false);
        private final Runnable myTaskRunnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    BuildManagerPeriodicTask.this.runTask();
                }
                finally {
                    BuildManagerPeriodicTask.this.myInProgress.set(false);
                }
            }
        };

        private BuildManagerPeriodicTask() {
        }

        public final void schedule() {
            this.myAlarm.cancelAllRequests();
            int delay = Math.max(100, this.getDelay());
            this.myAlarm.addRequest((Runnable)this, delay);
        }

        protected abstract int getDelay();

        protected abstract void runTask();

        @Override
        public final void run() {
            if (!HeavyProcessLatch.INSTANCE.isRunning() && !this.myInProgress.getAndSet(true)) {
                try {
                    ApplicationManager.getApplication().executeOnPooledThread(this.myTaskRunnable);
                }
                catch (RejectedExecutionException ignored) {
                    this.myInProgress.set(false);
                }
                catch (Throwable e) {
                    this.myInProgress.set(false);
                    throw new RuntimeException(e);
                }
            } else {
                this.schedule();
            }
        }
    }
}

