/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.actions.DebuggerAction;
import com.intellij.debugger.engine.evaluation.expression.Modifier;
import com.intellij.debugger.engine.events.DebuggerContextCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.FieldDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.LocalVariableDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.WatchItemDescriptor;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;

public class EditSourceAction
extends DebuggerAction {
    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(e.getDataContext());
        if (project == null) {
            return;
        }
        final DebuggerContextImpl debuggerContext = EditSourceAction.getDebuggerContext(e.getDataContext());
        final DebuggerTreeNodeImpl selectedNode = EditSourceAction.getSelectedNode(e.getDataContext());
        if (debuggerContext != null && selectedNode != null) {
            debuggerContext.getDebugProcess().getManagerThread().schedule(new DebuggerContextCommandImpl(debuggerContext){

                @Override
                public void threadAction() {
                    SourcePosition sourcePosition = EditSourceAction.this.getSourcePosition(selectedNode, debuggerContext);
                    if (sourcePosition != null) {
                        sourcePosition.navigate(true);
                    }
                }
            });
        }
    }

    private SourcePosition getSourcePosition(DebuggerTreeNodeImpl selectedNode, DebuggerContextImpl debuggerContext) {
        DebuggerTreeNodeImpl node = selectedNode;
        final DebuggerContextImpl context = debuggerContext;
        if (node == null || context == null) {
            return null;
        }
        final Project project = context.getProject();
        final DebuggerSession debuggerSession = context.getDebuggerSession();
        if (debuggerSession == null) {
            return null;
        }
        NodeDescriptorImpl nodeDescriptor = node.getDescriptor();
        if (nodeDescriptor instanceof WatchItemDescriptor) {
            Modifier modifier = ((WatchItemDescriptor)nodeDescriptor).getModifier();
            if (modifier == null) {
                return null;
            }
            nodeDescriptor = (NodeDescriptorImpl)modifier.getInspectItem(project);
        }
        final NodeDescriptorImpl nodeDescriptor1 = nodeDescriptor;
        return (SourcePosition)ApplicationManager.getApplication().runReadAction((Computable)new Computable<SourcePosition>(){

            public SourcePosition compute() {
                if (nodeDescriptor1 instanceof FieldDescriptorImpl && debuggerSession != null) {
                    return ((FieldDescriptorImpl)nodeDescriptor1).getSourcePosition(project, context);
                }
                if (nodeDescriptor1 instanceof LocalVariableDescriptorImpl && debuggerSession != null) {
                    return ((LocalVariableDescriptorImpl)nodeDescriptor1).getSourcePosition(project, context);
                }
                return null;
            }
        });
    }

    public void update(AnActionEvent e) {
        final Project project = (Project)CommonDataKeys.PROJECT.getData(e.getDataContext());
        final DebuggerContextImpl debuggerContext = EditSourceAction.getDebuggerContext(e.getDataContext());
        final DebuggerTreeNodeImpl node = EditSourceAction.getSelectedNode(e.getDataContext());
        final Presentation presentation = e.getPresentation();
        if (debuggerContext != null && debuggerContext.getDebugProcess() != null) {
            presentation.setEnabled(true);
            debuggerContext.getDebugProcess().getManagerThread().schedule(new DebuggerContextCommandImpl(debuggerContext){

                @Override
                public void threadAction() {
                    SourcePosition position = EditSourceAction.this.getSourcePosition(node, debuggerContext);
                    if (position == null) {
                        DebuggerInvocationUtil.swingInvokeLater(project, new Runnable(){

                            @Override
                            public void run() {
                                presentation.setEnabled(false);
                            }
                        });
                    }
                }
            });
        } else {
            presentation.setEnabled(false);
        }
        e.getPresentation().setText(ActionManager.getInstance().getAction("EditSource").getTemplatePresentation().getText());
    }
}

