/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.actions.AutoRendererAction;
import com.intellij.debugger.actions.DebuggerAction;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.engine.events.DebuggerContextCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.tree.render.NodeRenderer;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.impl.ui.tree.actions.XDebuggerTreeActionBase;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ViewAsGroup
extends ActionGroup
implements DumbAware {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.actions.ViewAsGroup");
    private AnAction[] myChildren = AnAction.EMPTY_ARRAY;

    public ViewAsGroup() {
        super(null, true);
    }

    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent e) {
        if (this.myChildren == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/actions/ViewAsGroup", "getChildren"));
        }
        return this.myChildren;
    }

    private static AnAction[] calcChildren(NodeDescriptorImpl[] descriptors) {
        AnAction[] viewAsActions;
        ArrayList<RendererAction> renderers = new ArrayList<RendererAction>();
        List<NodeRenderer> allRenderers = NodeRendererSettings.getInstance().getAllRenderers();
        boolean anyValueDescriptor = false;
        for (NodeRenderer nodeRenderer : allRenderers) {
            boolean allApp = true;
            for (NodeDescriptorImpl descriptor : descriptors) {
                if (!(descriptor instanceof ValueDescriptorImpl)) continue;
                anyValueDescriptor = true;
                ValueDescriptorImpl valueDescriptor = (ValueDescriptorImpl)descriptor;
                if (valueDescriptor.isValueValid() && nodeRenderer.isApplicable(valueDescriptor.getType())) continue;
                allApp = false;
                break;
            }
            if (!anyValueDescriptor) {
                return AnAction.EMPTY_ARRAY;
            }
            if (!allApp) continue;
            renderers.add(new RendererAction(nodeRenderer));
        }
        ArrayList<Object> children = new ArrayList<Object>();
        for (AnAction viewAsAction : viewAsActions = ((DefaultActionGroup)ActionManager.getInstance().getAction("Debugger.Representation")).getChildren(null)) {
            if (viewAsAction instanceof AutoRendererAction) {
                if (renderers.size() <= 1) continue;
                viewAsAction.getTemplatePresentation().setVisible(true);
                children.add(viewAsAction);
                continue;
            }
            children.add(viewAsAction);
        }
        if (!children.isEmpty()) {
            children.add(Separator.getInstance());
        }
        children.addAll(renderers);
        return children.toArray(new AnAction[children.size()]);
    }

    public void update(final AnActionEvent event) {
        if (!DebuggerAction.isFirstStart(event)) {
            return;
        }
        DebuggerContextImpl debuggerContext = DebuggerAction.getDebuggerContext(event.getDataContext());
        XValueNodeImpl node = XDebuggerTreeActionBase.getSelectedNode(event.getDataContext());
        if (node == null) {
            return;
        }
        final XValue container = (XValue)node.getValueContainer();
        if (!(container instanceof JavaValue)) {
            event.getPresentation().setEnabled(false);
            return;
        }
        DebugProcessImpl process = debuggerContext.getDebugProcess();
        if (process == null) {
            event.getPresentation().setEnabled(false);
            return;
        }
        process.getManagerThread().schedule(new DebuggerContextCommandImpl(debuggerContext){

            @Override
            public void threadAction() {
                ViewAsGroup.access$202(ViewAsGroup.this, ViewAsGroup.calcChildren(new NodeDescriptorImpl[]{((JavaValue)container).getDescriptor()}));
                DebuggerAction.enableAction(event, ViewAsGroup.this.myChildren.length > 0);
            }
        });
    }

    static /* synthetic */ AnAction[] access$202(ViewAsGroup x0, AnAction[] x1) {
        x0.myChildren = x1;
        return x1;
    }

    private static class RendererAction
    extends ToggleAction {
        private final NodeRenderer myNodeRenderer;

        public RendererAction(NodeRenderer nodeRenderer) {
            super(nodeRenderer.getName());
            this.myNodeRenderer = nodeRenderer;
        }

        public boolean isSelected(AnActionEvent e) {
            XValueNodeImpl node = XDebuggerTreeActionBase.getSelectedNode(e.getDataContext());
            if (node == null) {
                return false;
            }
            XValue container = (XValue)node.getValueContainer();
            return !(container instanceof JavaValue) || ((JavaValue)container).getDescriptor().getLastRenderer() == this.myNodeRenderer;
        }

        public void setSelected(AnActionEvent e, final boolean state) {
            DebuggerContextImpl debuggerContext = DebuggerAction.getDebuggerContext(e.getDataContext());
            final XValueNodeImpl node = XDebuggerTreeActionBase.getSelectedNode(e.getDataContext());
            LOG.assertTrue(debuggerContext != null && node != null);
            debuggerContext.getDebugProcess().getManagerThread().schedule(new DebuggerContextCommandImpl(debuggerContext){

                @Override
                public void threadAction() {
                    XValue container = (XValue)node.getValueContainer();
                    if (container instanceof JavaValue) {
                        ValueDescriptorImpl valueDescriptor = ((JavaValue)container).getDescriptor();
                        if (state) {
                            valueDescriptor.setRenderer(RendererAction.this.myNodeRenderer);
                            DebuggerAction.refreshViews(node);
                        }
                    }
                }
            });
        }
    }
}

