/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator.treeHash;

import com.intellij.dupLocator.DuplocatorSettings;
import com.intellij.dupLocator.NodeSpecificHasher;
import com.intellij.dupLocator.iterators.FilteringNodeIterator;
import com.intellij.dupLocator.iterators.SiblingNodeIterator;
import com.intellij.dupLocator.treeHash.DuplicatesMatchingVisitor;
import com.intellij.dupLocator.treeHash.DuplicatesProfileBase;
import com.intellij.dupLocator.treeHash.FragmentsCollector;
import com.intellij.dupLocator.treeHash.TreeHasherBase;
import com.intellij.dupLocator.util.DuplocatorUtil;
import com.intellij.dupLocator.util.NodeFilter;
import com.intellij.lang.Language;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class NodeSpecificHasherBase
extends NodeSpecificHasher {
    private final TreeHasherBase myTreeHasher;
    private final DuplocatorSettings mySettings;
    private final DuplicatesProfileBase myDuplicatesProfile;
    private final NodeFilter myNodeFilter;
    protected final boolean myForIndexing;

    private boolean isToSkipAsLiteral(PsiElement element) {
        return this.isLiteral(element) && !this.myDuplicatesProfile.getDuplocatorState(this.myDuplicatesProfile.getLanguage(element)).distinguishLiterals();
    }

    public NodeSpecificHasherBase(@NotNull DuplocatorSettings settings, @NotNull FragmentsCollector callback, @NotNull DuplicatesProfileBase duplicatesProfile) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/dupLocator/treeHash/NodeSpecificHasherBase", "<init>"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/dupLocator/treeHash/NodeSpecificHasherBase", "<init>"));
        }
        if (duplicatesProfile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "duplicatesProfile", "com/intellij/dupLocator/treeHash/NodeSpecificHasherBase", "<init>"));
        }
        this(settings, callback, duplicatesProfile, false);
    }

    public NodeSpecificHasherBase(@NotNull DuplocatorSettings settings, @NotNull FragmentsCollector callback, @NotNull DuplicatesProfileBase duplicatesProfile, boolean forIndexing) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/dupLocator/treeHash/NodeSpecificHasherBase", "<init>"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/dupLocator/treeHash/NodeSpecificHasherBase", "<init>"));
        }
        if (duplicatesProfile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "duplicatesProfile", "com/intellij/dupLocator/treeHash/NodeSpecificHasherBase", "<init>"));
        }
        this.myNodeFilter = new NodeFilter(){

            @Override
            public boolean accepts(PsiElement element) {
                return DuplocatorUtil.isIgnoredNode(element) || NodeSpecificHasherBase.this.isToSkipAsLiteral(element);
            }
        };
        this.myTreeHasher = new TreeHasherBase(callback, duplicatesProfile, forIndexing ? 0 : -1, forIndexing);
        this.mySettings = settings;
        this.myDuplicatesProfile = duplicatesProfile;
        this.myForIndexing = forIndexing;
    }

    @NotNull
    public NodeFilter getNodeFilter() {
        NodeFilter nodeFilter = this.myNodeFilter;
        if (nodeFilter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dupLocator/treeHash/NodeSpecificHasherBase", "getNodeFilter"));
        }
        return nodeFilter;
    }

    @Override
    public int getNodeHash(PsiElement node) {
        if (node == null) {
            return 0;
        }
        if (node instanceof PsiWhiteSpace || node instanceof PsiErrorElement) {
            return 0;
        }
        if (node instanceof LeafElement) {
            if (this.isToSkipAsLiteral(node)) {
                return 0;
            }
            return node.getText().hashCode();
        }
        return node.getClass().getName().hashCode();
    }

    private boolean isLiteral(PsiElement node) {
        if (node instanceof LeafElement) {
            IElementType elementType = ((LeafElement)node).getElementType();
            if (this.myDuplicatesProfile.getLiterals().contains(elementType)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public int getNodeCost(PsiElement node) {
        return node != null ? this.myDuplicatesProfile.getNodeCost(node) : 0;
    }

    @Override
    public List<PsiElement> getNodeChildren(PsiElement node) {
        ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        FilteringNodeIterator it = new FilteringNodeIterator(new SiblingNodeIterator(node.getFirstChild()), this.myNodeFilter);
        while (it.hasNext()) {
            result.add(it.current());
            it.advance();
        }
        return result;
    }

    @Override
    public boolean areNodesEqual(@NotNull PsiElement node1, @NotNull PsiElement node2) {
        if (node1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node1", "com/intellij/dupLocator/treeHash/NodeSpecificHasherBase", "areNodesEqual"));
        }
        if (node2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node2", "com/intellij/dupLocator/treeHash/NodeSpecificHasherBase", "areNodesEqual"));
        }
        return false;
    }

    @Override
    public boolean areTreesEqual(@NotNull PsiElement root1, @NotNull PsiElement root2, int discardCost) {
        if (root1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root1", "com/intellij/dupLocator/treeHash/NodeSpecificHasherBase", "areTreesEqual"));
        }
        if (root2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root2", "com/intellij/dupLocator/treeHash/NodeSpecificHasherBase", "areTreesEqual"));
        }
        if (root1 == root2) {
            return true;
        }
        return new DuplicatesMatchingVisitor(this, this.myNodeFilter, discardCost).match(root1, root2);
    }

    @NotNull
    public DuplicatesProfileBase getDuplicatesProfile() {
        DuplicatesProfileBase duplicatesProfileBase = this.myDuplicatesProfile;
        if (duplicatesProfileBase == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dupLocator/treeHash/NodeSpecificHasherBase", "getDuplicatesProfile"));
        }
        return duplicatesProfileBase;
    }

    @Override
    public boolean checkDeep(PsiElement node1, PsiElement node2) {
        return true;
    }

    @Override
    public void visitNode(@NotNull PsiElement node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/dupLocator/treeHash/NodeSpecificHasherBase", "visitNode"));
        }
        Language language = node.getLanguage();
        if ((this.myForIndexing || this.mySettings.SELECTED_PROFILES.contains(language.getDisplayName())) && this.myDuplicatesProfile.isMyLanguage(language)) {
            this.myTreeHasher.hash(node, this);
        }
    }

    @Override
    public void hashingFinished() {
    }
}

