/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs;

import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.repo.RepositoryManager;
import com.intellij.ide.file.BatchFileChangeListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.status.StatusBarUtil;
import com.intellij.util.Function;
import com.intellij.util.io.storage.HeavyProcessLatch;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.vcs.log.TimedVcsCommit;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.intellij.images.editor.ImageFileEditor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DvcsUtil {
    private static final int SHORT_HASH_LENGTH = 8;

    public static void installStatusBarWidget(@NotNull Project project, @NotNull StatusBarWidget widget) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/dvcs/DvcsUtil", "installStatusBarWidget"));
        }
        if (widget == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "widget", "com/intellij/dvcs/DvcsUtil", "installStatusBarWidget"));
        }
        StatusBar statusBar = WindowManager.getInstance().getStatusBar(project);
        if (statusBar != null) {
            statusBar.addWidget(widget, "after " + (SystemInfo.isMac ? "Encoding" : "InsertOverwrite"), (Disposable)project);
        }
    }

    public static void removeStatusBarWidget(@NotNull Project project, @NotNull StatusBarWidget widget) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/dvcs/DvcsUtil", "removeStatusBarWidget"));
        }
        if (widget == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "widget", "com/intellij/dvcs/DvcsUtil", "removeStatusBarWidget"));
        }
        StatusBar statusBar = WindowManager.getInstance().getStatusBar(project);
        if (statusBar != null) {
            statusBar.removeWidget(widget.ID());
        }
    }

    @NotNull
    public static String getShortRepositoryName(@NotNull Project project, @NotNull VirtualFile root) {
        String relativePath;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/dvcs/DvcsUtil", "getShortRepositoryName"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/dvcs/DvcsUtil", "getShortRepositoryName"));
        }
        VirtualFile projectDir = project.getBaseDir();
        String repositoryPath = root.getPresentableUrl();
        if (projectDir != null && (relativePath = VfsUtilCore.getRelativePath((VirtualFile)root, (VirtualFile)projectDir, (char)File.separatorChar)) != null) {
            repositoryPath = relativePath;
        }
        String string = repositoryPath.isEmpty() ? root.getName() : repositoryPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/DvcsUtil", "getShortRepositoryName"));
        }
        return string;
    }

    @NotNull
    public static String getShortRepositoryName(@NotNull Repository repository) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "com/intellij/dvcs/DvcsUtil", "getShortRepositoryName"));
        }
        String string = DvcsUtil.getShortRepositoryName(repository.getProject(), repository.getRoot());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/DvcsUtil", "getShortRepositoryName"));
        }
        return string;
    }

    @NotNull
    public static String getShortNames(@NotNull Collection<? extends Repository> repositories) {
        if (repositories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "com/intellij/dvcs/DvcsUtil", "getShortNames"));
        }
        String string = StringUtil.join(repositories, (Function)new Function<Repository, String>(){

            public String fun(Repository repository) {
                return DvcsUtil.getShortRepositoryName(repository);
            }
        }, (String)", ");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/DvcsUtil", "getShortNames"));
        }
        return string;
    }

    @NotNull
    public static String joinRootsPaths(@NotNull Collection<VirtualFile> roots) {
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/dvcs/DvcsUtil", "joinRootsPaths"));
        }
        String string = StringUtil.join(roots, (Function)new Function<VirtualFile, String>(){

            public String fun(VirtualFile virtualFile) {
                return virtualFile.getPresentableUrl();
            }
        }, (String)", ");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/DvcsUtil", "joinRootsPaths"));
        }
        return string;
    }

    public static boolean anyRepositoryIsFresh(Collection<? extends Repository> repositories) {
        for (Repository repository : repositories) {
            if (!repository.isFresh()) continue;
            return true;
        }
        return false;
    }

    public static void noVcsRepositoryForRoot(@NotNull Logger log, @NotNull VirtualFile root, @NotNull Project project, @NotNull RepositoryManager repositoryManager, @Nullable AbstractVcs vcs) {
        if (log == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "log", "com/intellij/dvcs/DvcsUtil", "noVcsRepositoryForRoot"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/dvcs/DvcsUtil", "noVcsRepositoryForRoot"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/dvcs/DvcsUtil", "noVcsRepositoryForRoot"));
        }
        if (repositoryManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositoryManager", "com/intellij/dvcs/DvcsUtil", "noVcsRepositoryForRoot"));
        }
        if (vcs == null) {
            return;
        }
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        List<VirtualFile> roots = Arrays.asList(vcsManager.getRootsUnderVcs(vcs));
        log.warn(String.format("Repository not found for root: %s. All roots: %s, all repositories: %s", root, roots, repositoryManager.getRepositories()));
    }

    @Nullable
    public static String joinMessagesOrNull(@NotNull Collection<String> messages) {
        if (messages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messages", "com/intellij/dvcs/DvcsUtil", "joinMessagesOrNull"));
        }
        String joined = StringUtil.join(messages, (String)"\n");
        return StringUtil.isEmptyOrSpaces((String)joined) ? null : joined;
    }

    @Nullable
    public static VirtualFile getSelectedFile(@NotNull Project project) {
        Editor editor;
        FileEditorManager manager;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/dvcs/DvcsUtil", "getSelectedFile"));
        }
        StatusBar statusBar = WindowManager.getInstance().getStatusBar(project);
        FileEditor fileEditor = StatusBarUtil.getCurrentFileEditor(project, statusBar);
        VirtualFile result = null;
        if (fileEditor != null) {
            if (fileEditor instanceof TextEditor) {
                Document document = ((TextEditor)fileEditor).getEditor().getDocument();
                result = FileDocumentManager.getInstance().getFile(document);
            } else if (fileEditor instanceof ImageFileEditor) {
                result = ((ImageFileEditor)fileEditor).getImageEditor().getFile();
            }
        }
        if (result == null && (manager = FileEditorManager.getInstance((Project)project)) != null && (editor = manager.getSelectedTextEditor()) != null) {
            result = FileDocumentManager.getInstance().getFile(editor.getDocument());
        }
        return result;
    }

    @NotNull
    public static String getShortHash(@NotNull String hash) {
        if (hash == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hash", "com/intellij/dvcs/DvcsUtil", "getShortHash"));
        }
        if (hash.length() == 0) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/DvcsUtil", "getShortHash"));
            }
            return "";
        }
        if (hash.length() == 40) {
            String string = hash.substring(0, 8);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/DvcsUtil", "getShortHash"));
            }
            return string;
        }
        if (hash.length() > 40) {
            String string = hash.substring(hash.indexOf("[") + 1, 8);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/DvcsUtil", "getShortHash"));
            }
            return string;
        }
        String string = hash;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/DvcsUtil", "getShortHash"));
        }
        return string;
    }

    @NotNull
    public static String getDateString(@NotNull TimedVcsCommit commit) {
        if (commit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commit", "com/intellij/dvcs/DvcsUtil", "getDateString"));
        }
        String string = DateFormatUtil.formatPrettyDateTime((long)commit.getTimestamp()) + " ";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/DvcsUtil", "getDateString"));
        }
        return string;
    }

    public static void workingTreeChangeStarted(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/dvcs/DvcsUtil", "workingTreeChangeStarted"));
        }
        HeavyProcessLatch.INSTANCE.processStarted();
        ((BatchFileChangeListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(BatchFileChangeListener.TOPIC)).batchChangeStarted(project);
    }

    public static void workingTreeChangeFinished(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/dvcs/DvcsUtil", "workingTreeChangeFinished"));
        }
        HeavyProcessLatch.INSTANCE.processFinished();
        ((BatchFileChangeListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(BatchFileChangeListener.TOPIC)).batchChangeCompleted(project);
    }
}

