/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ChooseRunConfigurationPopup;
import com.intellij.execution.actions.ExecutorProvider;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.impl.RunDialog;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.IdeTooltipManager;
import com.intellij.ide.SearchTopHitProvider;
import com.intellij.ide.actions.ActivateToolWindowAction;
import com.intellij.ide.actions.GotoActionAction;
import com.intellij.ide.actions.NonProjectScopeDisablerEP;
import com.intellij.ide.actions.SearchEverywherePsiRenderer;
import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.ide.actions.ToolWindowsGroup;
import com.intellij.ide.structureView.StructureView;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.ui.OptionsTopHitProvider;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.laf.darcula.ui.DarculaTextBorder;
import com.intellij.ide.ui.laf.darcula.ui.DarculaTextFieldUI;
import com.intellij.ide.ui.search.BooleanOptionDescription;
import com.intellij.ide.ui.search.OptionDescription;
import com.intellij.ide.util.DefaultPsiElementCellRenderer;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.gotoByName.ChooseByNameItemProvider;
import com.intellij.ide.util.gotoByName.ChooseByNameModel;
import com.intellij.ide.util.gotoByName.ChooseByNamePopup;
import com.intellij.ide.util.gotoByName.GotoActionItemProvider;
import com.intellij.ide.util.gotoByName.GotoActionModel;
import com.intellij.ide.util.gotoByName.GotoClassModel2;
import com.intellij.ide.util.gotoByName.GotoFileModel;
import com.intellij.ide.util.gotoByName.GotoSymbolModel2;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.lang.Language;
import com.intellij.lang.LanguagePsiElementExternalizer;
import com.intellij.lang.PsiElementExternalizer;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AbbreviationManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.RightAlignedToolbarAction;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actions.TextComponentEditorAction;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.impl.EditorHistoryManager;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.keymap.impl.ModifierKeyDoubleClickHandler;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFilePathWrapper;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.ClickListener;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.Gradient;
import com.intellij.ui.Gray;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.ListDelegationUtil;
import com.intellij.ui.ListScrollingUtil;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.SeparatorComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.OnOffButton;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.ui.popup.PopupPositionManager;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.IconUtil;
import com.intellij.util.OpenSourceUtil;
import com.intellij.util.Processor;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.Matcher;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SearchEverywhereAction
extends AnAction
implements CustomComponentAction,
DumbAware,
DataProvider,
RightAlignedToolbarAction {
    public static final String SE_HISTORY_KEY = "SearchEverywhereHistoryKey";
    public static final int SEARCH_FIELD_COLUMNS = 25;
    private static final int MAX_CLASSES = 6;
    private static final int MAX_FILES = 6;
    private static final int MAX_RUN_CONFIGURATION = 6;
    private static final int MAX_TOOL_WINDOWS = 4;
    private static final int MAX_SYMBOLS = 6;
    private static final int MAX_SETTINGS = 5;
    private static final int MAX_ACTIONS = 5;
    private static final int MAX_STRUCTURE = 10;
    private static final int MAX_RECENT_FILES = 10;
    private static final int DEFAULT_MORE_STEP_COUNT = 15;
    public static final int MAX_SEARCH_EVERYWHERE_HISTORY = 50;
    public static final int MAX_TOP_HIT = 15;
    private static final int POPUP_MAX_WIDTH = 600;
    private static final Logger LOG = Logger.getInstance((String)("#" + SearchEverywhereAction.class.getName()));
    private MyListRenderer myRenderer;
    MySearchTextField myPopupField;
    private volatile GotoClassModel2 myClassModel;
    private volatile GotoFileModel myFileModel;
    private volatile GotoActionItemProvider myActionProvider;
    private volatile GotoSymbolModel2 mySymbolsModel;
    private Component myFocusComponent;
    private JBPopup myPopup;
    private Map<String, String> myConfigurables = new HashMap<String, String>();
    private Alarm myAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)ApplicationManager.getApplication());
    private Alarm myUpdateAlarm = new Alarm((Disposable)ApplicationManager.getApplication());
    private JBList myList;
    private JCheckBox myNonProjectCheckBox;
    private AnActionEvent myActionEvent;
    private Component myContextComponent;
    private CalcThread myCalcThread;
    private static AtomicBoolean ourShiftIsPressed = new AtomicBoolean(false);
    private static AtomicBoolean showAll = new AtomicBoolean(false);
    private volatile ActionCallback myCurrentWorker = ActionCallback.DONE;
    private int myHistoryIndex = 0;
    boolean mySkipFocusGain = false;
    private volatile JBPopup myBalloon;
    private int myPopupActualWidth;
    private Component myFocusOwner;
    private ChooseByNamePopup myFileChooseByName;
    private ChooseByNamePopup myClassChooseByName;
    private ChooseByNamePopup mySymbolsChooseByName;
    private StructureViewModel myStructureModel;
    private Editor myEditor;
    private FileEditor myFileEditor;
    private PsiFile myFile;
    private HistoryItem myHistoryItem;

    public JComponent createCustomComponent(Presentation presentation) {
        JPanel panel = new JPanel(new BorderLayout()){

            @Override
            protected void paintComponent(Graphics g) {
                if (SearchEverywhereAction.this.myBalloon != null && !SearchEverywhereAction.this.myBalloon.isDisposed() && SearchEverywhereAction.this.myActionEvent != null && SearchEverywhereAction.this.myActionEvent.getInputEvent() instanceof MouseEvent) {
                    Gradient gradient = SearchEverywhereAction.getGradientColors();
                    ((Graphics2D)g).setPaint(new GradientPaint(0.0f, 0.0f, gradient.getStartColor(), 0.0f, this.getHeight(), gradient.getEndColor()));
                    g.fillRect(0, 0, this.getWidth(), this.getHeight());
                } else {
                    super.paintComponent(g);
                }
            }
        };
        panel.setOpaque(false);
        JBLabel label = new JBLabel(AllIcons.Actions.FindPlain){
            {
                this.enableEvents(16L);
                this.enableEvents(32L);
            }
        };
        panel.add((Component)label, "Center");
        SearchEverywhereAction.initTooltip((JLabel)label);
        label.addMouseListener(new MouseAdapter((JLabel)label){
            final /* synthetic */ JLabel val$label;
            {
                this.val$label = jLabel;
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (SearchEverywhereAction.this.myBalloon != null) {
                    SearchEverywhereAction.this.myBalloon.cancel();
                }
                SearchEverywhereAction.this.myFocusOwner = IdeFocusManager.findInstance().getFocusOwner();
                this.val$label.setToolTipText(null);
                IdeTooltipManager.getInstance().hideCurrentNow(false);
                this.val$label.setIcon(AllIcons.Actions.FindWhite);
                SearchEverywhereAction.this.actionPerformed(null, e);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (SearchEverywhereAction.this.myBalloon == null || SearchEverywhereAction.this.myBalloon.isDisposed()) {
                    this.val$label.setIcon(AllIcons.Actions.Find);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (SearchEverywhereAction.this.myBalloon == null || SearchEverywhereAction.this.myBalloon.isDisposed()) {
                    this.val$label.setIcon(AllIcons.Actions.FindPlain);
                }
            }
        });
        return panel;
    }

    private static Gradient getGradientColors() {
        return new Gradient((Color)new JBColor(new Color(101, 147, 242), new Color(64, 80, 94)), (Color)new JBColor(new Color(46, 111, 205), new Color(53, 65, 87)));
    }

    public SearchEverywhereAction() {
        this.updateComponents();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SearchEverywhereAction.this.onFocusLost();
            }
        });
    }

    private void updateComponents() {
        this.myRenderer = new MyListRenderer();
        this.myList = new JBList(){

            public Dimension getPreferredSize() {
                Dimension size = super.getPreferredSize();
                return new Dimension(Math.min(size.width - 2, 600), size.height);
            }

            public void clearSelection() {
            }

            public Object getSelectedValue() {
                try {
                    return super.getSelectedValue();
                }
                catch (Exception e) {
                    return null;
                }
            }
        };
        this.myList.setCellRenderer((ListCellRenderer)((Object)this.myRenderer));
        this.myList.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                e.consume();
                final int i = SearchEverywhereAction.this.myList.locationToIndex(e.getPoint());
                if (i != -1) {
                    SearchEverywhereAction.this.mySkipFocusGain = true;
                    SearchEverywhereAction.this.getField().requestFocus();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SearchEverywhereAction.this.myList.setSelectedIndex(i);
                            SearchEverywhereAction.this.doNavigate(i);
                        }
                    });
                }
            }
        });
        this.myNonProjectCheckBox = new JCheckBox();
        this.myNonProjectCheckBox.setOpaque(false);
        this.myNonProjectCheckBox.setAlignmentX(1.0f);
        this.myNonProjectCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (showAll.get() != SearchEverywhereAction.this.myNonProjectCheckBox.isSelected()) {
                    showAll.set(!showAll.get());
                    final JTextField editor = (JTextField)UIUtil.findComponentOfType((JComponent)SearchEverywhereAction.this.myBalloon.getContent(), JTextField.class);
                    if (editor != null) {
                        final String pattern = editor.getText();
                        SearchEverywhereAction.this.myAlarm.cancelAllRequests();
                        SearchEverywhereAction.this.myAlarm.addRequest(new Runnable(){

                            @Override
                            public void run() {
                                if (editor.hasFocus()) {
                                    SearchEverywhereAction.this.rebuildList(pattern);
                                }
                            }
                        }, 30);
                    }
                }
            }
        });
    }

    private static void initTooltip(JLabel label) {
        String shortcutText = SearchEverywhereAction.getShortcut();
        label.setToolTipText("<html><body>Search Everywhere<br/>Press <b>" + shortcutText + "</b> to access<br/> - Classes<br/> - Files<br/> - Tool Windows<br/> - Actions<br/> - Settings</body></html>");
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        return null;
    }

    private static String getShortcut() {
        Shortcut[] shortcuts = KeymapManager.getInstance().getActiveKeymap().getShortcuts("SearchEverywhere");
        String shortcutText = shortcuts.length == 0 ? "Double " + (SystemInfo.isMac ? "\u21e7" : "Shift") : KeymapUtil.getShortcutsText((Shortcut[])shortcuts);
        return shortcutText;
    }

    private void initSearchField(final MySearchTextField search) {
        final JTextField editor = search.getTextEditor();
        editor.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                String pattern = editor.getText();
                if (editor.hasFocus()) {
                    SearchEverywhereAction.this.rebuildList(pattern);
                }
            }
        });
        editor.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (SearchEverywhereAction.this.mySkipFocusGain) {
                    SearchEverywhereAction.this.mySkipFocusGain = false;
                    return;
                }
                search.setText("");
                search.getTextEditor().setForeground(UIUtil.getLabelForeground());
                editor.setColumns(25);
                SearchEverywhereAction.this.myFocusComponent = e.getOppositeComponent();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JComponent parent = (JComponent)editor.getParent();
                        parent.revalidate();
                        parent.repaint();
                    }
                });
                SearchEverywhereAction.this.rebuildList("");
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (SearchEverywhereAction.this.myPopup instanceof AbstractPopup && SearchEverywhereAction.this.myPopup.isVisible() && (SearchEverywhereAction.this.myList == e.getOppositeComponent() || ((AbstractPopup)SearchEverywhereAction.this.myPopup).getPopupWindow() == e.getOppositeComponent())) {
                    return;
                }
                if (SearchEverywhereAction.this.myNonProjectCheckBox == e.getOppositeComponent()) {
                    SearchEverywhereAction.this.mySkipFocusGain = true;
                    editor.requestFocus();
                    return;
                }
                SearchEverywhereAction.this.onFocusLost();
            }
        });
    }

    private void jumpNextGroup(boolean forward) {
        int index = this.myList.getSelectedIndex();
        SearchListModel model = this.getModel();
        if (index >= 0) {
            int newIndex = forward ? model.next(index) : model.prev(index);
            this.myList.setSelectedIndex(newIndex);
            int more = model.next(newIndex) - 1;
            if (more < newIndex) {
                more = this.myList.getItemsCount() - 1;
            }
            ListScrollingUtil.ensureIndexIsVisible((JList)this.myList, (int)more, (int)(forward ? 1 : -1));
            ListScrollingUtil.ensureIndexIsVisible((JList)this.myList, (int)newIndex, (int)(forward ? 1 : -1));
        }
    }

    private SearchListModel getModel() {
        return (SearchListModel)this.myList.getModel();
    }

    private ActionCallback onFocusLost() {
        final ActionCallback result = new ActionCallback();
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    if (SearchEverywhereAction.this.myCalcThread != null) {
                        SearchEverywhereAction.this.myCalcThread.cancel();
                    }
                    SearchEverywhereAction.this.myAlarm.cancelAllRequests();
                    if (SearchEverywhereAction.this.myBalloon != null && !SearchEverywhereAction.this.myBalloon.isDisposed() && SearchEverywhereAction.this.myPopup != null && !SearchEverywhereAction.this.myPopup.isDisposed()) {
                        SearchEverywhereAction.this.myBalloon.cancel();
                        SearchEverywhereAction.this.myPopup.cancel();
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ActionToolbarImpl.updateAllToolbarsImmediately();
                        }
                    });
                }
                finally {
                    result.setDone();
                }
            }
        });
        return result;
    }

    private SearchTextField getField() {
        return this.myPopupField;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doNavigate(final int index) {
        String pattern;
        Executor executor;
        final Project project = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)this.getField().getTextEditor()));
        Executor executor2 = executor = ourShiftIsPressed.get() ? DefaultRunExecutor.getRunExecutorInstance() : ExecutorRegistry.getInstance().getExecutorById(ToolWindowId.DEBUG);
        assert (project != null);
        SearchListModel model = this.getModel();
        if (this.isMoreItem(index)) {
            pattern = this.myPopupField.getText();
            WidgetID wid = null;
            if (index == model.moreIndex.classes) {
                wid = WidgetID.CLASSES;
            } else if (index == model.moreIndex.files) {
                wid = WidgetID.FILES;
            } else if (index == model.moreIndex.settings) {
                wid = WidgetID.SETTINGS;
            } else if (index == model.moreIndex.actions) {
                wid = WidgetID.ACTIONS;
            } else if (index == model.moreIndex.symbols) {
                wid = WidgetID.SYMBOLS;
            } else if (index == model.moreIndex.runConfigurations) {
                wid = WidgetID.RUN_CONFIGURATIONS;
            }
            if (wid != null) {
                final WidgetID widgetID = wid;
                this.myCurrentWorker.doWhenProcessed(new Runnable(){

                    @Override
                    public void run() {
                        SearchEverywhereAction.this.myCalcThread = new CalcThread(project, pattern, true);
                        SearchEverywhereAction.this.myPopupActualWidth = 0;
                        SearchEverywhereAction.this.myCurrentWorker = SearchEverywhereAction.this.myCalcThread.insert(index, widgetID);
                    }
                });
                return;
            }
        }
        pattern = this.getField().getText();
        final Object value = this.myList.getSelectedValue();
        SearchEverywhereAction.saveHistory(project, pattern, value);
        IdeFocusManager focusManager = IdeFocusManager.findInstanceByComponent((Component)this.getField().getTextEditor());
        if (this.myPopup != null && this.myPopup.isVisible()) {
            this.myPopup.cancel();
        }
        if (value instanceof BooleanOptionDescription) {
            BooleanOptionDescription option;
            option.setOptionState(!(option = (BooleanOptionDescription)value).isOptionEnabled());
            this.myList.revalidate();
            this.myList.repaint();
            this.getField().requestFocus();
            return;
        }
        if (value instanceof OptionsTopHitProvider) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SearchEverywhereAction.this.getField().setText("#" + ((OptionsTopHitProvider)value).getId() + " ");
                }
            });
            return;
        }
        Runnable onDone = null;
        AccessToken token = ApplicationManager.getApplication().acquireReadActionLock();
        try {
            if (value instanceof PsiElement) {
                onDone = new Runnable(){

                    @Override
                    public void run() {
                        NavigationUtil.activateFileWithPsiElement((PsiElement)value, true);
                    }
                };
                return;
            }
            if (SearchEverywhereAction.isVirtualFile(value)) {
                onDone = new Runnable(){

                    @Override
                    public void run() {
                        OpenSourceUtil.navigate((boolean)true, (Navigatable[])new Navigatable[]{new OpenFileDescriptor(project, (VirtualFile)value)});
                    }
                };
                return;
            }
            if (SearchEverywhereAction.isActionValue(value) || SearchEverywhereAction.isSetting(value) || SearchEverywhereAction.isRunConfiguration(value)) {
                focusManager.requestDefaultFocus(true);
                final Component comp = this.myContextComponent;
                final AnActionEvent event = this.myActionEvent;
                IdeFocusManager.getInstance((Project)project).doWhenFocusSettlesDown(new Runnable(){

                    @Override
                    public void run() {
                        Component c = comp;
                        if (c == null) {
                            c = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                        }
                        if (SearchEverywhereAction.isRunConfiguration(value)) {
                            ((ChooseRunConfigurationPopup.ItemWrapper)value).perform(project, executor, DataManager.getInstance().getDataContext(c));
                        } else {
                            GotoActionAction.openOptionOrPerformAction(value, pattern, project, c, event);
                            if (SearchEverywhereAction.isToolWindowAction(value)) {
                                return;
                            }
                        }
                    }
                });
                return;
            }
            if (value instanceof Navigatable) {
                onDone = new Runnable(){

                    @Override
                    public void run() {
                        OpenSourceUtil.navigate((boolean)true, (Navigatable[])new Navigatable[]{(Navigatable)value});
                    }
                };
                return;
            }
        }
        finally {
            token.finish();
            ActionCallback callback = this.onFocusLost();
            if (onDone != null) {
                callback.doWhenDone(onDone);
            }
        }
        focusManager.requestDefaultFocus(true);
    }

    private boolean isMoreItem(int index) {
        SearchListModel model = this.getModel();
        return index == model.moreIndex.classes || index == model.moreIndex.files || index == model.moreIndex.settings || index == model.moreIndex.actions || index == model.moreIndex.symbols || index == model.moreIndex.runConfigurations;
    }

    private void rebuildList(final String pattern) {
        assert (EventQueue.isDispatchThread()) : "Must be EDT";
        if (this.myCalcThread != null && !this.myCurrentWorker.isProcessed()) {
            this.myCurrentWorker = this.myCalcThread.cancel();
        }
        if (this.myCalcThread != null && !this.myCalcThread.isCanceled()) {
            this.myCalcThread.cancel();
        }
        final Project project = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)this.getField().getTextEditor()));
        assert (project != null);
        this.myRenderer.myProject = project;
        Runnable run = new Runnable(){

            @Override
            public void run() {
                SearchEverywhereAction.this.myCalcThread = new CalcThread(project, pattern, false);
                SearchEverywhereAction.this.myPopupActualWidth = 0;
                SearchEverywhereAction.this.myCurrentWorker = SearchEverywhereAction.this.myCalcThread.start();
            }
        };
        if (this.myCurrentWorker.isDone()) {
            this.myCurrentWorker.doWhenDone(run);
        } else {
            this.myCurrentWorker.doWhenRejected(run);
        }
    }

    public void actionPerformed(AnActionEvent e) {
        this.actionPerformed(e, null);
    }

    public void actionPerformed(AnActionEvent e, MouseEvent me) {
        RelativePoint showPoint;
        Window wnd;
        if (this.myBalloon != null && this.myBalloon.isVisible()) {
            showAll.set(!showAll.get());
            this.myNonProjectCheckBox.setSelected(showAll.get());
            this.rebuildList(this.myPopupField.getText());
            return;
        }
        this.myCurrentWorker = ActionCallback.DONE;
        if (e != null) {
            this.myEditor = (Editor)e.getData(CommonDataKeys.EDITOR);
            this.myFileEditor = (FileEditor)e.getData(PlatformDataKeys.FILE_EDITOR);
            this.myFile = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        }
        if (e == null && this.myFocusOwner != null) {
            e = new AnActionEvent((InputEvent)me, DataManager.getInstance().getDataContext(this.myFocusOwner), "unknown", this.getTemplatePresentation(), ActionManager.getInstance(), 0);
        }
        if (e == null) {
            return;
        }
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        this.updateComponents();
        this.myContextComponent = (Component)PlatformDataKeys.CONTEXT_COMPONENT.getData(e.getDataContext());
        Window window = wnd = this.myContextComponent != null ? SwingUtilities.windowForComponent(this.myContextComponent) : KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow();
        if (wnd == null && this.myContextComponent instanceof Window) {
            wnd = (Window)this.myContextComponent;
        }
        if (wnd == null || wnd.getParent() != null) {
            return;
        }
        this.myActionEvent = e;
        if (this.myPopupField != null) {
            Disposer.dispose((Disposable)this.myPopupField);
        }
        this.myPopupField = new MySearchTextField();
        this.myPopupField.getTextEditor().addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                SearchEverywhereAction.this.myHistoryIndex = 0;
                SearchEverywhereAction.this.myHistoryItem = null;
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 16) {
                    SearchEverywhereAction.this.myList.repaint();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 16) {
                    SearchEverywhereAction.this.myList.repaint();
                }
            }
        });
        this.initSearchField(this.myPopupField);
        this.myPopupField.setOpaque(false);
        JTextField editor = this.myPopupField.getTextEditor();
        editor.setColumns(25);
        JPanel panel = new JPanel(new BorderLayout()){

            @Override
            protected void paintComponent(Graphics g) {
                Gradient gradient = SearchEverywhereAction.getGradientColors();
                ((Graphics2D)g).setPaint(new GradientPaint(0.0f, 0.0f, gradient.getStartColor(), 0.0f, this.getHeight(), gradient.getEndColor()));
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
        };
        JLabel title = new JLabel(" Search Everywhere:       ");
        NonOpaquePanel topPanel = new NonOpaquePanel((LayoutManager)new BorderLayout());
        title.setForeground((Color)new JBColor((Color)Gray._240, (Color)Gray._200));
        if (SystemInfo.isMac) {
            title.setFont(title.getFont().deriveFont(1, (float)title.getFont().getSize() - 1.0f));
        } else {
            title.setFont(title.getFont().deriveFont(1));
        }
        topPanel.add((Component)title, "West");
        JPanel controls = new JPanel(new BorderLayout());
        controls.setOpaque(false);
        JLabel settings = new JLabel(AllIcons.General.SearchEverywhereGear);
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent event, int clickCount) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ide/actions/SearchEverywhereAction$21", "onClick"));
                }
                SearchEverywhereAction.this.showSettings();
                return true;
            }
        }.installOn((Component)settings);
        controls.add((Component)settings, "East");
        this.myNonProjectCheckBox.setForeground((Color)new JBColor((Color)Gray._240, (Color)Gray._200));
        this.myNonProjectCheckBox.setText("Include non-project items (" + SearchEverywhereAction.getShortcut() + ")  ");
        if (!NonProjectScopeDisablerEP.isSearchInNonProjectDisabled()) {
            controls.add((Component)this.myNonProjectCheckBox, "West");
        }
        topPanel.add((Component)controls, "East");
        panel.add((Component)((Object)this.myPopupField), "Center");
        panel.add((Component)topPanel, "North");
        panel.setBorder(IdeBorderFactory.createEmptyBorder((int)3, (int)5, (int)4, (int)5));
        DataManager.registerDataProvider((JComponent)panel, (DataProvider)this);
        ComponentPopupBuilder builder = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)panel, (JComponent)editor);
        this.myBalloon = builder.setCancelOnClickOutside(true).setModalContext(false).setRequestFocus(true).setCancelCallback((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                return !SearchEverywhereAction.this.mySkipFocusGain;
            }
        }).createPopup();
        this.myBalloon.getContent().setBorder(new EmptyBorder(0, 0, 0, 0));
        Window window2 = WindowManager.getInstance().suggestParentWindow(project);
        project.getMessageBus().connect((Disposable)this.myBalloon).subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(){

            public void enteredDumbMode() {
            }

            public void exitDumbMode() {
                SearchEverywhereAction.this.rebuildList(SearchEverywhereAction.this.myPopupField.getText());
            }
        });
        Component parent = UIUtil.findUltimateParent((Component)window2);
        this.registerDataProvider(panel, project);
        if (me != null) {
            Component label = me.getComponent();
            Container button = label.getParent();
            assert (button != null);
            showPoint = new RelativePoint((Component)button, new Point(button.getWidth() - panel.getPreferredSize().width, button.getHeight()));
        } else if (parent != null) {
            int height;
            int n = height = UISettings.getInstance().SHOW_MAIN_TOOLBAR ? 135 : 115;
            if (parent instanceof IdeFrameImpl && ((IdeFrameImpl)parent).isInFullScreen()) {
                height -= 20;
            }
            showPoint = new RelativePoint(parent, new Point((parent.getSize().width - panel.getPreferredSize().width) / 2, height));
        } else {
            showPoint = JBPopupFactory.getInstance().guessBestPopupLocation(e.getDataContext());
        }
        this.myList.setFont(UIUtil.getListFont());
        this.myBalloon.show(showPoint);
        this.initSearchActions(this.myBalloon, this.myPopupField);
        IdeFocusManager focusManager = IdeFocusManager.getInstance((Project)project);
        focusManager.requestFocus((Component)editor, true);
        FeatureUsageTracker.getInstance().triggerFeatureUsed("SearchEverywhere");
    }

    private void showSettings() {
        this.myPopupField.setText("");
        final SearchListModel model = new SearchListModel();
        model.addElement((Object)new SEOption("Show files", "search.everywhere.files"));
        model.addElement((Object)new SEOption("Show symbols", "search.everywhere.symbols"));
        model.addElement((Object)new SEOption("Show tool windows", "search.everywhere.toolwindows"));
        model.addElement((Object)new SEOption("Show run configurations", "search.everywhere.configurations"));
        model.addElement((Object)new SEOption("Show actions", "search.everywhere.actions"));
        model.addElement((Object)new SEOption("Show IDE settings", "search.everywhere.settings"));
        if (this.myCalcThread != null && !this.myCurrentWorker.isProcessed()) {
            this.myCurrentWorker = this.myCalcThread.cancel();
        }
        if (this.myCalcThread != null && !this.myCalcThread.isCanceled()) {
            this.myCalcThread.cancel();
        }
        this.myCurrentWorker.doWhenProcessed(new Runnable(){

            @Override
            public void run() {
                SearchEverywhereAction.this.myList.setModel((ListModel)model);
                SearchEverywhereAction.this.updatePopupBounds();
            }
        });
    }

    private static void saveHistory(Project project, String text, Object value) {
        PsiElement psiElement;
        Language language;
        String name;
        if (project == null || project.isDisposed() || !project.isInitialized()) {
            return;
        }
        HistoryType type = null;
        String fqn = null;
        if (SearchEverywhereAction.isActionValue(value)) {
            type = HistoryType.ACTION;
            AnAction action = (AnAction)(value instanceof GotoActionModel.ActionWrapper ? ((GotoActionModel.ActionWrapper)value).getAction() : value);
            fqn = ActionManager.getInstance().getId(action);
        } else if (value instanceof VirtualFile) {
            type = HistoryType.FILE;
            fqn = ((VirtualFile)value).getUrl();
        } else if (value instanceof ChooseRunConfigurationPopup.ItemWrapper) {
            type = HistoryType.RUN_CONFIGURATION;
            fqn = ((ChooseRunConfigurationPopup.ItemWrapper)value).getText();
        } else if (value instanceof PsiElement && (name = ((PsiElementExternalizer)LanguagePsiElementExternalizer.INSTANCE.forLanguage(language = (psiElement = (PsiElement)value).getLanguage())).getQualifiedName(psiElement)) != null) {
            type = HistoryType.PSI;
            fqn = language.getID() + "://" + name;
        }
        PropertiesComponent storage = PropertiesComponent.getInstance((Project)project);
        String[] values = storage.getValues(SE_HISTORY_KEY);
        List<HistoryItem> history = new ArrayList<HistoryItem>();
        if (values != null) {
            for (String s : values) {
                String[] split = s.split("\t");
                if (split.length != 3 || text.equals(split[0]) || StringUtil.isEmpty((String)split[0])) continue;
                history.add(new HistoryItem(split[0], split[1], split[2]));
            }
        }
        history.add(0, new HistoryItem(text, type == null ? null : type.name(), fqn));
        if (history.size() > 50) {
            history = history.subList(0, 50);
        }
        String[] newValues = new String[history.size()];
        for (int i = 0; i < newValues.length; ++i) {
            newValues[i] = ((HistoryItem)history.get(i)).toString();
        }
        storage.setValues(SE_HISTORY_KEY, newValues);
    }

    public Executor getExecutor() {
        return ourShiftIsPressed.get() ? DefaultRunExecutor.getRunExecutorInstance() : ExecutorRegistry.getInstance().getExecutorById(ToolWindowId.DEBUG);
    }

    private void registerDataProvider(JPanel panel, final Project project) {
        DataManager.registerDataProvider((JComponent)panel, (DataProvider)new DataProvider(){

            @Nullable
            public Object getData(@NonNls String dataId) {
                Object value = SearchEverywhereAction.this.myList.getSelectedValue();
                if (CommonDataKeys.PSI_ELEMENT.is(dataId) && value instanceof PsiElement) {
                    return value;
                }
                if (CommonDataKeys.VIRTUAL_FILE.is(dataId) && value instanceof VirtualFile) {
                    return value;
                }
                if (CommonDataKeys.NAVIGATABLE.is(dataId)) {
                    Object config;
                    if (value instanceof Navigatable) {
                        return value;
                    }
                    if (value instanceof ChooseRunConfigurationPopup.ItemWrapper && (config = ((ChooseRunConfigurationPopup.ItemWrapper)value).getValue()) instanceof RunnerAndConfigurationSettings) {
                        return new Navigatable(){

                            public void navigate(boolean requestFocus) {
                                RunDialog.editConfiguration(project, (RunnerAndConfigurationSettings)config, "Edit Configuration", SearchEverywhereAction.this.getExecutor());
                            }

                            public boolean canNavigate() {
                                return true;
                            }

                            public boolean canNavigateToSource() {
                                return true;
                            }
                        };
                    }
                }
                return null;
            }
        });
    }

    private void initSearchActions(JBPopup balloon, MySearchTextField searchTextField) {
        final JTextField editor = searchTextField.getTextEditor();
        new DumbAwareAction(){

            public void actionPerformed(AnActionEvent e) {
                SearchEverywhereAction.this.jumpNextGroup(true);
            }
        }.registerCustomShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"TAB"}), (JComponent)editor, (Disposable)balloon);
        new DumbAwareAction(){

            public void actionPerformed(AnActionEvent e) {
                SearchEverywhereAction.this.jumpNextGroup(false);
            }
        }.registerCustomShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"shift TAB"}), (JComponent)editor, (Disposable)balloon);
        new DumbAwareAction(){

            public void actionPerformed(AnActionEvent e) {
                if (SearchEverywhereAction.this.myBalloon != null && SearchEverywhereAction.this.myBalloon.isVisible()) {
                    SearchEverywhereAction.this.myBalloon.cancel();
                }
                if (SearchEverywhereAction.this.myPopup != null && SearchEverywhereAction.this.myPopup.isVisible()) {
                    SearchEverywhereAction.this.myPopup.cancel();
                }
            }
        }.registerCustomShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"ESCAPE"}), (JComponent)editor, (Disposable)balloon);
        new DumbAwareAction(){

            public void actionPerformed(AnActionEvent e) {
                int index = SearchEverywhereAction.this.myList.getSelectedIndex();
                if (index != -1) {
                    SearchEverywhereAction.this.doNavigate(index);
                }
            }
        }.registerCustomShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"ENTER", "shift ENTER"}), (JComponent)editor, (Disposable)balloon);
        new DumbAwareAction(){

            public void actionPerformed(AnActionEvent e) {
                PropertiesComponent storage = PropertiesComponent.getInstance((Project)e.getProject());
                String[] values = storage.getValues(SearchEverywhereAction.SE_HISTORY_KEY);
                if (values != null && values.length > SearchEverywhereAction.this.myHistoryIndex) {
                    List data = StringUtil.split((String)values[SearchEverywhereAction.this.myHistoryIndex], (String)"\t");
                    SearchEverywhereAction.this.myHistoryItem = new HistoryItem((String)data.get(0), (String)data.get(1), (String)data.get(2));
                    SearchEverywhereAction.this.myHistoryIndex++;
                    editor.setText(((SearchEverywhereAction)SearchEverywhereAction.this).myHistoryItem.pattern);
                    editor.setCaretPosition(((SearchEverywhereAction)SearchEverywhereAction.this).myHistoryItem.pattern.length());
                    editor.moveCaretPosition(0);
                }
            }

            public void update(AnActionEvent e) {
                e.getPresentation().setEnabled(editor.getCaretPosition() == 0);
            }
        }.registerCustomShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"LEFT"}), (JComponent)editor, (Disposable)balloon);
    }

    private static String getSettingText(OptionDescription value) {
        String text;
        String hit = value.getHit();
        if (hit == null) {
            hit = value.getOption();
        }
        if ((hit = StringUtil.unescapeXml((String)hit)).length() > 60) {
            hit = hit.substring(0, 60) + "...";
        }
        if ((text = (hit = hit.replace("  ", " ")).trim()).endsWith(":")) {
            text = text.substring(0, text.length() - 1);
        }
        return text;
    }

    private static boolean isActionValue(Object o) {
        return o instanceof GotoActionModel.ActionWrapper || o instanceof AnAction;
    }

    private static boolean isSetting(Object o) {
        return o instanceof OptionDescription;
    }

    private static boolean isRunConfiguration(Object o) {
        return o instanceof ChooseRunConfigurationPopup.ItemWrapper;
    }

    private static boolean isVirtualFile(Object o) {
        return o instanceof VirtualFile;
    }

    private static Font getTitleFont() {
        return UIUtil.getLabelFont().deriveFont(UIUtil.getFontSize((UIUtil.FontSize)UIUtil.FontSize.SMALL));
    }

    protected void resetFields() {
        if (this.myBalloon != null) {
            this.myBalloon.cancel();
            this.myBalloon = null;
        }
        this.myCurrentWorker.doWhenProcessed(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                CalcThread lock;
                SearchEverywhereAction.this.myFileModel = null;
                if (SearchEverywhereAction.this.myFileChooseByName != null) {
                    SearchEverywhereAction.this.myFileChooseByName.close(false);
                    SearchEverywhereAction.this.myFileChooseByName = null;
                }
                if (SearchEverywhereAction.this.myClassChooseByName != null) {
                    SearchEverywhereAction.this.myClassChooseByName.close(false);
                    SearchEverywhereAction.this.myClassChooseByName = null;
                }
                if (SearchEverywhereAction.this.mySymbolsChooseByName != null) {
                    SearchEverywhereAction.this.mySymbolsChooseByName.close(false);
                    SearchEverywhereAction.this.mySymbolsChooseByName = null;
                }
                if ((lock = SearchEverywhereAction.this.myCalcThread) != null) {
                    CalcThread calcThread = lock;
                    synchronized (calcThread) {
                        SearchEverywhereAction.this.myClassModel = null;
                        SearchEverywhereAction.this.myActionProvider = null;
                        SearchEverywhereAction.this.mySymbolsModel = null;
                        SearchEverywhereAction.this.myConfigurables.clear();
                        SearchEverywhereAction.this.myFocusComponent = null;
                        SearchEverywhereAction.this.myContextComponent = null;
                        SearchEverywhereAction.this.myFocusOwner = null;
                        SearchEverywhereAction.this.myRenderer.myProject = null;
                        SearchEverywhereAction.this.myPopup = null;
                        SearchEverywhereAction.this.myHistoryIndex = 0;
                        SearchEverywhereAction.this.myPopupActualWidth = 0;
                        SearchEverywhereAction.this.myCurrentWorker = ActionCallback.DONE;
                        showAll.set(false);
                        SearchEverywhereAction.this.myCalcThread = null;
                        SearchEverywhereAction.this.myEditor = null;
                        SearchEverywhereAction.this.myFileEditor = null;
                        SearchEverywhereAction.this.myStructureModel = null;
                    }
                }
            }
        });
        this.mySkipFocusGain = false;
    }

    private void updatePopupBounds() {
        if (this.myPopup == null || !this.myPopup.isVisible()) {
            return;
        }
        Container parent = this.getField().getParent();
        Dimension size = this.myList.getParent().getParent().getPreferredSize();
        size.width = this.myPopupActualWidth - 2;
        if (size.width + 2 < parent.getWidth()) {
            size.width = parent.getWidth();
        }
        if (this.myList.getItemsCount() == 0) {
            size.height = 70;
        }
        Dimension sz = new Dimension(size.width, this.myList.getPreferredSize().height);
        if (sz.width > 600 || sz.height > 600) {
            JBScrollPane pane = new JBScrollPane();
            int extraWidth = pane.getVerticalScrollBar().getWidth() + 1;
            int extraHeight = pane.getHorizontalScrollBar().getHeight() + 1;
            sz = new Dimension(Math.min(600, Math.max(this.getField().getWidth(), sz.width + extraWidth)), Math.min(600, sz.height + extraHeight));
            sz.width += 20;
            sz.height += 2;
        } else {
            sz.width += 2;
            sz.height += 2;
        }
        sz.width = Math.max(sz.width, this.myPopup.getSize().width);
        this.myPopup.setSize(sz);
        if (this.myActionEvent != null && this.myActionEvent.getInputEvent() == null) {
            Point p = parent.getLocationOnScreen();
            p.y += parent.getHeight();
            if (parent.getWidth() < sz.width) {
                p.x -= sz.width - parent.getWidth();
            }
            this.myPopup.setLocation(p);
        } else {
            try {
                this.adjustPopup();
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
    }

    private void adjustPopup() {
        Dimension d = PopupPositionManager.PositionAdjuster.getPopupSize(this.myPopup);
        JComponent myRelativeTo = this.myBalloon.getContent();
        Point myRelativeOnScreen = myRelativeTo.getLocationOnScreen();
        Rectangle screen = ScreenUtil.getScreenRectangle((Point)myRelativeOnScreen);
        Rectangle popupRect = null;
        Rectangle r = new Rectangle(myRelativeOnScreen.x, myRelativeOnScreen.y + myRelativeTo.getHeight(), d.width, d.height);
        if (screen.contains(r)) {
            popupRect = r;
        }
        if (popupRect != null) {
            this.myPopup.setLocation(new Point(r.x, r.y));
        } else {
            if (r.y + d.height > screen.y + screen.height) {
                r.height = screen.y + screen.height - r.y - 2;
            }
            if (r.width > screen.width) {
                r.width = screen.width - 50;
            }
            if (r.x + r.width > screen.x + screen.width) {
                r.x = screen.x + screen.width - r.width - 2;
            }
            this.myPopup.setSize(r.getSize());
            this.myPopup.setLocation(r.getLocation());
        }
    }

    private static boolean isToolWindowAction(Object o) {
        return SearchEverywhereAction.isActionValue(o) && o instanceof GotoActionModel.ActionWrapper && ((GotoActionModel.ActionWrapper)o).getAction() instanceof ActivateToolWindowAction;
    }

    private void fillConfigurablesIds(String pathToParent, Configurable[] configurables) {
        for (Configurable configurable : configurables) {
            if (!(configurable instanceof SearchableConfigurable)) continue;
            String id = ((SearchableConfigurable)configurable).getId();
            String name = configurable.getDisplayName();
            if (pathToParent != null) {
                name = pathToParent + " -> " + name;
            }
            this.myConfigurables.put(id, name);
            if (!(configurable instanceof SearchableConfigurable.Parent)) continue;
            this.fillConfigurablesIds(name, ((SearchableConfigurable.Parent)configurable).getConfigurables());
        }
    }

    private static JComponent createTitle(String titleText) {
        JLabel titleLabel = new JLabel(titleText);
        titleLabel.setFont(SearchEverywhereAction.getTitleFont());
        titleLabel.setForeground(UIUtil.getLabelDisabledForeground());
        Color bg = UIUtil.getListBackground();
        SeparatorComponent separatorComponent = new SeparatorComponent(titleLabel.getPreferredSize().height / 2, (Color)new JBColor((Color)Gray._220, (Color)Gray._80), null);
        JPanel result = new JPanel(new BorderLayout(5, 10));
        result.add((Component)titleLabel, "West");
        result.add((Component)separatorComponent, "Center");
        result.setBackground(bg);
        return result;
    }

    @Nullable
    private static HistoryType parseHistoryType(@Nullable String name) {
        try {
            return HistoryType.valueOf(name);
        }
        catch (Exception e) {
            return null;
        }
    }

    static {
        ModifierKeyDoubleClickHandler.getInstance().registerAction("SearchEverywhere", 16, -1);
        IdeEventQueue.getInstance().addPostprocessor(new IdeEventQueue.EventDispatcher(){

            @Override
            public boolean dispatch(AWTEvent event) {
                int keyCode;
                if (event instanceof KeyEvent && (keyCode = ((KeyEvent)event).getKeyCode()) == 16) {
                    ourShiftIsPressed.set(event.getID() == 401);
                }
                return false;
            }
        }, null);
    }

    private static class HistoryItem {
        final String pattern;
        final String type;
        final String fqn;

        private HistoryItem(String pattern, String type, String fqn) {
            this.pattern = pattern;
            this.type = type;
            this.fqn = fqn;
        }

        public String toString() {
            return this.pattern + "\t" + this.type + "\t" + this.fqn;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HistoryItem item = (HistoryItem)o;
            return this.pattern.equals(item.pattern);
        }

        public int hashCode() {
            return this.pattern.hashCode();
        }
    }

    private static enum HistoryType {
        PSI,
        FILE,
        SETTING,
        ACTION,
        RUN_CONFIGURATION;

    }

    static class More
    extends JPanel {
        static final More instance = new More();
        final JLabel label = new JLabel("    ... more   ");

        private More() {
            super(new BorderLayout());
            this.add((Component)this.label, "Center");
        }

        static More get(boolean isSelected) {
            instance.setBackground(UIUtil.getListBackground((boolean)isSelected));
            More.instance.label.setForeground(UIUtil.getLabelDisabledForeground());
            More.instance.label.setFont(SearchEverywhereAction.getTitleFont());
            More.instance.label.setBackground(UIUtil.getListBackground((boolean)isSelected));
            return instance;
        }
    }

    private static class SearchListModel
    extends DefaultListModel {
        Vector myDelegate;
        volatile TitleIndex titleIndex = new TitleIndex();
        volatile MoreIndex moreIndex = new MoreIndex();

        private SearchListModel() {
            this.myDelegate = (Vector)ReflectionUtil.getField(DefaultListModel.class, (Object)this, Vector.class, (String)"delegate");
        }

        int next(int index) {
            int[] all = this.getAll();
            Arrays.sort(all);
            for (int next : all) {
                if (next <= index) continue;
                return next;
            }
            return 0;
        }

        int[] getAll() {
            return new int[]{this.titleIndex.topHit, this.titleIndex.recentFiles, this.titleIndex.structure, this.titleIndex.runConfigurations, this.titleIndex.classes, this.titleIndex.files, this.titleIndex.actions, this.titleIndex.settings, this.titleIndex.toolWindows, this.titleIndex.symbols, this.moreIndex.classes, this.moreIndex.actions, this.moreIndex.files, this.moreIndex.settings, this.moreIndex.symbols, this.moreIndex.runConfigurations, this.moreIndex.structure};
        }

        int prev(int index) {
            int[] all = this.getAll();
            Arrays.sort(all);
            for (int i = all.length - 1; i >= 0; --i) {
                if (all[i] == -1 || all[i] >= index) continue;
                return all[i];
            }
            return all[all.length - 1];
        }

        public void addElement(Object obj) {
            this.myDelegate.add(obj);
        }

        public void update() {
            this.fireContentsChanged(this, 0, this.getSize() - 1);
        }
    }

    static class SearchResult
    extends ArrayList<Object> {
        boolean needMore;

        SearchResult() {
        }
    }

    static class TitleIndex {
        volatile int topHit = -1;
        volatile int recentFiles = -1;
        volatile int runConfigurations = -1;
        volatile int classes = -1;
        volatile int structure = -1;
        volatile int files = -1;
        volatile int actions = -1;
        volatile int settings = -1;
        volatile int toolWindows = -1;
        volatile int symbols = -1;
        final String gotoClassTitle;
        final String gotoFileTitle;
        final String gotoActionTitle;
        final String gotoSettingsTitle;
        final String gotoRecentFilesTitle;
        final String gotoRunConfigurationsTitle;
        final String gotoSymbolTitle;
        final String gotoStructureTitle;
        static final String toolWindowsTitle = "Tool Windows";

        TitleIndex() {
            String gotoClass = KeymapUtil.getFirstKeyboardShortcutText((AnAction)ActionManager.getInstance().getAction("GotoClass"));
            this.gotoClassTitle = StringUtil.isEmpty((String)gotoClass) ? "Classes" : "Classes (" + gotoClass + ")";
            String gotoFile = KeymapUtil.getFirstKeyboardShortcutText((AnAction)ActionManager.getInstance().getAction("GotoFile"));
            this.gotoFileTitle = StringUtil.isEmpty((String)gotoFile) ? "Files" : "Files (" + gotoFile + ")";
            String gotoAction = KeymapUtil.getFirstKeyboardShortcutText((AnAction)ActionManager.getInstance().getAction("GotoAction"));
            this.gotoActionTitle = StringUtil.isEmpty((String)gotoAction) ? "Actions" : "Actions (" + gotoAction + ")";
            String gotoSettings = KeymapUtil.getFirstKeyboardShortcutText((AnAction)ActionManager.getInstance().getAction("ShowSettings"));
            this.gotoSettingsTitle = StringUtil.isEmpty((String)gotoAction) ? "Preferences" : "Preferences (" + gotoSettings + ")";
            String gotoRecentFiles = KeymapUtil.getFirstKeyboardShortcutText((AnAction)ActionManager.getInstance().getAction("RecentFiles"));
            this.gotoRecentFilesTitle = StringUtil.isEmpty((String)gotoRecentFiles) ? "Recent Files" : "Recent Files (" + gotoRecentFiles + ")";
            String gotoSymbol = KeymapUtil.getFirstKeyboardShortcutText((AnAction)ActionManager.getInstance().getAction("GotoSymbol"));
            this.gotoSymbolTitle = StringUtil.isEmpty((String)gotoSymbol) ? "Symbols" : "Symbols (" + gotoSymbol + ")";
            String gotoRunConfiguration = KeymapUtil.getFirstKeyboardShortcutText((AnAction)ActionManager.getInstance().getAction("ChooseDebugConfiguration"));
            if (StringUtil.isEmpty((String)gotoRunConfiguration)) {
                gotoRunConfiguration = KeymapUtil.getFirstKeyboardShortcutText((AnAction)ActionManager.getInstance().getAction("ChooseRunConfiguration"));
            }
            this.gotoRunConfigurationsTitle = StringUtil.isEmpty((String)gotoRunConfiguration) ? "Run Configurations" : "Run Configurations (" + gotoRunConfiguration + ")";
            String gotoStructure = KeymapUtil.getFirstKeyboardShortcutText((AnAction)ActionManager.getInstance().getAction("FileStructurePopup"));
            this.gotoStructureTitle = StringUtil.isEmpty((String)gotoStructure) ? "File Structure" : "File Structure (" + gotoStructure + ")";
        }

        String getTitle(int index) {
            if (index == this.topHit) {
                return index == 0 ? "Top Hit" : "Top Hits";
            }
            if (index == this.recentFiles) {
                return this.gotoRecentFilesTitle;
            }
            if (index == this.structure) {
                return this.gotoStructureTitle;
            }
            if (index == this.runConfigurations) {
                return this.gotoRunConfigurationsTitle;
            }
            if (index == this.classes) {
                return this.gotoClassTitle;
            }
            if (index == this.files) {
                return this.gotoFileTitle;
            }
            if (index == this.toolWindows) {
                return toolWindowsTitle;
            }
            if (index == this.actions) {
                return this.gotoActionTitle;
            }
            if (index == this.settings) {
                return this.gotoSettingsTitle;
            }
            if (index == this.symbols) {
                return this.gotoSymbolTitle;
            }
            return null;
        }

        public void clear() {
            this.topHit = -1;
            this.runConfigurations = -1;
            this.recentFiles = -1;
            this.classes = -1;
            this.files = -1;
            this.structure = -1;
            this.actions = -1;
            this.settings = -1;
            this.toolWindows = -1;
        }

        public void shift(int index, int shift) {
            if (this.toolWindows != -1 && this.toolWindows > index) {
                this.toolWindows += shift;
            }
            if (this.settings != -1 && this.settings > index) {
                this.settings += shift;
            }
            if (this.actions != -1 && this.actions > index) {
                this.actions += shift;
            }
            if (this.files != -1 && this.files > index) {
                this.files += shift;
            }
            if (this.structure != -1 && this.structure > index) {
                this.structure += shift;
            }
            if (this.classes != -1 && this.classes > index) {
                this.classes += shift;
            }
            if (this.runConfigurations != -1 && this.runConfigurations > index) {
                this.runConfigurations += shift;
            }
            if (this.symbols != -1 && this.symbols > index) {
                this.symbols += shift;
            }
        }
    }

    static class MoreIndex {
        volatile int classes = -1;
        volatile int files = -1;
        volatile int actions = -1;
        volatile int settings = -1;
        volatile int symbols = -1;
        volatile int runConfigurations = -1;
        volatile int structure = -1;

        MoreIndex() {
        }

        public void shift(int index, int shift) {
            if (this.runConfigurations >= index) {
                this.runConfigurations += shift;
            }
            if (this.classes >= index) {
                this.classes += shift;
            }
            if (this.files >= index) {
                this.files += shift;
            }
            if (this.symbols >= index) {
                this.symbols += shift;
            }
            if (this.actions >= index) {
                this.actions += shift;
            }
            if (this.settings >= index) {
                this.settings += shift;
            }
            if (this.structure >= index) {
                this.structure += shift;
            }
        }
    }

    private class CalcThread
    implements Runnable {
        private final Project project;
        private final String pattern;
        private final ProgressIndicator myProgressIndicator = new ProgressIndicatorBase();
        private final ActionCallback myDone = new ActionCallback();
        private final SearchListModel myListModel;
        private final ArrayList<VirtualFile> myAlreadyAddedFiles = new ArrayList();
        private final ArrayList<AnAction> myAlreadyAddedActions = new ArrayList();

        public CalcThread(Project project, String pattern, boolean reuseModel) {
            this.project = project;
            this.pattern = pattern;
            this.myListModel = reuseModel ? (SearchListModel)SearchEverywhereAction.this.myList.getModel() : new SearchListModel();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            block11: {
                block9: {
                    block10: {
                        this.check();
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                SearchEverywhereAction.this.myList.getEmptyText().setText("Searching...");
                                if (SearchEverywhereAction.this.myList.getModel() instanceof SearchListModel) {
                                    SearchEverywhereAction.this.myAlarm.cancelAllRequests();
                                    SearchEverywhereAction.this.myAlarm.addRequest(new Runnable(){

                                        @Override
                                        public void run() {
                                            if (!CalcThread.this.myDone.isRejected()) {
                                                SearchEverywhereAction.this.myList.setModel((ListModel)CalcThread.this.myListModel);
                                                CalcThread.this.updatePopup();
                                            }
                                        }
                                    }, 50);
                                } else {
                                    SearchEverywhereAction.this.myList.setModel((ListModel)CalcThread.this.myListModel);
                                }
                            }
                        });
                        if (this.pattern.trim().length() != 0) break block9;
                        this.buildModelFromRecentFiles();
                        this.updatePopup();
                        if (this.isCanceled()) break block10;
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                SearchEverywhereAction.this.myList.getEmptyText().setText(StatusText.DEFAULT_EMPTY_TEXT);
                            }
                        });
                        this.updatePopup();
                    }
                    if (this.myDone.isProcessed()) return;
                    this.myDone.setDone();
                    return;
                }
                try {
                    this.checkModelsUpToDate();
                    this.check();
                    this.buildTopHit(this.pattern);
                    this.check();
                    if (!this.pattern.startsWith("#")) {
                        this.buildRecentFiles(this.pattern);
                        this.check();
                        this.runReadAction(new Runnable(){

                            @Override
                            public void run() {
                                CalcThread.this.buildStructure(CalcThread.this.pattern);
                            }
                        }, true);
                        this.updatePopup();
                        this.check();
                        this.buildToolWindows(this.pattern);
                        this.check();
                        this.updatePopup();
                        this.check();
                        this.runReadAction(new Runnable(){

                            @Override
                            public void run() {
                                CalcThread.this.buildRunConfigurations(CalcThread.this.pattern);
                            }
                        }, true);
                        this.runReadAction(new Runnable(){

                            @Override
                            public void run() {
                                CalcThread.this.buildClasses(CalcThread.this.pattern);
                            }
                        }, true);
                        this.runReadAction(new Runnable(){

                            @Override
                            public void run() {
                                CalcThread.this.buildFiles(CalcThread.this.pattern);
                            }
                        }, false);
                        this.runReadAction(new Runnable(){

                            @Override
                            public void run() {
                                CalcThread.this.buildSymbols(CalcThread.this.pattern);
                            }
                        }, true);
                        this.buildActionsAndSettings(this.pattern);
                        this.updatePopup();
                    }
                    this.updatePopup();
                    if (this.isCanceled()) break block11;
                }
                catch (ProcessCanceledException ignore) {
                    block12: {
                        this.myDone.setRejected();
                        if (this.isCanceled()) break block12;
                        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                        this.updatePopup();
                    }
                    if (this.myDone.isProcessed()) return;
                    this.myDone.setDone();
                    return;
                }
                catch (Exception e) {
                    block13: {
                        LOG.error((Throwable)e);
                        this.myDone.setRejected();
                        if (this.isCanceled()) break block13;
                        {
                            catch (Throwable throwable) {
                                if (!this.isCanceled()) {
                                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                                    this.updatePopup();
                                }
                                if (this.myDone.isProcessed()) throw throwable;
                                this.myDone.setDone();
                                throw throwable;
                            }
                        }
                        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                        this.updatePopup();
                    }
                    if (this.myDone.isProcessed()) return;
                    this.myDone.setDone();
                    return;
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                this.updatePopup();
            }
            if (this.myDone.isProcessed()) return;
            this.myDone.setDone();
            return;
        }

        private void runReadAction(Runnable action, boolean checkDumb) {
            if (!checkDumb || !DumbService.getInstance((Project)this.project).isDumb()) {
                ApplicationManager.getApplication().runReadAction(action);
                this.updatePopup();
            }
        }

        protected void check() {
            this.myProgressIndicator.checkCanceled();
            if (this.myDone.isRejected()) {
                throw new ProcessCanceledException();
            }
            if (SearchEverywhereAction.this.myBalloon == null || SearchEverywhereAction.this.myBalloon.isDisposed()) {
                throw new ProcessCanceledException();
            }
        }

        private synchronized void buildToolWindows(String pattern) {
            if (!Registry.is((String)"search.everywhere.toolwindows")) {
                return;
            }
            final ArrayList<ActivateToolWindowAction> actions = new ArrayList<ActivateToolWindowAction>();
            for (ActivateToolWindowAction action : ToolWindowsGroup.getToolWindowActions(this.project)) {
                String text = action.getTemplatePresentation().getText();
                if (text == null || !StringUtil.startsWithIgnoreCase((String)text, (String)pattern)) continue;
                actions.add(action);
                if (actions.size() != 4) continue;
                break;
            }
            this.check();
            if (actions.isEmpty()) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ((CalcThread)CalcThread.this).myListModel.titleIndex.toolWindows = CalcThread.this.myListModel.size();
                    for (ActivateToolWindowAction toolWindow : actions) {
                        CalcThread.this.myListModel.addElement((Object)toolWindow);
                    }
                }
            });
        }

        private SearchResult getActionsOrSettings(String pattern, final int max, final boolean actions) {
            final SearchResult result = new SearchResult();
            if (actions && !Registry.is((String)"search.everywhere.actions") || !actions && !Registry.is((String)"search.everywhere.settings")) {
                return result;
            }
            final MinusculeMatcher matcher = new MinusculeMatcher("*" + pattern, NameUtil.MatchingCaseSensitivity.NONE);
            if (SearchEverywhereAction.this.myActionProvider == null) {
                SearchEverywhereAction.this.myActionProvider = this.createActionProvider();
            }
            SearchEverywhereAction.this.myActionProvider.filterElements(pattern, true, new Processor<GotoActionModel.MatchedValue>(){

                public boolean process(GotoActionModel.MatchedValue matched) {
                    CalcThread.this.check();
                    Comparable object = matched.value;
                    if (CalcThread.this.myListModel.contains(object)) {
                        return true;
                    }
                    if (!actions && SearchEverywhereAction.isSetting(object)) {
                        if (matcher.matches(SearchEverywhereAction.getSettingText((OptionDescription)object))) {
                            result.add(object);
                        }
                    } else if (actions && !SearchEverywhereAction.isToolWindowAction(object) && SearchEverywhereAction.isActionValue(object)) {
                        result.add(object);
                    }
                    return result.size() <= max;
                }
            });
            return result;
        }

        private synchronized void buildActionsAndSettings(String pattern) {
            final SearchResult actions = this.getActionsOrSettings(pattern, 5, true);
            final SearchResult settings = this.getActionsOrSettings(pattern, 5, false);
            this.check();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (CalcThread.this.isCanceled()) {
                        return;
                    }
                    if (actions.size() > 0) {
                        ((CalcThread)CalcThread.this).myListModel.titleIndex.actions = CalcThread.this.myListModel.size();
                        for (Object action : actions) {
                            CalcThread.this.myListModel.addElement(action);
                        }
                    }
                    int n = ((CalcThread)CalcThread.this).myListModel.moreIndex.actions = actions.size() >= 5 ? CalcThread.this.myListModel.size() - 1 : -1;
                    if (settings.size() > 0) {
                        ((CalcThread)CalcThread.this).myListModel.titleIndex.settings = CalcThread.this.myListModel.size();
                        for (Object setting : settings) {
                            CalcThread.this.myListModel.addElement(setting);
                        }
                    }
                    ((CalcThread)CalcThread.this).myListModel.moreIndex.settings = settings.size() >= 5 ? CalcThread.this.myListModel.size() - 1 : -1;
                }
            });
        }

        private synchronized void buildFiles(String pattern) {
            final SearchResult files = this.getFiles(pattern, 6, SearchEverywhereAction.this.myFileChooseByName);
            this.check();
            if (files.size() > 0) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (CalcThread.this.isCanceled()) {
                            return;
                        }
                        ((CalcThread)CalcThread.this).myListModel.titleIndex.files = CalcThread.this.myListModel.size();
                        for (Object file : files) {
                            CalcThread.this.myListModel.addElement(file);
                        }
                        ((CalcThread)CalcThread.this).myListModel.moreIndex.files = files.needMore ? CalcThread.this.myListModel.size() - 1 : -1;
                    }
                });
            }
        }

        private synchronized void buildStructure(String pattern) {
            if (!Registry.is((String)"search.everywhere.structure") || SearchEverywhereAction.this.myStructureModel == null) {
                return;
            }
            final ArrayList<StructureViewTreeElement> elements = new ArrayList<StructureViewTreeElement>();
            MinusculeMatcher matcher = new MinusculeMatcher("*" + pattern, NameUtil.MatchingCaseSensitivity.NONE);
            this.fillStructure(SearchEverywhereAction.this.myStructureModel.getRoot(), elements, (Matcher)matcher);
            if (elements.size() > 0) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (CalcThread.this.isCanceled()) {
                            return;
                        }
                        ((CalcThread)CalcThread.this).myListModel.titleIndex.structure = CalcThread.this.myListModel.size();
                        for (StructureViewTreeElement element : elements) {
                            CalcThread.this.myListModel.addElement(element);
                        }
                        ((CalcThread)CalcThread.this).myListModel.moreIndex.files = -1;
                    }
                });
            }
        }

        private void fillStructure(StructureViewTreeElement element, List<StructureViewTreeElement> elements, Matcher matcher) {
            TreeElement[] children = element.getChildren();
            this.check();
            for (TreeElement child : children) {
                this.check();
                if (!(child instanceof StructureViewTreeElement)) continue;
                String text = child.getPresentation().getPresentableText();
                if (text != null && matcher.matches(text)) {
                    elements.add((StructureViewTreeElement)child);
                }
                this.fillStructure((StructureViewTreeElement)child, elements, matcher);
            }
        }

        private synchronized void buildSymbols(String pattern) {
            final SearchResult symbols = this.getSymbols(pattern, 6, SearchEverywhereAction.this.mySymbolsChooseByName);
            this.check();
            if (symbols.size() > 0) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (CalcThread.this.isCanceled()) {
                            return;
                        }
                        ((CalcThread)CalcThread.this).myListModel.titleIndex.symbols = CalcThread.this.myListModel.size();
                        for (Object file : symbols) {
                            CalcThread.this.myListModel.addElement(file);
                        }
                        ((CalcThread)CalcThread.this).myListModel.moreIndex.symbols = symbols.needMore ? CalcThread.this.myListModel.size() - 1 : -1;
                    }
                });
            }
        }

        @Nullable
        private ChooseRunConfigurationPopup.ItemWrapper getRunConfigurationByName(String name) {
            ChooseRunConfigurationPopup.ItemWrapper[] wrappers;
            for (ChooseRunConfigurationPopup.ItemWrapper wrapper : wrappers = ChooseRunConfigurationPopup.createSettingsList(this.project, new ExecutorProvider(){

                @Override
                public Executor getExecutor() {
                    return ExecutorRegistry.getInstance().getExecutorById(ToolWindowId.DEBUG);
                }
            }, false)) {
                if (!wrapper.getText().equals(name)) continue;
                return wrapper;
            }
            return null;
        }

        private synchronized void buildRunConfigurations(String pattern) {
            final SearchResult runConfigurations = this.getConfigurations(pattern, 6);
            if (runConfigurations.size() > 0) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (CalcThread.this.isCanceled()) {
                            return;
                        }
                        ((CalcThread)CalcThread.this).myListModel.titleIndex.runConfigurations = CalcThread.this.myListModel.size();
                        for (Object runConfiguration : runConfigurations) {
                            CalcThread.this.myListModel.addElement(runConfiguration);
                        }
                        ((CalcThread)CalcThread.this).myListModel.moreIndex.runConfigurations = runConfigurations.needMore ? CalcThread.this.myListModel.getSize() - 1 : -1;
                    }
                });
            }
        }

        private SearchResult getConfigurations(String pattern, int max) {
            SearchResult configurations = new SearchResult();
            if (!Registry.is((String)"search.everywhere.configurations")) {
                return configurations;
            }
            MinusculeMatcher matcher = new MinusculeMatcher(pattern, NameUtil.MatchingCaseSensitivity.NONE);
            ChooseRunConfigurationPopup.ItemWrapper[] wrappers = ChooseRunConfigurationPopup.createSettingsList(this.project, new ExecutorProvider(){

                @Override
                public Executor getExecutor() {
                    return ExecutorRegistry.getInstance().getExecutorById(ToolWindowId.DEBUG);
                }
            }, false);
            this.check();
            for (ChooseRunConfigurationPopup.ItemWrapper wrapper : wrappers) {
                if (matcher.matches(wrapper.getText()) && !this.myListModel.contains(wrapper)) {
                    if (configurations.size() == max) {
                        configurations.needMore = true;
                        break;
                    }
                    configurations.add(wrapper);
                }
                this.check();
            }
            return configurations;
        }

        private synchronized void buildClasses(String pattern) {
            final SearchResult classes = this.getClasses(pattern, showAll.get(), 6, SearchEverywhereAction.this.myClassChooseByName);
            this.check();
            if (classes.size() > 0) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (CalcThread.this.isCanceled()) {
                            return;
                        }
                        ((CalcThread)CalcThread.this).myListModel.titleIndex.classes = CalcThread.this.myListModel.size();
                        for (Object file : classes) {
                            CalcThread.this.myListModel.addElement(file);
                        }
                        ((CalcThread)CalcThread.this).myListModel.moreIndex.classes = -1;
                        if (classes.needMore) {
                            ((CalcThread)CalcThread.this).myListModel.moreIndex.classes = CalcThread.this.myListModel.size() - 1;
                        }
                    }
                });
            }
        }

        private SearchResult getSymbols(String pattern, final int max, ChooseByNamePopup chooseByNamePopup) {
            final SearchResult symbols = new SearchResult();
            if (!Registry.is((String)"search.everywhere.symbols")) {
                return symbols;
            }
            final GlobalSearchScope scope = GlobalSearchScope.projectScope((Project)this.project);
            if (chooseByNamePopup == null) {
                return symbols;
            }
            ChooseByNameItemProvider provider = chooseByNamePopup.getProvider();
            provider.filterElements(chooseByNamePopup, pattern, false, this.myProgressIndicator, new Processor<Object>(){

                public boolean process(Object o) {
                    if (o instanceof PsiElement && !(((PsiElement)o).getParent() instanceof PsiFile)) {
                        PsiElement element = (PsiElement)o;
                        PsiFile file = element.getContainingFile();
                        if (!CalcThread.this.myListModel.contains(o) && (file == null || file.getVirtualFile() != null && scope.accept(file.getVirtualFile()))) {
                            symbols.add(o);
                        }
                    }
                    symbols.needMore = symbols.size() == max;
                    return !symbols.needMore;
                }
            });
            return symbols;
        }

        private SearchResult getClasses(String pattern, boolean includeLibs, final int max, ChooseByNamePopup chooseByNamePopup) {
            final SearchResult classes = new SearchResult();
            if (chooseByNamePopup == null) {
                return classes;
            }
            chooseByNamePopup.getProvider().filterElements(chooseByNamePopup, pattern, includeLibs, this.myProgressIndicator, new Processor<Object>(){

                public boolean process(Object o) {
                    if (o instanceof PsiElement && !CalcThread.this.myListModel.contains(o) && !classes.contains(o)) {
                        if (classes.size() == max) {
                            classes.needMore = true;
                            return false;
                        }
                        classes.add(o);
                        if (o instanceof PsiNamedElement) {
                            VirtualFile virtualFile;
                            String name = ((PsiNamedElement)o).getName();
                            PsiFile file = ((PsiNamedElement)o).getContainingFile();
                            if (file != null && StringUtil.equals((CharSequence)name, (CharSequence)(virtualFile = file.getVirtualFile()).getNameWithoutExtension())) {
                                CalcThread.this.myAlreadyAddedFiles.add(virtualFile);
                            }
                        }
                    }
                    return true;
                }
            });
            if (!includeLibs && classes.isEmpty()) {
                return this.getClasses(pattern, true, max, chooseByNamePopup);
            }
            return classes;
        }

        private SearchResult getFiles(final String pattern, final int max, ChooseByNamePopup chooseByNamePopup) {
            final SearchResult files = new SearchResult();
            if (chooseByNamePopup == null || !Registry.is((String)"search.everywhere.files")) {
                return files;
            }
            final GlobalSearchScope scope = GlobalSearchScope.projectScope((Project)this.project);
            chooseByNamePopup.getProvider().filterElements(chooseByNamePopup, pattern, true, this.myProgressIndicator, new Processor<Object>(){

                public boolean process(Object o) {
                    VirtualFile file = null;
                    if (o instanceof VirtualFile) {
                        file = (VirtualFile)o;
                    } else if (o instanceof PsiFile) {
                        file = ((PsiFile)o).getVirtualFile();
                    } else if (o instanceof PsiDirectory) {
                        file = ((PsiDirectory)o).getVirtualFile();
                    }
                    if (!(file == null || pattern.indexOf(32) != -1 && file.getName().indexOf(32) == -1 || !showAll.get() && (!scope.accept(file) || CalcThread.this.myListModel.contains(file) || CalcThread.this.myAlreadyAddedFiles.contains(file)) || files.contains(file))) {
                        if (files.size() == max) {
                            files.needMore = true;
                            return false;
                        }
                        files.add(file);
                    }
                    return true;
                }
            });
            return files;
        }

        private synchronized void buildRecentFiles(String pattern) {
            MinusculeMatcher matcher = new MinusculeMatcher("*" + pattern, NameUtil.MatchingCaseSensitivity.NONE);
            final ArrayList<VirtualFile> files = new ArrayList<VirtualFile>();
            List<VirtualFile> selected = Arrays.asList(FileEditorManager.getInstance((Project)this.project).getSelectedFiles());
            for (VirtualFile file : (VirtualFile[])ArrayUtil.reverseArray((Object[])EditorHistoryManager.getInstance(this.project).getFiles())) {
                if ((StringUtil.isEmptyOrSpaces((String)pattern) || matcher.matches(file.getName())) && !files.contains(file) && !selected.contains(file)) {
                    files.add(file);
                }
                if (files.size() > 10) break;
            }
            if (files.size() > 0) {
                this.myAlreadyAddedFiles.addAll(files);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (CalcThread.this.isCanceled()) {
                            return;
                        }
                        ((CalcThread)CalcThread.this).myListModel.titleIndex.recentFiles = CalcThread.this.myListModel.size();
                        for (VirtualFile file : files) {
                            CalcThread.this.myListModel.addElement(file);
                        }
                    }
                });
            }
        }

        private boolean isCanceled() {
            return this.myProgressIndicator.isCanceled() || this.myDone.isRejected();
        }

        private synchronized void buildTopHit(String pattern) {
            HistoryType type;
            final ArrayList<Object> elements = new ArrayList<Object>();
            final HistoryItem history = SearchEverywhereAction.this.myHistoryItem;
            if (history != null && (type = SearchEverywhereAction.parseHistoryType(history.type)) != null) {
                switch (type) {
                    case PSI: {
                        if (DumbService.isDumb((Project)this.project)) break;
                        ApplicationManager.getApplication().runReadAction(new Runnable(){

                            @Override
                            public void run() {
                                int i = history.fqn.indexOf("://");
                                if (i != -1) {
                                    PsiElement psi;
                                    String langId = history.fqn.substring(0, i);
                                    Language language = Language.findLanguageByID((String)langId);
                                    String psiFqn = history.fqn.substring(i + 3);
                                    if (language != null && (psi = ((PsiElementExternalizer)LanguagePsiElementExternalizer.INSTANCE.forLanguage(language)).findByQualifiedName(CalcThread.this.project, psiFqn)) != null) {
                                        VirtualFile file;
                                        elements.add(psi);
                                        PsiFile psiFile = psi.getContainingFile();
                                        if (psiFile != null && (file = psiFile.getVirtualFile()) != null) {
                                            CalcThread.this.myAlreadyAddedFiles.add(file);
                                        }
                                    }
                                }
                            }
                        });
                        break;
                    }
                    case FILE: {
                        VirtualFile file = VirtualFileManager.getInstance().findFileByUrl(history.fqn);
                        if (file == null) break;
                        elements.add(file);
                        break;
                    }
                    case SETTING: {
                        break;
                    }
                    case ACTION: {
                        AnAction action = ActionManager.getInstance().getAction(history.fqn);
                        if (action == null) break;
                        elements.add(action);
                        this.myAlreadyAddedActions.add(action);
                        break;
                    }
                    case RUN_CONFIGURATION: {
                        if (DumbService.isDumb((Project)this.project)) break;
                        ApplicationManager.getApplication().runReadAction(new Runnable(){

                            @Override
                            public void run() {
                                ChooseRunConfigurationPopup.ItemWrapper runConfiguration = CalcThread.this.getRunConfigurationByName(history.fqn);
                                if (runConfiguration != null) {
                                    elements.add(runConfiguration);
                                }
                            }
                        });
                    }
                }
            }
            Consumer<Object> consumer = new Consumer<Object>(){

                public void consume(Object o) {
                    if (SearchEverywhereAction.isSetting(o) || SearchEverywhereAction.isVirtualFile(o) || SearchEverywhereAction.isActionValue(o) || o instanceof PsiElement || o instanceof OptionsTopHitProvider) {
                        if (o instanceof AnAction && CalcThread.this.myAlreadyAddedActions.contains(o)) {
                            return;
                        }
                        elements.add(o);
                    }
                }
            };
            if (pattern.equals("#")) {
                HashSet<String> ids = new HashSet<String>();
                for (SearchTopHitProvider provider : (SearchTopHitProvider[])SearchTopHitProvider.EP_NAME.getExtensions()) {
                    this.check();
                    if (!(provider instanceof OptionsTopHitProvider) || ids.contains(((OptionsTopHitProvider)provider).getId())) continue;
                    consumer.consume((Object)provider);
                    ids.add(((OptionsTopHitProvider)provider).getId());
                }
            } else {
                ActionManager actionManager = ActionManager.getInstance();
                List actions = AbbreviationManager.getInstance().findActions(pattern);
                for (String actionId : actions) {
                    consumer.consume((Object)actionManager.getAction(actionId));
                }
                for (SearchTopHitProvider provider : (SearchTopHitProvider[])SearchTopHitProvider.EP_NAME.getExtensions()) {
                    this.check();
                    if (provider instanceof OptionsTopHitProvider && !((OptionsTopHitProvider)provider).isEnabled(this.project)) continue;
                    provider.consumeTopHits(pattern, (Consumer)consumer, this.project);
                }
            }
            if (elements.size() > 0) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (CalcThread.this.isCanceled()) {
                            return;
                        }
                        for (Object element : new ArrayList(elements)) {
                            if (!(element instanceof AnAction)) continue;
                            AnAction action = (AnAction)element;
                            AnActionEvent e = new AnActionEvent(SearchEverywhereAction.this.myActionEvent.getInputEvent(), SearchEverywhereAction.this.myActionEvent.getDataContext(), SearchEverywhereAction.this.myActionEvent.getPlace(), action.getTemplatePresentation(), SearchEverywhereAction.this.myActionEvent.getActionManager(), SearchEverywhereAction.this.myActionEvent.getModifiers());
                            ActionUtil.performDumbAwareUpdate((AnAction)action, (AnActionEvent)e, (boolean)false);
                            Presentation presentation = e.getPresentation();
                            if (!presentation.isEnabled() || !presentation.isVisible() || StringUtil.isEmpty((String)presentation.getText())) {
                                elements.remove(element);
                            }
                            if (!CalcThread.this.isCanceled()) continue;
                            return;
                        }
                        if (CalcThread.this.isCanceled() || elements.isEmpty()) {
                            return;
                        }
                        ((CalcThread)CalcThread.this).myListModel.titleIndex.topHit = CalcThread.this.myListModel.size();
                        for (Object element : ContainerUtil.getFirstItems((List)elements, (int)15)) {
                            CalcThread.this.myListModel.addElement(element);
                        }
                    }
                });
            }
        }

        private synchronized void checkModelsUpToDate() {
            if (SearchEverywhereAction.this.myClassModel == null) {
                SearchEverywhereAction.this.myClassModel = new GotoClassModel2(this.project);
                SearchEverywhereAction.this.myFileModel = new GotoFileModel(this.project);
                SearchEverywhereAction.this.mySymbolsModel = new GotoSymbolModel2(this.project);
                SearchEverywhereAction.this.myFileChooseByName = ChooseByNamePopup.createPopup(this.project, (ChooseByNameModel)SearchEverywhereAction.this.myFileModel, (PsiElement)null);
                SearchEverywhereAction.this.myClassChooseByName = ChooseByNamePopup.createPopup(this.project, (ChooseByNameModel)SearchEverywhereAction.this.myClassModel, (PsiElement)null);
                SearchEverywhereAction.this.mySymbolsChooseByName = ChooseByNamePopup.createPopup(this.project, (ChooseByNameModel)SearchEverywhereAction.this.mySymbolsModel, (PsiElement)null);
                this.project.putUserData(ChooseByNamePopup.CHOOSE_BY_NAME_POPUP_IN_PROJECT_KEY, null);
                SearchEverywhereAction.this.myActionProvider = this.createActionProvider();
                SearchEverywhereAction.this.myConfigurables.clear();
                SearchEverywhereAction.this.fillConfigurablesIds(null, ShowSettingsUtilImpl.getConfigurables(this.project, true));
            }
            if (SearchEverywhereAction.this.myStructureModel == null && SearchEverywhereAction.this.myFileEditor != null && Registry.is((String)"search.everywhere.structure")) {
                this.runReadAction(new Runnable(){

                    @Override
                    public void run() {
                        StructureViewBuilder structureViewBuilder = SearchEverywhereAction.this.myFileEditor.getStructureViewBuilder();
                        if (structureViewBuilder == null) {
                            return;
                        }
                        StructureView structureView = structureViewBuilder.createStructureView(SearchEverywhereAction.this.myFileEditor, CalcThread.this.project);
                        SearchEverywhereAction.this.myStructureModel = structureView.getTreeModel();
                    }
                }, true);
            }
        }

        private void buildModelFromRecentFiles() {
            this.buildRecentFiles("");
        }

        private GotoActionItemProvider createActionProvider() {
            GotoActionModel model = new GotoActionModel(this.project, SearchEverywhereAction.this.myFocusComponent, SearchEverywhereAction.this.myEditor, SearchEverywhereAction.this.myFile){

                @Override
                protected GotoActionModel.MatchMode actionMatches(String pattern, @NotNull AnAction anAction) {
                    if (anAction == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anAction", "com/intellij/ide/actions/SearchEverywhereAction$CalcThread$27", "actionMatches"));
                    }
                    String text = anAction.getTemplatePresentation().getText();
                    return text != null && NameUtil.buildMatcher((String)("*" + pattern), (NameUtil.MatchingCaseSensitivity)NameUtil.MatchingCaseSensitivity.NONE).matches(text) ? GotoActionModel.MatchMode.NAME : GotoActionModel.MatchMode.NONE;
                }
            };
            return new GotoActionItemProvider(model);
        }

        private void updatePopup() {
            this.check();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CalcThread.this.myListModel.update();
                    SearchEverywhereAction.this.myList.revalidate();
                    SearchEverywhereAction.this.myList.repaint();
                    SearchEverywhereAction.this.myRenderer.recalculateWidth();
                    if (SearchEverywhereAction.this.myBalloon == null || SearchEverywhereAction.this.myBalloon.isDisposed()) {
                        return;
                    }
                    if (SearchEverywhereAction.this.myPopup == null || !SearchEverywhereAction.this.myPopup.isVisible()) {
                        final ActionCallback callback = ListDelegationUtil.installKeyboardDelegation((JComponent)SearchEverywhereAction.this.getField().getTextEditor(), (JList)SearchEverywhereAction.this.myList);
                        ComponentPopupBuilder builder = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)new JBScrollPane((Component)SearchEverywhereAction.this.myList), null);
                        SearchEverywhereAction.this.myPopup = builder.setRequestFocus(false).setCancelKeyEnabled(false).setCancelCallback((Computable)new Computable<Boolean>(){

                            public Boolean compute() {
                                return SearchEverywhereAction.this.myBalloon == null || SearchEverywhereAction.this.myBalloon.isDisposed() || !SearchEverywhereAction.this.getField().getTextEditor().hasFocus() && !SearchEverywhereAction.this.mySkipFocusGain;
                            }
                        }).createPopup();
                        SearchEverywhereAction.this.myPopup.getContent().setBorder(new EmptyBorder(0, 0, 0, 0));
                        Disposer.register((Disposable)SearchEverywhereAction.this.myPopup, (Disposable)new Disposable(){

                            public void dispose() {
                                JLabel label;
                                Component component;
                                callback.setDone();
                                SearchEverywhereAction.this.resetFields();
                                SearchEverywhereAction.this.myNonProjectCheckBox.setSelected(false);
                                ActionToolbarImpl.updateAllToolbarsImmediately();
                                if (SearchEverywhereAction.this.myActionEvent != null && SearchEverywhereAction.this.myActionEvent.getInputEvent() instanceof MouseEvent && (component = SearchEverywhereAction.this.myActionEvent.getInputEvent().getComponent()) != null && (label = (JLabel)UIUtil.getParentOfType(JLabel.class, (Component)component)) != null) {
                                    label.setIcon(AllIcons.Actions.FindPlain);
                                }
                                SearchEverywhereAction.this.myActionEvent = null;
                            }
                        });
                        SearchEverywhereAction.this.myPopup.show(new RelativePoint((Component)SearchEverywhereAction.this.getField().getParent(), new Point(0, SearchEverywhereAction.this.getField().getParent().getHeight())));
                        SearchEverywhereAction.this.updatePopupBounds();
                        ActionManager.getInstance().addAnActionListener((AnActionListener)new AnActionListener.Adapter(){

                            public void beforeActionPerformed(AnAction action, DataContext dataContext, AnActionEvent event) {
                                if (action instanceof TextComponentEditorAction) {
                                    return;
                                }
                                SearchEverywhereAction.this.myPopup.cancel();
                            }
                        }, (Disposable)SearchEverywhereAction.this.myPopup);
                    } else {
                        SearchEverywhereAction.this.myList.revalidate();
                        SearchEverywhereAction.this.myList.repaint();
                    }
                    ListScrollingUtil.ensureSelectionExists((JList)SearchEverywhereAction.this.myList);
                    if (SearchEverywhereAction.this.myList.getModel().getSize() > 0) {
                        SearchEverywhereAction.this.updatePopupBounds();
                    }
                }
            });
        }

        public ActionCallback cancel() {
            this.myProgressIndicator.cancel();
            this.myDone.setRejected();
            return this.myDone;
        }

        public ActionCallback insert(final int index, final WidgetID id) {
            ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                @Override
                public void run() {
                    CalcThread.this.runReadAction(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                final SearchResult result = id == WidgetID.CLASSES ? CalcThread.this.getClasses(CalcThread.this.pattern, showAll.get(), 15, SearchEverywhereAction.this.myClassChooseByName) : (id == WidgetID.FILES ? CalcThread.this.getFiles(CalcThread.this.pattern, 15, SearchEverywhereAction.this.myFileChooseByName) : (id == WidgetID.RUN_CONFIGURATIONS ? CalcThread.this.getConfigurations(CalcThread.this.pattern, 15) : (id == WidgetID.SYMBOLS ? CalcThread.this.getSymbols(CalcThread.this.pattern, 15, SearchEverywhereAction.this.mySymbolsChooseByName) : (id == WidgetID.ACTIONS ? CalcThread.this.getActionsOrSettings(CalcThread.this.pattern, 15, true) : (id == WidgetID.SETTINGS ? CalcThread.this.getActionsOrSettings(CalcThread.this.pattern, 15, false) : new SearchResult())))));
                                CalcThread.this.check();
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        try {
                                            int shift = 0;
                                            int i = index + 1;
                                            for (Object o : result) {
                                                CalcThread.this.myListModel.insertElementAt(o, i);
                                                ++shift;
                                                ++i;
                                            }
                                            MoreIndex moreIndex = ((CalcThread)CalcThread.this).myListModel.moreIndex;
                                            ((CalcThread)CalcThread.this).myListModel.titleIndex.shift(index, shift);
                                            moreIndex.shift(index, shift);
                                            if (!result.needMore) {
                                                switch (id) {
                                                    case CLASSES: {
                                                        moreIndex.classes = -1;
                                                        break;
                                                    }
                                                    case FILES: {
                                                        moreIndex.files = -1;
                                                        break;
                                                    }
                                                    case ACTIONS: {
                                                        moreIndex.actions = -1;
                                                        break;
                                                    }
                                                    case SETTINGS: {
                                                        moreIndex.settings = -1;
                                                        break;
                                                    }
                                                    case SYMBOLS: {
                                                        moreIndex.symbols = -1;
                                                        break;
                                                    }
                                                    case RUN_CONFIGURATIONS: {
                                                        moreIndex.runConfigurations = -1;
                                                    }
                                                }
                                            }
                                            ListScrollingUtil.selectItem((JList)SearchEverywhereAction.this.myList, (int)index);
                                            CalcThread.this.myDone.setDone();
                                        }
                                        catch (Exception e) {
                                            CalcThread.this.myDone.setRejected();
                                        }
                                    }
                                });
                            }
                            catch (Exception e) {
                                CalcThread.this.myDone.setRejected();
                            }
                        }
                    }, true);
                }
            });
            return this.myDone;
        }

        public ActionCallback start() {
            ApplicationManager.getApplication().executeOnPooledThread((Runnable)this);
            return this.myDone;
        }
    }

    static enum WidgetID {
        CLASSES,
        FILES,
        ACTIONS,
        SETTINGS,
        SYMBOLS,
        RUN_CONFIGURATIONS;

    }

    private class MyListRenderer
    extends ColoredListCellRenderer {
        ColoredListCellRenderer myLocation = new ColoredListCellRenderer(){

            protected void customizeCellRenderer(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                this.setPaintFocusBorder(false);
                this.append(MyListRenderer.this.myLocationString, SimpleTextAttributes.GRAYED_ATTRIBUTES);
                this.setIcon(MyListRenderer.this.myLocationIcon);
            }
        };
        SearchEverywherePsiRenderer myFileRenderer = new SearchEverywherePsiRenderer((JList)SearchEverywhereAction.access$700(SearchEverywhereAction.this));
        private String myLocationString;
        private DefaultPsiElementCellRenderer myPsiRenderer = new DefaultPsiElementCellRenderer(){
            {
                this.setFocusBorderEnabled(false);
            }
        };
        private Icon myLocationIcon;
        private Project myProject;
        private JPanel myMainPanel = new JPanel(new BorderLayout());
        private JLabel myTitle = new JLabel();

        private MyListRenderer() {
        }

        public void clear() {
            super.clear();
            this.myLocation.clear();
            this.myLocationString = null;
            this.myLocationIcon = null;
        }

        public void setLocationString(String locationString) {
            this.myLocationString = locationString;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Color bg;
            PsiDirectory file;
            Component cmp;
            this.myLocationString = null;
            String pattern = "*" + SearchEverywhereAction.this.myPopupField.getText();
            Matcher matcher = NameUtil.buildMatcher((String)pattern, (int)0, (boolean)true, (boolean)true, (boolean)pattern.toLowerCase().equals(pattern));
            if (SearchEverywhereAction.this.isMoreItem(index)) {
                cmp = More.get(isSelected);
            } else if (value instanceof VirtualFile && this.myProject != null && (((VirtualFile)value).isDirectory() && (file = PsiManager.getInstance((Project)this.myProject).findDirectory((VirtualFile)value)) != null || (file = PsiManager.getInstance((Project)this.myProject).findFile((VirtualFile)value)) != null)) {
                this.myFileRenderer.setPatternMatcher(matcher);
                cmp = this.myFileRenderer.getListCellRendererComponent(list, file, index, isSelected, cellHasFocus);
            } else if (value instanceof PsiElement) {
                this.myFileRenderer.setPatternMatcher(matcher);
                cmp = this.myFileRenderer.getListCellRendererComponent(list, value, index, isSelected, isSelected);
            } else {
                cmp = super.getListCellRendererComponent(list, value, index, isSelected, isSelected);
                JPanel p = new JPanel(new BorderLayout());
                p.setBackground(UIUtil.getListBackground((boolean)isSelected));
                p.add(cmp, "Center");
                cmp = p;
            }
            if (this.myLocationString != null || value instanceof BooleanOptionDescription) {
                Component rightComponent;
                JPanel panel = new JPanel(new BorderLayout());
                panel.setBackground(UIUtil.getListBackground((boolean)isSelected));
                panel.add(cmp, "Center");
                if (value instanceof BooleanOptionDescription) {
                    OnOffButton button = new OnOffButton();
                    button.setSelected(((BooleanOptionDescription)value).isOptionEnabled());
                    rightComponent = button;
                } else {
                    rightComponent = this.myLocation.getListCellRendererComponent(list, value, index, isSelected, isSelected);
                }
                panel.add(rightComponent, "East");
                cmp = panel;
            }
            if ((bg = cmp.getBackground()) == null) {
                cmp.setBackground(UIUtil.getListBackground((boolean)isSelected));
                bg = cmp.getBackground();
            }
            this.myMainPanel.setBorder((Border)new CustomLineBorder(bg, 0, 0, 2, 0));
            String title = ((SearchEverywhereAction)SearchEverywhereAction.this).getModel().titleIndex.getTitle(index);
            this.myMainPanel.removeAll();
            if (title != null) {
                this.myTitle.setText(title);
                this.myMainPanel.add((Component)SearchEverywhereAction.createTitle(" " + title), "North");
            }
            this.myMainPanel.add(cmp, "Center");
            int width = this.myMainPanel.getPreferredSize().width;
            if (width > SearchEverywhereAction.this.myPopupActualWidth) {
                SearchEverywhereAction.this.myPopupActualWidth = width;
            }
            return this.myMainPanel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void customizeCellRenderer(JList list, Object value, int index, boolean selected, boolean hasFocus) {
            this.setPaintFocusBorder(false);
            this.setIcon(EmptyIcon.ICON_16);
            AccessToken token = ApplicationManager.getApplication().acquireReadActionLock();
            try {
                if (value instanceof PsiElement) {
                    String name = SearchEverywhereAction.this.myClassModel.getElementName(value);
                    assert (name != null);
                    this.append(name);
                } else if (value instanceof ChooseRunConfigurationPopup.ItemWrapper) {
                    ChooseRunConfigurationPopup.ItemWrapper wrapper = (ChooseRunConfigurationPopup.ItemWrapper)value;
                    this.append(wrapper.getText());
                    this.setIcon(wrapper.getIcon());
                    this.setLocationString(ourShiftIsPressed.get() ? "Run" : "Debug");
                    this.myLocationIcon = ourShiftIsPressed.get() ? AllIcons.Toolwindows.ToolWindowRun : AllIcons.Toolwindows.ToolWindowDebugger;
                } else if (SearchEverywhereAction.isVirtualFile(value)) {
                    VirtualFile file = (VirtualFile)value;
                    if (file instanceof VirtualFilePathWrapper) {
                        this.append(((VirtualFilePathWrapper)file).getPresentablePath());
                    } else {
                        this.append(file.getName());
                    }
                    this.setIcon(IconUtil.getIcon((VirtualFile)file, (int)2, (Project)this.myProject));
                } else if (SearchEverywhereAction.isActionValue(value)) {
                    String groupName;
                    GotoActionModel.ActionWrapper actionWithParentGroup = value instanceof GotoActionModel.ActionWrapper ? (GotoActionModel.ActionWrapper)value : null;
                    AnAction anAction = actionWithParentGroup == null ? (AnAction)value : actionWithParentGroup.getAction();
                    Presentation templatePresentation = anAction.getTemplatePresentation();
                    Icon icon = templatePresentation.getIcon();
                    if (anAction instanceof ActivateToolWindowAction) {
                        String id = ((ActivateToolWindowAction)anAction).getToolWindowId();
                        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(id);
                        if (toolWindow != null) {
                            icon = toolWindow.getIcon();
                        }
                    }
                    this.append(templatePresentation.getText());
                    if (actionWithParentGroup != null && !StringUtil.isEmpty((String)(groupName = actionWithParentGroup.getGroupName()))) {
                        this.setLocationString(groupName);
                    }
                    String string = groupName = actionWithParentGroup == null ? null : actionWithParentGroup.getGroupName();
                    if (!StringUtil.isEmpty((String)groupName)) {
                        this.setLocationString(groupName);
                    }
                    if (icon != null && icon.getIconWidth() <= 16 && icon.getIconHeight() <= 16) {
                        this.setIcon(IconUtil.toSize((Icon)icon, (int)16, (int)16));
                    }
                } else if (SearchEverywhereAction.isSetting(value)) {
                    String text = SearchEverywhereAction.getSettingText((OptionDescription)value);
                    this.append(text);
                    String id = ((OptionDescription)value).getConfigurableId();
                    String name = (String)SearchEverywhereAction.this.myConfigurables.get(id);
                    if (name != null) {
                        this.setLocationString(name);
                    }
                } else if (value instanceof OptionsTopHitProvider) {
                    this.append("#" + ((OptionsTopHitProvider)value).getId());
                } else {
                    ItemPresentation presentation = null;
                    if (value instanceof ItemPresentation) {
                        presentation = (ItemPresentation)value;
                    } else if (value instanceof NavigationItem) {
                        presentation = ((NavigationItem)value).getPresentation();
                    }
                    if (presentation != null) {
                        Icon icon;
                        String text = presentation.getPresentableText();
                        this.append(text == null ? value.toString() : text);
                        String location = presentation.getLocationString();
                        if (!StringUtil.isEmpty((String)location)) {
                            this.setLocationString(location);
                        }
                        if ((icon = presentation.getIcon(false)) != null) {
                            this.setIcon(icon);
                        }
                    }
                }
            }
            finally {
                token.finish();
            }
        }

        public void recalculateWidth() {
            ListModel model = SearchEverywhereAction.this.myList.getModel();
            this.myTitle.setIcon(EmptyIcon.ICON_16);
            this.myTitle.setFont(SearchEverywhereAction.getTitleFont());
            for (int index = 0; index < model.getSize(); ++index) {
                String title = ((SearchEverywhereAction)SearchEverywhereAction.this).getModel().titleIndex.getTitle(index);
                if (title == null) continue;
                this.myTitle.setText(title);
            }
            this.myTitle.setForeground((Color)Gray._122);
            this.myTitle.setAlignmentY(1.0f);
        }
    }

    private static class MySearchTextField
    extends SearchTextField
    implements DataProvider,
    Disposable {
        public MySearchTextField() {
            super(false);
            this.getTextEditor().setOpaque(false);
            this.getTextEditor().setUI((DarculaTextFieldUI)DarculaTextFieldUI.createUI(this.getTextEditor()));
            this.getTextEditor().setBorder(new DarculaTextBorder());
            this.getTextEditor().putClientProperty("JTextField.Search.noBorderRing", Boolean.TRUE);
            if (UIUtil.isUnderDarcula()) {
                this.getTextEditor().setBackground((Color)Gray._45);
                this.getTextEditor().setForeground((Color)Gray._240);
            }
        }

        protected boolean isSearchControlUISupported() {
            return true;
        }

        protected boolean hasIconsOutsideOfTextField() {
            return false;
        }

        protected void showPopup() {
        }

        @Nullable
        public Object getData(@NonNls String dataId) {
            if (PlatformDataKeys.PREDEFINED_TEXT.is(dataId)) {
                return this.getTextEditor().getText();
            }
            return null;
        }

        public void dispose() {
        }
    }

    static class SEOption
    extends BooleanOptionDescription {
        private final String myKey;

        public SEOption(String option, String registryKey) {
            super(option, null);
            this.myKey = registryKey;
        }

        public boolean isOptionEnabled() {
            return Registry.is((String)this.myKey);
        }

        public void setOptionState(boolean enabled) {
            Registry.get((String)this.myKey).setValue(enabled);
        }
    }
}

