/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.persistence;

import com.intellij.internal.statistic.beans.GroupDescriptor;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class ApplicationStatisticsPersistence {
    private final Map<GroupDescriptor, Map<String, Set<UsageDescriptor>>> myApplicationData = new HashMap();

    public void persistUsages(@NotNull GroupDescriptor groupDescriptor, @NotNull Project project, @NotNull Set<UsageDescriptor> usageDescriptors) {
        if (groupDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupDescriptor", "com/intellij/internal/statistic/persistence/ApplicationStatisticsPersistence", "persistUsages"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/internal/statistic/persistence/ApplicationStatisticsPersistence", "persistUsages"));
        }
        if (usageDescriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageDescriptors", "com/intellij/internal/statistic/persistence/ApplicationStatisticsPersistence", "persistUsages"));
        }
        if (!this.myApplicationData.containsKey(groupDescriptor)) {
            this.myApplicationData.put(groupDescriptor, (Map<String, Set<UsageDescriptor>>)new HashMap());
        }
        this.myApplicationData.get(groupDescriptor).put(project.getName(), usageDescriptors);
    }

    @NotNull
    public Map<String, Set<UsageDescriptor>> getApplicationData(@NotNull GroupDescriptor groupDescriptor) {
        if (groupDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupDescriptor", "com/intellij/internal/statistic/persistence/ApplicationStatisticsPersistence", "getApplicationData"));
        }
        if (!this.myApplicationData.containsKey(groupDescriptor)) {
            this.myApplicationData.put(groupDescriptor, (Map<String, Set<UsageDescriptor>>)new HashMap());
        }
        Map<String, Set<UsageDescriptor>> map = this.myApplicationData.get(groupDescriptor);
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/statistic/persistence/ApplicationStatisticsPersistence", "getApplicationData"));
        }
        return map;
    }

    @NotNull
    public Map<GroupDescriptor, Map<String, Set<UsageDescriptor>>> getApplicationData() {
        Map<GroupDescriptor, Map<String, Set<UsageDescriptor>>> map = this.myApplicationData;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/statistic/persistence/ApplicationStatisticsPersistence", "getApplicationData"));
        }
        return map;
    }
}

