/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.psi;

import com.intellij.json.JsonElementTypes;
import com.intellij.json.JsonParserDefinition;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonValue;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class JsonPsiUtil {
    private JsonPsiUtil() {
    }

    public static boolean isArrayElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/json/psi/JsonPsiUtil", "isArrayElement"));
        }
        return element instanceof JsonValue && element.getParent() instanceof JsonArray;
    }

    public static boolean isPropertyKey(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/json/psi/JsonPsiUtil", "isPropertyKey"));
        }
        PsiElement parent = element.getParent();
        return parent instanceof JsonProperty && element == ((JsonProperty)parent).getNameElement();
    }

    public static boolean isPropertyValue(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/json/psi/JsonPsiUtil", "isPropertyValue"));
        }
        PsiElement parent = element.getParent();
        return parent instanceof JsonProperty && element == ((JsonProperty)parent).getValue();
    }

    @NotNull
    public static PsiElement findFurthestSiblingOfSameType(@NotNull PsiElement anchor, boolean after) {
        if (anchor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/intellij/json/psi/JsonPsiUtil", "findFurthestSiblingOfSameType"));
        }
        ASTNode node = anchor.getNode();
        IElementType expectedType = node.getElementType();
        ASTNode lastSeen = node;
        while (node != null) {
            IElementType elementType = node.getElementType();
            if (elementType == expectedType) {
                lastSeen = node;
            } else if (elementType != TokenType.WHITE_SPACE ? !JsonParserDefinition.JSON_COMMENTARIES.contains(elementType) || JsonParserDefinition.JSON_COMMENTARIES.contains(expectedType) : expectedType == JsonElementTypes.LINE_COMMENT && node.getText().indexOf(10, 1) != -1) break;
            node = after ? node.getTreeNext() : node.getTreePrev();
        }
        PsiElement psiElement = lastSeen.getPsi();
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/json/psi/JsonPsiUtil", "findFurthestSiblingOfSameType"));
        }
        return psiElement;
    }
}

