/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl.stores;

import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.components.impl.stores.BaseFileConfigurableStoreImpl;
import com.intellij.openapi.components.impl.stores.ProjectStateStorageManager;
import com.intellij.openapi.components.impl.stores.ProjectStoreImpl;
import com.intellij.openapi.components.impl.stores.ProjectWithModulesStoreImpl;
import com.intellij.openapi.components.impl.stores.StateStorageManager;
import com.intellij.openapi.components.impl.stores.StorageData;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.impl.ProjectImpl;
import com.intellij.openapi.project.impl.convertors.Convertor01;
import com.intellij.openapi.project.impl.convertors.Convertor12;
import com.intellij.openapi.project.impl.convertors.Convertor23;
import com.intellij.openapi.project.impl.convertors.Convertor34;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class IdeaProjectStoreImpl
extends ProjectWithModulesStoreImpl {
    public IdeaProjectStoreImpl(ProjectImpl project) {
        super(project);
    }

    @Override
    @NotNull
    protected StateStorageManager createStateStorageManager() {
        ProjectStateStorageManager projectStateStorageManager = new ProjectStateStorageManager(PathMacroManager.getInstance(this.getComponentManager()).createTrackingSubstitutor(), this.myProject){

            @Override
            public StorageData createWsStorageData() {
                return new IdeaWsStorageData("project", this.myProject);
            }

            @Override
            public StorageData createIprStorageData() {
                return new IdeaIprStorageData("project", this.myProject);
            }
        };
        if (projectStateStorageManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/IdeaProjectStoreImpl", "createStateStorageManager"));
        }
        return projectStateStorageManager;
    }

    private class IdeaIprStorageData
    extends ProjectStoreImpl.IprStorageData {
        public IdeaIprStorageData(String rootElementName, Project project) {
            super(rootElementName, project);
        }

        public IdeaIprStorageData(ProjectStoreImpl.IprStorageData storageData) {
            super(storageData);
        }

        @Override
        public StorageData clone() {
            return new IdeaIprStorageData(this);
        }

        @Override
        protected void convert(Element root, int originalVersion) {
            if (originalVersion < 1) {
                Convertor01.execute(root);
            }
            if (originalVersion < 2) {
                Convertor12.execute(root);
            }
            if (originalVersion < 3) {
                Convertor23.execute(root);
            }
            if (originalVersion < 4) {
                Convertor34.execute(root, this.myFilePath, BaseFileConfigurableStoreImpl.getConversionProblemsStorage());
            }
        }
    }

    private class IdeaWsStorageData
    extends ProjectStoreImpl.WsStorageData {
        public IdeaWsStorageData(String rootElementName, Project project) {
            super(rootElementName, project);
        }

        public IdeaWsStorageData(ProjectStoreImpl.WsStorageData storageData) {
            super(storageData);
        }

        @Override
        public StorageData clone() {
            return new IdeaWsStorageData(this);
        }
    }
}

