/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.ui.TypingTarget;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.ui.Grayer;
import com.intellij.ui.components.Magnificator;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.InputMethodEvent;
import java.awt.im.InputMethodRequests;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class EditorComponentImpl
extends JComponent
implements Scrollable,
DataProvider,
Queryable,
TypingTarget {
    private final EditorImpl myEditor;
    private final ApplicationImpl myApplication;

    public EditorComponentImpl(@NotNull EditorImpl editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/impl/EditorComponentImpl", "<init>"));
        }
        this.myEditor = editor;
        this.enableEvents(2056L);
        this.enableInputMethods(true);
        this.setFocusCycleRoot(true);
        this.setOpaque(true);
        this.putClientProperty(Magnificator.CLIENT_PROPERTY_KEY, new Magnificator(){

            public Point magnify(double scale, Point at) {
                VisualPosition magnificationPosition = EditorComponentImpl.this.myEditor.xyToVisualPosition(at);
                double currentSize = EditorComponentImpl.this.myEditor.getColorsScheme().getEditorFontSize();
                int defaultFontSize = EditorColorsManager.getInstance().getGlobalScheme().getEditorFontSize();
                EditorComponentImpl.this.myEditor.setFontSize(Math.max((int)(currentSize * scale), defaultFontSize));
                return EditorComponentImpl.this.myEditor.visualPositionToXY(magnificationPosition);
            }
        });
        this.myApplication = (ApplicationImpl)ApplicationManager.getApplication();
    }

    @Override
    public void paint(@NotNull Graphics g) {
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/openapi/editor/impl/EditorComponentImpl", "paint"));
        }
        if (!this.isEnabled()) {
            g = new Grayer((Graphics2D)g, EditorColorsManager.getInstance().getGlobalScheme().getDefaultBackground());
        }
        super.paint(g);
    }

    @NotNull
    public EditorImpl getEditor() {
        EditorImpl editorImpl = this.myEditor;
        if (editorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorComponentImpl", "getEditor"));
        }
        return editorImpl;
    }

    public Object getData(String dataId) {
        if (this.myEditor.isRendererMode()) {
            return null;
        }
        if (CommonDataKeys.EDITOR.is(dataId)) {
            return this.myEditor.getVirtualFile() == null ? this.myEditor : null;
        }
        if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId)) {
            return this.myEditor.getDeleteProvider();
        }
        if (PlatformDataKeys.CUT_PROVIDER.is(dataId)) {
            return this.myEditor.getCutProvider();
        }
        if (PlatformDataKeys.COPY_PROVIDER.is(dataId)) {
            return this.myEditor.getCopyProvider();
        }
        if (PlatformDataKeys.PASTE_PROVIDER.is(dataId)) {
            return this.myEditor.getPasteProvider();
        }
        return null;
    }

    @Override
    public Color getBackground() {
        return this.myEditor.getBackgroundColor();
    }

    @Override
    public Dimension getPreferredSize() {
        return this.myEditor.getPreferredSize();
    }

    protected void fireResized() {
        this.processComponentEvent(new ComponentEvent(this, 101));
    }

    @Override
    protected void processInputMethodEvent(InputMethodEvent e) {
        super.processInputMethodEvent(e);
        if (!e.isConsumed()) {
            switch (e.getID()) {
                case 1100: {
                    this.myEditor.replaceInputMethodText(e);
                }
                case 1101: {
                    this.myEditor.inputMethodCaretPositionChanged(e);
                }
            }
            e.consume();
        }
    }

    public ActionCallback type(final String text) {
        final ActionCallback result = new ActionCallback();
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                EditorComponentImpl.this.myEditor.type(text).notify(result);
            }
        });
        return result;
    }

    @Override
    public InputMethodRequests getInputMethodRequests() {
        return IdeEventQueue.getInstance().isInputMethodEnabled() ? this.myEditor.getInputMethodRequests() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintComponent(Graphics g) {
        this.myApplication.editorPaintStart();
        try {
            UIUtil.setupComposite((Graphics2D)((Graphics2D)g));
            UISettings.setupAntialiasing((Graphics)g);
            this.myEditor.paint((Graphics2D)g);
        }
        finally {
            this.myApplication.editorPaintFinish();
        }
    }

    @Override
    public void revalidate() {
        this.myEditor.resetPaintersWidth();
        super.revalidate();
    }

    public void repaintEditorComponent() {
        this.repaint();
    }

    public void repaintEditorComponent(int x, int y, int width, int height) {
        this.repaint(x, y, width, height);
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.myEditor.getPreferredSize();
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation == 1) {
            return this.myEditor.getLineHeight();
        }
        return EditorUtil.getSpaceWidth(0, this.myEditor);
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation == 1) {
            int lineHeight = this.myEditor.getLineHeight();
            if (direction > 0) {
                int lineNumber = (visibleRect.y + visibleRect.height) / lineHeight;
                return lineHeight * lineNumber - visibleRect.y;
            }
            int lineNumber = (visibleRect.y - visibleRect.height) / lineHeight;
            return visibleRect.y - lineHeight * lineNumber;
        }
        return visibleRect.width;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return this.getParent() instanceof JViewport && this.getParent().getWidth() > this.getPreferredSize().width;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return this.getParent() instanceof JViewport && this.getParent().getHeight() > this.getPreferredSize().height;
    }

    public void putInfo(@NotNull Map<String, String> info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/openapi/editor/impl/EditorComponentImpl", "putInfo"));
        }
        this.myEditor.putInfo(info);
    }

    @Override
    @NonNls
    public String toString() {
        return "EditorComponent file=" + this.myEditor.getVirtualFile();
    }
}

