/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.task.ui;

import com.intellij.execution.Location;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.ide.ui.customization.CustomizationUtil;
import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalTaskExecutionInfo;
import com.intellij.openapi.externalSystem.model.project.ExternalProjectPojo;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemTaskLocation;
import com.intellij.openapi.externalSystem.service.task.ui.ExternalSystemNode;
import com.intellij.openapi.externalSystem.service.task.ui.ExternalSystemRecentTaskListModel;
import com.intellij.openapi.externalSystem.service.task.ui.ExternalSystemRecentTasksList;
import com.intellij.openapi.externalSystem.service.task.ui.ExternalSystemTasksTree;
import com.intellij.openapi.externalSystem.service.task.ui.ExternalSystemTasksTreeModel;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemLocalSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemUiUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.Producer;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemTasksPanel
extends SimpleToolWindowPanel
implements DataProvider {
    @NotNull
    private final ExternalSystemRecentTasksList myRecentTasksList;
    @NotNull
    private final ExternalSystemTasksTreeModel myAllTasksModel;
    @NotNull
    private final ExternalSystemTasksTree myAllTasksTree;
    @NotNull
    private final ProjectSystemId myExternalSystemId;
    @NotNull
    private final NotificationGroup myNotificationGroup;
    @NotNull
    private final Project myProject;
    @Nullable
    private Producer<ExternalTaskExecutionInfo> mySelectedTaskProvider;

    public ExternalSystemTasksPanel(@NotNull Project project, @NotNull ProjectSystemId externalSystemId, @NotNull NotificationGroup notificationGroup) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/task/ui/ExternalSystemTasksPanel", "<init>"));
        }
        if (externalSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalSystemId", "com/intellij/openapi/externalSystem/service/task/ui/ExternalSystemTasksPanel", "<init>"));
        }
        if (notificationGroup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notificationGroup", "com/intellij/openapi/externalSystem/service/task/ui/ExternalSystemTasksPanel", "<init>"));
        }
        super(true);
        this.myExternalSystemId = externalSystemId;
        this.myNotificationGroup = notificationGroup;
        this.myProject = project;
        ExternalSystemManager manager = ExternalSystemApiUtil.getManager((ProjectSystemId)externalSystemId);
        assert (manager != null);
        AbstractExternalSystemLocalSettings settings = (AbstractExternalSystemLocalSettings)manager.getLocalSettingsProvider().fun((Object)project);
        ExternalSystemRecentTaskListModel recentTasksModel = new ExternalSystemRecentTaskListModel(externalSystemId, project);
        recentTasksModel.setTasks(settings.getRecentTasks());
        this.myRecentTasksList = new ExternalSystemRecentTasksList(recentTasksModel, externalSystemId, project){

            protected void processMouseEvent(MouseEvent e) {
                if (e.getClickCount() > 0) {
                    ExternalSystemTasksPanel.this.mySelectedTaskProvider = ExternalSystemTasksPanel.this.myRecentTasksList;
                    ExternalSystemTasksPanel.this.myAllTasksTree.getSelectionModel().clearSelection();
                }
                super.processMouseEvent(e);
            }
        };
        this.myAllTasksModel = new ExternalSystemTasksTreeModel(externalSystemId);
        this.myAllTasksTree = new ExternalSystemTasksTree(this.myAllTasksModel, settings.getExpandStates(), project, externalSystemId){

            protected void processMouseEvent(MouseEvent e) {
                if (e.getClickCount() > 0) {
                    ExternalSystemTasksPanel.this.mySelectedTaskProvider = ExternalSystemTasksPanel.this.myAllTasksTree;
                    ExternalSystemTasksPanel.this.myRecentTasksList.getSelectionModel().clearSelection();
                }
                super.processMouseEvent(e);
            }
        };
        final String actionIdToUseForDoubleClick = DefaultRunExecutor.getRunExecutorInstance().getContextActionId();
        this.myAllTasksTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() >= 2 && !e.isPopupTrigger()) {
                    ExternalSystemUiUtil.executeAction(actionIdToUseForDoubleClick, e);
                }
            }
        });
        ExternalSystemUiUtil.apply(settings, this.myAllTasksModel);
        CustomizationUtil.installPopupHandler((JComponent)((Object)this.myAllTasksTree), "ExternalSystem.Tree.Context", "ExternalSystem.Tree.Context.Menu");
        ActionManager actionManager = ActionManager.getInstance();
        ActionGroup group = (ActionGroup)actionManager.getAction("ExternalSystem.ToolWindow.Toolbar");
        ActionToolbar toolbar = actionManager.createActionToolbar("ExternalSystem.ToolWindow", group, true);
        toolbar.setTargetComponent((JComponent)((Object)this));
        this.setToolbar(toolbar.getComponent());
        JPanel content = new JPanel(new GridBagLayout());
        content.setOpaque(true);
        content.setBackground(UIUtil.getListBackground());
        JComponent recentTasksWithTitle = ExternalSystemTasksPanel.wrap((JComponent)((Object)this.myRecentTasksList), ExternalSystemBundle.message((String)"tasks.recent.title", (Object[])new Object[0]));
        content.add((Component)recentTasksWithTitle, ExternalSystemUiUtil.getFillLineConstraints(0));
        JBScrollPane scrollPane = new JBScrollPane((Component)((Object)this.myAllTasksTree));
        scrollPane.setBorder(null);
        JComponent allTasksWithTitle = ExternalSystemTasksPanel.wrap((JComponent)scrollPane, ExternalSystemBundle.message((String)"tasks.all.title", (Object[])new Object[0]));
        content.add((Component)allTasksWithTitle, ExternalSystemUiUtil.getFillLineConstraints(0).weighty(1.0).fillCell());
        this.setContent(content);
    }

    private static JComponent wrap(@NotNull JComponent content, @NotNull String title) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/openapi/externalSystem/service/task/ui/ExternalSystemTasksPanel", "wrap"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/openapi/externalSystem/service/task/ui/ExternalSystemTasksPanel", "wrap"));
        }
        JPanel result = new JPanel(new BorderLayout());
        result.setOpaque(false);
        result.setBorder((Border)IdeBorderFactory.createTitledBorder((String)title, (boolean)false));
        result.add((Component)content, "Center");
        return result;
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        if (ExternalSystemDataKeys.RECENT_TASKS_LIST.is(dataId)) {
            return this.myRecentTasksList;
        }
        if (ExternalSystemDataKeys.ALL_TASKS_MODEL.is(dataId)) {
            return this.myAllTasksModel;
        }
        if (ExternalSystemDataKeys.EXTERNAL_SYSTEM_ID.is(dataId)) {
            return this.myExternalSystemId;
        }
        if (ExternalSystemDataKeys.NOTIFICATION_GROUP.is(dataId)) {
            return this.myNotificationGroup;
        }
        if (ExternalSystemDataKeys.SELECTED_TASK.is(dataId)) {
            return this.mySelectedTaskProvider == null ? null : (ExternalTaskExecutionInfo)this.mySelectedTaskProvider.produce();
        }
        if (ExternalSystemDataKeys.SELECTED_PROJECT.is(dataId)) {
            if (this.mySelectedTaskProvider != this.myAllTasksTree) {
                return null;
            }
            Object component = this.myAllTasksTree.getLastSelectedPathComponent();
            if (component instanceof ExternalSystemNode) {
                Object element = ((ExternalSystemNode)component).getDescriptor().getElement();
                return element instanceof ExternalProjectPojo ? element : null;
            }
        } else if (Location.DATA_KEY.is(dataId)) {
            Location location = this.buildLocation();
            return location == null ? super.getData(dataId) : location;
        }
        return null;
    }

    @Nullable
    private Location buildLocation() {
        if (this.mySelectedTaskProvider == null) {
            return null;
        }
        ExternalTaskExecutionInfo task = (ExternalTaskExecutionInfo)this.mySelectedTaskProvider.produce();
        if (task == null) {
            return null;
        }
        String projectPath = task.getSettings().getExternalProjectPath();
        String name = this.myExternalSystemId.getReadableName() + projectPath + StringUtil.join((Collection)task.getSettings().getTaskNames(), (String)" ");
        PsiFile file = PsiFileFactory.getInstance((Project)this.myProject).createFileFromText(name, (FileType)PlainTextFileType.INSTANCE, (CharSequence)"nichts");
        return new ExternalSystemTaskLocation(this.myProject, file, task);
    }
}

