/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.newEditor;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableGroup;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.options.ex.ConfigurableVisitor;
import com.intellij.openapi.options.ex.ConfigurableWrapper;
import com.intellij.openapi.options.ex.Settings;
import com.intellij.openapi.options.newEditor.AbstractEditor;
import com.intellij.openapi.options.newEditor.Banner;
import com.intellij.openapi.options.newEditor.ConfigurableEditor;
import com.intellij.openapi.options.newEditor.OptionsEditorColleague;
import com.intellij.openapi.options.newEditor.SettingsFilter;
import com.intellij.openapi.options.newEditor.SettingsSearch;
import com.intellij.openapi.options.newEditor.SettingsTreeView;
import com.intellij.openapi.options.newEditor.SpotlightPainter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.OnePixelDivider;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.ui.treeStructure.SimpleNode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.LinkedHashMap;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

final class SettingsEditor
extends AbstractEditor
implements DataProvider {
    private static final String SELECTED_CONFIGURABLE = "settings.editor.selected.configurable";
    private static final String SPLITTER_PROPORTION = "settings.editor.splitter.proportion";
    private final PropertiesComponent myProperties;
    private final Settings mySettings;
    private final SettingsSearch mySearch;
    private final SettingsFilter myFilter;
    private final SettingsTreeView myTreeView;
    private final ConfigurableEditor myEditor;
    private final OnePixelSplitter mySplitter;
    private final SpotlightPainter mySpotlightPainter;
    private final Banner myBanner;

    SettingsEditor(Disposable parent, Project project, ConfigurableGroup[] groups, Configurable configurable, String filter) {
        super(parent);
        String id;
        this.myProperties = PropertiesComponent.getInstance((Project)project);
        this.mySettings = new Settings(groups){

            @Override
            protected ActionCallback selectImpl(Configurable configurable) {
                SettingsEditor.this.myFilter.update((String)null, false, true);
                return SettingsEditor.this.myTreeView.select(configurable);
            }
        };
        this.mySearch = new SettingsSearch(){

            @Override
            void onTextKeyEvent(KeyEvent event) {
                ((SettingsEditor)SettingsEditor.this).myTreeView.myTree.processKeyEvent(event);
            }
        };
        this.myFilter = new SettingsFilter(project, groups, this.mySearch){

            @Override
            Configurable getConfigurable(SimpleNode node) {
                return SettingsTreeView.getConfigurable(node);
            }

            @Override
            SimpleNode findNode(Configurable configurable) {
                return SettingsEditor.this.myTreeView.findNode(configurable);
            }

            @Override
            void updateSpotlight(boolean now) {
                if (!SettingsEditor.this.myDisposed && SettingsEditor.this.mySpotlightPainter != null) {
                    if (!now) {
                        SettingsEditor.this.mySpotlightPainter.updateLater();
                    } else {
                        SettingsEditor.this.mySpotlightPainter.updateNow();
                    }
                }
            }
        };
        this.myFilter.myContext.addColleague(new OptionsEditorColleague(){

            @Override
            public ActionCallback onSelected(@Nullable Configurable configurable, Configurable oldConfigurable) {
                if (configurable != null) {
                    SettingsEditor.this.myProperties.setValue(SettingsEditor.SELECTED_CONFIGURABLE, ConfigurableVisitor.ByID.getID(configurable));
                }
                SettingsEditor.this.checkModified(oldConfigurable);
                return SettingsEditor.this.myEditor.select(configurable);
            }

            @Override
            public ActionCallback onModifiedAdded(Configurable configurable) {
                return this.updateIfCurrent(configurable);
            }

            @Override
            public ActionCallback onModifiedRemoved(Configurable configurable) {
                return this.updateIfCurrent(configurable);
            }

            @Override
            public ActionCallback onErrorsChanged() {
                return this.updateIfCurrent(((SettingsEditor)SettingsEditor.this).myFilter.myContext.getCurrentConfigurable());
            }

            private ActionCallback updateIfCurrent(Configurable configurable) {
                if (configurable != null && configurable == ((SettingsEditor)SettingsEditor.this).myFilter.myContext.getCurrentConfigurable()) {
                    SettingsEditor.this.updateStatus(configurable);
                    return ActionCallback.DONE;
                }
                return ActionCallback.REJECTED;
            }
        });
        this.myTreeView = new SettingsTreeView(this.myFilter, groups);
        this.myTreeView.myTree.addKeyListener((KeyListener)this.mySearch);
        this.myTreeView.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent event) {
                Dimension size = SettingsEditor.this.mySearch.getPreferredSize();
                size.width = SettingsEditor.this.myTreeView.getWidth() - 10;
                SettingsEditor.this.mySearch.setPreferredSize(size);
                SettingsEditor.this.mySearch.setSize(size);
                SettingsEditor.this.mySearch.revalidate();
                SettingsEditor.this.mySearch.repaint();
            }
        });
        this.myEditor = new ConfigurableEditor(this, null, true){

            @Override
            boolean apply() {
                SettingsEditor.this.checkModified(((SettingsEditor)SettingsEditor.this).myFilter.myContext.getCurrentConfigurable());
                if (((SettingsEditor)SettingsEditor.this).myFilter.myContext.getModified().isEmpty()) {
                    return true;
                }
                LinkedHashMap<Configurable, ConfigurationException> map = new LinkedHashMap<Configurable, ConfigurationException>();
                for (Configurable configurable : ((SettingsEditor)SettingsEditor.this).myFilter.myContext.getModified()) {
                    ConfigurationException exception = ConfigurableEditor.apply(configurable);
                    if (exception != null) {
                        map.put(configurable, exception);
                        continue;
                    }
                    if (configurable.isModified()) continue;
                    ((SettingsEditor)SettingsEditor.this).myFilter.myContext.fireModifiedRemoved(configurable, null);
                }
                ((SettingsEditor)SettingsEditor.this).myFilter.myContext.fireErrorsChanged(map, null);
                if (!map.isEmpty()) {
                    SettingsEditor.this.myTreeView.select((Configurable)map.keySet().iterator().next());
                    return false;
                }
                SettingsEditor.this.updateStatus(((SettingsEditor)SettingsEditor.this).myFilter.myContext.getCurrentConfigurable());
                return true;
            }

            @Override
            void updateCurrent(Configurable configurable, boolean reset) {
                if (reset && configurable != null) {
                    ((SettingsEditor)SettingsEditor.this).myFilter.myContext.fireReset(configurable);
                }
                SettingsEditor.this.checkModified(configurable);
            }

            @Override
            void openLink(Configurable configurable) {
                SettingsEditor.this.mySettings.select(configurable);
            }
        };
        this.mySplitter = new OnePixelSplitter(false, this.myProperties.getFloat(SPLITTER_PROPORTION, 0.2f));
        this.mySplitter.setHonorComponentsMinimumSize(true);
        this.mySplitter.setFirstComponent((JComponent)this.myTreeView);
        this.mySplitter.setSecondComponent((JComponent)this.myEditor);
        this.mySpotlightPainter = new SpotlightPainter(this.myEditor, this){

            @Override
            void updateNow() {
                Configurable configurable = ((SettingsEditor)SettingsEditor.this).myFilter.myContext.getCurrentConfigurable();
                this.update(SettingsEditor.this.myFilter, configurable, SettingsEditor.this.myEditor.getContent(configurable));
            }
        };
        this.myBanner = new Banner(this.myEditor.getResetAction());
        this.myBanner.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        JPanel panel = new JPanel(new BorderLayout(10, 10));
        panel.add("West", (Component)((Object)this.mySearch));
        panel.add("Center", this.myBanner);
        panel.setBorder(BorderFactory.createCompoundBorder((Border)new CustomLineBorder(OnePixelDivider.BACKGROUND, 0, 0, 1, 0), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.add("North", panel);
        this.add("Center", (Component)this.mySplitter);
        if (configurable == null && (configurable = new ConfigurableVisitor.ByID((id = this.myProperties.getValue(SELECTED_CONFIGURABLE)) != null ? id : "preferences.lookFeel").find(groups)) == null) {
            configurable = ConfigurableVisitor.ALL.find(groups);
        }
        this.myFilter.update(filter, false, true);
        this.myTreeView.select(configurable);
        Disposer.register((Disposable)this, (Disposable)this.myTreeView);
    }

    public Object getData(@NonNls String dataId) {
        return Settings.KEY.is(dataId) ? this.mySettings : null;
    }

    @Override
    void disposeOnce() {
        this.myProperties.setValue(SPLITTER_PROPORTION, Float.toString(this.mySplitter.getProportion()));
    }

    @Override
    Action getApplyAction() {
        return this.myEditor.getApplyAction();
    }

    @Override
    Action getResetAction() {
        return null;
    }

    @Override
    String getHelpTopic() {
        Configurable configurable = this.myFilter.myContext.getCurrentConfigurable();
        while (configurable != null) {
            String topic = configurable.getHelpTopic();
            if (topic != null) {
                return topic;
            }
            configurable = this.myFilter.myContext.getParentConfigurable(configurable);
        }
        return null;
    }

    @Override
    boolean apply() {
        return this.myEditor.apply();
    }

    @Override
    boolean cancel() {
        if (this.myFilter.myContext.isHoldingFilter()) {
            this.mySearch.setText("");
            return false;
        }
        return super.cancel();
    }

    @Override
    JComponent getPreferredFocusedComponent() {
        return this.myTreeView != null ? this.myTreeView.myTree : this.myEditor;
    }

    void updateStatus(Configurable configurable) {
        this.myFilter.updateSpotlight(configurable == null);
        if (this.myBanner != null) {
            this.myBanner.setProject(this.myTreeView.findConfigurableProject(configurable));
            this.myBanner.setText(this.myTreeView.getPathNames(configurable));
        }
        if (this.myEditor != null) {
            ConfigurationException exception = this.myFilter.myContext.getErrors().get(configurable);
            this.myEditor.getApplyAction().setEnabled(!this.myFilter.myContext.getModified().isEmpty());
            this.myEditor.getResetAction().setEnabled(this.myFilter.myContext.isModified(configurable) || exception != null);
            this.myEditor.setError(exception);
        }
    }

    void checkModified(Configurable configurable) {
        Configurable parent = this.myFilter.myContext.getParentConfigurable(configurable);
        if (ConfigurableWrapper.hasOwnContent((UnnamedConfigurable)parent)) {
            this.checkModifiedForItem(parent);
            for (Configurable child : this.myFilter.myContext.getChildren(parent)) {
                this.checkModifiedForItem(child);
            }
        } else if (configurable != null) {
            this.checkModifiedForItem(configurable);
        }
        this.updateStatus(configurable);
    }

    private void checkModifiedForItem(Configurable configurable) {
        if (configurable != null) {
            JComponent component = this.myEditor.getContent(configurable);
            if (component == null && ConfigurableWrapper.hasOwnContent((UnnamedConfigurable)configurable)) {
                component = this.myEditor.readContent(configurable);
            }
            if (component != null) {
                this.checkModifiedInternal(configurable);
            }
        }
    }

    private void checkModifiedInternal(Configurable configurable) {
        if (configurable.isModified()) {
            this.myFilter.myContext.fireModifiedAdded(configurable, null);
        } else if (!this.myFilter.myContext.getErrors().containsKey(configurable)) {
            this.myFilter.myContext.fireModifiedRemoved(configurable, null);
        }
    }
}

