/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.preview;

import com.intellij.openapi.preview.PreviewPanelProvider;
import com.intellij.openapi.preview.PreviewProviderId;
import com.intellij.util.ui.EmptyIcon;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class PreviewInfo<V, C> {
    @NotNull
    private final PreviewPanelProvider<V, C> myProvider;
    @NotNull
    private final V myData;

    public static <V, C> PreviewInfo<V, C> create(@NotNull PreviewPanelProvider<V, C> provider, @NotNull V data) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/openapi/preview/PreviewInfo", "create"));
        }
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/openapi/preview/PreviewInfo", "create"));
        }
        return new PreviewInfo<V, C>(provider, data);
    }

    public PreviewInfo(@NotNull PreviewPanelProvider<V, C> provider, @NotNull V data) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/openapi/preview/PreviewInfo", "<init>"));
        }
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/openapi/preview/PreviewInfo", "<init>"));
        }
        this.myProvider = provider;
        this.myData = data;
    }

    public PreviewProviderId<V, C> getId() {
        return this.myProvider.getId();
    }

    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myProvider.getComponent();
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/preview/PreviewInfo", "getComponent"));
        }
        return jComponent;
    }

    @NotNull
    public String getTitle() {
        String string = this.myProvider.getTitle(this.myData);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/preview/PreviewInfo", "getTitle"));
        }
        return string;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = this.myProvider.getIcon(this.myData);
        Icon icon2 = icon != null ? icon : EmptyIcon.ICON_16;
        if (icon2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/preview/PreviewInfo", "getIcon"));
        }
        return icon2;
    }

    @NotNull
    public PreviewPanelProvider<V, C> getProvider() {
        PreviewPanelProvider<V, C> previewPanelProvider = this.myProvider;
        if (previewPanelProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/preview/PreviewInfo", "getProvider"));
        }
        return previewPanelProvider;
    }

    @NotNull
    public V getData() {
        V v = this.myData;
        if (v == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/preview/PreviewInfo", "getData"));
        }
        return v;
    }

    public C initComponent(boolean requestFocus) {
        return this.myProvider.initComponent(this.myData, requestFocus);
    }

    public int hashCode() {
        return this.myProvider.hashCode() * 31 + this.myData.hashCode();
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof PreviewInfo && ((PreviewInfo)obj).myProvider.equals(this.myProvider) && ((PreviewInfo)obj).myData.equals(this.myData);
    }
}

