/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationAdapter;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.progress.util.ReadTask;
import com.intellij.ui.AppUIUtil;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.ide.PooledThreadExecutor;

public class ProgressIndicatorUtils {
    private ProgressIndicatorUtils() {
    }

    @NotNull
    public static ProgressIndicator forceWriteActionPriority(final @NotNull ProgressIndicator progress, @NotNull Disposable builder) {
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/openapi/progress/util/ProgressIndicatorUtils", "forceWriteActionPriority"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/openapi/progress/util/ProgressIndicatorUtils", "forceWriteActionPriority"));
        }
        ApplicationManager.getApplication().addApplicationListener((ApplicationListener)new ApplicationAdapter(){

            public void beforeWriteActionStart(Object action) {
                if (progress.isRunning()) {
                    progress.cancel();
                }
            }
        }, builder);
        ProgressIndicator progressIndicator = progress;
        if (progressIndicator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/progress/util/ProgressIndicatorUtils", "forceWriteActionPriority"));
        }
        return progressIndicator;
    }

    public static void scheduleWithWriteActionPriority(@NotNull ReadTask task) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/progress/util/ProgressIndicatorUtils", "scheduleWithWriteActionPriority"));
        }
        ProgressIndicatorUtils.scheduleWithWriteActionPriority(new ProgressIndicatorBase(), task);
    }

    public static void scheduleWithWriteActionPriority(@NotNull ProgressIndicator progressIndicator, @NotNull ReadTask readTask) {
        if (progressIndicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressIndicator", "com/intellij/openapi/progress/util/ProgressIndicatorUtils", "scheduleWithWriteActionPriority"));
        }
        if (readTask == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "readTask", "com/intellij/openapi/progress/util/ProgressIndicatorUtils", "scheduleWithWriteActionPriority"));
        }
        ProgressIndicatorUtils.scheduleWithWriteActionPriority(progressIndicator, PooledThreadExecutor.INSTANCE, readTask);
    }

    public static void scheduleWithWriteActionPriority(final @NotNull ProgressIndicator progressIndicator, final @NotNull Executor executor, final @NotNull ReadTask readTask) {
        if (progressIndicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressIndicator", "com/intellij/openapi/progress/util/ProgressIndicatorUtils", "scheduleWithWriteActionPriority"));
        }
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/openapi/progress/util/ProgressIndicatorUtils", "scheduleWithWriteActionPriority"));
        }
        if (readTask == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "readTask", "com/intellij/openapi/progress/util/ProgressIndicatorUtils", "scheduleWithWriteActionPriority"));
        }
        AppUIUtil.invokeOnEdt(new Runnable(){

            @Override
            public void run() {
                final Application application = ApplicationManager.getApplication();
                application.assertIsDispatchThread();
                final ApplicationAdapter listener = new ApplicationAdapter(){

                    public void beforeWriteActionStart(Object action) {
                        progressIndicator.cancel();
                    }
                };
                application.addApplicationListener((ApplicationListener)listener);
                try {
                    executor.execute(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            try {
                                ProgressIndicatorUtils.runUnderProgress(progressIndicator, readTask);
                            }
                            finally {
                                application.removeApplicationListener((ApplicationListener)listener);
                            }
                        }
                    });
                }
                catch (RuntimeException e) {
                    application.removeApplicationListener((ApplicationListener)listener);
                    throw e;
                }
                catch (Error e) {
                    application.removeApplicationListener((ApplicationListener)listener);
                    throw e;
                }
            }
        });
    }

    private static void runUnderProgress(final @NotNull ProgressIndicator progressIndicator, final @NotNull ReadTask task) {
        if (progressIndicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressIndicator", "com/intellij/openapi/progress/util/ProgressIndicatorUtils", "runUnderProgress"));
        }
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/progress/util/ProgressIndicatorUtils", "runUnderProgress"));
        }
        ProgressManager.getInstance().runProcess(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    ApplicationManager.getApplication().runReadAction(new Runnable(){

                        @Override
                        public void run() {
                            task.computeInReadAction(progressIndicator);
                        }
                    });
                }
                catch (ProcessCanceledException processCanceledException) {
                }
                finally {
                    if (progressIndicator.isCanceled()) {
                        task.onCanceled(progressIndicator);
                    }
                }
            }
        }, progressIndicator);
    }
}

