/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.diagnostic.IdeErrorsDialog;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.InstalledPluginsTableModel;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginManagerUISettings;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.RepositoryHelper;
import com.intellij.ide.reporter.ConnectionException;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.IdeaLoggingEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.updateSettings.impl.BuildInfo;
import com.intellij.openapi.updateSettings.impl.CheckForUpdateResult;
import com.intellij.openapi.updateSettings.impl.NewChannelDialog;
import com.intellij.openapi.updateSettings.impl.NoUpdatesDialog;
import com.intellij.openapi.updateSettings.impl.PatchInfo;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.updateSettings.impl.PluginUpdateInfoDialog;
import com.intellij.openapi.updateSettings.impl.UpdateChannel;
import com.intellij.openapi.updateSettings.impl.UpdateInfoDialog;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.updateSettings.impl.UpdateStrategy;
import com.intellij.openapi.updateSettings.impl.UpdatesInfo;
import com.intellij.openapi.updateSettings.impl.UpdatesXmlLoader;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.UrlConnectionUtil;
import com.intellij.util.net.HttpConfigurable;
import com.intellij.util.ui.UIUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.event.HyperlinkEvent;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UpdateChecker {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.updateSettings.impl.UpdateChecker");
    private static final Map<String, PluginDownloader> ourUpdatedPlugins = new HashMap<String, PluginDownloader>();
    private static final NotNullLazyValue<NotificationGroup> GROUP = new NotNullLazyValue<NotificationGroup>(){

        @NotNull
        protected NotificationGroup compute() {
            NotificationGroup notificationGroup = new NotificationGroup(IdeBundle.message((String)"update.available.group", (Object[])new Object[0]), NotificationDisplayType.STICKY_BALLOON, true);
            if (notificationGroup == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/updateSettings/impl/UpdateChecker$1", "compute"));
            }
            return notificationGroup;
        }
    };
    @NonNls
    private static final String INSTALLATION_UID = "installation.uid";
    @NonNls
    private static final String DISABLED_UPDATE = "disabled_update.txt";
    private static Set<String> ourDisabledToUpdatePlugins;
    private static Map<String, String> ourAdditionalRequestOptions;
    private static boolean ourHasFailedPlugins;

    private UpdateChecker() {
    }

    private static String getUpdateUrl() {
        String url = System.getProperty("idea.updates.url");
        return url != null ? url : Holder.UPDATE_URL;
    }

    private static String getPatchesUrl() {
        String url = System.getProperty("idea.patches.url");
        return url != null ? url : Holder.PATCHES_URL;
    }

    public static ActionCallback updateAndShowResult() {
        final ActionCallback callback = new ActionCallback();
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                UpdateChecker.doUpdateAndShowResult(null, true, false, UpdateSettings.getInstance(), null, callback);
            }
        });
        return callback;
    }

    public static void updateAndShowResult(final @Nullable Project project, final boolean fromSettings, final UpdateSettings settings) {
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, IdeBundle.message((String)"updates.checking.progress", (Object[])new Object[0]), true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/updateSettings/impl/UpdateChecker$3", "run"));
                }
                indicator.setIndeterminate(true);
                UpdateChecker.doUpdateAndShowResult(project, !fromSettings, true, settings, indicator, null);
            }

            public boolean isConditionalModal() {
                return fromSettings;
            }

            public boolean shouldStartInBackground() {
                return !fromSettings;
            }
        });
    }

    private static void doUpdateAndShowResult(final @Nullable Project project, final boolean enableLink, final boolean manualCheck, UpdateSettings updateSettings, @Nullable ProgressIndicator indicator, final @Nullable ActionCallback callback) {
        BuildInfo latestBuild;
        final CheckForUpdateResult result = UpdateChecker.checkForUpdates(updateSettings);
        if (result.getState() == UpdateStrategy.State.LOADED) {
            UpdateSettings settings = UpdateSettings.getInstance();
            settings.saveLastCheckedInfo();
            settings.setKnownChannelIds(result.getAllChannelsIds());
        } else if (result.getState() == UpdateStrategy.State.CONNECTION_ERROR) {
            UpdateChecker.showErrorMessage(manualCheck, IdeBundle.message((String)"updates.error.connection.failed", (Object[])new Object[0]));
            return;
        }
        UpdateChannel updatedChannel = result.getUpdatedChannel();
        boolean platformUpdate = UpdateChecker.newChannelReady(result.getChannelToPropose());
        BuildNumber buildNumber = null;
        if (updatedChannel != null && (latestBuild = updatedChannel.getLatestBuild()) != null) {
            buildNumber = latestBuild.getNumber();
        }
        final HashSet<IdeaPluginDescriptor> incompatiblePlugins = buildNumber != null ? new HashSet<IdeaPluginDescriptor>() : null;
        final Collection<PluginDownloader> updatedPlugins = platformUpdate ? null : UpdateChecker.updatePlugins(manualCheck, incompatiblePlugins, indicator, buildNumber);
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                UpdateChecker.showUpdateResult(project, result, updatedPlugins, incompatiblePlugins, enableLink, manualCheck);
                if (callback != null) {
                    callback.setDone();
                }
            }
        });
    }

    public static Collection<PluginDownloader> updatePlugins(boolean manualCheck, @Nullable Collection<IdeaPluginDescriptor> incompatiblePlugins, @Nullable ProgressIndicator indicator, @Nullable BuildNumber buildNumber) {
        IdeaPluginDescriptor[] installedPlugins;
        HashMap<PluginId, PluginDownloader> downloaded = new HashMap<PluginId, PluginDownloader>();
        HashSet<String> failed = new HashSet<String>();
        for (String host : UpdateChecker.getPluginHosts()) {
            try {
                UpdateChecker.checkPluginsHost(host, downloaded, incompatiblePlugins, true, indicator, buildNumber);
            }
            catch (ProcessCanceledException e) {
                return null;
            }
            catch (Exception e) {
                LOG.info((Throwable)e);
                failed.add(host);
            }
        }
        HashMap<String, IdeaPluginDescriptor> toUpdate = new HashMap<String, IdeaPluginDescriptor>();
        for (IdeaPluginDescriptor installedPlugin : installedPlugins = PluginManagerCore.getPlugins()) {
            if (installedPlugin.isBundled()) continue;
            toUpdate.put(installedPlugin.getPluginId().getIdString(), installedPlugin);
        }
        Iterator iterator = downloaded.keySet().iterator();
        while (iterator.hasNext()) {
            if (toUpdate.containsKey(((PluginId)iterator.next()).getIdString())) continue;
            iterator.remove();
        }
        File installedTxt = new File(PathManager.getConfigPath(), "installed.txt");
        if (installedTxt.isFile()) {
            try {
                String oldInstalledPlugins = FileUtil.loadFile((File)installedTxt);
                for (String pluginId : oldInstalledPlugins.trim().split("\n")) {
                    if (toUpdate.containsKey(pluginId)) continue;
                    toUpdate.put(pluginId.trim(), null);
                }
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
            installedTxt.deleteOnExit();
        }
        PluginManagerUISettings updateSettings = PluginManagerUISettings.getInstance();
        updateSettings.myOutdatedPlugins.clear();
        if (!toUpdate.isEmpty()) {
            try {
                List<IdeaPluginDescriptor> process = RepositoryHelper.loadPluginsFromRepository(indicator, buildNumber);
                for (IdeaPluginDescriptor loadedPlugin : process) {
                    String pluginId;
                    pluginId = loadedPlugin.getPluginId();
                    String idString = pluginId.getIdString();
                    if (!toUpdate.containsKey(idString) || downloaded.containsKey(pluginId)) continue;
                    UpdateChecker.prepareToInstall(PluginDownloader.createDownloader(loadedPlugin, buildNumber), buildNumber, downloaded, incompatiblePlugins, true, indicator);
                }
            }
            catch (ProcessCanceledException ignore) {
                return null;
            }
            catch (Exception e) {
                UpdateChecker.showErrorMessage(manualCheck, e.getMessage());
            }
        }
        if (!failed.isEmpty()) {
            LOG.warn(IdeBundle.message((String)"updates.error.plugin.description.failed", (Object[])new Object[]{StringUtil.join(failed, (String)",")}));
        }
        return downloaded.isEmpty() ? null : downloaded.values();
    }

    private static boolean isReadyToUpdate(String idString, String newVersion) {
        PluginDownloader oldPlugin = ourUpdatedPlugins.get(idString);
        return oldPlugin == null || StringUtil.compareVersionNumbers((String)newVersion, (String)oldPlugin.getPluginVersion()) > 0;
    }

    private static void prepareToInstall(PluginDownloader downloader, BuildNumber buildNumber, Map<PluginId, PluginDownloader> downloaded, Collection<IdeaPluginDescriptor> incompatiblePlugins, boolean collectToUpdate, ProgressIndicator indicator) throws IOException {
        String pluginId = downloader.getPluginId();
        String pluginVersion = downloader.getPluginVersion();
        if (collectToUpdate && PluginManagerCore.getDisabledPlugins().contains(pluginId)) {
            return;
        }
        IdeaPluginDescriptor installedPlugin = PluginManager.getPlugin(PluginId.getId((String)pluginId));
        if (installedPlugin == null || pluginVersion == null || PluginDownloader.compareVersionsSkipBroken(installedPlugin, pluginVersion) > 0) {
            IdeaPluginDescriptor descriptor = null;
            if (UpdateChecker.isReadyToUpdate(pluginId, pluginVersion)) {
                descriptor = downloader.getDescriptor();
                if (descriptor == null) {
                    if (downloader.prepareToInstall(indicator, buildNumber)) {
                        descriptor = downloader.getDescriptor();
                    }
                    ourUpdatedPlugins.put(pluginId, downloader);
                }
            } else {
                PluginDownloader oldDownloader = ourUpdatedPlugins.get(pluginId);
                if (oldDownloader != null) {
                    downloader = oldDownloader;
                    descriptor = oldDownloader.getDescriptor();
                }
            }
            if (descriptor != null && !PluginManagerCore.isIncompatible(descriptor, buildNumber) && !InstalledPluginsTableModel.wasUpdated(descriptor.getPluginId())) {
                downloaded.put(PluginId.getId((String)pluginId), downloader);
            }
        }
        if (incompatiblePlugins != null && installedPlugin != null && installedPlugin.isEnabled() && !downloaded.containsKey(installedPlugin.getPluginId()) && PluginManagerCore.isIncompatible(installedPlugin, buildNumber)) {
            incompatiblePlugins.add(installedPlugin);
        }
    }

    private static void showErrorMessage(boolean showDialog, final String message) {
        if (showDialog) {
            UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                @Override
                public void run() {
                    Messages.showErrorDialog((String)message, (String)IdeBundle.message((String)"updates.error.connection.title", (Object[])new Object[0]));
                }
            });
        } else {
            LOG.warn(message);
        }
    }

    private static List<String> getPluginHosts() {
        List<String> hosts = UpdateSettings.getInstance().getPluginHosts();
        ContainerUtil.addIfNotNull((Object)ApplicationInfoEx.getInstanceEx().getBuiltinPluginsUrl(), hosts);
        return hosts;
    }

    public static boolean checkPluginsHost(String host, Map<PluginId, PluginDownloader> downloaded) throws Exception {
        try {
            return UpdateChecker.checkPluginsHost(host, downloaded, null, true, null, null);
        }
        catch (ProcessCanceledException e) {
            return false;
        }
    }

    public static boolean checkPluginsHost(String host, Map<PluginId, PluginDownloader> downloaded, boolean collectToUpdate, @Nullable ProgressIndicator indicator) throws Exception {
        return UpdateChecker.checkPluginsHost(host, downloaded, null, collectToUpdate, indicator, null);
    }

    private static boolean checkPluginsHost(String host, final Map<PluginId, PluginDownloader> downloaded, final @Nullable Collection<IdeaPluginDescriptor> incompatiblePlugins, final boolean collectToUpdate, final @Nullable ProgressIndicator indicator, final BuildNumber buildNumber) throws Exception {
        Document document;
        InputStream inputStream = UpdateChecker.loadVersionInfo(host);
        if (inputStream == null) {
            return false;
        }
        try {
            document = JDOMUtil.loadDocument((InputStream)inputStream);
        }
        catch (JDOMException e) {
            return false;
        }
        inputStream = UpdateChecker.loadVersionInfo(host);
        if (inputStream == null) {
            return false;
        }
        List<IdeaPluginDescriptor> descriptors = RepositoryHelper.loadPluginsFromDescription(inputStream, indicator);
        for (IdeaPluginDescriptor descriptor : descriptors) {
            ((PluginNode)descriptor).setRepositoryName(host);
            UpdateChecker.prepareToInstall(PluginDownloader.createDownloader(descriptor, buildNumber), buildNumber, downloaded, incompatiblePlugins, collectToUpdate, indicator);
        }
        boolean success = true;
        Iterator i$ = document.getRootElement().getChildren("plugin").iterator();
        while (i$.hasNext()) {
            Element plugin;
            Element pluginElement = plugin = (Element)i$.next();
            final String pluginId = pluginElement.getAttributeValue("id");
            String pluginUrl = pluginElement.getAttributeValue("url");
            final String pluginVersion = pluginElement.getAttributeValue("version");
            Element descriptionElement = pluginElement.getChild("description");
            String description = descriptionElement != null ? descriptionElement.getText() : null;
            ArrayList<PluginId> dependsPlugins = new ArrayList<PluginId>();
            List depends = pluginElement.getChildren("depends");
            for (Object depend : depends) {
                dependsPlugins.add(PluginId.getId((String)((Element)depend).getText()));
            }
            if (pluginId == null) {
                LOG.info("plugin id should not be null");
                success = false;
                continue;
            }
            if (pluginUrl == null) {
                LOG.info("plugin url should not be null");
                success = false;
                continue;
            }
            VirtualFile pluginFile = PluginDownloader.findPluginFile(pluginUrl, host);
            if (pluginFile == null) continue;
            if (collectToUpdate) {
                final String finalPluginUrl = UpdateChecker.getPluginUrl(pluginFile);
                Runnable updatePluginRunnable = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
                            if (progressIndicator != null) {
                                progressIndicator.setText2(finalPluginUrl);
                            }
                            PluginDownloader downloader = new PluginDownloader(pluginId, finalPluginUrl, pluginVersion, null, null, buildNumber);
                            UpdateChecker.prepareToInstall(downloader, buildNumber, downloaded, incompatiblePlugins, collectToUpdate, indicator);
                        }
                        catch (IOException e) {
                            LOG.info((Throwable)e);
                        }
                    }
                };
                if (ApplicationManager.getApplication().isDispatchThread()) {
                    String title = IdeBundle.message((String)"update.uploading.plugin.progress.title", (Object[])new Object[0]);
                    ProgressManager.getInstance().runProcessWithProgressSynchronously(updatePluginRunnable, title, true, null);
                    continue;
                }
                updatePluginRunnable.run();
                continue;
            }
            PluginDownloader downloader = new PluginDownloader(pluginId, pluginUrl, pluginVersion);
            downloader.setDescription(description);
            downloader.setDepends(dependsPlugins);
            downloaded.put(PluginId.getId((String)pluginId), downloader);
        }
        return success;
    }

    @NotNull
    private static String getPluginUrl(@NotNull VirtualFile pluginFile) {
        String path;
        if (pluginFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginFile", "com/intellij/openapi/updateSettings/impl/UpdateChecker", "getPluginUrl"));
        }
        String protocol = pluginFile.getFileSystem().getProtocol();
        if ("file".equals(protocol) && SystemInfo.isWindows && (path = pluginFile.getPath()).length() != 0 && path.charAt(0) != '/') {
            String string = protocol + ":///" + path;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/updateSettings/impl/UpdateChecker", "getPluginUrl"));
            }
            return string;
        }
        String string = pluginFile.getUrl();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/updateSettings/impl/UpdateChecker", "getPluginUrl"));
        }
        return string;
    }

    @NotNull
    private static CheckForUpdateResult checkForUpdates(UpdateSettings settings) {
        UpdatesInfo info;
        block4: {
            CheckForUpdateResult checkForUpdateResult;
            block5: {
                try {
                    UpdatesXmlLoader loader = new UpdatesXmlLoader(UpdateChecker.getUpdateUrl());
                    info = loader.loadUpdatesInfo();
                    if (info != null) break block4;
                    checkForUpdateResult = new CheckForUpdateResult(UpdateStrategy.State.NOTHING_LOADED);
                    if (checkForUpdateResult != null) break block5;
                }
                catch (ConnectionException e) {
                    CheckForUpdateResult checkForUpdateResult2 = new CheckForUpdateResult(UpdateStrategy.State.CONNECTION_ERROR, e);
                    if (checkForUpdateResult2 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/updateSettings/impl/UpdateChecker", "checkForUpdates"));
                    }
                    return checkForUpdateResult2;
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/updateSettings/impl/UpdateChecker", "checkForUpdates"));
            }
            return checkForUpdateResult;
        }
        ApplicationInfo appInfo = ApplicationInfo.getInstance();
        int majorVersion = Integer.parseInt(appInfo.getMajorVersion());
        UpdateStrategy strategy = new UpdateStrategy(majorVersion, appInfo.getBuild(), info, settings);
        CheckForUpdateResult checkForUpdateResult = strategy.checkForUpdates();
        if (checkForUpdateResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/updateSettings/impl/UpdateChecker", "checkForUpdates"));
        }
        return checkForUpdateResult;
    }

    public static void addUpdateRequestParameter(String name) {
        UpdateChecker.addUpdateRequestParameter(name, "");
    }

    public static void addUpdateRequestParameter(@NotNull String name, @NotNull String value) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/updateSettings/impl/UpdateChecker", "addUpdateRequestParameter"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/openapi/updateSettings/impl/UpdateChecker", "addUpdateRequestParameter"));
        }
        ourAdditionalRequestOptions.put(name, value);
    }

    @Contract(value="null -> false")
    private static boolean newChannelReady(@Nullable UpdateChannel channelToPropose) {
        return channelToPropose != null && channelToPropose.getLatestBuild() != null;
    }

    private static void showUpdateResult(@Nullable Project project, CheckForUpdateResult checkForUpdateResult, final Collection<PluginDownloader> updatedPlugins, final Collection<IdeaPluginDescriptor> incompatiblePlugins, final boolean enableLink, boolean alwaysShowResults) {
        final UpdateChannel channelToPropose = checkForUpdateResult.getChannelToPropose();
        final UpdateChannel updatedChannel = checkForUpdateResult.getUpdatedChannel();
        if (UpdateChecker.newChannelReady(channelToPropose)) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    new NewChannelDialog(channelToPropose).show();
                }
            };
            if (alwaysShowResults) {
                runnable.run();
            } else {
                String message = IdeBundle.message((String)"updates.new.version.available", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getFullProductName()});
                UpdateChecker.showNotification(project, message, false, runnable);
            }
        } else if (updatedChannel != null) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    new UpdateInfoDialog(updatedChannel, enableLink, updatedPlugins, incompatiblePlugins).show();
                }
            };
            if (alwaysShowResults) {
                runnable.run();
            } else {
                String message = IdeBundle.message((String)"updates.ready.message", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getFullProductName()});
                UpdateChecker.showNotification(project, message, false, runnable);
            }
        } else if (updatedPlugins != null && !updatedPlugins.isEmpty()) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    new PluginUpdateInfoDialog(updatedPlugins, enableLink).show();
                }
            };
            if (alwaysShowResults) {
                runnable.run();
            } else {
                String plugins = StringUtil.join(updatedPlugins, (Function)new Function<PluginDownloader, String>(){

                    public String fun(PluginDownloader downloader) {
                        return downloader.getPluginName();
                    }
                }, (String)", ");
                String message = IdeBundle.message((String)"updates.plugins.ready.message", (Object[])new Object[]{updatedPlugins.size(), plugins});
                UpdateChecker.showNotification(project, message, false, runnable);
            }
        } else if (alwaysShowResults) {
            new NoUpdatesDialog(enableLink).show();
        }
    }

    private static void showNotification(@Nullable Project project, String message, boolean error, final @Nullable Runnable runnable) {
        NotificationListener listener = null;
        if (runnable != null) {
            listener = new NotificationListener(){

                public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                    if (notification == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/openapi/updateSettings/impl/UpdateChecker$11", "hyperlinkUpdate"));
                    }
                    if (event == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/updateSettings/impl/UpdateChecker$11", "hyperlinkUpdate"));
                    }
                    notification.expire();
                    runnable.run();
                }
            };
        }
        String title = IdeBundle.message((String)"updates.info.dialog.title", (Object[])new Object[0]);
        NotificationType type = error ? NotificationType.ERROR : NotificationType.INFORMATION;
        Notifications.Bus.notify((Notification)((NotificationGroup)GROUP.getValue()).createNotification(title, message, type, listener), (Project)project);
    }

    public static String prepareUpdateCheckArgs() {
        UpdateChecker.addUpdateRequestParameter("build", ApplicationInfo.getInstance().getBuild().asString());
        UpdateChecker.addUpdateRequestParameter("uid", UpdateChecker.getInstallationUID(PropertiesComponent.getInstance()));
        UpdateChecker.addUpdateRequestParameter("os", SystemInfo.OS_NAME + ' ' + SystemInfo.OS_VERSION);
        if (ApplicationInfoEx.getInstanceEx().isEAP()) {
            UpdateChecker.addUpdateRequestParameter("eap");
        }
        StringBuilder args = new StringBuilder();
        try {
            for (String name : ourAdditionalRequestOptions.keySet()) {
                if (args.length() > 0) {
                    args.append('&');
                }
                args.append(URLEncoder.encode(name, "UTF-8"));
                String value = ourAdditionalRequestOptions.get(name);
                if (StringUtil.isEmpty((String)value)) continue;
                args.append('=').append(URLEncoder.encode(value, "UTF-8"));
            }
            return args.toString();
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    private static InputStream loadVersionInfo(final String url) throws Exception {
        final InputStream[] inputStreams = new InputStream[]{null};
        final Exception[] exception = new Exception[]{null};
        Future downloadThreadFuture = ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                try {
                    URLConnection connection;
                    String urlToCheck = !"file".equals(new URL(url).getProtocol()) ? url + (url.contains("?") ? "&" : "?") + "build=" + ApplicationInfo.getInstance().getBuild().asString() : url;
                    if (ApplicationManager.getApplication() != null) {
                        connection = HttpConfigurable.getInstance().openConnection(urlToCheck);
                    } else {
                        connection = new URL(urlToCheck).openConnection();
                        connection.setReadTimeout(HttpConfigurable.CONNECTION_TIMEOUT);
                        connection.setConnectTimeout(HttpConfigurable.CONNECTION_TIMEOUT);
                    }
                    connection.connect();
                    inputStreams[0] = connection.getInputStream();
                }
                catch (IOException e) {
                    exception[0] = e;
                }
            }
        });
        try {
            downloadThreadFuture.get(5L, TimeUnit.SECONDS);
        }
        catch (TimeoutException ignored) {
            // empty catch block
        }
        if (!downloadThreadFuture.isDone()) {
            downloadThreadFuture.cancel(true);
            throw new ConnectionException(IdeBundle.message((String)"updates.timeout.error", (Object[])new Object[0]));
        }
        if (exception[0] != null) {
            throw exception[0];
        }
        return inputStreams[0];
    }

    public static String getInstallationUID(PropertiesComponent propertiesComponent) {
        String uid;
        if (SystemInfo.isWindows && (uid = UpdateChecker.getInstallationUIDOnWindows(propertiesComponent)) != null) {
            return uid;
        }
        if (!propertiesComponent.isValueSet(INSTALLATION_UID)) {
            uid = UpdateChecker.generateUUID();
            propertiesComponent.setValue(INSTALLATION_UID, uid);
        } else {
            uid = propertiesComponent.getValue(INSTALLATION_UID);
        }
        return uid;
    }

    @Nullable
    private static String getInstallationUIDOnWindows(PropertiesComponent propertiesComponent) {
        File jetBrainsDir;
        String appdata = System.getenv("APPDATA");
        if (appdata != null && ((jetBrainsDir = new File(appdata, "JetBrains")).exists() || jetBrainsDir.mkdirs())) {
            File permanentIdFile = new File(jetBrainsDir, "PermanentUserId");
            try {
                if (permanentIdFile.exists()) {
                    return FileUtil.loadFile((File)permanentIdFile).trim();
                }
                String uuid = propertiesComponent.isValueSet(INSTALLATION_UID) ? propertiesComponent.getValue(INSTALLATION_UID) : UpdateChecker.generateUUID();
                FileUtil.writeToFile((File)permanentIdFile, (String)uuid);
                return uuid;
            }
            catch (IOException ignored) {
                // empty catch block
            }
        }
        return null;
    }

    private static String generateUUID() {
        try {
            return UUID.randomUUID().toString();
        }
        catch (Exception ignored) {
        }
        catch (InternalError internalError) {
            // empty catch block
        }
        return "";
    }

    public static boolean install(Collection<PluginDownloader> downloaders) {
        boolean installed = false;
        for (PluginDownloader downloader : downloaders) {
            if (UpdateChecker.getDisabledToUpdatePlugins().contains(downloader.getPluginId())) continue;
            try {
                IdeaPluginDescriptor descriptor;
                if (!downloader.prepareToInstall(ProgressManager.getInstance().getProgressIndicator()) || (descriptor = downloader.getDescriptor()) == null) continue;
                InstalledPluginsTableModel.updateExistingPlugin(descriptor, PluginManager.getPlugin(descriptor.getPluginId()));
                downloader.install();
                installed = true;
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
            }
        }
        return installed;
    }

    public static DownloadPatchResult downloadAndInstallPatch(final BuildInfo newVersion) {
        final DownloadPatchResult[] result = new DownloadPatchResult[]{DownloadPatchResult.CANCELED};
        if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

            @Override
            public void run() {
                try {
                    UpdateChecker.doDownloadAndInstallPatch(newVersion, ProgressManager.getInstance().getProgressIndicator());
                    result[0] = DownloadPatchResult.SUCCESS;
                }
                catch (IOException e) {
                    LOG.info((Throwable)e);
                    result[0] = DownloadPatchResult.FAILED;
                    Notifications.Bus.notify((Notification)new Notification("Updater", "Failed to download patch file", e.getMessage(), NotificationType.ERROR));
                }
            }
        }, IdeBundle.message((String)"update.downloading.patch.progress.title", (Object[])new Object[0]), true, null)) {
            return DownloadPatchResult.CANCELED;
        }
        return result[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doDownloadAndInstallPatch(BuildInfo newVersion, ProgressIndicator i) throws IOException {
        PatchInfo patch = newVersion.findPatchForCurrentBuild();
        if (patch == null) {
            throw new IOException("No patch is available for current version");
        }
        String productCode = ApplicationInfo.getInstance().getBuild().getProductCode();
        String osSuffix = "-" + patch.getOSSuffix();
        String fromBuildNumber = patch.getFromBuild().asStringWithoutProductCode();
        String toBuildNumber = newVersion.getNumber().asStringWithoutProductCode();
        String bundledJdk = "jdk-bundled".equals(System.getProperty("idea.java.redist")) ? "-jdk-bundled" : "";
        String fileName = productCode + "-" + fromBuildNumber + "-" + toBuildNumber + "-patch" + bundledJdk + osSuffix + ".jar";
        String platform = PlatformUtils.getPlatformPrefix();
        File tempFile = FileUtil.createTempFile((String)platform, (String)"patch", (boolean)true);
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(tempFile));
        try {
            URLConnection connection = HttpConfigurable.getInstance().openConnection(new URL(new URL(UpdateChecker.getPatchesUrl()), fileName).toString());
            try {
                InputStream in = UrlConnectionUtil.getConnectionInputStreamWithException(connection, i);
                try {
                    int count;
                    int total = connection.getContentLength();
                    i.setIndeterminate(total <= 0);
                    byte[] buffer = new byte[10240];
                    int read = 0;
                    while ((count = in.read(buffer)) > 0) {
                        i.checkCanceled();
                        ((OutputStream)out).write(buffer, 0, count);
                        read += count;
                        if (total > 0) {
                            i.setFraction((double)read / (double)total);
                            i.setText2(read / 1024 + "/" + total / 1024 + " KB");
                            continue;
                        }
                        i.setText2(read / 1024 + " KB");
                    }
                }
                finally {
                    in.close();
                }
            }
            finally {
                if (connection instanceof HttpURLConnection) {
                    ((HttpURLConnection)connection).disconnect();
                }
            }
        }
        finally {
            ((OutputStream)out).close();
        }
        String patchFileName = ("jetbrains.patch.jar." + platform).toLowerCase();
        File patchFile = new File(FileUtil.getTempDirectory(), patchFileName);
        FileUtil.copy((File)tempFile, (File)patchFile);
        FileUtil.delete((File)tempFile);
    }

    public static Set<String> getDisabledToUpdatePlugins() {
        if (ourDisabledToUpdatePlugins == null) {
            ourDisabledToUpdatePlugins = new TreeSet<String>();
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                try {
                    File file = new File(PathManager.getConfigPath(), DISABLED_UPDATE);
                    if (file.isFile()) {
                        String[] ids;
                        for (String id : ids = FileUtil.loadFile((File)file).split("[\\s]")) {
                            if (id == null || id.trim().length() <= 0) continue;
                            ourDisabledToUpdatePlugins.add(id.trim());
                        }
                    }
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
            }
        }
        return ourDisabledToUpdatePlugins;
    }

    public static void saveDisabledToUpdatePlugins() {
        File plugins = new File(PathManager.getConfigPath(), DISABLED_UPDATE);
        try {
            PluginManagerCore.savePluginsList(UpdateChecker.getDisabledToUpdatePlugins(), false, plugins);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    public static void checkForUpdate(IdeaLoggingEvent event) {
        Throwable throwable;
        IdeaPluginDescriptor pluginDescriptor;
        if (!ourHasFailedPlugins && UpdateSettings.getInstance().CHECK_NEEDED && (pluginDescriptor = PluginManager.getPlugin(IdeErrorsDialog.findPluginId(throwable = event.getThrowable()))) != null && !pluginDescriptor.isBundled()) {
            ourHasFailedPlugins = true;
            UpdateChecker.updateAndShowResult();
        }
    }

    static String getDownloadUrl(IdeaPluginDescriptor descriptor, @Nullable BuildNumber buildNumber) throws UnsupportedEncodingException {
        VirtualFile pluginFile;
        String repositoryName;
        String url = null;
        if (descriptor instanceof PluginNode && (url = ((PluginNode)descriptor).getDownloadUrl()) != null && (repositoryName = ((PluginNode)descriptor).getRepositoryName()) != null && (pluginFile = PluginDownloader.findPluginFile(url, repositoryName)) != null) {
            url = UpdateChecker.getPluginUrl(pluginFile);
        }
        if (url == null) {
            String uuid;
            String string = uuid = ApplicationManager.getApplication() == null ? UUID.randomUUID().toString() : UpdateChecker.getInstallationUID(PropertiesComponent.getInstance());
            String buildNumberAsString = buildNumber != null ? buildNumber.asString() : (ApplicationManager.getApplication() != null ? ApplicationInfo.getInstance().getApiVersion() : ApplicationInfoImpl.getShadowInstance().getBuild().asString());
            url = RepositoryHelper.getDownloadUrl() + URLEncoder.encode(descriptor.getPluginId().getIdString(), "UTF8") + "&build=" + buildNumberAsString + "&uuid=" + URLEncoder.encode(uuid, "UTF8");
        }
        return url;
    }

    static {
        ourAdditionalRequestOptions = new HashMap<String, String>();
        ourHasFailedPlugins = false;
    }

    private static class Holder {
        private static final String UPDATE_URL = ApplicationInfoEx.getInstanceEx().getUpdateUrls().getCheckingUrl();
        private static final String PATCHES_URL = ApplicationInfoEx.getInstanceEx().getUpdateUrls().getPatchesUrl();

        private Holder() {
        }
    }

    public static enum DownloadPatchResult {
        SUCCESS,
        FAILED,
        CANCELED;

    }
}

