/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.ZipFileCache;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.impl.ArchiveHandler;
import com.intellij.openapi.vfs.newvfs.ArchiveFileSystem;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VfsImplUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vfs.newvfs.VfsImplUtil");
    private static final String FILE_SEPARATORS = "/" + File.separator;
    private static final AtomicBoolean ourSubscribed = new AtomicBoolean(false);
    private static final Object ourLock = new Object();
    private static final Map<String, Pair<ArchiveFileSystem, ArchiveHandler>> ourHandlers = ContainerUtil.newTroveMap((TObjectHashingStrategy)FileUtil.PATH_HASHING_STRATEGY);
    private static final Map<String, Set<String>> ourDominatorsMap = ContainerUtil.newTroveMap((TObjectHashingStrategy)FileUtil.PATH_HASHING_STRATEGY);

    private VfsImplUtil() {
    }

    @Nullable
    public static NewVirtualFile findFileByPath(@NotNull NewVirtualFileSystem vfs, @NotNull @NonNls String path) {
        if (vfs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vfs", "com/intellij/openapi/vfs/newvfs/VfsImplUtil", "findFileByPath"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vfs/newvfs/VfsImplUtil", "findFileByPath"));
        }
        Pair<NewVirtualFile, Iterable<String>> data = VfsImplUtil.prepare(vfs, path);
        if (data == null) {
            return null;
        }
        NewVirtualFile file = (NewVirtualFile)data.first;
        for (String pathElement : (Iterable)data.second) {
            NewVirtualFile canonicalFile;
            if (pathElement.isEmpty() || ".".equals(pathElement)) continue;
            file = "..".equals(pathElement) ? (file.is(VFileProperty.SYMLINK) ? ((canonicalFile = file.getCanonicalFile()) != null ? canonicalFile.getParent() : null) : file.getParent()) : file.findChild(pathElement);
            if (file != null) continue;
            return null;
        }
        return file;
    }

    @Nullable
    public static NewVirtualFile findFileByPathIfCached(@NotNull NewVirtualFileSystem vfs, @NotNull @NonNls String path) {
        if (vfs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vfs", "com/intellij/openapi/vfs/newvfs/VfsImplUtil", "findFileByPathIfCached"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vfs/newvfs/VfsImplUtil", "findFileByPathIfCached"));
        }
        Pair<NewVirtualFile, Iterable<String>> data = VfsImplUtil.prepare(vfs, path);
        if (data == null) {
            return null;
        }
        NewVirtualFile file = (NewVirtualFile)data.first;
        for (String pathElement : (Iterable)data.second) {
            if (pathElement.isEmpty() || ".".equals(pathElement)) continue;
            if ("..".equals(pathElement)) {
                if (file.is(VFileProperty.SYMLINK)) {
                    String canonicalPath = file.getCanonicalPath();
                    NewVirtualFile canonicalFile = canonicalPath != null ? VfsImplUtil.findFileByPathIfCached(vfs, canonicalPath) : null;
                    file = canonicalFile != null ? canonicalFile.getParent() : null;
                } else {
                    file = file.getParent();
                }
            } else {
                file = file.findChildIfCached(pathElement);
            }
            if (file != null) continue;
            return null;
        }
        return file;
    }

    @Nullable
    public static NewVirtualFile refreshAndFindFileByPath(@NotNull NewVirtualFileSystem vfs, @NotNull @NonNls String path) {
        if (vfs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vfs", "com/intellij/openapi/vfs/newvfs/VfsImplUtil", "refreshAndFindFileByPath"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vfs/newvfs/VfsImplUtil", "refreshAndFindFileByPath"));
        }
        Pair<NewVirtualFile, Iterable<String>> data = VfsImplUtil.prepare(vfs, path);
        if (data == null) {
            return null;
        }
        NewVirtualFile file = (NewVirtualFile)data.first;
        for (String pathElement : (Iterable)data.second) {
            if (pathElement.isEmpty() || ".".equals(pathElement)) continue;
            if ("..".equals(pathElement)) {
                if (file.is(VFileProperty.SYMLINK)) {
                    String canonicalPath = file.getCanonicalPath();
                    NewVirtualFile canonicalFile = canonicalPath != null ? VfsImplUtil.refreshAndFindFileByPath(vfs, canonicalPath) : null;
                    file = canonicalFile != null ? canonicalFile.getParent() : null;
                } else {
                    file = file.getParent();
                }
            } else {
                file = file.refreshAndFindChild(pathElement);
            }
            if (file != null) continue;
            return null;
        }
        return file;
    }

    @Nullable
    private static Pair<NewVirtualFile, Iterable<String>> prepare(@NotNull NewVirtualFileSystem vfs, @NotNull String path) {
        if (vfs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vfs", "com/intellij/openapi/vfs/newvfs/VfsImplUtil", "prepare"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vfs/newvfs/VfsImplUtil", "prepare"));
        }
        String normalizedPath = VfsImplUtil.normalize(vfs, path);
        if (StringUtil.isEmptyOrSpaces((String)normalizedPath)) {
            return null;
        }
        String basePath = vfs.extractRootPath(normalizedPath);
        if (basePath.length() > normalizedPath.length()) {
            LOG.error(vfs + " failed to extract root path '" + basePath + "' from '" + normalizedPath + "' (original '" + path + "')");
            return null;
        }
        NewVirtualFile root = ManagingFS.getInstance().findRoot(basePath, vfs);
        if (root == null || !root.exists()) {
            return null;
        }
        Iterable parts = StringUtil.tokenize((String)normalizedPath.substring(basePath.length()), (String)FILE_SEPARATORS);
        return Pair.create((Object)root, (Object)parts);
    }

    public static void refresh(@NotNull NewVirtualFileSystem vfs, boolean asynchronous) {
        if (vfs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vfs", "com/intellij/openapi/vfs/newvfs/VfsImplUtil", "refresh"));
        }
        VirtualFile[] roots = ManagingFS.getInstance().getRoots(vfs);
        if (roots.length > 0) {
            RefreshQueue.getInstance().refresh(asynchronous, true, null, roots);
        }
    }

    @Nullable
    public static String normalize(@NotNull NewVirtualFileSystem vfs, @NotNull String path) {
        if (vfs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vfs", "com/intellij/openapi/vfs/newvfs/VfsImplUtil", "normalize"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vfs/newvfs/VfsImplUtil", "normalize"));
        }
        return vfs.normalize(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static <T extends ArchiveHandler> T getHandler(@NotNull VirtualFile entryFile, @NotNull ArchiveFileSystem vfs, @NotNull Function<String, T> producer) {
        ArchiveHandler t;
        ArchiveHandler handler;
        if (entryFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entryFile", "com/intellij/openapi/vfs/newvfs/VfsImplUtil", "getHandler"));
        }
        if (vfs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vfs", "com/intellij/openapi/vfs/newvfs/VfsImplUtil", "getHandler"));
        }
        if (producer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "producer", "com/intellij/openapi/vfs/newvfs/VfsImplUtil", "getHandler"));
        }
        VfsImplUtil.checkSubscription();
        String rootPath = vfs.extractRootPath(entryFile.getPath());
        rootPath = vfs.extractLocalPath(rootPath);
        boolean refresh = false;
        Object object = ourLock;
        synchronized (object) {
            Pair record = ourHandlers.get(rootPath);
            if (record == null) {
                handler = (ArchiveHandler)producer.fun((Object)rootPath);
                record = Pair.create((Object)vfs, (Object)handler);
                ourHandlers.put(rootPath, (Pair<ArchiveFileSystem, ArchiveHandler>)record);
                final String finalRootPath = rootPath;
                VfsImplUtil.forEachDirectoryComponent(rootPath, new Processor<String>(){

                    public boolean process(String containingDirectoryPath) {
                        Set handlers = (Set)ourDominatorsMap.get(containingDirectoryPath);
                        if (handlers == null) {
                            handlers = new THashSet();
                            ourDominatorsMap.put(containingDirectoryPath, handlers);
                        }
                        handlers.add(finalRootPath);
                        return true;
                    }
                });
                refresh = true;
            }
            handler = (ArchiveHandler)record.second;
        }
        if (refresh) {
            final File file = handler.getFile();
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file);
                }
            }, ModalityState.defaultModalityState());
        }
        ArchiveHandler archiveHandler = t = handler;
        if (archiveHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/VfsImplUtil", "getHandler"));
        }
        return (T)archiveHandler;
    }

    private static void forEachDirectoryComponent(String rootPath, Processor<String> processor) {
        int index = rootPath.lastIndexOf(47);
        while (index > 0) {
            String containingDirectoryPath = rootPath.substring(0, index);
            if (!processor.process((Object)containingDirectoryPath)) {
                return;
            }
            index = rootPath.lastIndexOf(47, index - 1);
        }
    }

    private static void checkSubscription() {
        if (ourSubscribed.getAndSet(true)) {
            return;
        }
        MessageBus bus = ApplicationManager.getApplication().getMessageBus();
        bus.connect().subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener.Adapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void after(@NotNull List<? extends VFileEvent> events) {
                if (events == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/openapi/vfs/newvfs/VfsImplUtil$3", "after"));
                }
                Map rootsToRefresh = null;
                Object object = ourLock;
                synchronized (object) {
                    for (VFileEvent vFileEvent : events) {
                        if (!(vFileEvent.getFileSystem() instanceof LocalFileSystem) || vFileEvent instanceof VFileCreateEvent || vFileEvent instanceof VFilePropertyChangeEvent && !"name".equals(((VFilePropertyChangeEvent)vFileEvent).getPropertyName())) continue;
                        VirtualFile file = vFileEvent.getFile();
                        String path = vFileEvent.getPath();
                        if (file == null || !file.isDirectory()) {
                            rootsToRefresh = VfsImplUtil.invalidateHandlerForPath(path, rootsToRefresh);
                            continue;
                        }
                        ArrayList affectedPaths = (ArrayList)ourDominatorsMap.get(path);
                        if (affectedPaths == null) continue;
                        affectedPaths = new ArrayList(affectedPaths);
                        for (String affectedPath : affectedPaths) {
                            rootsToRefresh = VfsImplUtil.invalidateHandlerForPath(affectedPath, rootsToRefresh);
                        }
                    }
                }
                if (rootsToRefresh != null) {
                    ZipFileCache.reset(rootsToRefresh.keySet());
                    boolean async = !ApplicationManager.getApplication().isUnitTestMode();
                    RefreshQueue.getInstance().refresh(async, true, null, rootsToRefresh.values());
                }
            }
        });
    }

    private static Map<String, VirtualFile> invalidateHandlerForPath(final String path, Map<String, VirtualFile> rootsToRefresh) {
        Pair<ArchiveFileSystem, ArchiveHandler> handlerPair = ourHandlers.remove(path);
        if (handlerPair != null) {
            String rootPath = ((ArchiveFileSystem)handlerPair.first).convertLocalToRootPath(path);
            NewVirtualFile root = ManagingFS.getInstance().findRoot(rootPath, (NewVirtualFileSystem)handlerPair.first);
            if (root != null) {
                root.markDirtyRecursively();
                if (rootsToRefresh == null) {
                    rootsToRefresh = ContainerUtil.newHashMap();
                }
                rootsToRefresh.put(path, root);
            }
            VfsImplUtil.forEachDirectoryComponent(path, new Processor<String>(){

                public boolean process(String containingDirectoryPath) {
                    Set handlers = (Set)ourDominatorsMap.get(containingDirectoryPath);
                    if (handlers != null && handlers.remove(path) && handlers.size() == 0) {
                        ourDominatorsMap.remove(containingDirectoryPath);
                    }
                    return true;
                }
            });
        }
        return rootsToRefresh;
    }
}

