/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.templates;

import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleTypeManager;
import com.intellij.openapi.util.ClearableLazyValue;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.platform.ProjectTemplate;
import com.intellij.platform.ProjectTemplatesFactory;
import com.intellij.platform.templates.ArchivedProjectTemplate;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.net.HttpConfigurable;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.util.Collection;
import java.util.List;
import java.util.zip.ZipInputStream;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteTemplatesFactory
extends ProjectTemplatesFactory {
    private static final String URL = "http://download.jetbrains.com/idea/project_templates/";
    public static final String TEMPLATE = "template";
    public static final String INPUT_DEFAULT = "default";
    public static final Function<Element, String> ELEMENT_STRING_FUNCTION = new Function<Element, String>(){

        public String fun(Element element) {
            return element.getText();
        }
    };
    private final ClearableLazyValue<MultiMap<String, ArchivedProjectTemplate>> myTemplates = new ClearableLazyValue<MultiMap<String, ArchivedProjectTemplate>>(){

        @NotNull
        protected MultiMap<String, ArchivedProjectTemplate> compute() {
            MultiMap multiMap = RemoteTemplatesFactory.getTemplates();
            if (multiMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/platform/templates/RemoteTemplatesFactory$2", "compute"));
            }
            return multiMap;
        }
    };
    private static final Logger LOG = Logger.getInstance(RemoteTemplatesFactory.class);

    @Override
    @NotNull
    public String[] getGroups() {
        this.myTemplates.drop();
        String[] stringArray = ArrayUtil.toStringArray((Collection)((MultiMap)this.myTemplates.getValue()).keySet());
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/platform/templates/RemoteTemplatesFactory", "getGroups"));
        }
        return stringArray;
    }

    @Override
    @NotNull
    public ProjectTemplate[] createTemplates(String group, WizardContext context) {
        Collection templates = ((MultiMap)this.myTemplates.getValue()).get((Object)group);
        ProjectTemplate[] projectTemplateArray = templates.toArray(new ProjectTemplate[templates.size()]);
        if (projectTemplateArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/platform/templates/RemoteTemplatesFactory", "createTemplates"));
        }
        return projectTemplateArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static MultiMap<String, ArchivedProjectTemplate> getTemplates() {
        InputStream stream = null;
        HttpURLConnection connection = null;
        String code = ApplicationInfo.getInstance().getBuild().getProductCode();
        try {
            connection = RemoteTemplatesFactory.getConnection(code + "_templates.xml");
            stream = connection.getInputStream();
            String text = StreamUtil.readText((InputStream)stream, (String)"UTF-8");
            MultiMap<String, ArchivedProjectTemplate> multiMap = RemoteTemplatesFactory.createFromText(text);
            StreamUtil.closeStream((Closeable)stream);
            if (connection != null) {
                connection.disconnect();
            }
            return multiMap;
        }
        catch (IOException ex) {
            LOG.info((Throwable)ex);
            MultiMap multiMap = MultiMap.emptyInstance();
            return multiMap;
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            MultiMap multiMap = MultiMap.emptyInstance();
            return multiMap;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            StreamUtil.closeStream(stream);
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    public static MultiMap<String, ArchivedProjectTemplate> createFromText(String text) throws IOException, JDOMException {
        MultiMap map = new MultiMap();
        Element rootElement = JDOMUtil.loadDocument((CharSequence)text).getRootElement();
        List<ArchivedProjectTemplate> templates = RemoteTemplatesFactory.createGroupTemplates(rootElement, Namespace.NO_NAMESPACE);
        for (ArchivedProjectTemplate template : templates) {
            map.putValue((Object)template.getCategory(), (Object)template);
        }
        return map;
    }

    private static List<ArchivedProjectTemplate> createGroupTemplates(Element groupElement, final Namespace ns) {
        List elements = groupElement.getChildren(TEMPLATE, ns);
        return ContainerUtil.mapNotNull((Collection)elements, (Function)new NullableFunction<Element, ArchivedProjectTemplate>(){

            public ArchivedProjectTemplate fun(Element element) {
                if (!RemoteTemplatesFactory.checkRequiredPlugins(element, ns)) {
                    return null;
                }
                String type = element.getChildText("moduleType");
                ModuleType moduleType = ModuleTypeManager.getInstance().findByID(type);
                String path = element.getChildText("path", ns);
                String description = element.getChildTextTrim("description", ns);
                String name = element.getChildTextTrim("name", ns);
                RemoteProjectTemplate template = new RemoteProjectTemplate(name, element, moduleType, path, description);
                template.populateFromElement(element, ns);
                return template;
            }
        });
    }

    public static List<String> getFrameworks(Element element) {
        List frameworks = element.getChildren("framework");
        return ContainerUtil.map((Collection)frameworks, ELEMENT_STRING_FUNCTION);
    }

    private static boolean checkRequiredPlugins(Element element, Namespace ns) {
        List plugins = element.getChildren("requiredPlugin", ns);
        for (Element plugin : plugins) {
            String id = plugin.getTextTrim();
            if (PluginManager.isPluginInstalled(PluginId.getId((String)id))) continue;
            return false;
        }
        return true;
    }

    private static HttpURLConnection getConnection(String path) throws IOException {
        HttpURLConnection connection = HttpConfigurable.getInstance().openHttpConnection(URL + path);
        connection.setConnectTimeout(2000);
        connection.setReadTimeout(2000);
        connection.connect();
        return connection;
    }

    private static class RemoteProjectTemplate
    extends ArchivedProjectTemplate {
        private final ModuleType myModuleType;
        private final String myPath;
        private final String myDescription;

        public RemoteProjectTemplate(String name, Element element, ModuleType moduleType, String path, String description) {
            super(name, element.getChildTextTrim("category"));
            this.myModuleType = moduleType;
            this.myPath = path;
            this.myDescription = description;
        }

        @Override
        protected ModuleType getModuleType() {
            return this.myModuleType;
        }

        @Override
        public ZipInputStream getStream() throws IOException {
            final HttpURLConnection connection = RemoteTemplatesFactory.getConnection(this.myPath);
            return new ZipInputStream(connection.getInputStream()){

                @Override
                public void close() throws IOException {
                    super.close();
                    connection.disconnect();
                }
            };
        }

        @Nullable
        public String getDescription() {
            return this.myDescription;
        }
    }
}

