/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.graphInference.constraints;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiMethodReferenceUtil;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.impl.source.resolve.graphInference.FunctionalInterfaceParameterizationUtil;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import com.intellij.psi.impl.source.resolve.graphInference.PsiPolyExpressionUtil;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.ConstraintFormula;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.StrictSubtypingConstraint;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.TypeCompatibilityConstraint;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Map;

public class PsiMethodReferenceCompatibilityConstraint
implements ConstraintFormula {
    private static final Logger LOG = Logger.getInstance((String)("#" + PsiMethodReferenceCompatibilityConstraint.class.getName()));
    private final PsiMethodReferenceExpression myExpression;
    private PsiType myT;

    public PsiMethodReferenceCompatibilityConstraint(PsiMethodReferenceExpression expression, PsiType t) {
        this.myExpression = expression;
        this.myT = t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean reduce(InferenceSession session, List<ConstraintFormula> constraints) {
        JavaResolveResult resolve;
        if (!LambdaUtil.isFunctionalType((PsiType)this.myT)) {
            return false;
        }
        PsiType groundTargetType = FunctionalInterfaceParameterizationUtil.getGroundTargetType(this.myT);
        PsiClassType.ClassResolveResult classResolveResult = PsiUtil.resolveGenericsClassInType((PsiType)groundTargetType);
        PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiClassType.ClassResolveResult)classResolveResult);
        if (interfaceMethod == null) {
            return false;
        }
        PsiSubstitutor substitutor = LambdaUtil.getSubstitutor((PsiMethod)interfaceMethod, (PsiClassType.ClassResolveResult)classResolveResult);
        PsiParameter[] targetParameters = interfaceMethod.getParameterList().getParameters();
        PsiType interfaceMethodReturnType = interfaceMethod.getReturnType();
        PsiType returnType = substitutor.substitute(interfaceMethodReturnType);
        PsiType[] typeParameters = this.myExpression.getTypeParameters();
        PsiMethodReferenceUtil.QualifierResolveResult qualifierResolveResult = PsiMethodReferenceUtil.getQualifierResolveResult((PsiMethodReferenceExpression)this.myExpression);
        if (!this.myExpression.isExact()) {
            for (PsiParameter parameter : targetParameters) {
                if (session.isProperType(substitutor.substitute(parameter.getType()))) continue;
                return false;
            }
        } else {
            int i;
            PsiParameter[] parameters;
            PsiMember applicableMember = this.myExpression.getPotentiallyApplicableMember();
            LOG.assertTrue(applicableMember != null);
            PsiClass applicableMemberContainingClass = applicableMember.getContainingClass();
            PsiClass containingClass = qualifierResolveResult.getContainingClass();
            PsiSubstitutor psiSubstitutor = qualifierResolveResult.getSubstitutor();
            psiSubstitutor = applicableMemberContainingClass == null || containingClass == null || this.myExpression.isConstructor() ? psiSubstitutor : TypeConversionUtil.getSuperClassSubstitutor((PsiClass)applicableMemberContainingClass, (PsiClass)containingClass, (PsiSubstitutor)psiSubstitutor);
            PsiType applicableMethodReturnType = applicableMember instanceof PsiMethod ? ((PsiMethod)applicableMember).getReturnType() : null;
            int idx = 0;
            for (PsiTypeParameter param : ((PsiTypeParameterListOwner)applicableMember).getTypeParameters()) {
                if (idx >= typeParameters.length) continue;
                psiSubstitutor = psiSubstitutor.put(param, typeParameters[idx++]);
            }
            PsiParameter[] psiParameterArray = parameters = applicableMember instanceof PsiMethod ? ((PsiMethod)applicableMember).getParameterList().getParameters() : PsiParameter.EMPTY_ARRAY;
            if (targetParameters.length == parameters.length + 1) {
                this.specialCase(session, constraints, substitutor, targetParameters, true);
                for (i = 1; i < targetParameters.length; ++i) {
                    constraints.add(new TypeCompatibilityConstraint(session.substituteWithInferenceVariables(psiSubstitutor.substitute(parameters[i - 1].getType())), substitutor.substitute(targetParameters[i].getType())));
                }
            } else if (targetParameters.length == parameters.length) {
                for (i = 0; i < targetParameters.length; ++i) {
                    constraints.add(new TypeCompatibilityConstraint(session.substituteWithInferenceVariables(psiSubstitutor.substitute(parameters[i].getType())), substitutor.substitute(targetParameters[i].getType())));
                }
            } else {
                return false;
            }
            if (returnType != PsiType.VOID && returnType != null) {
                if (applicableMethodReturnType == PsiType.VOID) {
                    return false;
                }
                if (applicableMethodReturnType != null) {
                    constraints.add(new TypeCompatibilityConstraint(returnType, session.substituteWithInferenceVariables(psiSubstitutor.substitute(applicableMethodReturnType))));
                } else if (applicableMember instanceof PsiClass || applicableMember instanceof PsiMethod && ((PsiMethod)applicableMember).isConstructor()) {
                    PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)applicableMember.getProject());
                    if (containingClass != null) {
                        PsiType classType = session.substituteWithInferenceVariables((PsiType)elementFactory.createType(containingClass, psiSubstitutor));
                        constraints.add(new TypeCompatibilityConstraint(returnType, classType));
                    }
                }
            }
            return true;
        }
        Map map = PsiMethodReferenceUtil.getFunctionalTypeMap();
        PsiType added = map.put(this.myExpression, session.startWithFreshVars(groundTargetType));
        try {
            resolve = this.myExpression.advancedResolve(true);
        }
        finally {
            if (added == null) {
                map.remove(this.myExpression);
            }
        }
        PsiElement element = resolve.getElement();
        if (element == null) {
            return false;
        }
        if (PsiType.VOID.equals((Object)returnType) || returnType == null) {
            return true;
        }
        if (element instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)element;
            PsiClass containingClass = method.getContainingClass();
            LOG.assertTrue(containingClass != null, (Object)method);
            PsiClass qContainingClass = qualifierResolveResult.getContainingClass();
            PsiSubstitutor psiSubstitutor = qualifierResolveResult.getSubstitutor();
            if (qContainingClass != null) {
                if (PsiUtil.isRawSubstitutor((PsiTypeParameterListOwner)qContainingClass, (PsiSubstitutor)psiSubstitutor)) {
                    psiSubstitutor = PsiSubstitutor.EMPTY;
                }
                if (qContainingClass.isInheritor(containingClass, true)) {
                    psiSubstitutor = TypeConversionUtil.getClassSubstitutor((PsiClass)containingClass, (PsiClass)qContainingClass, (PsiSubstitutor)PsiSubstitutor.EMPTY);
                    LOG.assertTrue(psiSubstitutor != null);
                }
            }
            Object referencedMethodReturnType = method.isConstructor() ? JavaPsiFacade.getElementFactory((Project)method.getProject()).createType(containingClass, PsiSubstitutor.EMPTY) : method.getReturnType();
            LOG.assertTrue(referencedMethodReturnType != null, (Object)method);
            session.initBounds((PsiElement)this.myExpression, method.getTypeParameters());
            if (!PsiTreeUtil.isContextAncestor((PsiElement)containingClass, (PsiElement)this.myExpression, (boolean)false) || PsiUtil.getEnclosingStaticElement((PsiElement)this.myExpression, (PsiClass)containingClass) != null) {
                session.initBounds((PsiElement)this.myExpression, containingClass.getTypeParameters());
            }
            if (typeParameters.length == 0 && method.getTypeParameters().length > 0) {
                PsiClass interfaceClass = classResolveResult.getElement();
                LOG.assertTrue(interfaceClass != null);
                if (PsiPolyExpressionUtil.mentionsTypeParameters(referencedMethodReturnType, ContainerUtil.newHashSet((Object[])method.getTypeParameters())).booleanValue()) {
                    session.collectApplicabilityConstraints(this.myExpression, (MethodCandidateInfo)resolve, groundTargetType);
                    session.registerReturnTypeConstraints((PsiType)referencedMethodReturnType, returnType);
                    return true;
                }
            }
            if (PsiType.VOID.equals(referencedMethodReturnType)) {
                return false;
            }
            int idx = 0;
            for (PsiTypeParameter param : method.getTypeParameters()) {
                if (idx >= typeParameters.length) continue;
                psiSubstitutor = psiSubstitutor.put(param, typeParameters[idx++]);
            }
            PsiParameter[] parameters = method.getParameterList().getParameters();
            if (targetParameters.length == parameters.length + 1 && !method.isVarArgs() && PsiPolyExpressionUtil.mentionsTypeParameters(referencedMethodReturnType, ContainerUtil.newHashSet((Object[])containingClass.getTypeParameters())).booleanValue()) {
                this.specialCase(session, constraints, substitutor, targetParameters, false);
            }
            constraints.add(new TypeCompatibilityConstraint(returnType, session.substituteWithInferenceVariables(psiSubstitutor.substitute(referencedMethodReturnType))));
        }
        return true;
    }

    private void specialCase(InferenceSession session, List<ConstraintFormula> constraints, PsiSubstitutor substitutor, PsiParameter[] targetParameters, boolean ignoreRaw) {
        JavaResolveResult resolveResult;
        PsiElement res;
        PsiClass qualifierClass;
        PsiElement qualifier = this.myExpression.getQualifier();
        PsiType qualifierType = null;
        if (qualifier instanceof PsiTypeElement) {
            qualifierType = ((PsiTypeElement)qualifier).getType();
            qualifierClass = PsiUtil.resolveClassInType((PsiType)qualifierType);
            if (qualifierClass != null) {
                qualifierType = JavaPsiFacade.getElementFactory((Project)this.myExpression.getProject()).createType(qualifierClass, PsiSubstitutor.EMPTY);
            }
        } else if (qualifier instanceof PsiExpression && (qualifierType = ((PsiExpression)qualifier).getType()) == null && qualifier instanceof PsiReferenceExpression && (res = (resolveResult = ((PsiReferenceExpression)qualifier).advancedResolve(false)).getElement()) instanceof PsiClass) {
            PsiClass containingClass = (PsiClass)res;
            boolean isRawSubst = !ignoreRaw && !this.myExpression.isConstructor() && PsiUtil.isRawSubstitutor((PsiTypeParameterListOwner)containingClass, (PsiSubstitutor)resolveResult.getSubstitutor());
            qualifierType = JavaPsiFacade.getElementFactory((Project)res.getProject()).createType(containingClass, isRawSubst ? PsiSubstitutor.EMPTY : resolveResult.getSubstitutor());
        }
        qualifierClass = PsiUtil.resolveClassInType((PsiType)qualifierType);
        if (qualifierClass != null) {
            session.initBounds((PsiElement)this.myExpression, qualifierClass.getTypeParameters());
            constraints.add(new StrictSubtypingConstraint(session.substituteWithInferenceVariables(qualifierType), session.substituteWithInferenceVariables(substitutor.substitute(targetParameters[0].getType()))));
        }
    }

    @Override
    public void apply(PsiSubstitutor substitutor, boolean cache) {
        this.myT = substitutor.substitute(this.myT);
    }

    public String toString() {
        return this.myExpression.getText() + " -> " + this.myT.getPresentableText();
    }
}

