/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util.proximity;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NullableLazyKey;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.ProximityLocation;
import com.intellij.psi.util.proximity.ProximityWeigher;
import com.intellij.util.LogicalRoot;
import com.intellij.util.LogicalRootsManager;
import com.intellij.util.NullableFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SameLogicalRootWeigher
extends ProximityWeigher {
    private static final NullableLazyKey<LogicalRoot, ProximityLocation> LOGICAL_ROOT_KEY = NullableLazyKey.create((String)"logicalRoot", (NullableFunction)new NullableFunction<ProximityLocation, LogicalRoot>(){

        public LogicalRoot fun(ProximityLocation proximityLocation) {
            return SameLogicalRootWeigher.findLogicalRoot(proximityLocation.getPosition());
        }
    });

    @Override
    public Comparable weigh(@NotNull PsiElement element, @NotNull ProximityLocation location) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/util/proximity/SameLogicalRootWeigher", "weigh"));
        }
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "com/intellij/psi/util/proximity/SameLogicalRootWeigher", "weigh"));
        }
        if (location.getPosition() == null) {
            return null;
        }
        LogicalRoot contextRoot = (LogicalRoot)LOGICAL_ROOT_KEY.getValue((UserDataHolder)location);
        if (contextRoot == null) {
            return Boolean.valueOf(false);
        }
        return Boolean.valueOf(contextRoot.equals(SameLogicalRootWeigher.findLogicalRoot(element)));
    }

    @Nullable
    private static LogicalRoot findLogicalRoot(PsiElement element) {
        if (element == null) {
            return null;
        }
        PsiFile psiFile = element.getContainingFile();
        if (psiFile == null) {
            return null;
        }
        VirtualFile file = psiFile.getVirtualFile();
        if (file == null) {
            return null;
        }
        return LogicalRootsManager.getLogicalRootsManager((Project)element.getProject()).findLogicalRoot(file);
    }
}

